<?php
/* * ** Meta Box Functions **** */
$prefix = 'tentered_';
global $meta_boxes;
$options = get_option('tentered_options');
$gmap_api_key = (isset($options['google_map_api']))?$options['google_map_api']:'';
load_theme_textdomain('tentered', TENTERED_FILEPATH . '/language');
$meta_boxes = array();
//Page Design Meta Box
$meta_boxes[] = array(
	'title'       => esc_html__( 'Page Design Options', 'tentered' ),
	'tabs'      => array(
		'layout'    => array(
			'label' => esc_html__( 'Layout', 'tentered' ),
		),
		'header'    => array(
			'label' => esc_html__( 'Header', 'tentered' ),
		),
		'page_header'  => array(
			'label' => esc_html__( 'Page Header', 'tentered' ),
		),
		'page_title'  => array(
			'label' => esc_html__( 'Page Title', 'tentered' ),
		),
		'page_content' => array(
			'label' => esc_html__( 'Content', 'tentered' ),
		),
		'social_share'    => array(
			'label' => esc_html__( 'Social Sharing', 'tentered' ),
		),
	),
	// Tab style: 'default', 'box' or 'left'. Optional
	'tab_style' => 'left',
	// Show meta box wrapper around tabs? true (default) or false. Optional
	'tab_wrapper' => true,
   	'pages' => array('post','page','team','project','service','product'),
	'fields'    => array(
		array(
            'name' => esc_html__('Header Style', 'tentered'),
            'id' => $prefix . 'page_header_style',
            'desc' => esc_html__("Select header style for the page.", 'tentered'),
            'type' => 'select',
			'tab'  => 'header',
            'options' => array(
				'' => esc_html__('Theme Default', 'tentered'),
				'1' => esc_html__('Style 1', 'tentered'),
				'2' => esc_html__('Style 2', 'tentered'),
                '3' => esc_html__('Style 3', 'tentered'),
                '4' => esc_html__('Style 4', 'tentered'),
				'hidden' => esc_html__('No Header', 'tentered'),
            )
        ),
		array(
            'name' => esc_html__('Standard Logo', 'tentered'),
            'id' => $prefix . 'page_logo',
            'desc' => esc_html__("Upload logo image to show on this page.", 'tentered'),
            'type' => 'image_advanced',
			'tab'  => 'header',
            'max_file_uploads' => 1
        ),
		array(
            'name' => esc_html__('Retina Logo', 'tentered'),
            'id' => $prefix . 'page_logo_retina',
            'desc' => esc_html__("Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch.", 'tentered'),
            'type' => 'image_advanced',
			'tab'  => 'header',
            'max_file_uploads' => 1
        ),
		array(
            'name' => esc_html__('Standard Logo Width for Retina Logo', 'tentered'),
            'desc' => esc_html__("If retina logo is uploaded, enter the standard logo (1x) version width, do not enter the retina logo width.", 'tentered'),
            'id' => $prefix . 'page_logo_retina_width',
            'type' => 'text',
			'tab'  => 'header',
		),
		array(
            'name' => esc_html__('Standard Logo Height for Retina Logo', 'tentered'),
            'desc' => esc_html__("If retina logo is uploaded, enter the standard logo (1x) version height, do not enter the retina logo height.", 'tentered'),
            'id' => $prefix . 'page_logo_retina_height',
            'type' => 'text',
			'tab'  => 'header',
		),
		array(
            'name' => esc_html__('Topbar Show/Hide', 'tentered'),
            'id' => $prefix . 'page_topbar_show',
            'type' => 'select',
			'tab'  => 'header',
            'options' => array(
                1 => esc_html__('Show', 'tentered'),
                0 => esc_html__('Hide', 'tentered'),
            ),
            'std' => 1,
        ),
		array(
            'name' => esc_html__('Page layout', 'tentered'),
            'id' => $prefix . 'page_layout',
            'desc' => esc_html__("Select layout for the page.", 'tentered'),
            'type' => 'select',
			'tab'  => 'layout',
            'options' => array(
				'' => esc_html__('Theme Default', 'tentered'),
				'full-width-page' => esc_html__('Full Width', 'tentered'),
				'boxed' => esc_html__('Boxed', 'tentered'),
            )
        ),
		array(
            'name' => esc_html__('Content Width', 'tentered'),
            'desc' => esc_html__("Enter width of content in px or %", 'tentered'),
            'id' => $prefix . 'content_width',
            'type' => 'text',
			'tab'  => 'page_content',
		),
		array(
            'name' => esc_html__('Content Padding Top', 'tentered'),
            'id' => $prefix . 'content_padding_top',
            'type' => 'number',
            'std' => 60,
			'tab'  => 'page_content',
		),
		array(
            'name' => esc_html__('Content Padding Bottom', 'tentered'),
            'id' => $prefix . 'content_padding_bottom',
            'type' => 'number',
            'std' => '60',
			'tab'  => 'page_content',
		),
		array(
            'name' => esc_html__('Background Color', 'tentered'),
            'id' => $prefix . 'pages_body_bg_color',
            'desc' => esc_html__("Choose background color for the outer area", 'tentered'),
            'type' => 'color',
			'tab'  => 'layout',
			'visible' => array( 'tentered_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('Background Image', 'tentered'),
            'id' => $prefix . 'pages_body_bg_image',
            'desc' => esc_html__("Choose background image for the outer area", 'tentered'),
            'type' => 'image_advanced',
			'tab'  => 'layout',
            'max_file_uploads' => 1,
			'visible' => array( 'tentered_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('100% Background Image', 'tentered'),
            'id' => $prefix . 'pages_body_bg_wide',
            'desc' => esc_html__("Choose to have the background image display at 100%.", 'tentered'),
            'type' => 'select',
			'tab'  => 'layout',
            'options' => array(
                '1' => esc_html__('Yes', 'tentered'),
                '0' => esc_html__('No', 'tentered'),
            ),
            'std' => 0,
			'visible' => array( 'tentered_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('Background Repeat', 'tentered'),
            'id' => $prefix . 'pages_body_bg_repeat',
            'desc' => esc_html__("Select how the background image repeats.", 'tentered'),
            'type' => 'select',
			'tab'  => 'layout',
            'options' => array(
                'repeat' => esc_html__('Repeat', 'tentered'),
                'repeat-x' => esc_html__('Repeat Horizontally', 'tentered'),
                'repeat-y' => esc_html__('Repeat Vertically', 'tentered'),
                'no-repeat' => esc_html__('No Repeat', 'tentered'),
            ),
            'std' => 'repeat',
			'visible' => array( 'tentered_page_layout', '=', 'boxed' )
        ),
		array(
            'name' => esc_html__('Background Color', 'tentered'),
            'id' => $prefix . 'pages_content_bg_color',
            'desc' => esc_html__("Choose background color for the Content area", 'tentered'),
            'type' => 'color',
			'tab'  => 'page_content',
        ),
		array(
            'name' => esc_html__('Background Image', 'tentered'),
            'id' => $prefix . 'pages_content_bg_image',
            'desc' => esc_html__("Choose background image for the Content area", 'tentered'),
            'type' => 'image_advanced',
			'tab'  => 'page_content',
            'max_file_uploads' => 1
        ),
		array(
            'name' => esc_html__('100% Background Image', 'tentered'),
            'id' => $prefix . 'pages_content_bg_wide',
            'desc' => esc_html__("Choose to have the background image display at 100%.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_content',
            'options' => array(
                1 => esc_html__('Yes', 'tentered'),
                0 => esc_html__('No', 'tentered'),
            ),
            'std' => 0,
        ),
		array(
            'name' => esc_html__('Background Repeat', 'tentered'),
            'id' => $prefix . 'pages_content_bg_repeat',
            'desc' => esc_html__("Select how the background image repeats.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_content',
            'options' => array(
                'repeat' => esc_html__('Repeat', 'tentered'),
                'repeat-x' => esc_html__('Repeat Horizontally', 'tentered'),
                'repeat-y' => esc_html__('Repeat Vertically', 'tentered'),
                'no-repeat' => esc_html__('No Repeat', 'tentered'),
            ),
            'std' => 'repeat',
        ),
		array(
            'name' => esc_html__('Page Header Show/Hide', 'tentered'),
            'id' => $prefix . 'page_header_show',
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                1 => esc_html__('Show', 'tentered'),
                0 => esc_html__('Hide', 'tentered'),
            ),
            'std' => 1,
        ),
		array(
            'name' => esc_html__('Choose Header Type', 'tentered'),
            'id' => $prefix . 'pages_Choose_slider_display',
            'desc' => esc_html__("Select Banner Type.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
				1 => esc_html__('Colored Banner', 'tentered'),
				2 => esc_html__('Image Banner', 'tentered'),
                4 => esc_html__('Flex Slider', 'tentered'),
                5 => esc_html__('Revolution Slider', 'tentered'),
            ),
			'std' => 2,
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
        ),
		array(
			'name' => esc_html__( 'Banner Color', 'tentered' ),
			'id' => $prefix.'pages_banner_color',
			'type' => 'color',
			'tab'  => 'page_header',
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '1' ),
		),
		array(
            'name' => esc_html__('Use featured image as page banner', 'tentered'),
            'id' => $prefix . 'featured_image_banner',
            'desc' => esc_html__("If checked then your page/post featured image will be used as it's page header banner image. Uncheck to upload your own new image for the page header banner.", 'tentered'),
            'type' => 'checkbox',
			'tab'  => 'page_header',
			'std'  => 0,
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '2' ),
        ),
		array(
            'name' => esc_html__('Banner Image', 'tentered'),
            'id' => $prefix . 'header_image',
            'desc' => esc_html__("Upload banner image for header for this Page/Post.", 'tentered'),
            'type' => 'image_advanced',
			'tab'  => 'page_header',
            'max_file_uploads' => 1,
			'hidden' => array( 'tentered_featured_image_banner', true ),
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '2' ),
        ),
		array(
            'name' => esc_html__('Banner image overlay', 'tentered'),
            'id' => $prefix . 'header_image_overlay',
            'desc' => esc_html__("Choose over color for Image banner.", 'tentered'),
            'type' => 'color',
			'tab'  => 'page_header',
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'hidden' => array( 'tentered_pages_Choose_slider_display', 'between', [3,5] ),
        ),
		array(
            'name' => esc_html__('Banner image overlay opacity', 'tentered'),
            'id' => $prefix . 'header_image_overlay_opacity',
            'desc' => esc_html__("Enter value for opacity of banner image overlay. Enter value between 0.1 to 1.", 'tentered'),
            'type' => 'text',
			'tab'  => 'page_header',
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'hidden' => array( 'tentered_pages_Choose_slider_display', 'between', [3,5] ),
        ),
        array(
		   'name' => esc_html__('Select Revolution Slider from list','tentered'),
			'id' => $prefix . 'pages_select_revolution_from_list',
			'desc' => esc_html__("Select Revolution Slider from list", 'tentered'),
			'type' => 'select',
			'tab'  => 'page_header',
			'options' => tentered_RevSliderShortCode(),
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '5' ),
		),
        //Slider Images
        array(
            'name' => esc_html__('Slider Images', 'tentered'),
            'id' => $prefix . 'pages_slider_image',
            'desc' => esc_html__("Upload/select slider images.", 'tentered'),
            'type' => 'image_advanced',
			'tab'  => 'page_header',
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Pagination', 'tentered'),
            'id' => $prefix . 'pages_slider_pagination',
            'desc' => esc_html__("Enable to show pagination for slider.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'yes' => esc_html__('Enable', 'tentered'),
                'no' => esc_html__('Disable', 'tentered'),
            ),
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Auto Slide', 'tentered'),
            'id' => $prefix . 'pages_slider_auto_slide',
            'desc' => esc_html__("Select Yes to slide automatically.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'yes' => esc_html__('Yes', 'tentered'),
                'no' => esc_html__('No', 'tentered'),
            ),
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Direction Arrows', 'tentered'),
            'id' => $prefix . 'pages_slider_direction_arrows',
            'desc' => esc_html__("Select Yes to show slider direction arrows.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'yes' => esc_html__('Yes', 'tentered'),
                'no' => esc_html__('No', 'tentered'),
            ),
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Slider Effects', 'tentered'),
            'id' => $prefix . 'pages_slider_effects',
            'desc' => esc_html__("Select effects for slider.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_header',
            'options' => array(
                'fade' => esc_html__('Fade', 'tentered'),
                'slide' => esc_html__('Slide', 'tentered'),
            ),
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'visible' => array( 'tentered_pages_Choose_slider_display', '=', '4' ),
        ),
		array(
            'name' => esc_html__('Banner/Slider Height', 'tentered'),
            'id' => $prefix . 'pages_slider_height',
            'desc' => esc_html__("Enter Height for Banner/Slider Ex-250. DO NOT ENTER px HERE", 'tentered'),
            'type' => 'text',
			'tab'  => 'page_header',
			'visible' => array( 'tentered_page_header_show', '=', '1' ),
			'hidden' => array( 'tentered_pages_Choose_slider_display', '=', '4' ),
			'hidden' => array( 'tentered_pages_Choose_slider_display', '=', '5' ),
        ),
		array(
            'name' => esc_html__('Page Title Show/Hide', 'tentered'),
            'id' => $prefix . 'pages_title_show',
            'type' => 'select',
			'tab'  => 'page_title',
            'options' => array(
                1 => esc_html__('Show', 'tentered'),
                0 => esc_html__('Hide', 'tentered'),
            ),
            'std' => 1,
        ),
		array(
            'name' => esc_html__('Page Title Text Color', 'tentered'),
            'id' => $prefix . 'pages_banner_text_color',
            'desc' => esc_html__("Select banner text color.", 'tentered'),
            'type' => 'color',
			'tab'  => 'page_title'
        ),
		array(
            'name' => esc_html__('Page Title Alignment', 'tentered'),
            'id' => $prefix . 'pages_title_alignment',
            'desc' => esc_html__("Choose aligment of the page title.", 'tentered'),
            'type' => 'select',
			'tab'  => 'page_title',
            'options' => array(
				'' => esc_html__('Theme Default', 'tentered'),
				'left' => esc_html__('Left', 'tentered'),
				'center' => esc_html__('Center', 'tentered'),
                'right' => esc_html__('Right', 'tentered'),
            ),
        ),
		array(
            'name' => esc_html__('Page header sub title', 'tentered'),
            'desc' => esc_html__("Enter sub title for the page that will show below the page title in the page header area.", 'tentered'),
            'id' => $prefix . 'header_sub_title',
            'type' => 'text',
			'tab'  => 'page_title',
		),
		array(
            'name' => esc_html__('Breadcrumb Show/Hide', 'tentered'),
            'id' => $prefix . 'pages_breadcrumb_show',
            'type' => 'select',
			'tab'  => 'page_title',
            'options' => array(
                1 => esc_html__('Show', 'tentered'),
                0 => esc_html__('Hide', 'tentered'),
            ),
            'std' => 1,
        ),
		array(
            'name' => esc_html__('Show social sharing buttons', 'tentered'),
            'id' => $prefix . 'page_social_share',
            'type' => 'select',
			'tab'  => 'social_share',
            'options' => array(
                '1' => esc_html__('Show', 'tentered'),
                '0' => esc_html__('Hide', 'tentered'),
            ),
            'std' => 1,
        ),
	)
);

/* Post Meta Box
  ================================================== */
$meta_boxes[] = array(
    'id' => 'gallery_meta_box',
    'title' => esc_html__('Post media', 'tentered'),
    'pages' => array('post'),
	'context' => 'side',
	'priority' => 'low',
    'fields' => array(
        // Video Url
        array(
            'name' => esc_html__('Video URL', 'tentered'),
            'id' => $prefix . 'post_video_url',
            'desc' => esc_html__("Enter Youtube or Vimeo URL", 'tentered'),
            'type' => 'url',
			'visible' => ['post_format','video']
        ),
        // Link URL
        array(
            'name' => esc_html__('Link', 'tentered'),
            'id' => $prefix . 'post_link_url',
            'desc' => esc_html__("Enter the Link URL", 'tentered'),
            'type' => 'url',
			'visible' => ['post_format','link']
        ),
		array(
            'name' => esc_html__('Gallery Images', 'tentered'),
            'id' => $prefix . 'post_gallery_images',
            'desc' => esc_html__("Upload images for gallery", 'tentered'),
            'type' => 'image_advanced',
            'max_file_uploads' => 30,
			'visible' => ['post_format','gallery']
        ),
       array(
            'name' => esc_html__('Show Pagination', 'tentered'),
            'id' => $prefix . 'post_slider_pagination',
            'desc' => esc_html__("Select yes to show pagination for slider.", 'tentered'),
            'type' => 'select',
            'options' => array(
                'yes' => esc_html__('Yes', 'tentered'),
                'no' => esc_html__('No', 'tentered'),
            ),
			'visible' => ['post_format','gallery']
        ),
		array(
            'name' => esc_html__('Show Next/Prev Arrows', 'tentered'),
            'id' => $prefix . 'post_slider_direction_arrows',
            'desc' => esc_html__("Select Yes to show slider direction arrows.", 'tentered'),
            'type' => 'select',
            'options' => array(
                'yes' => esc_html__('Yes', 'tentered'),
                'no' => esc_html__('No', 'tentered'),
            ),
			'visible' => ['post_format','gallery']
        ),
		array(
            'name' => esc_html__('Slider Auto Slide', 'tentered'),
            'id' => $prefix . 'post_slider_auto_slide',
            'desc' => esc_html__("If you want the carousel to auto rotate then enter time for rotation interval. 1000 = 1 second.", 'tentered'),
            'type' => 'text',
			'visible' => ['post_format','gallery']
        ),
        //Audio Display
        array(
            'name' => esc_html__('Soundcloud URL', 'tentered'),
            'id' => $prefix . 'post_uploaded_audio',
            'desc' => esc_html__("Enter SoundCloud audio URL", 'tentered'),
            'type' => 'text',
			'visible' => ['post_format','audio']
        ),
    )
);
/* Testimonials Meta Box
  ================================================== */
$meta_boxes[] = array(
    'title' => esc_html__('Testimonial Author Info', 'tentered'),
    'pages' => array('testimonial'),
    'fields' => array(
        array(
            'name' => esc_html__('Sub title', 'tentered'),
            'id' => $prefix . 'testi_sub_title',
            'desc' => esc_html__("Enter sub title for the testimonial that will appear with the name of the author. It can be company name or job position.", 'tentered'),
            'type' => 'text',
        ),
    )
);
/* Services Meta Box
  ================================================== */
$meta_boxes[] = array(
    'title' => esc_html__('Service Info', 'tentered'),
    'pages' => array('service'),
    'fields' => array(
        array(
            'name' => esc_html__('Choose Icon', 'tentered'),
            'id' => $prefix . 'service_icon',
            'desc' => esc_html__("Enter class name of the icon you want to show for this service. All Font Awesome Icon classes can be found here: http://fontawesome.io/cheatsheet/ Use full class name for example: fa-camera", 'tentered'),
            'type' => 'text',
        ),
    )
);
/* Team Meta Box
  ================================================== */
$meta_boxes[] = array(
    'id' => 'team_meta_box',
    'title' => esc_html__('Team Member Information', 'tentered'),
    'pages' => array('team'),
	'priority' => 'high',
    'fields' => array(
		array(
            'name' => esc_html__('Job Position', 'tentered'),
            'id' => $prefix . 'staff_position',
            'desc' => esc_html__("Enter job position of team member.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Email', 'tentered'),
            'id' => $prefix . 'staff_member_email',
            'desc' => esc_html__("Enter the team member's Email.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Phone no.', 'tentered'),
            'id' => $prefix . 'staff_member_phone',
            'desc' => esc_html__("Enter the team member's Phone number.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Facebook', 'tentered'),
            'id' => $prefix . 'staff_member_facebook',
            'desc' => esc_html__("Enter team member's Facebook Account URL.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Twitter', 'tentered'),
            'id' => $prefix . 'staff_member_twitter',
            'desc' => esc_html__("Enter team member's Twitter Account URL.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Google Plus', 'tentered'),
            'id' => $prefix . 'staff_member_gplus',
            'desc' => esc_html__("Enter team member's Google Plus Profile URL.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Linkedin', 'tentered'),
            'id' => $prefix . 'staff_member_linkedin',
            'desc' => esc_html__("Enter team member's Linkedin Profile URL.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
		array(
            'name' => esc_html__('Pinterest', 'tentered'),
            'id' => $prefix . 'staff_member_pinterest',
            'desc' => esc_html__("Enter team member's Pinterest Profile URL.", 'tentered'),
            'type' => 'text',
            'std' => '',
        ),
    )
);
/* * ******************* META BOX REGISTERING ********************** */
/**
 * Register meta boxes
 *
 * @return void
 */
function tentered_register_meta_boxes() {
    global $meta_boxes;
    // Make sure there's no errors when the plugin is deactivated or during upgrade
    if (class_exists('RW_Meta_Box')) {
        foreach ($meta_boxes as $meta_box) {
            new RW_Meta_Box($meta_box);
        }
    }
}
add_action('rwmb_meta_boxes', 'tentered_register_taxonomy_meta_boxes');
function tentered_register_taxonomy_meta_boxes($meta_boxes) {
$prefix = 'tentered_';
/* Term Meta Box
  ================================================== */
$meta_boxes[] = array(
    'title' => esc_html__('Additional Info', 'tentered'),
    'taxonomies' => array('project-category', 'service-category', 'team-category', 'category'),
    'fields' => array(
		array(
            'name' => esc_html__('Page Image Banner', 'tentered'),
            'id' => $prefix . 'term_banner_image',
            'type' => 'image_advanced',
            'max_file_uploads' => 1
		),
    )
);
	return $meta_boxes;
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking Page template, categories, etc.
add_action('admin_init', 'tentered_register_meta_boxes');
/* * ******************* META BOX CHECK ********************** */
/**
 * Check if meta boxes is included
 *
 * @return bool
 */
function rw_maybe_include($template_file) {
    // Include in back-end only
    if (!defined('WP_ADMIN') || !WP_ADMIN)
        return false;
    // Always include for ajax
    if (defined('DOING_AJAX') && DOING_AJAX)
        return true;
    // Check for post IDs
    $checked_post_IDs = array();
    if (isset($_GET['post']))
        $post_id = $_GET['post'];
    elseif (isset($_POST['post_ID']))
        $post_id = $_POST['post_ID'];
    else
        $post_id = false;
    $post_id = (int) $post_id;
    if (in_array($post_id, $checked_post_IDs))
        return true;
    // Check for Page template
    $checked_templates = array($template_file);
    $template = get_post_meta($post_id, '_wp_page_template', true);
    if (in_array($template, $checked_templates))
        return true;
// If no condition matched
    return false;
}
?>