<?php

    /**
     * ReduxFramework Barebones Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
	load_theme_textdomain('tentered', TENTERED_FILEPATH . '/language');
    // This is your option name where all the Redux data is stored.
    $opt_name = "tentered_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'tentered' ),
        'page_title'           => esc_html__( 'Theme Options', 'tentered' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        // OPTIONAL -> Give you extra features
        'page_priority'        => 57,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.


        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/imithemes',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://twitter.com/imithemes',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
    } else {
    }

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */


    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'tentered' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */
			load_theme_textdomain('tentered', TENTERED_FILEPATH . '/language');
			$defaultAdminLogo = get_template_directory_uri().'/images/logo-admin.png';
			$defaultBannerImages = get_template_directory_uri().'/images/page-header.png';
			$default_logo = get_template_directory_uri() . '/images/logo.png';
			$default_retina_logo = get_template_directory_uri() . '/images/logo@2x.png';
    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-cogs',
    'icon_class' => 'icon-large',
    'title' => esc_html__('General', 'tentered'),
    'fields' => array(
        array(
            'id' => 'enable_maintenance',
            'type' => 'switch',
            'title' => esc_html__('Enable Maintenance', 'tentered'),
            'subtitle' => esc_html__('Enable the themes in maintenance mode.', 'tentered'),
            "default" => false,
            'on' => esc_html__('Enabled', 'tentered'),
            'off' => esc_html__('Disabled', 'tentered'),
        ),
        array(
            'id' => 'enable_backtotop',
            'type' => 'switch',
            'title' => esc_html__('Enable Back To Top', 'tentered'),
            'subtitle' => esc_html__('Enable the back to top button that appears in the bottom right corner of the screen.', 'tentered'),
            "default" => 1,
        ),
       array(
            'id' => 'space-before-head',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing head tag', 'tentered'),
            'subtitle' => esc_html__('Add your code before closing head tag', 'tentered'),
			'default' => '',
        ),
       array(
            'id' => 'space-before-body',
            'type' => 'ace_editor',
            'title' => esc_html__('Space before closing body tag', 'tentered'),
            'subtitle' => esc_html__('Add your code before closing body tag', 'tentered'),
			'default' => '',
        ),
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-website',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Responsive', 'tentered'),
    'fields' => array(
        array(
            'id' => 'switch-responsive',
            'type' => 'switch',
            'title' => esc_html__('Enable Responsive', 'tentered'),
            'subtitle' => esc_html__('Enable/Disable the responsive behaviour of the theme', 'tentered'),
            "default" => 1,
        ),
        array(
            'id' => 'switch-zoom-pinch',
            'type' => 'switch',
            'title' => esc_html__('Enable Zoom on mobile devices', 'tentered'),
            'subtitle' => esc_html__('Enable/Disable zoom pinch behaviour on touch devices', 'tentered'),
            "default" => 0,
        ),
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-screen',
    'icon_class' => 'icon-large',
    'title' => esc_html__('Layout', 'tentered'),
    'fields' => array(
        array(
			'id'=>'site_width',
			'type' => 'text',
			'compiler'=>true,
			'title' => esc_html__('Site Width', 'tentered'), 
			'subtitle' => esc_html__('Controls the overall site width. Without px, ex: 1170(Default). Recommended maximum width is 1170 to maintain the theme structure.', 'tentered'),
			'default' => '1170',
		),
        array(
			'id'=>'site_layout',
			'type' => 'image_select',
			'compiler'=>true,
			'title' => esc_html__('Page Layout', 'tentered'), 
			'subtitle' => esc_html__('Select the page layout type', 'tentered'),
			'options' => array(
					'wide' => array('alt' => 'Wide', 'img' => get_template_directory_uri().'/images/wide.png'),
					'boxed' => array('alt' => 'Boxed', 'img' => get_template_directory_uri().'/images/boxed.png')
				),
			'default' => 'wide',
			),
		array(
			'id'=>'repeatable-bg-image',
			'type' => 'image_select',
			'required' => array('site_layout','equals','boxed'),
			'title' => esc_html__('Repeatable Background Images', 'tentered'), 
			'subtitle' => esc_html__('Select image to set in background.', 'tentered'),
			'options' => array(
				'pt1.png' => array('alt' => 'pt1', 'img' => get_template_directory_uri().'/images/patterns/pt1.png'),
				'pt2.png' => array('alt' => 'pt2', 'img' => get_template_directory_uri().'/images/patterns/pt2.png'),
				'pt3.png' => array('alt' => 'pt3', 'img' => get_template_directory_uri().'/images/patterns/pt3.png'),
				'pt4.png' => array('alt' => 'pt4', 'img' => get_template_directory_uri().'/images/patterns/pt4.png'),
				'pt5.png' => array('alt' => 'pt5', 'img' => get_template_directory_uri().'/images/patterns/pt5.png'),
				'pt6.png' => array('alt' => 'pt6', 'img' => get_template_directory_uri().'/images/patterns/pt6.png'),
				'pt7.png' => array('alt' => 'pt7', 'img' => get_template_directory_uri().'/images/patterns/pt7.png'),
				'pt8.png' => array('alt' => 'pt8', 'img' => get_template_directory_uri().'/images/patterns/pt8.png'),
				'pt9.png' => array('alt' => 'pt9', 'img' => get_template_directory_uri().'/images/patterns/pt9.png'),
				'pt10.png' => array('alt' => 'pt10', 'img' => get_template_directory_uri().'/images/patterns/pt10.png'),
				'pt11.jpg' => array('alt' => 'pt11', 'img' => get_template_directory_uri().'/images/patterns/pt11.png'),
				'pt12.jpg' => array('alt' => 'pt12', 'img' => get_template_directory_uri().'/images/patterns/pt12.png'),
				'pt13.jpg' => array('alt' => 'pt13', 'img' => get_template_directory_uri().'/images/patterns/pt13.png'),
				'pt14.jpg' => array('alt' => 'pt14', 'img' => get_template_directory_uri().'/images/patterns/pt14.png'),
				'pt15.jpg' => array('alt' => 'pt15', 'img' => get_template_directory_uri().'/images/patterns/pt15.png'),
				'pt16.png' => array('alt' => 'pt16', 'img' => get_template_directory_uri().'/images/patterns/pt16.png'),
				'pt17.png' => array('alt' => 'pt17', 'img' => get_template_directory_uri().'/images/patterns/pt17.png'),
				'pt18.png' => array('alt' => 'pt18', 'img' => get_template_directory_uri().'/images/patterns/pt18.png'),
				'pt19.png' => array('alt' => 'pt19', 'img' => get_template_directory_uri().'/images/patterns/pt19.png'),
				'pt20.png' => array('alt' => 'pt20', 'img' => get_template_directory_uri().'/images/patterns/pt20.png'),
				'pt21.png' => array('alt' => 'pt21', 'img' => get_template_directory_uri().'/images/patterns/pt21.png'),
				'pt22.png' => array('alt' => 'pt22', 'img' => get_template_directory_uri().'/images/patterns/pt22.png'),
				'pt23.png' => array('alt' => 'pt23', 'img' => get_template_directory_uri().'/images/patterns/pt23.png'),
				'pt24.png' => array('alt' => 'pt24', 'img' => get_template_directory_uri().'/images/patterns/pt24.png'),
				'pt25.png' => array('alt' => 'pt25', 'img' => get_template_directory_uri().'/images/patterns/pt25.png'),
				'pt26.png' => array('alt' => 'pt26', 'img' => get_template_directory_uri().'/images/patterns/pt26.png'),
				'pt27.png' => array('alt' => 'pt27', 'img' => get_template_directory_uri().'/images/patterns/pt27.png'),
				'pt28.png' => array('alt' => 'pt28', 'img' => get_template_directory_uri().'/images/patterns/pt28.png'),
				'pt29.png' => array('alt' => 'pt29', 'img' => get_template_directory_uri().'/images/patterns/pt29.png'),
				'pt30.png' => array('alt' => 'pt30', 'img' => get_template_directory_uri().'/images/patterns/pt30.png')
				)
			),	
		array(
			'id'=>'upload-repeatable-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Repeatable Background Image', 'tentered')
			),
		array(
			'id'=>'full-screen-bg-image',
			'compiler'=>true,
			'required' => array('site_layout','equals','boxed'),
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Upload Full Screen Background Image', 'tentered')
		),	
    )
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Content', 'tentered'),
	'subsection' => true,
    'fields' => array(
		array(  'id' => 'content_background',
				'type' => 'background',
				'background-color'=> true,
				'output' => array('.content'),
				'title' => esc_html__('Content area Background', 'tentered'),
    			'subtitle' => esc_html__('Background color or image for the content area. This works for both boxed or wide layouts.', 'tentered'),
		),
		array(
			'id'       => 'content_padding',
			'type'     => 'spacing',
			'units'    => array('px'),
			'mode'	   => 'padding',
			'left'	   => false,
			'right'	   => false,
			'output'   => array('.content'),
			'title'    => esc_html__('Top and Bottom padding for content area', 'tentered'),
			'subtitle' => esc_html__('Enter top and bottom padding for content area. Default is 50px/50px', 'tentered'),
			'default'            => array(
			'padding-top'     => '60px',
			'padding-bottom'  => '60px',
			'units'          => 'px',
			),
		),
		array(
			'id'       => 'content_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Minimum Height for Content area', 'tentered'),
			'subtitle' => esc_html__('Enter minimum height for the page content area. DO NOT PUT px HERE. Default is 400', 'tentered'),
			'default'  => '400'
		),
        array(
			'id'=>'content_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Content Width', 'tentered'), 
			'subtitle' => esc_html__('Check this box to set the content area to 100% of the browser width. Uncheck to follow site width.', 'tentered'),
			'default' => '0',
		),

	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-up',
    'title' => esc_html__('Header', 'tentered'),
    'desc' => esc_html__('These are the options for the header.', 'tentered'),
    'fields' => array(
		array(
    		'id' => 'header_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Header Layout','tentered'), 
			'subtitle' => esc_html__('Select the Header layout', 'tentered'),
    			'options' => array(
					'1' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/1.png'),
    				'2' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/2.png'),
    				'3' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/3.png'),
    				'4' => array('title' => '', 'img' => get_template_directory_uri().'/images/headerlayouts/4.png'),
    				),
    		'default' => '1'
    	),
        array(
			'id'=>'header_wide_width',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('100% Header Width', 'tentered'), 
			'subtitle' => esc_html__('Check this box to set the header area to 100% of the browser width. Uncheck to follow site width.', 'tentered'),
			'default' => '0',
		),
		array(  'id' => 'header_background_alpha',
			'type' => 'background',
			'output' => array('.site-header'),
			'title' => esc_html__('Header Background', 'tentered'),
			'required' => array('header_layout','!=','2'),
		),
		array(
            'id' => 'header_info_text',
            'type' => 'text',
            'title' => esc_html__('Header Info Text', 'tentered'),
			'required' => array('header_layout','=','3'),
            'subtitle' => esc_html__('Enter text for header info on homepage 3', 'tentered'),
            'default' => ''
        ),
		array(
			'id'       => 'header_info_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => true,
			'line-height' => false,
			'text-align' => false,
			'required' => array('header_layout','=','3'),
			'title'    => esc_html__('Header Info Typograohy', 'tentered'),
			'output'   => array('.header_info_text')
		),
        array(
            'id' => 'enable-search',
            'type' => 'switch',
            'title' => esc_html__('Search in Header', 'tentered'),
			'required' => array('header_layout','!=','4'),
            'subtitle' => esc_html__('Enable/Disable search form in header', 'tentered'),
            "default" => 1,
        ),
        array(
            'id' => 'enable-cart',
            'type' => 'switch',
            'title' => esc_html__('Cart in Header', 'tentered'),
			'required' => array('header_layout','!=','4'),
            'subtitle' => esc_html__('Enable/Disable cart option in header', 'tentered'),
            "default" => 0,
        ),
		array(
			'id'       => 'search_cart_link_color',
			'type'     => 'link_color',
			'required' => array('header_layout','!=','4'),
			'title'    => esc_html__('Search, Cart Icon Link Color', 'tentered'),
			'desc'     => esc_html__('Set the links color, hover, active for search and cart icons in the header.', 'tentered'),
			'output'   => array('.search-module-trigger, .cart-module-trigger, .header-style3 .site-header .cart-module-trigger, .header-style3 .search-form-blocked button'),
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Sticky Header', 'tentered'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'enable_sticky_header',
            'type' => 'switch',
            'title' => esc_html__('Sticky Header', 'tentered'),
            'subtitle' => esc_html__('Enable/Disable Sticky header', 'tentered'),
            "default" => 1,
        ),
		array(  'id' => 'sticky_header_background',
			'type' => 'background',
			'background-color'=> true,
			'output' => array('.is-sticky #sticky-nav, body.sticky-menu-active .site-header'),
			'title' => esc_html__('Sticky Header Background', 'tentered'),
			'subtitle' => esc_html__('Background color or image for the header when its sticky.', 'tentered'),
		),
		array(
			'id'       => 'sticky_link_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Sticky Navigation Link Color', 'tentered'),
			'desc'     => esc_html__('Set the sticky navigation menu links color, hover, active.', 'tentered'),
			'output'   => array('.is-sticky .dd-menu > li > a, .header-style2 .is-sticky .dd-menu > li > a, .sticky-menu-active .dd-menu > li > a, .is-sticky .search-module-trigger, .is-sticky .cart-module-trigger, .header-style3.sticky-menu-active .cart-module-trigger'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Inner Page Header', 'tentered'),
	'subsection' => true,
    'fields' => array(
        array(
			'id'=>'inner_page_header_display',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Hide page header', 'tentered'), 
			'subtitle' => esc_html__('Check this box to hide page header on the inner pages/posts/custom posts. This can be used as default for all inner pages and can override the individual page design options.', 'tentered'),
			'default' => 0,
		),
		array(  
			'id' => 'inner_page_header_background',
			'type' => 'background',
			'background-color'=> true,
			'background-image'=> false,
			'background-repeat'=> false,
			'background-attachment'=> false,
			'background-size'=> false,
			'background-position'=> false,
			'preview'=> false,
			'output' => array('.page-banner'),
			'title' => esc_html__('Default Banner Color', 'tentered'),
			'subtitle' => esc_html__('Background color for the inner pages header.', 'tentered'),
		),
		array(
			'id'=>'tentered_default_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image', 'tentered'),
			'subtitle' => esc_html__('Upload default banner image for the inner pages header.', 'tentered'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_project_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Projects', 'tentered'),
			'subtitle' => esc_html__('Upload default banner image for the projects header.', 'tentered'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_post_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Blog Posts', 'tentered'),
			'subtitle' => esc_html__('Upload default banner image for the blog posts header.', 'tentered'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_service_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Services', 'tentered'),
			'subtitle' => esc_html__('Upload default banner image for the service posts header.', 'tentered'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_team_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for Team', 'tentered'),
			'subtitle' => esc_html__('Upload default banner image for the team posts header.', 'tentered'),
            'default' => array('url' => ''),
		),
		array(
			'id'=>'default_product_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Default Banner Image for WooCommerce products', 'tentered'),
			'subtitle' => esc_html__('Upload default banner image for the woocommerce product posts header.', 'tentered'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'inner_page_header_min_height',
			'type'     => 'text',
			'title'    => esc_html__('Default Height', 'tentered'),
			'subtitle' => esc_html__('Enter default height for the inner pages header. DO NOT PUT px HERE', 'tentered'),
		),
        array(
			'id'=>'inner_page_header_title',
			'type' => 'checkbox',
			'compiler'=>true,
			'title' => esc_html__('Show page title', 'tentered'), 
			'subtitle' => esc_html__('Check this box to show page title in the page banner. Uncheck to hide. This can be used as default for all inner pages and can override the individual page design options.', 'tentered'),
			'default' => '1',
		),
        array(
            'id' => 'inner_page_header_title_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Title Typography', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => true,
			'text-align'	  => true,
            'font-weight' => true,
            'font-style' => true,
			'font-size'	  => true,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('.page-banner-image .page-banner-text h1, .page-banner-image .page-banner-text p, .page-banner-image .breadcrumb, .page-banner-image .breadcrumb a'),
			'units'       =>'px',
        ),
        array(
            'id' => 'page_title_sec',
            'type' => 'section',
			'indent' => true,
            'title' => esc_html__('Archive Page Titles', 'tentered'),
        ),
		array(
            'id' => 'project_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Projects Archive', 'tentered'),
            'subtitle' => esc_html__('Enter title of the archive page for the Projects post type.', 'tentered'),
            'default' => 'Projects'
        ),
		array(
            'id' => 'blog_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Blog Archive', 'tentered'),
            'subtitle' => esc_html__('Enter title of the archive page for the Blog post type.', 'tentered'),
            'default' => 'Blog'
        ),
		array(
            'id' => 'service_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Services Archive', 'tentered'),
            'subtitle' => esc_html__('Enter title of the archive page for the Services post type.', 'tentered'),
            'default' => 'Services'
        ),
		array(
            'id' => 'team_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Team Archive', 'tentered'),
            'subtitle' => esc_html__('Enter title of the archive page for the Team post type.', 'tentered'),
            'default' => 'Team'
        ),
		array(
            'id' => 'shop_archive_title',
            'type' => 'text',
            'title' => esc_html__('Title for Shop Archive', 'tentered'),
            'subtitle' => esc_html__('Enter title of the archive page for the Products/Shop post type.', 'tentered'),
            'default' => 'Shop'
        ),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Topbar', 'tentered'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'show_topbar',
            'type' => 'checkbox',
            'title' => esc_html__('Show Topbar', 'tentered'),
            'subtitle' => esc_html__('Enable/Disable Topbar', 'tentered'	
			),
            "default" => 1,
       	),
		array(  'id' => 'topbar_background',
			'type' => 'background',
			'background-color'=> true,
			'background-image'=> false,
			'background-repeat'=> false,
			'background-attachment'=> false,
			'background-size'=> false,
			'background-position'=> false,
			'preview'=> false,
			'output' => array('.topbar'),
			'title' => esc_html__('Background Color', 'tentered'),
			'subtitle' => esc_html__('Background color for the topbar header.', 'tentered'),
		),
        array(
			'id' => 'header_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'title' => esc_html__('Social Links', 'tentered'),
			'desc' => esc_html__('Enter the social links and sort to active and display according to sequence in Header topBar.', 'tentered'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo-square' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Enter Email Address'
			),
		),
        array(
            'id' => 'topbar_social_icon_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Topbar Menu/Social Icons Typography', 'tentered'),
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
			'font-size'	  => true,
			'line-height' => true,
			'output'      => array('.topbar .secondary-menu > ul > li > a'),
			'units'       =>'px',
        ),
		array(
			'id'       => 'topbar_social_icon_color',
			'type'     => 'link_color',
			'visited'  => false,
			'output'   => array('.topbar .secondary-menu > ul > li > a'),
			'title'    => esc_html__('Topbar Links Color', 'tentered'),
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-upload',
    'title' => esc_html__('Logo', 'tentered'),
    'desc' => esc_html__('These are the options for the header.', 'tentered'),
    'fields' => array(
        array(
            'id' => 'logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo', 'tentered'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'tentered'),
            'default' => array('url' => $default_logo,'height' => '17',),
        ),
        array(
            'id' => 'retina_logo_upload',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Upload Logo for Retina Devices', 'tentered'),
            'desc' => esc_html__('Retina Display is a marketing term developed by Apple to refer to devices and monitors that have a resolution and pixel density so high &ndash; roughly 300 or more pixels per inch', 'tentered'),
            'subtitle' => esc_html__('Upload site logo to display in header.', 'tentered'),
            'default' => array('url' => $default_retina_logo),
        ),
		array(
            'id' => 'retina_logo_width',
            'type' => 'text',
            'title' => esc_html__('Standard Logo Width for Retina Logo', 'tentered'),
            'subtitle' => esc_html__('If retina logo is uploaded, enter the standard logo (1x) version width, do not enter the retina logo width.', 'tentered'),
            'default' => '114'
        ),
		array(
            'id' => 'retina_logo_height',
            'type' => 'text',
            'title' => esc_html__('Standard Logo Height for Retina Logo', 'tentered'),
            'subtitle' => esc_html__('If retina logo is uploaded, enter the standard logo (1x) version height, do not enter the retina logo height.', 'tentered'),
            'default' => '17'
        ),
		array(
			'id'             => 'logo_spacing',
			'type'           => 'spacing',
			'output'         => array('.site-logo'),
			'mode'           => 'margin',
			'units'          => array('px'),
			'units_extended' => 'false',
			'required' 		 => array('header_layout','!=','3'),
			'title'          => esc_html__('Logo Spacing', 'tentered'),
			'subtitle'       => esc_html__('Set top, right, bottom, left spacing for the logo', 'tentered'),
			'default' 		 => array(
								'margin-top' => '30px',
								'margin-bottom' => '30px'
							)
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Admin Logo', 'tentered'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'custom_admin_login_logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Custom admin login logo', 'tentered'),
            'compiler' => 'true',
            //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
            'desc' => esc_html__('Upload a 254 x 95px image here to replace the default wordpress login logo.', 'tentered'),
            'default' => array('url' => $defaultAdminLogo),
        )
	)
));

Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-lines',
    'title' => esc_html__('Menu', 'tentered'),
    'desc' => esc_html__('These are the options for the menu.', 'tentered'),
    'fields' => array(
        array(
            'id' => 'nav_directions_arrows',
            'type' => 'checkbox',
            'title' => esc_html__('Direction arrows with menu label', 'tentered'),
            'subtitle' => esc_html__('Uncheck to disable arrows that appear with menu text which is having dropdown. Check to enable.', 'tentered'),
            "default" => 1,
        ),
		array(
			'id'       => 'main_nav_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Main Navigation Links Typography', 'tentered'),
			'output'   => array('.dd-menu > li > a, .search-module-trigger, .cart-module-trigger')
		),
		array(
			'id'       => 'main_nav_link',
			'type'     => 'link_color',
			'title'    => esc_html__('Main Navigation Link Color', 'tentered'),
			'desc'     => esc_html__('Set the Main Navigation links color, hover, active.', 'tentered'),
			'output'   => array('.header-style1 .dd-menu > li > a, .header-style2 .dd-menu > li > a, .header-style3 .dd-menu > li > a, .header-style4 .dd-menu > li > a'),
		),
		array(
			'id'       => 'main_nav_link_active',
			'type'     => 'link_color',
			'title'    => esc_html__('Main Navigation current menu link Color', 'tentered'),
			'desc'     => esc_html__('Set the Main Navigation links color for active page.', 'tentered'),
			'output'   => array('.header-style1 .dd-menu > li.current-menu-item > a, .header-style2 .dd-menu > li.current-menu-item > a, .header-style3 .dd-menu > li.current-menu-item > a, .header-style4 .dd-menu > li.current-menu-item > a'),
		),
		array(
            'id' => 'dd_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
			'output' => array('.dd-menu > li ul, .header-style3 .dd-menu > li:hover > a, .header-style4 .dd-menu > li:hover > a, .header-style3 .dd-menu > li ul, .header-style4 .dd-menu > li ul'),
            'title' => esc_html__('Background color for dropdown menus', 'tentered'),
            'desc' => esc_html__('Background color set for the dropdowns of main navigation.', 'tentered'),
        ),
		array(
			'id'       => 'dd_item_border',
			'type'     => 'border',
			'title'    => esc_html__('Dropdown links border bottom', 'tentered'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a'),
			'top' 	   => false,
			'left' 	   => false,
			'right' 	   => false,
			'bottom' 	=> true
		),
		array(
			'id'       => 'dd_item_spacing',
			'type'     => 'spacing',
			'title'    => esc_html__('Dropdown links spacing', 'tentered'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a'),
			'mode' 	   => 'padding',
			'units'    => array('px'),
		),
		array(
            'id' => 'dd_item_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
			'output' => array('.dd-menu > li > ul > li > a:hover, .dd-menu > li > ul > li > ul > li > a:hover, .dd-menu > li > ul > li > ul > li > ul > li > a:hover, .header-style4 .dd-menu > li > ul > li > a:hover, .header-style4 .dd-menu > li > ul > li > ul > li > a:hover, .header-style4 .dd-menu > li > ul > li > ul > li > ul > li > a:hover, .header-style3 .dd-menu > li > ul > li > a:hover, .header-style3 .dd-menu > li > ul > li > ul > li > a:hover, .header-style3 .dd-menu > li > ul > li > ul > li > ul > li > a:hover'),
            'title' => esc_html__('Background color for dropdown menus links hover', 'tentered'),
        ),
		array(
			'id'       => 'dd_item_link_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'color' => false,
			'line-height' => false,
			'text-align' => false,
			'title'    => esc_html__('Dropdown Menu Links Typography', 'tentered'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a')
		),
		array(
			'id'       => 'dd_item_link_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Dropdown links color', 'tentered'),
			'output'   => array('.dd-menu > li > ul > li > a, .dd-menu > li > ul > li > ul > li > a, .dd-menu > li > ul > li > ul > li > ul > li > a, .header-style3 .dd-menu > li > ul > li > a, .header-style3 .dd-menu > li > ul > li > ul > li > a, .header-style3 .dd-menu > li > ul > li > ul > li > ul > li > a, .header-style4 .dd-menu > li > ul > li > a, .header-style4 .dd-menu > li > ul > li > ul > li > a, .header-style4 .dd-menu > li > ul > li > ul > li > ul > li > a')
		),
		array(
            'id' => 'mm_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
			'output' => array('.dd-menu > li.megamenu > ul, .header-style3 .dd-menu > li.megamenu ul'),
            'title' => esc_html__('Megamenu Background color', 'tentered'),
        ),
		array(
			'id'       => 'mm_title_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'title'    => esc_html__('Megamenu Column Title Typography', 'tentered'),
			'output'   => array('.dd-menu .megamenu-container .megamenu-sub-title, .dd-menu .megamenu-container .widget .widgettitle, .dd-menu .megamenu-container .widget .widget-title')
		),
		array(
			'id'       => 'mm_content_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'title'    => esc_html__('Megamenu Content Typography', 'tentered'),
			'output'   => array('.dd-menu .megamenu-container')
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Mobile Menu', 'tentered'),
	'subsection' => true,
    'fields' => array(
		array(
			'id'       => 'menu_toggle_typo',
			'type'     => 'typography',
			'text-transform' => false,
			'font-family' => false,
			'font-weight' => false,
			'font-style' => false,
			'line-height'=> false,
			'color' => false,
			'text-align' => false,
			'preview' => false,
			'title'    => esc_html__('Mobile Menu opener icon size', 'tentered'),
			'output'   => array('.mmenu-toggle'),
		),
		array(
			'id'       => 'menu_toggle_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Mobile Menu opener icon color', 'tentered'),
			'output'   => array('#menu-toggle')
		),
		array(
			'id'       => 'mobile_menu_drop_top_position',
			'type'     => 'text',
			'title'    => esc_html__('Mobile Menu space from top', 'tentered'),
			'desc'    => esc_html__('DO NOT PUT px HERE.', 'tentered'),
		),
		array(
            'id' => 'mobile_menu_background',
            'type' => 'background',
			'background-image' => false,
			'background-repeat' => false,
			'background-size' => false,
			'background-position' => false,
			'background-attachment' => false,
			'preview' => false,
			'transparent' => false,
            'title' => esc_html__('Background color for mobile menu', 'tentered'),
            'desc' => esc_html__('Background color set for the mobile navigation.', 'tentered'),
        ),
		array(
			'id'       => 'mobile_menu_typo',
			'type'     => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'text-align' => false,
			'title'    => esc_html__('Mobile Menu Typography', 'tentered'),
			'output'   => array('.mobile-menu .dd-menu > li > a, .mobile-menu .dd-menu > li > ul > li > a, .mobile-menu .dd-menu > li > ul > li > ul > li > a, .mobile-menu .dd-menu > li > a:hover, .mobile-menu .dd-menu > li:hover > a')
		),
		array(
			'id'       => 'mobile_menu_color',
			'type'     => 'link_color',
			'title'    => esc_html__('Mobile Menu links color', 'tentered'),
		),
		array(
			'id'       => 'mobile_menu_border',
			'type'     => 'border',
			'all'	   => false,
			'title'    => esc_html__('Mobile Menu links border bottom', 'tentered'),
			'top' 	   => false,
			'left' 	   => false,
			'right' 	   => false,
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-chevron-down',
    'title' => esc_html__('Footer', 'tentered'),
    'desc' => esc_html__('These are the options for the footer.', 'tentered'),
    'fields' => array(
        array(
            'id' => 'full_width_footer',
            'type' => 'checkbox',
            'title' => esc_html__('100% Footer Width', 'tentered'),
            'subtitle' => esc_html__('Check this box to set footer width to 100% of the browser width. Uncheck to follow site width. Only works with wide layout mode.', 'tentered'),
            "default" => 0,
        ),
        array(
            'id' => 'footer_top_sec',
            'type' => 'section',
			'indent' => true,
            'title' => esc_html__('Footer Widgets Area', 'tentered'),
        ),
		array(
    		'id' => 'footer_layout',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Footer Layout', 'tentered'), 
			'subtitle' => esc_html__('Select the footer widgeted area layout', 'tentered'),
    			'options' => array(
					'12' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-1.png'),
    				'6' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-2.png'),
    				'4' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-3.png'),
    				'3' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-4.png'),
					'2' => array('title' => '', 'img' => get_template_directory_uri().'/images/footerColumns/footer-5.png'),
    							),
    		'default' => '4'
    	),
		array(  'id' => 'footer_background',
				'type' => 'background',
				'background-color'=> true,
				'output' => array('.site-footer-top'),
				'title' => esc_html__('Footer widgets area Background', 'tentered'),
    			'subtitle' => esc_html__('Background color or image for the footer widgets area.', 'tentered'),
		),
		array(
			'id'       => 'footer_top_spacing',
			'type'     => 'spacing',
			'left' => false,
			'right' => false,
			'title'    => esc_html__('Footer widgets area Top/Bottom padding', 'tentered'),
            'desc' => esc_html__('Enter top and bottom spacing for the footer widget area. DO NOT ENTER px HERE.', 'tentered'),
			'mode' 	   => 'padding',
			'output' => array('.site-footer-top'),
			'units'    => array('px'),
		),
        array(
			'id'          => 'tfooter_border',
			'type'        => 'border',
			'title'       => esc_html__('Footer widgets area border top', 'tentered'),
			'left' => false,
			'right' => false,
			'bottom' => false,
			'top' => true,
			'output'      => array('.site-footer-top'),
		),
        array(
			'id'          => 'widgettitle_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets title typography', 'tentered'),
			'output'      => array('.footer_widget h4.widgettitle, .footer_widget h4.widget-title'),
		),
        array(
			'id'          => 'tfwidget_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'word-spacing' => true,
			'letter-spacing' => true,
			'title'       => esc_html__('Footer widgets area text typography', 'tentered'),
			'output'      => array('.site-footer .footer_widget'),
		),
        array(
			'id'          => 'tfooter_link_color',
			'type'        => 'link_color',
			'title'       => esc_html__('Footer widgets area links color', 'tentered'),
			'output'      => array('.body .site-footer-top .footer_widget a'),
		),
        array(
            'id' => 'footer_bottom_sec',
            'type' => 'section',
			'indent' => true,
            'title' => esc_html__('Footer Copyrights Area', 'tentered'),
        ),
        array(
            'id' => 'footer_bottom_enable',
            'type' => 'checkbox',
            'title' => esc_html__('Enable Footer copyrights area', 'tentered'),
            'desc' => __('Uncheck to disable footer copyrights area that comes below the footer widgets area.', 'tentered'),
			'default' => 1
        ),
        array(
			'id'          => 'bfooter_bg',
			'type'        => 'background',
			'title'       => esc_html__('Footer copyrights area background', 'tentered'),
			'output'      => array('.site-footer-bottom'),
		),
		array(
			'id'       => 'footer_bottom_spacing',
			'type'     => 'spacing',
			'left' => false,
			'right' => false,
			'title'    => esc_html__('Footer copyrights area Top/Bottom padding', 'tentered'),
            'desc' => __('Enter top and bottom spacing for the footer copyrights area. DO NOT ENTER px HERE.', 'tentered'),
			'mode' 	   => 'padding',
			'output' => array('.site-footer-bottom'),
			'units'    => array('px'),
		),
        array(
			'id'          => 'bfooter_border',
			'type'        => 'border',
			'title'       => esc_html__('Footer copyrights area border top', 'tentered'),
			'left' => false,
			'right' => false,
			'bottom' => false,
			'top' => true,
			'output'      => array('.site-footer-bottom'),
		),
        array(
            'id' => 'footer_copyright_text',
            'type' => 'text',
            'title' => esc_html__('Footer Copyright Text', 'tentered'),
            'subtitle' => esc_html__(' Enter Copyright Text', 'tentered'),
            'default' => esc_html__('All Rights Reserved', 'tentered')
        ),
        array(
			'id'          => 'bfwidget_typo',
			'type'        => 'typography',
			'text-transform' => true,
			'title'       => esc_html__('Footer copyrights area text typography', 'tentered'),
			'output'      => array('.site-footer-bottom'),
		),
        array(
			'id'          => 'bfooter_link_color',
			'type'        => 'link_color',
			'title'       => esc_html__('Footer copyrights area links color', 'tentered'),
			'output'      => array('.body .site-footer-bottom a'),
		),
		array(
			'id'=>'footer_bottom_cont_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Copyrights footer right', 'tentered'), 
			'subtitle' => esc_html__('Choose what to display at the right corner of copyrights footer area.', 'tentered'),
			'options' => array(
				0 => esc_html__('Menu','tentered'),
				1 => esc_html__('Social Icons','tentered'),
				2 => esc_html__('None','tentered'),
			),
			'default' => '0',
		),
		array(
			'id'   => 'info_footer_menu_type',
			'type' => 'info',
			'style' => 'info',
			'required' => array('footer_bottom_cont_type','=',0),
			'desc' => esc_html__('If menu option is chosen then you can set a Menu for location "Footer Menu" at Appearance > Menus', 'tentered')
		),
		array(
			'id' => 'footer_social_links',
			'type' => 'sortable',
			'label' => true,
			'compiler'=>true,
			'required' => array('footer_bottom_cont_type','=','1'),
			'title' => esc_html__('Social Links', 'tentered'),
			'desc' => esc_html__('Insert Social URL in their respective fields and sort as your desired order.', 'tentered'),
			'options' => array(
				'fa-facebook' => 'facebook',
				'fa-twitter' => 'twitter',
				'fa-pinterest' => 'pinterest',
				'fa-google-plus' => 'google',
				'fa-youtube' => 'youtube',
				'fa-instagram' => 'instagram',
				'fa-vimeo-square' => 'vimeo',
				'fa-rss' => 'rss',
				'fa-dribbble' => 'dribbble',
				'fa-dropbox' => 'dropbox',
				'fa-bitbucket' => 'bitbucket',
				'fa-flickr' => 'flickr',
				'fa-foursquare' => 'foursquare',
				'fa-github' => 'github',
				'fa-gittip' => 'gittip',
				'fa-linkedin' => 'linkedin',
				'fa-pagelines' => 'pagelines',
				'fa-skype' => 'Enter Skype ID',
				'fa-tumblr' => 'tumblr',
				'fa-vk' => 'vk',
				'fa-envelope' => 'Enter Email Address'
			),
		),
		array(
			'id'=>'footer_bottom_icons',
			'required' => array('footer_bottom_cont_type','=','1'),
			'type' => 'typography',
			'google'      => false,
			'font-family'      => false,
			'font-backup' => false,
			'subsets' 	  => false,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => false,
            'font-style' => false,
			'font-size'	  => true,
            'word-spacing'=>false,
			'line-height' => true,
			'letter-spacing' => false,
			'text-transform' => false,
			'preview' => false,
			'output' => array('.copyrights-col-right .social-icons-bar li a'),
			'title' => esc_html__('Social icons size for Site Footer Bottom Social icons', 'tentered'),
		),
		array(
			'id'=>'footer_bottom_icons_link_color',
			'required' => array('footer_bottom_cont_type','=','1'),
			'compiler'=>true,
			'type' => 'link_color',
			'output' => array('.copyrights-col-right .social-icons-bar li a'),
			'title' => esc_html__('Link, Hover, Active Color sets for Site Footer Bottom Social icons', 'tentered'),
		),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-lines',
    'title' => esc_html__('Sidebars', 'tentered'),
    'fields' => array(
        array(
    		'id' => 'sidebar_position',
    		'type' => 'image_select',
    		'compiler'=>true,
			'title' => esc_html__('Sidebar position','tentered'), 
			'subtitle' => esc_html__('Select the Global Sidebar Position. Can be overridden by page sidebar settings.', 'tentered'),
    			'options' => array(
    				'2' => array('title' => 'Left', 'img' => get_template_directory_uri().'/images/2cl.png'),
					'1' => array('title' => 'Right', 'img' => get_template_directory_uri().'/images/2cr.png')
    				),
    		'default' => '1'
    	),
		array(
			'id'       => 'page_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Pages Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all pages.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'blog_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Blog Posts Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all single posts.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'blog_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Blog Posts Archive/Category Pages Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all blog posts category/archive pages.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'project_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Project Posts Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all single project pages.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'project_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Project Posts Archive/Category Projects Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all project posts category pages.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'service_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Service Posts Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all single service pages.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'service_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Service Posts Archive/Category Pages Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all service posts category pages.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'team_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Team Posts Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all team posts.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'team_archive_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Team Posts Archive/Category Pages Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar that will display on all team posts category pages.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'search_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Search Page Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar for search results page.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
		array(
			'id'       => 'product_sidebar',
			'type'     => 'select',
			'title'    => esc_html__('Woocommerce Pages Sidebar', 'tentered'), 
			'desc'     => esc_html__('Select sidebar for Woocommerce pages including shop, cart, checkout.', 'tentered'),
			'data'  => 'sidebars',
			'default'  => '',
		),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-share',
    'title' => esc_html__('Social Sharing', 'tentered'),
    'fields' => array(
        array(
            'id' => 'switch_sharing',
            'type' => 'switch',
            'title' => esc_html__('Social Sharing', 'tentered'),
            'subtitle' => esc_html__('Enable/Disable theme default social sharing buttons for posts/projects/services/team single pages', 'tentered'	
			),
            "default" => 1,
       	),
		 array(
			'id'=>'sharing_style',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Share Buttons Style', 'tentered'), 
			'subtitle' => esc_html__('Choose the style of share button icons', 'tentered'),
			'options' => array(
					'0' => esc_html__('Rounded','tentered'),
					'1' => esc_html__('Squared','tentered')
				),
			'default' => '0',
			),
		 array(
			'id'=>'sharing_color',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Share Buttons Color', 'tentered'), 
			'subtitle' => esc_html__('Choose the color scheme of the share button icons', 'tentered'),
			'options' => array(
					'0' => esc_html__('Brand Colors','tentered'),
					'1' => esc_html__('Theme Color','tentered'),
					'2' => esc_html__('GrayScale','tentered')
				),
			'default' => '0',
			),
		array(
			'id'       => 'share_icon',
			'type'     => 'checkbox',
			'required' => array('switch_sharing','equals','1'),
			'title'    => esc_html__('Social share options', 'tentered'),
			'subtitle' => esc_html__('Click on the buttons to disable/enable share buttons', 'tentered'),
			'options'  => array(
				'1' => esc_html__('Facebook','tentered'),
				'2' => esc_html__('Twitter','tentered'),
				'3' => esc_html__('Google','tentered'),
				'4' => esc_html__('Tumblr','tentered'),
				'5' => esc_html__('Pinterest','tentered'),
				'6' => esc_html__('Reddit','tentered'),
				'7' => esc_html__('Linkedin','tentered'),
				'8' => esc_html__('Email','tentered'),
				'9' => esc_html__('VKontakte','tentered'),
				'10' => esc_html__('Whatsapp','tentered')
			),
			'default' => array(
				'1' => '1',
				'2' => '1',
				'3' => '1',
				'4' => '1',
				'5' => '1',
				'6' => '1',
				'7' => '1',
				'8' => '1',
				'9' => '0',
				'10' => '0'
			)
		),
		array(
			'id'       => 'share_post_types',
			'type'     => 'checkbox',
			'required' => array('switch_sharing','equals','1'),
			'title'    => esc_html__('Select share buttons for post types', 'tentered'),
			'subtitle'     => esc_html__('Uncheck to disable for any type', 'tentered'),
			'options'  => array(
				'1' => esc_html__('Posts','tentered'),
				'2' => esc_html__('Pages','tentered'),
				'3' => esc_html__('Team','tentered'),
				'4' => esc_html__('Projects','tentered'),
				'5' => esc_html__('Services','tentered')
			),
			'default' => array(
				'1' => 1,
				'2' => 1,
				'3' => 1,
				'4' => 1,
				'5' => 1,
			)
		),
		array(
			'id'       => 'share_links_alt',
			'type'     => 'section',
			'indent' => true,
			'title'    => esc_html__('Sharing links alt/title text', 'tentered'),
		),
		array(
            'id' => 'facebook_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Facebook share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Facebook share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Share on Facebook','tentered')
        ),
		array(
            'id' => 'twitter_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Twitter share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Twitter share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Tweet','tentered')
        ),
		array(
            'id' => 'google_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Google Plus share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Google Plus share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Share on Google+','tentered')
        ),
		array(
            'id' => 'tumblr_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Tumblr share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Tumblr share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Post to Tumblr','tentered')
        ),
		array(
            'id' => 'pinterest_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Pinterest share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Pinterest share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Pin it','tentered')
        ),
		array(
            'id' => 'reddit_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Reddit share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Reddit share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Submit to Reddit','tentered')
        ),
		array(
            'id' => 'linkedin_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Linkedin share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Linkedin share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Share on Linkedin','tentered')
        ),
		array(
            'id' => 'email_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Email share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the Email share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Email','tentered')
        ),
		array(
            'id' => 'vk_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for VK share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the vk share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Share on vk','tentered')
        ),
		array(
            'id' => 'whatsapp_share_alt',
            'type' => 'text',
            'title' => esc_html__('Tooltip text for Whatsapp share icon', 'tentered'),
            'subtitle' => esc_html__('Text for the whatsapp share icon browser tooltip.', 'tentered'),
            'default' => esc_html__('Share on vk','tentered')
        ),
		array(
			'id'       => 'share_links_styling',
			'type'     => 'section',
			'indent' => true,
			'title'    => esc_html__('Sharing icons styling', 'tentered'),
		),
		array(
			'id'       => 'share_before_icon',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show sharing icon before the sharing icons', 'tentered'),
			'default' => 0
		),
		array(
			'id'       => 'share_before_text',
			'type'     => 'text',
			'title'    => esc_html__('Enter title to show before the sharing icons', 'tentered'),
			'default' => ''
		),
		array(
			'id'       => 'share_before_typo',
			'type'     => 'typography',
			'title'    => esc_html__('Share before text/icon typography', 'tentered'),
			'output'   => array('.social-share-bar .share-title'),
			'default' => array(
				'line-height' => '30px'
			)
		),
		array(
			'id'       => 'share_icons_box_size',
			'type'     => 'dimensions',
			'title'    => esc_html__('Share icons box size', 'tentered'),
			'output'   => array('.social-share-bar li a'),
			'default' => array(
				'height' => '30px',
				'width' => '30px'
			)
		),
		array(
			'id'       => 'share_icons_font_size',
			'type'     => 'typography',
			'title'    => esc_html__('Share icons font size', 'tentered'),
			'desc'    => esc_html__('Keep line height same as height of icon boxes set above', 'tentered'),
			'font-weight' => false,
			'font-family' => false,
			'font-style' => false,
			'text-align' => false,
			'preview' => false,
			'color' => false,
			'output'   => array('.social-share-bar li a'),
			'default' => array(
				'line-height' => '30px',
				'font-size' => '14px'
			)
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-brush',
    'title' => esc_html__('Color Scheme', 'tentered'),
    'fields' => array(
		 array(
			'id'=>'theme_color_type',
			'type' => 'button_set',
			'compiler'=>true,
			'title' => esc_html__('Color scheme', 'tentered'), 
			'options' => array(
					'0' => esc_html__('Pre-Defined Color Schemes','tentered'),
					'1' => esc_html__('Custom Color','tentered')
				),
			'default' => '0',
			),
        array(
            'id' => 'theme_color_scheme',
            'type' => 'select',
			'required' => array('theme_color_type','equals','0'),
            'title' => esc_html__('Theme Color Scheme', 'tentered'),
            'subtitle' => esc_html__('Select from pre built color schemes.', 'tentered'),
            'options' => array('color1.css' => 'color1.css', 'color2.css' => 'color2.css', 'color3.css' => 'color3.css', 'color4.css' => 'color4.css', 'color5.css' => 'color5.css', 'color6.css' => 'color6.css', 'color7.css' => 'color7.css', 'color8.css' => 'color8.css', 'color9.css' => 'color9.css', 'color10.css' => 'color10.css'),
            'default' => 'color1.css',
        ),
		array(
			'id'=>'primary_theme_color',
			'type' => 'color',
			'required' => array('theme_color_type','equals','1'),
			'title' => esc_html__('Primary Theme Color', 'tentered'), 
			'subtitle' => esc_html__('Pick a primary color.', 'tentered'),
			'validate' => 'color',
			'transparent' => false,
		),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-font',
    'title' => esc_html__('Typography', 'tentered'),
    'subtitle' => esc_html__('Global Font Family Sets', 'tentered'),
	'desc' => esc_html__('These options are as per the design which consists of 3 fonts. For more advanced typography options see Sub Sections below this in Left Sidebar. Make sure you set these options only if you have knowledge about every property to avoid disturbing the whole layout. If something went wrong just reset this section to reset all fields in Typography Options or click the small cross signs in each select field/delete text from input fields to reset them.', 'tentered'),
    'fields' => array(
        array(
            'id' => 'heading_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Heading font', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'output'      => array('h1,h2,h3,h4,h5,h6,blockquote,.dd-menu .megamenu-container .megamenu-sub-title'),
			'units'       =>'px',
            'subtitle' => esc_html__('Choose font style Headings', 'tentered'),
            'default' => array(
            	'font-family' => 'Poppins',
				'font-weight' => '300',
            ),
        ),
        array(
            'id' => 'body_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body/Primary font', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'output'      => array('body'),
			'units'       =>'px',
	    	'subtitle' => esc_html__('Choose font style Body text.', 'tentered'),
            'default' => array(
             	'font-family' => 'Roboto',
             	'font-weight' => '300',
              ),
        ),
        array(
            'id' => 'date_font_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Secondary font', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'color' 		  => false,
			'text-align'	  => false,
            'font-weight' => true,
            'font-style' => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'letter-spacing' => false,
			'output'      => array('.date, .project-categories, .team-position, .comments li .meta-data'),
			'units'       =>'px',
            'subtitle' => esc_html__('Choose font style for date info', 'tentered'),
            'default' => array(
            	'font-family' => 'Volkhov',
				'font-backup' => '',
               ),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('More Options', 'tentered'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'body_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('Body', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('body'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for body text', 'tentered'),
        ),
        array(
            'id' => 'h1_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H1 Title', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h1'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H1 title', 'tentered'),
        ),
        array(
            'id' => 'h2_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H2 Title', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h2'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H2 title', 'tentered'),
        ),
        array(
            'id' => 'h3_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H3 Title', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h3'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H3 title', 'tentered'),
        ),
        array(
            'id' => 'h4_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H4 Title', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h4'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H4 title', 'tentered'),
        ),
        array(
            'id' => 'h5_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H5 Title', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h5'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H5 title', 'tentered'),
        ),
        array(
            'id' => 'h6_tag_typography',
            'type'        => 'typography',
			'title'       => esc_html__('H6 Title', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => true,
			'font-style' 	  => true,
			'text-align'	  => false,
            'word-spacing'=>true,
			'line-height' => true,
			'letter-spacing' => true,
			'output'      => array('h6'),
			'units'       =>'px',
            'subtitle' => esc_html__('Typography options for H6 title', 'tentered'),
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
    'title' => esc_html__('Additional Styles', 'tentered'),
    'desc' => esc_html__('Choose and select font families and styles for Google Fonts that are not loaded with the primary typography options. For example add different weight and style for a same font family you choose for your Typography options above.', 'tentered'),
	'subsection' => true,
    'fields' => array(
        array(
            'id' => 'nowhere_font1',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 1', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'font-weight' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Volkhov',
				'font-style' => 'italic',
				'font-weight' => '400',
               ),
        ),
        array(
            'id' => 'nowhere_font2',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 2', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Roboto',
				'font-weight' => '700',
            ),
        ),
        array(
            'id' => 'nowhere_font3',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 3', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Roboto',
				'font-weight' => '400',
            ),
        ),
        array(
            'id' => 'nowhere_font4',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 4', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Poppins',
				'font-weight' => '700',
            ),
        ),
        array(
            'id' => 'nowhere_font5',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 5', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
            'default' => array(
            	'font-family' => 'Poppins',
				'font-weight' => '500',
            ),
        ),
        array(
            'id' => 'nowhere_font6',
            'type'        => 'typography',
			'title'       => esc_html__('Additional Font family and style 6', 'tentered'),
			'google'      => true,
			'font-backup' => true,
			'subsets' 	  => true,
			'text-transform' 	  => false,
			'font-style' 	  => true,
			'text-align'	  => false,
			'font-size'	  => false,
            'word-spacing'=>false,
			'line-height' => false,
			'color'	  => false,
			'letter-spacing' => false,
			'output'      => array('.nowhere-font'),
			'units'       =>'px',
        ),
	),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-edit',
    'title' => esc_html__('Blog', 'tentered'),
	'desc' => esc_html__('These options are the options for posts page set at Settings > Reading which use index.php template.', 'tentered'),
    'fields' => array(
		array(
            'id' => 'blog_content_type',
            'type' => 'select',
            'title' => esc_html__('Posts content type', 'tentered'),
            'subtitle' => esc_html__('If content is chosen then the full content of posts will be shown until the MORE tag which can be inserted in the post content.', 'tentered'),
            'options' => array(0 => 'Content', 1 => 'Excerpt'),
            'default' => 1,
        ),
		array(
			'id'       => 'blog_excerpt_words',
			'type'     => 'text',
			'required' => array('blog_content_type','equals',1),
			'title'    => esc_html__('Number of words to show as excerpt', 'tentered'),
			'default' => 40
		),
		array(
			'id'       => 'blog_author_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post author name/link?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_date_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post publish date?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_cats_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post categories?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_comments_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post comments count?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_read_more_btn',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show read more button?', 'tentered'),
			'default' => 1
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Single Post', 'tentered'),
	'desc' => esc_html__('These options are the options for single post page template which use single.php template.', 'tentered'),
    'fields' => array(
		array(
			'id'       => 'blog_post_author_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post author name/link?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_date_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post publish date?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_cats_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post categories?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_thumbnail',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post media?', 'tentered'),
			'default' => 1
		),
		array(
			'id'       => 'blog_post_comments_meta',
			'type'     => 'checkbox',
			'title'    => esc_html__('Show post comments count?', 'tentered'),
			'default' => 1
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-folder',
	'id'   => 'post-types',
    'title' => esc_html__('Custom Post Types', 'tentered'),
    'fields' => array(
		array(
			'id'    => 'info_post_types',
			'type'  => 'info',
			'title' => esc_html__('Sub sections here for each post type will help you change the permalinks slug for each post type. Also would be able to change the Title, Category, Tag title for menu on the left sidebar of WP Dashboard.', 'tentered'),
			'style' => 'warning',
			'desc'  => esc_html__('Make sure you go to Settings > Permalinks page once you make any change to any post type here to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'tentered')
		),
		array(
			'id'    => 'info_post_types_slug',
			'type'  => 'info',
			'title' => esc_html__('If the slug is identical to an existing page WP will display the cpt posts as blog posts, not with their own style. (unless you can work your php magic and get around this issue).', 'tentered'),
			'style' => 'critical',
		),
		
		
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Portfolio', 'tentered'),
    'desc' => esc_html__('From here you can change the slug for project post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'tentered'),
    'fields' => array(
		array(
			'id'    => 'info_post_project',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'tentered'),
			'style' => 'warning',
		),
		array(
            'id' => 'project_post_slug',
            'type' => 'text',
            'title' => esc_html__('Projects permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
            'id' => 'project_post_title',
            'type' => 'text',
            'title' => esc_html__('Portfolio menu name', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'project_post_all',
            'type' => 'text',
            'title' => esc_html__('Projects all posts title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'project_post_categories',
            'type' => 'text',
            'title' => esc_html__('Project categories title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'project_category_slug',
            'type' => 'text',
            'title' => esc_html__('Project Categories permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
			'id'       => 'disable_project_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Project post type archive page.', 'tentered'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'tentered'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Service', 'tentered'),
    'desc' => esc_html__('From here you can change the slug for gallery post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'tentered'),
    'fields' => array(
		array(
			'id'    => 'info_post_service',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'tentered'),
			'style' => 'warning',
		),
		array(
            'id' => 'service_post_slug',
            'type' => 'text',
            'title' => esc_html__('Services permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
            'id' => 'service_post_title',
            'type' => 'text',
            'title' => esc_html__('Services menu name', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'service_post_all',
            'type' => 'text',
            'title' => esc_html__('Services all posts title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'service_post_categories',
            'type' => 'text',
            'title' => esc_html__('Services categories title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'service_category_slug',
            'type' => 'text',
            'title' => esc_html__('Services Category permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
			'id'       => 'disable_service_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Service post type archive page.', 'tentered'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'tentered'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Team', 'tentered'),
    'desc' => esc_html__('From here you can change the slug for team post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'tentered'),
    'fields' => array(
		array(
			'id'    => 'info_post_team',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'tentered'),
			'style' => 'warning',
		),
		array(
            'id' => 'team_post_slug',
            'type' => 'text',
            'title' => esc_html__('Team permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
            'id' => 'team_post_title',
            'type' => 'text',
            'title' => esc_html__('Team menu name', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'team_post_all',
            'type' => 'text',
            'title' => esc_html__('Team all posts title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'team_post_categories',
            'type' => 'text',
            'title' => esc_html__('Team categories title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'team_category_slug',
            'type' => 'text',
            'title' => esc_html__('Team Category permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
			'id'       => 'disable_team_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Team post type archive page.', 'tentered'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'tentered'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-ok',
	'subsection' => true,
    'title' => esc_html__('Testimonial', 'tentered'),
    'desc' => esc_html__('From here you can change the slug for testimonial post types, along with title of the post types, taxonomies that displays on the left sidebar of WP Dashboard', 'tentered'),
    'fields' => array(
		array(
			'id'    => 'info_post_testimonial',
			'type'  => 'info',
			'title' => esc_html__('Make sure you go to Settings > Permalinks page once you make any change here in order to flush the permalinks structure cache. You just need to go to that permalinks page, no need to save the options.', 'tentered'),
			'style' => 'warning',
		),
		array(
            'id' => 'testimonial_post_slug',
            'type' => 'text',
            'title' => esc_html__('Testimonials permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
            'id' => 'testimonial_post_title',
            'type' => 'text',
            'title' => esc_html__('Testimonials menu name', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'testimonial_post_all',
            'type' => 'text',
            'title' => esc_html__('Testimonial all posts title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'testimonial_post_categories',
            'type' => 'text',
            'title' => esc_html__('Testimonial categories title', 'tentered'),
            'desc' => esc_html__('For the WP Dashboard left sidebar', 'tentered'),
        ),
		array(
            'id' => 'testimonial_category_slug',
            'type' => 'text',
            'title' => esc_html__('Testimonial Category permalink slug', 'tentered'),
            'desc' => esc_html__('All lowercase, no spaces in between words.', 'tentered'),
        ),
		array(
			'id'       => 'disable_testimonial_archive',
			'type'     => 'checkbox',
			'title'    => esc_html__('Disable Testimonial post type archive page.', 'tentered'),
            'desc' => esc_html__('By default WordPress create a page for all post types which makes it impossible for you to create a new page with the same slug as of custom post type. Check this to disable the default cpt page.', 'tentered'),
			'default' => 0
		),
	)
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-error',
    'title' => esc_html__('404 Page', 'tentered'),
    'fields' => array(
		array(
			'id'=>'page_404_banner',
			'type' => 'media', 
			'url'=> true,
			'title' => esc_html__('Page header image', 'tentered'),
			'subtitle' => esc_html__('Upload image to show on the page header of the 404 error page.', 'tentered'),
            'default' => array('url' => ''),
		),
		array(
			'id'       => 'page_404_banner_height',
			'type'     => 'dimensions',
			'title'    => esc_html__('Page header height', 'tentered'),
			'output'   => array('.error404 .page-banner-text div'),
			'width' => false,
			'default' => array(
				'height' => '200px',
				'unit' => 'px',
			)
		),
		array(
            'id' => 'page_404_title',
            'type' => 'text',
            'title' => esc_html__('Page title', 'tentered'),
            'desc' => esc_html__('Enter title for 404 error page. Default is 404 Error.', 'tentered'),
        ),
		array(
            'id' => 'page_404_title_color',
            'type' => 'color',
			'output' => array('.error404 .page-banner-text h1'),
            'title' => esc_html__('Page title color', 'tentered'),
        ),
		array(
            'id' => 'page_404_content',
            'type' => 'editor',
            'title' => esc_html__('Page content', 'tentered'),
            'desc' => esc_html__('Enter text/html content for 404 error page.', 'tentered'),
        ),
    ),
));
Redux::setSection( $opt_name, array(
    'icon' => 'el-icon-css',
    'title' => esc_html__('Custom CSS/JS', 'tentered'),
    'fields' => array(
        array(
            'id' => 'custom_css',
            'type' => 'ace_editor',
            'title' => esc_html__('CSS Code', 'tentered'),
            'subtitle' => esc_html__('Paste your CSS code here.', 'tentered'),
            'mode' => 'css',
            'theme' => 'monokai',
            'desc' => '',
            'default' => ""
        ),
        array(
            'id' => 'custom_js',
            'type' => 'ace_editor',
            'title' => esc_html__('JS Code', 'tentered'),
            'subtitle' => esc_html__('Paste your JS code here.', 'tentered'),
            'mode' => 'javascript',
            'theme' => 'chrome',
            'desc' => '',
            'default' => ""
        )
    ),
));
Redux::setSection( $opt_name, array(
	  'title' => esc_html__('Import / Export', 'tentered'),
	  'desc' => esc_html__('Import and Export your Theme Framework settings from file, text or URL.', 'tentered'),
	  'icon' => 'el-icon-download',
	  'fields' => array(
		  array(
			  'id' => 'opt-import-export',
			  'type' => 'import_export',
			 'title' => esc_html__('Import Export','tentered'),
			  'subtitle' => esc_html__('Save and restore your Theme options','tentered'),
			  'full_width' => false,
		  ),
	  ),
));

    /*
     * <--- END SECTIONS
     */
