jQuery(function($){
	"use strict";

var TENTERED = window.TENTERED || {};


TENTERED.megaMenu = function() {
        jQuery('.megamenu-sub-title').closest('ul.sub-menu').wrapInner('<div class="row" />').wrapInner('<div class ="megamenu-container container" />').wrapInner('<li />');
        jQuery('.megamenu-container').closest('li.menu-item-has-children').addClass('megamenu');
        var $class = '';
		jQuery(".megamenu-container").each(function(index, elem) {
    		var numImages = $(this).find('.row').children('li').length;
			switch (numImages)
			{
				case 1:
					$class = 12;
					break;
				case 2:
					$class = 6;
					break;
				case 3:
					$class = 4;
					break;
				case 4:
					$class = 3;
					break;
				default:
					$class = 2;
			}
		$(this).find('.row').find('.col-md-3').each(function() {
            jQuery(this).removeClass('col-md-3').addClass('col-md-' + $class);
        });
});
};

/* ==================================================
	Scroll Functions
================================================== */
	TENTERED.scrollToTop = function(){
		var didScroll = false;
	
		var $arrow = $('#back-to-top');
	
		$arrow.on('click',function(e) {
			$('body,html').animate({ scrollTop: "0" }, 750, 'easeOutExpo' );
			e.preventDefault();
		});
	
		$(window).scroll(function() {
			didScroll = true;
		});
	
		setInterval(function() {
			if( didScroll ) {
				didScroll = false;
	
				if( $(window).scrollTop() > 200 ) {
					$arrow.css("right",10);
				} else {
					$arrow.css("right","-50px");
				}
			}
		}, 250);
	};
/* ==================================================
   Accordion
================================================== */
	TENTERED.accordion = function(){
		var accordion_trigger = $('.accordion-heading.accordionize');
		
		accordion_trigger.delegate('.accordion-toggle','click', function(event){
			if($(this).hasClass('active')){
				$(this).removeClass('active');
				$(this).addClass('inactive');
			}
			else{
				accordion_trigger.find('.active').addClass('inactive');          
				accordion_trigger.find('.active').removeClass('active');   
				$(this).removeClass('inactive');
				$(this).addClass('active');
			}
			event.preventDefault();
		});
	};
/* ==================================================
   Toggle
================================================== */
	TENTERED.toggle = function(){
		var accordion_trigger_toggle = $('.accordion-heading.togglize');
		
		accordion_trigger_toggle.delegate('.accordion-toggle','click', function(event){
			if($(this).hasClass('active')){
				$(this).removeClass('active');
				$(this).addClass('inactive');
			}
			else{
				$(this).removeClass('inactive');
				$(this).addClass('active');
			}
			event.preventDefault();
		});
	};
/* ==================================================
   Tooltip
================================================== */
	TENTERED.toolTip = function(){ 
		$('a[data-toggle=tooltip]').tooltip(); 
		$('a[data-toggle=tooltip]').tooltip();
		$('a[data-toggle=popover]').popover({html:true}).on("click", function(e) { 
       		e.preventDefault(); 
       		$(this).focus(); 
		});
	};
/* ==================================================
   Hero Flex Slider
================================================== */
	TENTERED.heroflex = function() {
		$('.heroflex').each(function(){
				var carouselInstance = $(this); 
				var carouselAutoplay = carouselInstance.attr("data-autoplay") === 'yes' ? true : false;
				var carouselPagination = carouselInstance.attr("data-pagination") === 'yes' ? true : false;
				var carouselArrows = carouselInstance.attr("data-arrows") === 'yes' ? true : false;
				var carouselDirection = carouselInstance.attr("data-direction") ? carouselInstance.attr("data-direction") : "horizontal";
				var carouselStyle = carouselInstance.attr("data-style") ? carouselInstance.attr("data-style") : "fade";
				var carouselSpeed = carouselInstance.attr("data-speed") ? carouselInstance.attr("data-speed") : "5000";
				var carouselPause = carouselInstance.attr("data-pause") === 'yes' ? true : false;
				
				carouselInstance.flexslider({
					animation: carouselStyle,
					easing: "swing",
					direction: carouselDirection,
					slideshow: carouselAutoplay,
					slideshowSpeed: carouselSpeed,
					animationSpeed: 600,
					initDelay: 0,
					randomize: false,
					pauseOnHover: carouselPause,
					controlNav: carouselPagination,
					directionNav: carouselArrows,
					prevText: "",
					nextText: ""
				});
		});
	};
/* ==================================================
   Flex Slider
================================================== */
	TENTERED.galleryflex = function() {
		$('.galleryflex').each(function(){
				var carouselInstance = $(this); 
				var carouselAutoplay = carouselInstance.attr("data-autoplay") === 'yes' ? true : false;
				var carouselPagination = carouselInstance.attr("data-pagination") === 'yes' ? true : false;
				var carouselArrows = carouselInstance.attr("data-arrows") === 'yes' ? true : false;
				var carouselDirection = carouselInstance.attr("data-direction") ? carouselInstance.attr("data-direction") : "horizontal";
				var carouselStyle = carouselInstance.attr("data-style") ? carouselInstance.attr("data-style") : "fade";
				var carouselSpeed = carouselInstance.attr("data-speed") ? carouselInstance.attr("data-speed") : "5000";
				var carouselPause = carouselInstance.attr("data-pause") === 'yes' ? true : false;
				
				carouselInstance.flexslider({
					animation: carouselStyle,
					easing: "swing",
					direction: carouselDirection,
					slideshow: carouselAutoplay,
					slideshowSpeed: carouselSpeed,
					animationSpeed: 600,
					initDelay: 0,
					animationLoop: false,
					randomize: false,
					pauseOnHover: carouselPause,
					controlNav: carouselPagination,
					directionNav: carouselArrows,
					prevText: "",
					nextText: ""
				});
		});
	};
/* ==================================================
   Owl Carousel
================================================== */
	TENTERED.OwlCarousel = function() {
		$('.owl-carousel').each(function(){
				var carouselInstance = $(this); 
				var carouselColumns = carouselInstance.attr("data-columns") ? carouselInstance.attr("data-columns") : "1";
				var carouselitemsDesktop = carouselInstance.attr("data-items-desktop") ? carouselInstance.attr("data-items-desktop") : "4";
				var carouselitemsDesktopSmall = carouselInstance.attr("data-items-desktop-small") ? carouselInstance.attr("data-items-desktop-small") : "3";
				var carouselitemsTablet = carouselInstance.attr("data-items-tablet") ? carouselInstance.attr("data-items-tablet") : "2";
				var carouselitemsMobile = carouselInstance.attr("data-items-mobile") ? carouselInstance.attr("data-items-mobile") : "1";
				var carouselAutoplay = carouselInstance.attr("data-autoplay") ? carouselInstance.attr("data-autoplay") : false;
				var carouselPagination = carouselInstance.attr("data-pagination") === 'yes' ? true : false;
				var carouselArrows = carouselInstance.attr("data-arrows") === 'yes' ? true : false;
				var carouselSingle = carouselInstance.attr("data-single-item") === 'yes' ? true : false;
				var carouselStyle = carouselInstance.attr("data-style") ? carouselInstance.attr("data-style") : "fade";
				var carouselRTL = carouselInstance.attr("data-rtl") ? carouselInstance.attr("data-rtl") : "ltr";
				
				carouselInstance.owlCarousel({
					items: carouselColumns,
					autoPlay : carouselAutoplay,
					navigation : carouselArrows,
					pagination : carouselPagination,
					itemsDesktop:[1199,carouselitemsDesktop],
					itemsDesktopSmall:[979,carouselitemsDesktopSmall],
					itemsTablet:[768,carouselitemsTablet],
					itemsMobile:[479,carouselitemsMobile],
					singleItem:carouselSingle,
					navigationText: ["<i class='fa fa-chevron-left'></i>","<i class='fa fa-chevron-right'></i>"],
					stopOnHover: true,
					lazyLoad: true,
					direction: carouselRTL,
					transitionStyle: carouselStyle
				});
		});
	};
/* ==================================================
   Magnific Popup
================================================== */
	TENTERED.Magnific = function() {
		jQuery('.format-gallery').each(function(){
			$(this).magnificPopup({
				delegate: 'a.popup-image', // child items selector, by clicking on it popup will open
				type: 'image',
				autoFocusLast: true,
				mainClass: 'mfp-with-zoom mfp-img-mobile',
				gallery:{enabled:true},
			});
		});
		jQuery('.magnific-image').magnificPopup({ 
			type: 'image',
			autoFocusLast: true,
			mainClass: 'mfp-with-zoom mfp-img-mobile',
			gallery:{enabled:false}
		});
		jQuery('.magnific-video').magnificPopup({ 
			type: 'iframe',
			autoFocusLast: true,
			mainClass: 'mfp-with-zoom mfp-img-mobile',
			zoom: {
				enabled: true,
				duration: 300, // don't foget to change the duration also in CSS
				opener: function(element) {
				  return element.find('img');
				}
			},
			gallery:{enabled:false}
		});
	};
/* ==================================================
   Animated Counters
================================================== */
	TENTERED.Counters = function() {
		$('.cust-counter').each(function () {
			$(this).appear(function() {
			var counter = $(this).find(".timer .count").html();
			$(this).find(".timer .count").countTo({
				from: 0,
				to: counter,
				speed: 2000,
				refreshInterval: 60
				});
			});
		});
	};
/* ==================================================
   SuperFish menu
================================================== */
	TENTERED.SuperFish = function() {
		$(".dd-menu").clone().appendTo(".mobile-menu > div > div");
		$(".mmenu-toggle").on('click',function(){
			$(".mobile-menu").slideToggle();
		});
		$('.sf-menu').superfish({
			  delay: 200,
			  animation: {opacity:'show', height:'show'},
			  speed: 'fast',
			  cssArrows: false,
			  disableHI: true
		});
		// Centering the dropdown menus
		var a = $(".dd-menu li");
		a.mouseover(function() {
			 var the_width = $(this).find("a").width();
			 var child_width = $(this).find("ul").width();
			 var width = parseInt((child_width - the_width)/2);
			$(this).find("ul").css('left', -width);
		});
		
        a.each(function() {
            var a = $(window).width() - 16, t = $(this).offset().left, o = $(this).find("ul.sub-menu").width(), n = 0;
            n = $("body").hasClass("boxed") ? imi_local.siteWidth - (t - (a - imi_local.siteWidth) / 2) :a - t;
            var d;
            $(this).find("ul.sub-menu").length > 0 && (d = n - o), (o > n || o > d) && ($(this).find("ul.sub-menu").addClass("right"), 
            $(this).find("ul.sub-menu").addClass("right"));
        });
	};
/* ==================================================
   Header Functions
================================================== */
	TENTERED.StickyHeader = function() {
		$("#sticky-nav").sticky({topSpacing:0});
		if($("body").hasClass("boxed")){
			return false;
		}
			
		var header = $(".header-style3 .site-header"),
			headerHeight = header.height(),
			logoWrapper = header.find(".site-logo"),
			logo = header.find(".site-logo img"),
			logoWidth = logo.width(),
			logoHeight = logo.height(),
			$this = this,
			logoPaddingTop = 28,
			logoSmallHeight = 50;

		logo
			.css("height", logoSmallHeight);

		var logoSmallWidth = logo.width();

		logo
			.css("height", "auto")
			.css("width", "auto");


		$this.checkStickyMenu = function() {

			if($(window).scrollTop() > ((headerHeight - 15) - logoSmallHeight) && $(window).width() > 992) {

				if($("body.header-style3").hasClass("sticky-menu-active")){
					return false;
				}
				logo.stop(true, true);

				$("body.header-style3").addClass("sticky-menu-active");

				logoWrapper.addClass("logo-sticky-active");

				logo.animate({
					width: logoSmallWidth,
					height: logoSmallHeight,
					top: logoPaddingTop + "px"
				}, 200, function() {});

			} else {

				if($("body.header-style3").hasClass("sticky-menu-active")) {

					$("body.header-style3").removeClass("sticky-menu-active");

					logoWrapper.removeClass("logo-sticky-active");

					logo.animate({
						width: logoWidth,
						height: logoHeight,
						top: "0px"
					}, 200, function() {

						logo.css({
							width: "auto",
							height: "auto"
						});

					});

				}

			}

		};

		$(window).on("scroll", function() {
			$this.checkStickyMenu();
		});
	};
/* ==================================================
   IsoTope Portfolio
================================================== */
		TENTERED.IsoTope = function() {	
		$("ul.sort-source").each(function() {
			var source = $(this);
			var destination = $("ul.sort-destination[data-sort-id=" + $(this).attr("data-sort-id") + "]");
			if(destination.get(0)) {
				$(window).load(function() {
					destination.isotope({
						itemSelector: ".grid-item",
						layoutMode: 'sloppyMasonry'
					});
					source.find("a").on("click", function(e) {
						e.preventDefault();
						var $this = $(this),
							filter = $this.parent().attr("data-option-value");
						source.find("li.active").removeClass("active");
						$this.parent().addClass("active");
						destination.isotope({
							filter: filter
						});
						if(window.location.hash !== "" || filter.replace(".","") !== "*") {
							self.location = "#" + filter.replace(".","");
						}
						return false;
					});
					$(window).on("hashchange", function() {
						var hashFilter = "." + location.hash.replace("#",""),
							hash = (hashFilter === "." || hashFilter === ".*" ? "*" : hashFilter);
						source.find("li.active").removeClass("active");
						source.find("li[data-option-value='" + hash + "']").addClass("active");
						destination.isotope({
							filter: hash
						});
					});
					var hashFilter = "." + (location.hash.replace("#","") || "*");
					var initFilterEl = source.find("li[data-option-value='" + hashFilter + "'] a");
					if(initFilterEl.get(0)) {
						source.find("li[data-option-value='" + hashFilter + "'] a").click();
					} else {
						source.find("li:first-child a").click();
					}
				});
			}
		});
		$(window).load(function() {
			var IsoTopeCont = $(".isotope-grid");
			IsoTopeCont.isotope({
				itemSelector: ".grid-item",
				layoutMode: 'sloppyMasonry'
			});
			if ($(".grid-holder").length > 0){	
				var $container_blog = $('.grid-holder');
				$container_blog.isotope({
					itemSelector : '.grid-item'
				});
				$(window).resize(function() {
					var $container_blog = $('.grid-holder');
					$container_blog.isotope({
						itemSelector : '.grid-item'
					});
				});
			}
		});
	};
/* ==================================================
   IsoTope Full Width
================================================== */
	TENTERED.IsoTopeFull = function() {
		$("ul.sort-source").each(function() {
			var source = $(this);
			var destination = $("ul.sort-destination[data-sort-id=" + $(this).attr("data-sort-id") + "]");
			if(destination.get(0)) {
				$(window).load(function() {
					destination.isotope({
						itemSelector: ".grid-item",
						layoutMode: 'sloppyMasonry'
					});
					source.find("a").on("click", function(e) {
						e.preventDefault();
						var $this = $(this),
							filter = $this.parent().attr("data-option-value");
						source.find("li.active").removeClass("active");
						$this.parent().addClass("active");
						destination.isotope({
							filter: filter
						});
						if(window.location.hash !== "" || filter.replace(".","") !== "*") {
							self.location = "#" + filter.replace(".","");
						}
						return false;
					});
					$(window).on("hashchange", function() {
						var hashFilter = "." + location.hash.replace("#",""),
							hash = (hashFilter === "." || hashFilter === ".*" ? "*" : hashFilter);
						source.find("li.active").removeClass("active");
						source.find("li[data-option-value='" + hash + "']").addClass("active");
						destination.isotope({
							filter: hash
						});
					});
					var hashFilter = "." + (location.hash.replace("#","") || "*");
					var initFilterEl = source.find("li[data-option-value='" + hashFilter + "'] a");
					if(initFilterEl.get(0)) {
						source.find("li[data-option-value='" + hashFilter + "'] a").click();
					} else {
						source.find("li:first-child a").click();
					}
				});
			}
		});
		$(window).load(function() {
			var IsoTopeCont = $(".isotope-grid");
			IsoTopeCont.isotope({
				itemSelector: ".grid-item",
				layoutMode: 'sloppyMasonry'
			});
			if ($(".grid-holder").length > 0){	
				var $container_blog = $('.grid-holder');
				$container_blog.isotope({
					itemSelector : '.grid-item'
				});
				$(window).resize(function() {
					var $container_blog = $('.grid-holder');
					$container_blog.isotope({
						itemSelector : '.grid-item'
					});
				});
			}
		});
	};
/* ==================================================
   Pricing Tables
================================================== */
	var $tallestCol;
	TENTERED.pricingTable = function(){
		$('.pricing-table').each(function(){
			$tallestCol = 0;
			$(this).find('> div .features').each(function(){
				($(this).height() > $tallestCol) ? $tallestCol = $(this).height() : $tallestCol = $tallestCol;
			});	
			if($tallestCol === 0){ $tallestCol = 'auto';}
			$(this).find('> div .features').css('height',$tallestCol);
		});
	};
/* ==================================================
   One Page Menu
================================================== */
	TENTERED.OnePageMenu = function(){
		$(".page-template-template-onepage .menu-item").each(function(index, element) {
			var $menu_data_id = $(this).find("a").attr("data-id");
			var $home_url = window.location.href;
			if($(this).hasClass("menu-item-type-custom"))
			{

			}
			else
			{
				$(this).find("a").attr("href", window.location.href+"#scroll-"+$menu_data_id);
			}
		});
		if(Modernizr.touch && $(window).width() < 991 ) {
			$(".page-template-template-onepage .sf-menu > li > a").click(function(e){
				$(".main-menu").slideUp();
				e.preventDefault();
			});
		}
		
		//LOCAL SCROLL
		jQuery('.page-template-template-onepage .sf-menu').localScroll({
			offset: -62
		});

		var sections = jQuery('.page-template-template-onepage .page-section');
		var navigation_links = jQuery('.page-template-template-onepage .sf-menu a');
		sections.waypoint({
			handler: function(direction) {
				var active_section;
				active_section = jQuery(this);
				if (direction === "up"){ active_section = active_section.prev();}
				var active_link = jQuery('.page-template-template-onepage .sf-menu a[href="'+ window.location.href + '#' + active_section.attr("id") + '"]');
				navigation_links.parent('li').removeClass("current-menu-item");
				active_link.parent('li').addClass("current-menu-item").delay(1500);
			},
			offset: 150
		});
	};
/* ==================================================
   Init Functions
================================================== */
$(document).ready(function(){
	TENTERED.megaMenu();
	TENTERED.scrollToTop();
	TENTERED.accordion();
	TENTERED.toggle();
	TENTERED.toolTip();
	TENTERED.heroflex();
	TENTERED.galleryflex();
	TENTERED.OwlCarousel();
	TENTERED.Magnific();
	TENTERED.SuperFish();
	TENTERED.Counters();
	TENTERED.IsoTope();
	TENTERED.IsoTopeFull();
	if(imi_local.enableSticky == 1){
		TENTERED.StickyHeader();
	}
	TENTERED.pricingTable();
	TENTERED.OnePageMenu();
	$('.selectpicker').selectpicker({container:'body'});
	WWHGetter();
	
});

// DESIGN ELEMENTS //

// WINDOW RESIZE FUNCTIONS //
$(window).resize(function(){
	WWHGetter();
});

// Any Button Scroll to section
$('.scrollto').on("click", function(){
	$.scrollTo( this.hash, 800, { easing:'easeOutQuint' });
	return false;
});

// Cart & Search option in header
$(".search-module-trigger").on('click',function(e){
	e.stopPropagation();
	$(".search-module-opened").toggle();
 	$('.cart-module-opened').hide();
	e.preventDefault();
});
$(".search-module-opened").on('click',function(e){
	e.stopPropagation();
});
$("#cart-module-trigger").on('click',function(e){
	e.stopPropagation();
	$(".cart-module-opened").toggle();
 	$('.search-module-opened').hide();
	e.preventDefault();
});
$(".cart-module-opened").on('click',function(e){
	e.stopPropagation();
});
$(document).on('click',function(){
 	$('.search-module-opened, .cart-module-opened').hide();
});

// FITVIDS
$(".fw-video, .post-media").fitVids();


// Icon Append
$("#comment-submit").wrapAll("<div class=\"row\"><div class=\"form-group\"><div class=\"col-md-12\">");
$("#comment-submit").addClass("btn btn-primary btn-lg");

/* Circular Bars */
if(typeof($.fn.knob) !== "undefined") {
	$(".knob").knob({
		width: '100%'
	});
}

$(window).load(function(){
	$(".portfolio-item").show();
});
$(window).resize(function(){
if ($(window).width() > 992)
  {
	  $("#main-menu").show();
  }
if ($(window).width() > 992)
  {
	  $(".mobile-menu").hide();
  }
});
	
// Animation Appear
var AppDel;
function AppDelFunction($appd) {
	$appd.addClass("appear-animation");
	if(!$("html").hasClass("no-csstransitions") && $(window).width() > 767) {
		$appd.appear(function() {
			var delay = ($appd.attr("data-appear-animation-delay") ? $appd.attr("data-appear-animation-delay") : 1);
			if(delay > 1){ $appd.css("animation-delay", delay + "ms");}
			$appd.addClass($appd.attr("data-appear-animation"));
			setTimeout(function() {
				$appd.addClass("appear-animation-visible");
			}, delay);
			clearTimeout();
		}, {accX: 0, accY: -150});
	} else {
		$appd.addClass("appear-animation-visible");
	}
}
function AppDelStopFunction() {
	clearTimeout(AppDel);
}
$("[data-appear-animation]").each(function() {
	var $this = $(this);
	AppDelFunction($this);
	AppDelStopFunction();
});
// Animation Progress Bars

var AppAni;
function AppAniFunction($anim) {
	$anim.appear(function() {
		var delay = ($anim.attr("data-appear-animation-delay") ? $anim.attr("data-appear-animation-delay") : 1);
		if(delay > 1){ $anim.css("animation-delay", delay + "ms");}
		$anim.addClass($anim.attr("data-appear-animation"));
		setTimeout(function() {
			$anim.animate({
				width: $anim.attr("data-appear-progress-animation")
			}, 1500, "easeOutQuad", function() {
				$anim.find(".progress-bar-tooltip").animate({
					opacity: 1
				}, 500, "easeOutQuad");
			});
		}, delay);
		clearTimeout();
	}, {accX: 0, accY: -50});
}
function AppAniStopFunction() {
	clearTimeout(AppAni);
}
$("[data-appear-progress-animation]").each(function() {
	var $this = $(this);
	AppAniFunction($this);
	AppAniStopFunction();
});

// Parallax Jquery Callings
if(!Modernizr.touch) {
	parallaxInit();
}
function parallaxInit() {
	$('.parallax1').parallax("50%", 0.1);
	$('.parallax2').parallax("50%", 0.1);
	$('.parallax3').parallax("50%", 0.1);
	$('.parallax4').parallax("50%", 0.1);
	$('.parallax5').parallax("50%", 0.1);
	$('.parallax6').parallax("50%", 0.1);
	$('.parallax7').parallax("50%", 0.1);
	$('.parallax8').parallax("50%", 0.1);
	/*add as necessary*/
}

// Window height/Width Getter Classes
function WWHGetter(){
	var wheighter = $(window).height();
	var wwidth = $(window).width();
	$(".wheighter").css("height",wheighter);
	$(".wwidth").css("width",wwidth);
}
});