<?php
$options = get_option('tentered_options');
global $tentered_allowed_tags;
$menu_locations = get_nav_menu_locations();
if(is_home()) { $id = get_option('page_for_posts'); }
else { $id = get_the_ID(); }
$logo_meta = get_post_meta($id,'tentered_page_logo',true);
$logo_url_array = wp_get_attachment_image_src( $logo_meta, 'full', '', array() );
if(is_array($logo_url_array)) { $logo_url = $logo_url_array[0]; }else{$logo_url='';}
$logo_retina_meta = get_post_meta($id,'tentered_page_logo_retina',true);
$logo_retina_url_array = wp_get_attachment_image_src( $logo_retina_meta, 'full', '', array() );
if(is_array($logo_retina_url_array)) { $logo_retina_url = $logo_retina_url_array[0]; }
$logo_retina_url = (!empty($logo_retina_url))?$logo_retina_url:$logo_url;
$retina_logo_width = get_post_meta($id,'tentered_page_logo_retina_width',true);
$retina_logo_height = get_post_meta($id,'tentered_page_logo_retina_height',true);
if($logo_url == ''){
	$logo = (isset($options['logo_upload']))?$options['logo_upload']:'';
	$logo_url = (isset($logo['url']))?$logo['url']:'';
	$logo_retina = (isset($options['retina_logo_upload']))?$options['retina_logo_upload']:'';
	$logo_retina_url = (!empty($options['retina_logo_upload']['url'])!='')?$logo_retina['url']:$logo_url;
	$retina_logo_width = (isset($options['retina_logo_width']))?$options['retina_logo_width']:'114';
	$retina_logo_height = (isset($options['retina_logo_height']))?$options['retina_logo_height']:'17';
}
$header_info = (isset($options['header_info_text']))?$options['header_info_text']:'';
?>
   
  <!-- Start Header -->
  <header class="site-header">
    <div class="logo-wrapper">
      <div class="container">
        <button class="mmenu-toggle"><i class="fa fa-bars fa-lg"></i></button>
        <div class="site-logo">
		<?php if($logo_url == '' && $logo_retina_url == ''){ ?>
            <a href="<?php echo esc_url( home_url('/') ); ?>" class="static-logo">
            <span class="site-name"><?php echo esc_attr(get_bloginfo('name')); ?></span>
            <span class="site-tagline"><?php echo esc_attr(get_bloginfo('description')); ?></span>
            </a>
        <?php } else { ?>
            <a href="<?php echo esc_url( home_url('/') ); ?>" class="default-logo"><img src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"></a>
            <a href="<?php echo esc_url( home_url('/') ); ?>" class="default-retina-logo"><img src="<?php echo esc_url($logo_retina_url); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" width="<?php echo esc_attr($retina_logo_width); ?>" height="<?php echo esc_attr($retina_logo_height); ?>"></a>
            <?php } ?>
        </div>
      </div>
    </div>
    <div id="sticky-nav">
      <div class="container">
            <nav class="social-icons-colored pull-right">
                <ul class="social-icons">
                	<?php
						$socialSites = $options['header_social_links'];
						foreach ($socialSites as $key => $value) {
							$string = substr($key, 3);
							if (filter_var($value, FILTER_VALIDATE_EMAIL)) {
								echo '<li class="'.esc_attr($string).'"><a href="mailto:' . esc_attr($value) . '"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
							}
							if (filter_var($value, FILTER_VALIDATE_URL)) {
								echo '<li class="'.esc_attr($string).'"><a href="' . esc_url($value) . '" target="_blank"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
							}
							elseif($key == 'fa-skype' && $value != '' && $value != 'Enter Skype ID') {
								echo '<li class="'.esc_attr($string).'"><a href="skype:' . esc_attr($value) . '?call"><i class="fa fa-lg ' . esc_attr($key) . '"></i></a></li>';
							}
						}
					?>
                </ul>
               </nav>
            <div class="main-menu">
            <?php
			  	$onepage_menu = get_post_meta($id,'tentered_select_menu_from_list',true);
			  	if($onepage_menu != '' && is_page_template('template-onepage.php')){
					wp_nav_menu(array('menu' => $onepage_menu, 'container' => '','items_wrap' => '<ul id="%1$s" class="sf-menu dd-menu">%3$s</ul>', 'link_before' => '', 'link_after' => '', 'walker' => new Tentered_Walker));
				} else {
				if (!empty($menu_locations['primary-menu'])) { 
					wp_nav_menu(array('theme_location' => 'primary-menu', 'container' => '','items_wrap' => '<ul id="%1$s" class="sf-menu dd-menu">%3$s</ul>', 'link_before' => '<span>', 'link_after' => '</span>', 'walker' => new tentered_mega_menu_walker));
				}
				} ?>
          </div>
      </div>
    </div>
    <nav class="mobile-menu">
      <div class="container">
        <div class="row"></div>
      </div>
    </nav>
  </header>
  <!-- End Header --> 