<?php get_header(); // add header  ?>

<!-- Begin Wrap Content -->
<div class="wrap-fullwidth">

    <!-- Begin Main Home Content -->
    <div class="wrap-content">        
        <?php if (is_category()) { ?> 
            <h3 class="index-title"><?php esc_html_e( 'All posts in:', 'food-wp' ); ?> <?php single_cat_title(''); ?></h3>
            <div class="cat-info"><?php echo category_description(); ?></div>
        <?php } elseif (is_tag()) { ?>
            <h3 class="index-title"><?php esc_html_e( 'All posts tagged in:', 'food-wp' ); ?> <?php single_tag_title(''); ?></h3>
            <div class="cat-info"><?php echo tag_description(); ?></div>
        <?php } elseif (is_search()) { ?>
            <h3 class="index-title"><?php printf( esc_html__( 'Search Results for: %s', 'food-wp' ), '' . get_search_query() . '' ); ?></h3>
        <?php } elseif (is_author()) { ?> 
            <h3 class="index-title"><?php esc_html_e( 'All posts by:', 'food-wp' ); ?> <?php the_author(); ?></h3>
        <?php } elseif (is_404()) { ?> 
            <h3 class="index-title"><?php esc_html_e('Error 404 - Not Found', 'food-wp'); ?></h3>
            <?php esc_html_e('Sorry, but you are looking for something that isn\'t here.', 'food-wp'); ?>
        <?php } ?><div class="clear"></div>


        <ul id="infinite-articles" class="masonry_list js-masonry">
        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

            <li <?php post_class('ex34') ?> id="post-<?php the_ID(); ?>">

                <?php if ( has_post_thumbnail()) { ?>        
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('food_wp_thumbnail-blog-grid', array('title' => "")); ?></a>
                    <div class="article-wrap">
                        <div class="article-category"><i class="fa fa-cutlery" aria-hidden="true"></i> <?php $food_wp_category = get_the_category(); if ($food_wp_category) 
                            { echo wp_kses_post('<a href="' . get_category_link( $food_wp_category[0]->term_id ) . '">' . $food_wp_category[0]->name.'</a> ');}  ?>
                        </div><!-- end .article-category -->
                    </div><!-- end .article-wrap -->
                <?php } else { ?> 
                    <div class="article-wrap mtop">
                        <div class="article-category"><i class="fa fa-cutlery" aria-hidden="true"></i> <?php $food_wp_category = get_the_category(); if ($food_wp_category) 
                            { echo wp_kses_post('<a href="' . get_category_link( $food_wp_category[0]->term_id ) . '">' . $food_wp_category[0]->name.'</a> ');}  ?>
                        </div><!-- end .article-category -->
                    </div><!-- end .article-wrap -->    
                <?php } // Post Thumbnail ?> 
                <div class="clear"></div>

                <div class="content-masonry">
                    <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                    <ul class="meta-content">
                        <li><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 18 ); ?></a></li>
                        <li class="aut-name"><?php $food_wp_fname = get_the_author_meta('first_name'); if( empty($food_wp_fname)){ echo the_author_posts_link(); } else { echo the_author_meta('first_name'); echo ('&nbsp;'); echo substr(get_the_author_meta('last_name'),0,1).'.';} ?></li>
                        <li class="art-likes-text"><?php if (function_exists('thumbs_rating_getlink')) { esc_html_e( 'Likes!', 'food-wp' ); } ?></li>
                        <li class="art-likes"><?php if (function_exists('thumbs_rating_getlink')) { echo thumbs_rating_getlink(); } ?></li>
                    </ul><!-- end .meta-content -->
                </div><!-- end .content-masonry -->
            </li>
        <?php endwhile; endif; ?>
        </ul>  

         <!-- Pagination -->
        <?php if(function_exists('wp_pagenavi')) { ?>
            <?php wp_pagenavi(); ?>
            <?php } else { ?>
            <div class="defaultpag">
                    <div class="sright"><?php next_posts_link('' . esc_html__('Older Entries', 'food-wp') . ' &rsaquo;'); ?></div>
                    <div class="sleft"><?php previous_posts_link('&lsaquo; ' . esc_html__('Newer Entries', 'food-wp') . ''); ?></div>
            </div>
        <?php } // Default Pagination ?>
        <!-- pagination -->
    </div><!-- end .home-content -->


    <!-- Begin Sidebar 1 (default right) -->
    <?php get_sidebar(); // add sidebar ?>
    <!-- end #sidebar 1 (default right) --> 

        
<div class="clear"></div>
</div><!-- end .wrap-fullwidth -->

<?php get_footer(); // add footer  ?>