<?php 
get_header();

if (have_posts()){ while (have_posts()){ the_post(); global $post;

	$sermon_video_url = get_post_meta( get_the_ID(), 'sermon_video_url', true );
	$sermon_audio_url = get_post_meta( get_the_ID(), 'sermon_audio_url', true );
	$sermon_pdf_url = get_post_meta( get_the_ID(), 'sermon_pdf_url', true );
	$sermon_short_caption = get_post_meta( get_the_ID(), 'sermon_short_caption', true );
	$sermon_minutes_title = get_post_meta( get_the_ID(), 'sermon_minutes_title', true );
	$sermons_list = get_post_meta( get_the_ID(), 'sermons_list', true );
	$sermon_sub_title = get_post_meta( get_the_ID(), 'sermon_sub_title', true );
	
	/* it sets the post view */
	if(function_exists('tabligh_set_post_view')){ tabligh_set_post_view(); }

	/* Get Post Meta Elements detail */
	$tabligh_social_switch = '';
	$tabligh_sidebar_campaign = '';
	$tabligh_sel_right_sidebar = '';
	$tabligh_sel_left_sidebar = '';
	
	$tabligh_post_detail_xml = '';
	$tabligh_post_detail_xml = get_post_meta($post->ID, 'services_detail_xml', true);
	
	if($tabligh_post_detail_xml <> ''){
		
		$tabligh_post_xml = new DOMDocument ();
		$tabligh_post_xml->loadXML ( $tabligh_post_detail_xml );

		/* Sidebar Settings */
		$tabligh_sidebar_campaign = tabligh_find_xml_value($tabligh_post_xml->documentElement,'service_sidebar');
		$tabligh_sel_right_sidebar = tabligh_find_xml_value($tabligh_post_xml->documentElement,'service_sidebar_right');
		$tabligh_sel_left_sidebar = tabligh_find_xml_value($tabligh_post_xml->documentElement,'service_sidebar_left');
	}
	
	$archive_year  = get_the_time('Y'); 
	$archive_month = get_the_time('m'); 
	$archive_day   = get_the_time('d'); 
	
	$user = wp_get_current_user($post->ID);
	$avatar_url = get_avatar_url($user->ID, array("size"=>32));
	$avatar_url_large = get_avatar_url($user->ID, array("size"=>170));
	
	/* Get Comment Count */
	$comment_count = wp_count_comments( $post->ID );
	$comment_count = $comment_count->total_comments;

	/* Get Inner Header */ 
	if(function_exists('tabligh_secondary_header')) {
		tabligh_secondary_header($post->ID, esc_html__('Sermon Details','tabligh')); 
	} ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="sermon-detail-wrap w-100">
					<div class="sermon-detail-info-wrap w-100">
						<div class="row">
							<div class="col-md-5 col-sm-12 col-lg-6 order-md-1">
								<div class="sermon-video position-relative w-100">
									<?php if(has_post_thumbnail()){ ?> 
										<?php echo get_the_post_thumbnail($post->ID, 'tabligh-sermons-detail', array( 'class' => 'img-fluid w-100' ));?>
									<?php } /*endif*/ ?>
									<?php if($sermon_video_url){ ?>
										<a class="spinner position-absolute rounded-circle thm-clr" href="<?php echo esc_url($sermon_video_url); ?>" data-fancybox title="<?php esc_attr__('Video','tabligh'); ?>"><i class="fas fa-video"></i></a>
									<?php } ?>
								</div>
							</div>
							<div class="col-md-7 col-sm-12 col-lg-6">
								<div class="sermon-detail-info w-100">
									<span class="d-block"><?php echo esc_html($sermon_sub_title); ?></span>
									<h2 class="mb-0"><?php echo get_the_title(); ?></h2>
									<ul class="post-meta2 d-inline-flex flex-wrap align-items-center mb-0 list-unstyled">
										<li class="thm-clr"><i class="far fa-edit"></i><?php esc_html_e('By:','tabligh'); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_the_author_meta( 'display_name' , $post->post_author ); ?></a></li>
										<?php if(function_exists('tabligh_get_post_view')){ ?>
											<li class="thm-clr"><i class="far fa-eye"></i><?php echo tabligh_get_post_view(); ?> <?php esc_attr_e(' Views','tabligh'); ?></li>
										<?php } ?>
									</ul>
									<div class="sermons-btns-wrap position-relative pat-bg gray-layer opc8 back-blend-multiply gray-bg" style="<?php echo tabligh_background('pattern-bg.jpg');?>">
										<div class="sermons-btns2 d-inline-flex">
											<?php if($sermon_audio_url){ ?>
												<a data-src="<?php echo esc_url($sermon_audio_url);?>" data-fancybox data-type="video" title=""><i class="fas fa-volume-up"></i><?php esc_html_e('Audio MP3','tabligh'); ?></a>
											<?php } ?>
											<?php if($sermon_pdf_url){ ?>
												<a href="<?php echo esc_url($sermon_pdf_url); ?>" target="_blank"><i class="far fa-file"></i><?php esc_html_e('Download PDF','tabligh'); ?></a>
											<?php } ?>
										</div>
									</div>
									<h3 class="mb-0"><?php echo esc_html($sermon_minutes_title); ?></h3>
									<ul class="sermon-info-list mb-0 list-unstyled">
										<?php 
										if(is_array($sermons_list)){ 
											foreach($sermons_list as $list){ ?>
												<li><?php echo esc_html($list); ?></li>
											<?php }
										} ?>
									</ul>
								</div>
							</div>
						</div>
					</div>
					<div class="sermon-detail-desc w-100">
						<?php /* The Content */
							the_content(); 		
							wp_link_pages( array(
								'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'tabligh' ) . '</span>',
								'after'       => '</div>',
								'link_before' => '',
								'link_after'  => '',
								'pagelink'    => '<span>%</span>',
								'separator'   => '',
							) );
						?>
					</div>
				</div><!-- Sermon Detail Wrap -->
			</div>
		</div>
	</section>

	<?php 
	}/*end of while statement*/

} /*end of if statement*/
get_footer(); ?>