<?php  get_header(); 
	
	if ( have_posts() ){ while (have_posts()){ the_post(); global $post;

	$campaign_location = get_post_meta( get_the_ID(), 'campaign_location', true ); 
	$campaign_tags_sharing = get_post_meta( get_the_ID(), 'campaign_tags_sharing', true );
	$campaign_author_intro = get_post_meta( get_the_ID(), 'campaign_author_intro', true );
	$camp_author_intro_title = get_post_meta( get_the_ID(), 'camp_author_intro_title', true );
	$campaign_sidebar_layout = get_post_meta( get_the_ID(), 'campaign_sidebar_layout', true );
	$campaign_sidebar_selected = get_post_meta( get_the_ID(), 'campaign_sidebar_selected', true );

	/* Get Inner Header */ 
	if(function_exists('tabligh_secondary_header')) {
		tabligh_secondary_header($post->ID, esc_html__('Campaign Details','tabligh')); 
	} ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="post-detail-wrap w-100">
					<div class="row">
						<?php /* Left Sidebar */
						if($campaign_sidebar_layout == 'left'){ ?>
							<div class="col-md-6 col-sm-6 col-lg-3">
                                <aside class="sidebar w-100">
									<?php dynamic_sidebar( $campaign_sidebar_selected ); ?>
								</aside>
							</div>
						<?php } /*endif */ ?>
						<div class="<?php if($campaign_sidebar_layout == 'no'){ echo 'col-md-12 col-sm-12 col-lg-12'; }else{ echo 'col-md-12 col-sm-12 col-lg-9'; } ?>">
							<div class="post-detail-inner w-100">
								<div class="post-detail-img mb-0 w-100">
									<?php if(has_post_thumbnail()){ ?> 
										<?php echo get_the_post_thumbnail($post->ID, 'tabligh-post-detail', array( 'class' => 'img-fluid w-100' ));?>
									<?php } /*endif*/ ?>
								</div>
								<?php
									/* Get Campaign Object */
									$campaign = charitable_get_current_campaign();
									
									/* Percentage Donated */
									$percentage_donated_raw = intval($campaign->get_percent_donated_raw());
									
									/* Days Left */
									$campaign_days_left = $campaign->get_time_left();
									
									/* Get Donor Count */
									$campaign_donor_count = $campaign->get_donor_count();
						
									/* Initialize Variables */
									$donated_amount = $goal_amount = $needed_amount = '';
									
									/* Campaign Goal */
									$goal_amount = $campaign->sanitize_campaign_goal( $campaign->get( 'goal' ) );
									
									/* Donated Amount */
									$donated_amount = intval($campaign->get_donated_amount());
									
									/* Amount Left */
									$needed_amount = $goal_amount - $donated_amount; 
									
									$user = wp_get_current_user($post->ID);
									$avatar_url_large = get_avatar_url($user->ID, array("size"=>170));
								?>
										
								<div class="donation-detail-info-wrap d-flex flex-wrap align-items-end w-100">
									<div class="urgent-donat-info pat-bg gray-layer opc85 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background($image_name = 'pattern-bg.jpg'); ?>">
										<span class="donate-goal d-block thm-clr"><?php esc_html_e('Goal:','tabligh'); ?> <?php echo charitable_format_money($goal_amount); ?></span>
										<h3 class="mb-0"><?php echo get_the_title(); ?></h3>
										<ul class="urgent-donat-meta d-inline-flex flex-wrap mb-0 list-unstyled">
											<li class="thm-clr"><?php echo esc_html($campaign_location); ?></li>
											<li><i class="fas fa-heart thm-clr"></i><?php echo esc_html($campaign_donor_count); ?> <?php esc_html_e('Donors','tabligh'); ?></li>
										</ul>
										<div class="urgent-donat-info-raised pat-bg thm-layer opc7 position-absolute back-blend-multiply thm-bg w-100" style="<?php echo tabligh_background($image_name = 'pattern-bg.jpg'); ?>">
											<?php if(function_exists('tabligh_progress_bar_campaign')){ echo tabligh_progress_bar_campaign($campaign->ID, $percentage_donated_raw); } ?>
											<div class="urgent-progress" id="goal-prog<?php echo esc_html($campaign->ID); ?>"><span></span></div>
											<span class="d-block"><?php echo charitable_format_money($donated_amount); ?></span>
											<i class="d-block"><?php esc_html_e('Raised','tabligh'); ?></i>
										</div>
									</div>
									<a class="thm-btn bg-color1" href="<?php echo esc_url(get_the_permalink().'/donate');?>"><i class="mb-2 fas fa-heart d-block"></i><?php echo esc_html('DONATE NOW','tabligh'); ?></a>
								</div>
								<div class="post-detail-desc w-100">
									<?php if($campaign->description){ ?><div class = "description-block"><?php echo wpautop($campaign->description); ?></div><?php } ?>
									<?php
									/* Campaign Content */ 
										echo wpautop($campaign->post_content); 
									?>
								</div>
								<?php
								/* Post Tags */
								$posttags = get_the_terms( get_the_ID(), 'campaign_tag' );
								$all_tags = array();
								if ($posttags || $campaign_tags_sharing == 'display'){ ?>
									<div class="share-tags-wrap d-flex flex-wrap w-100">
										<?php if($campaign_tags_sharing == 'display'){ ?>
											<div class="share-links d-inline-flex">
												<span class="d-inline-block"><?php esc_html_e('Share This: ','tabligh');?></span>
												<div class="social-links4 v2 text-center d-inline-flex">
													<?php if(function_exists('tabligh_post_social_shares')){ echo tabligh_post_social_shares($post->ID); } ?>
												</div>
											</div>
										<?php } 
										if($posttags){ ?>
											<div class="tags-links d-inline-flex">											
												<span class="d-inline-block"><?php esc_html_e('Tags: ','tabligh');?></span>
												<?php 
												foreach($posttags as $tag) {
														$all_tags[] = '<a href = "'.esc_url(get_tag_link($tag->term_id)).'">'.esc_html($tag->name).'</a>';
												}
												
												$echo_tags = implode(', ', $all_tags);
												echo html_entity_decode($echo_tags);
												echo '
											</div>';
										} ?>
									<?php echo '
									</div>';
								} ?>
								</div><!-- Share & Tags Wrap -->
								<?php if($campaign_author_intro == 'false'){ ?>
										<div class="author-box-wrap w-100">
											<?php if($camp_author_intro_title) { ?> <h3 class="mb-0"><?php echo esc_html($camp_author_intro_title); ?></h3> <?php } ?>
											<div class="author-box d-flex flex-wrap pat-bg gray-layer opc8 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>">
												<div class="author-img">
													<img class="img-fluid w-100" src="<?php echo esc_url($avatar_url_large); ?>" alt="<?php esc_attr__('Author Image','tabligh'); ?>">
												</div>
												<div class="author-info">
													<h4 class="mb-0"><?php echo get_the_author_meta( 'display_name' , $post->post_author ); ?></h4> 
													<?php if(!empty(get_the_author_meta('designation'))) { ?>	
														<small class="thm-clr">(<?php echo esc_html(get_the_author_meta('designation')); ?>)</small> 
													<?php } ?>
													<p class="mb-0"><?php echo nl2br(get_the_author_meta('description')); ?></p>
													<div class="author-social d-inline-flex">
														<span class="d-inline-block"><?php echo esc_html('STAY CONNECTED:','tabligh'); ?></span>
														<div class="author-social-inner d-inline-flex">
														<?php if(!empty(get_the_author_meta('twitter'))) { ?>
															<a href="<?php echo esc_url(get_the_author_meta('twitter')); ?>" title="<?php esc_attr__('Twitter','tabligh'); ?>" target="_blank"><i class="fab fa-twitter"></i></a>
														<?php } ?>
														<?php if(!empty(get_the_author_meta('facebook'))) { ?>	
															<a href="<?php echo esc_url(get_the_author_meta('facebook')); ?>" title="<?php esc_attr__('Faceboook','tabligh'); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
														<?php } ?>	
														<?php if(!empty(get_the_author_meta('linkedin'))) { ?>	
															<a href="<?php echo esc_url(get_the_author_meta('linkedin')); ?>" title="<?php esc_attr__('LinkedIn','tabligh'); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
														<?php } ?>	
														</div>
													</div>
												</div>
											</div>
										</div><!-- Author Box Wrap -->
								<?php } ?>
								<?php /* Comments list Template */ if ( comments_open() || get_comments_number() ) : comments_template(); endif; ?>
								<?php if (comments_open()){ ?> 
								<div class = "comment-reply w-100">
									<?php /* comment Form */
									$post_commenter = wp_get_current_commenter();
									$req = get_option( 'require_name_email' );
									$aria_req = ( $req ? " aria-required='true'" : '' );
									if(function_exists('tabligh_comment_form_temp')){ ?>
										<div class = "comment-reply w-100"><?php echo tabligh_comment_form_temp($post_commenter, $req, $aria_req ); ?></div>
									<?php 
									}
									?>
								</div>
								<?php } ?>
							</div>
							<?php /* Right Sidebar */
							if($campaign_sidebar_layout == 'right'){ ?>
								<div class="col-md-6 col-sm-6 col-lg-3">
									<aside class="sidebar w-100">
										<?php dynamic_sidebar( $campaign_sidebar_selected ); ?>
									</aside>
								</div>
							<?php } /*endif */ ?>
						</div>
					</div>
				</div><!-- Post Detail Wrap -->
			</div>
		</div>
	</section>
	
<?php 
	}
  }
get_footer(); 
?>