<?php 

/* Add Default Styles 

*  Default Color Scheme: #b59d5a;

*/
	function tabligh_color_scheme_default(){

		/* Get Option Value From Theme Options */
		global $tabligh_options, $post;

		/* Get Color Scheme From Theme Options */
		$color_primary = $tabligh_options['color-primary']; 
		$color_secondary = $tabligh_options['color-secondary']; 
		/* Get Background Settings */
		$selected_type = $tabligh_options['select-bodybg-type'];
		$body_color = $tabligh_options['body_color'];
		$body_patterns = tabligh_get_pattern($tabligh_options['body_patterns']);
		$background_image = $tabligh_options['background_image']['url'];

		/* Create StyleSheet */

		$default_html = '<style id="stylesheet">';
		
		/* Body Color */
		if($selected_type == 'color'){ $default_html .= 'body{background:'.esc_attr($body_color).';}'; }
		/* Body Pattern */
		if($selected_type == 'pattren'){ $default_html .= 'body{background:url('.esc_url($body_patterns).') repeat;}'; }
		/* Body Background */
		if($selected_type == 'image'){ $default_html .= 'body{background:url('.esc_url($background_image).') repeat;}'; }
		
		$page_color_seperate = '';
		
		if(function_exists('get_post_meta') != (is_search() || is_404() || is_archive())){
			$page_color_seperate =  get_post_meta( get_the_ID($post->ID), 'page_color_seperate', 1 );
		}
		
		
		if(is_search() || is_404() || is_archive()){
			$color_primary = $color_primary;
		}elseif(!empty($page_color_seperate) ){
			$color_primary = $page_color_seperate; /*green*/
		}else{
			$color_primary = $color_primary;
		}
		
		$default_html .= '.thm-bg,
.thm-layer:before,
.thm-btn span,
.plyr .player .controls > div:hover,
.plyr .player .controls > div:focus,
.plyr .player .progressbar .bar-played,
.plyr .player .volume .volume-adjust div div,
.prod-caro > button.slick-arrow:hover,
.prod-caro > button.slick-arrow:focus,
.qty-wrap .bootstrap-touchspin > span button:hover,
.qty-wrap .bootstrap-touchspin > span button:focus,
.serv-box:hover,
.slick-slider:not(.feat-caro) ul.slick-dots li button:hover,
.slick-slider:not(.feat-caro) ul.slick-dots li button:focus,
.slick-slider:not(.feat-caro) ul.slick-dots li.slick-active button,
.plyr.v2 .player .volume .volume-btn:hover,
.plyr.v2 .player .volume .volume-btn:focus,
.plyr.v4 .player .volume .volume-btn:hover,
.plyr.v4 .player .volume .volume-btn:focus,
.video-box > a:hover,
.video-box > a:focus,
.about-video > a:hover,
.about-video > a:focus,
.event-caro > button.slick-arrow:hover,
.event-caro > button.slick-arrow:focus,
.pack-box.active,
.post-share:hover > i,
.post-share-social > a:hover,
.post-share-social > a:focus,
.course-box3:hover:before,
.white-layer .fact-box > span:after,
ul.pagination > li.page-item.prev a.page-link:hover, 
ul.pagination > li.page-item.next a.page-link:hover,
ul.pagination > li.page-item.prev a.page-link:focus, 
ul.pagination > li.page-item.next a.page-link:focus,
ul.pagination > li.page-item.active a.page-link, 
ul.pagination > li.page-item a.page-link.active, 
ul.pagination > li.page-item a.page-link:hover, 
ul.pagination > li.page-item a.page-link:focus,
.social-links4 > a:hover,
.social-links4 > a:focus,
.sermons-btns2 > a:hover i, 
.sermons-btns2 > a:focus i,
.sermon-video > a:hover,
.sermon-video > a:focus,
.services-detail-info > span + ul:before,
.prod-btn:hover,
.prod-btn:focus,
.prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:hover,
.prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:focus,
.prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link.active,
.adt-info-list > li::before,
.social-links4.v2 > a:hover,
.social-links4.v2 > a:focus,
.styled-list > li:before,
.rspn-scil > a:hover,
.rspn-scil > a:focus,
.rspn-mnu-btn:hover,
.rspn-mnu-btn:focus,
.rspn-mnu-cls:hover,
.rspn-mnu-cls:focus, .thm-bg, .thm-layer:before, .thm-btn span, .plyr .player .controls > div:hover, .plyr .player .controls > div:focus, .plyr .player .progressbar .bar-played, .plyr .player .volume .volume-adjust div div, .prod-caro > button.slick-arrow:hover, .prod-caro > button.slick-arrow:focus, .qty-wrap .bootstrap-touchspin > span button:hover, .qty-wrap .bootstrap-touchspin > span button:focus, .serv-box:hover, .slick-slider:not(.feat-caro) ul.slick-dots li button:hover, .slick-slider:not(.feat-caro) ul.slick-dots li button:focus, .slick-slider:not(.feat-caro) ul.slick-dots li.slick-active button, .plyr.v2 .player .volume .volume-btn:hover, .plyr.v2 .player .volume .volume-btn:focus, .plyr.v4 .player .volume .volume-btn:hover, .plyr.v4 .player .volume .volume-btn:focus, .video-box > a:hover, .video-box > a:focus, .about-video > a:hover, .about-video > a:focus, .event-caro > button.slick-arrow:hover, .event-caro > button.slick-arrow:focus, .pack-box.active, .post-share:hover > i, .post-share-social > a:hover, .post-share-social > a:focus, .course-box3:hover:before, .white-layer .fact-box > span:after, ul.pagination > li.page-item.prev a.page-link:hover, ul.pagination > li.page-item.next a.page-link:hover, ul.pagination > li.page-item.prev a.page-link:focus, ul.pagination > li.page-item.next a.page-link:focus, ul.pagination > li.page-item.active a.page-link, ul.pagination > li.page-item a.page-link:hover, ul.pagination > li.page-item a.page-link:focus, .social-links4 > a:hover, .social-links4 > a:focus, .sermons-btns2 > a:hover i, .sermons-btns2 > a:focus i, .sermon-video > a:hover, .sermon-video > a:focus, .services-detail-info > span + ul:before, .prod-btn:hover, .prod-btn:focus, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:hover, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:focus, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link.active, .adt-info-list > li::before, .social-links4.v2 > a:hover, .social-links4.v2 > a:focus, .styled-list > li:before, .rspn-scil > a:hover, .rspn-scil > a:focus, .rspn-mnu-btn:hover, .rspn-mnu-btn:focus, .rspn-mnu-cls:hover, .rspn-mnu-cls:focus, ul.pagination > li.page-item a.active.page-link,
.donation-detail-info-wrap .thm-btn:hover,
.donation-detail-info-wrap .thm-btn:focus,
.pagination-wrap > span.em-pagination > a:hover,
.pagination-wrap > span.em-pagination > a:focus,
.pagination-wrap > span.em-pagination > a.next:hover,
.pagination-wrap > span.em-pagination > a.prev:hover,
.pagination-wrap > span.em-pagination > a.next:focus,
.pagination-wrap > span.em-pagination > a.prev:focus,
.pagination-wrap > span.em-pagination > strong,
.event-booking-form input[type="submit"],
.search-form form button,
.woocommerce-page.woocommerce nav.woocommerce-pagination ul li a:hover, 
.woocommerce-page.woocommerce nav.woocommerce-pagination ul li a:focus, 
.woocommerce-page.woocommerce nav.woocommerce-pagination ul li span,
.woocommerce ul.products li.product .onsale,
.woocommerce ul.products li.product .button, 
.woocommerce ul.products li.product .added_to_cart,
.woocommerce #content .quantity .bootstrap-touchspin > span button:hover, 
.woocommerce .quantity .bootstrap-touchspin > span button:hover,
.woocommerce-page #content .quantity .bootstrap-touchspin > span button:hover, 
.woocommerce-page .quantity .bootstrap-touchspin > span button:hover,
.woocommerce #content .quantity .bootstrap-touchspin > span button:focus, 
.woocommerce .quantity .bootstrap-touchspin > span button:focus,
.woocommerce-page #content .quantity .bootstrap-touchspin > span button:focus, 
.woocommerce-page .quantity .bootstrap-touchspin > span button:focus,
.single-product div.product form.cart .button,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active > a,
.woocommerce div.product .woocommerce-tabs ul.tabs li > a:hover,
.woocommerce div.product .woocommerce-tabs ul.tabs li > a:focus,
.woocommerce #review_form #respond .form-submit input,
.woocommerce a.remove,
body .campaign-progress-bar .bar, 
body .donate-button, 
body .charitable-donation-form .donation-amount.selected, 
body .charitable-donation-amount-form .donation-amount.selected,
.tagcloud > a:hover, 
.wp-block-tag-cloud > a:hover,
.tagcloud > a:focus, 
.wp-block-tag-cloud > a:focus,
.calendar_wrap > table caption, 
table#wp-calendar caption,
.calendar_wrap > table tbody td#today, 
table#wp-calendar tbody td#today,
.widget2 .srch-frm button:hover,
.widget2 .srch-frm button:focus,
footer .srch-frm button:hover,
footer .srch-frm button:focus,
.wp-block-button .wp-block-button__link:hover,
.wp-block-button .wp-block-button__link:focus,
.page-links > a:hover, 
.page-links > a:focus, 
.page-links > span:not(.page-links-title),
.post-password-form input:not([type="password"]):hover,
.post-password-form input:not([type="password"]):focus, .woocommerce-page.woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce div.product p.price ins, .woocommerce div.product span.price ins, .single-product .product span.onsale, .single-product.woocommerce div.product form.cart div.quantity + button
 {
			background-color:'.esc_attr($color_primary).'; 
		}';
		
		
$default_html .= '.pr-tm-wrp:before {
    background-image: linear-gradient(120deg, '.esc_attr($color_primary).', '.esc_attr($color_primary).');
}';

			
		/* Theme - PRIMARY - Brown Color */
		
		$default_html .= '.thm-clr, div#countdown-container #namaz-counter span, .post-meta > li i, .donate-wrap2 .donate-title strong, .woocommerce .rate-wrap .star-rating::before, .woocommerce .rate-wrap .star-rating span::before, .post-type-archive-product ins .woocommerce-Price-currencySymbol,
nav > div > ul li:hover,  .single-product.woocommerce .related ins span.woocommerce-Price-amount.amount,
nav > div > ul li:hover > a, .related ins .woocommerce-Price-currencySymbol,
nav > div > ul li a:focus,
nav > div > ul > li.menu-item-has-children:hover:after,
.scl1 > a:hover, .related h2.woocommerce-loop-product__title:hover, .current_page_item, .current-menu-parent,
.scl1 > a:focus,
.tp-lnks > li a:hover,
.tp-lnks > li a:focus,
.srch-btn:hover, .single-courses .course-scholar-inner > span,
.srch-btn:focus,
.header-search form > button:hover,
.header-search form > button:focus,
header.style1 nav > div > a.srch-btn:hover,
header.style1 nav > div > a.srch-btn:focus,
.abt-vdo > a:hover,
.abt-vdo > a:focus,
.prayer-timings > table tr:hover td,
.serv-bx:hover > i.green-clr,
.post-inf > h5 a:hover,
.post-inf > h5 a:focus,
.pst-mta > li a:hover,
.pst-mta > li a:focus,
.post-inf > a:hover,
.post-inf > a:focus,
.event-bx > h5 a:hover,
.event-bx > h5 a:focus,
.event-bx > a:hover,
.event-bx > a:focus,
.event-bx:hover > a:hover,
.event-bx:hover > a:focus,
.rcnt-inf > h6 a:hover,
.rcnt-inf > h6 a:focus,
.cpy-rgt > p a:hover,
.cpy-rgt > p a:focus,
.cnt-inf > li a:hover,
.cnt-inf > li a:focus,
.inf-lst > li a:hover,
.inf-lst > li a:focus,
ol.breadcrumb > li.breadcrumb-item.active,
.breadcrumb > li a:hover,
.breadcrumb > li a:focus,
.cause-inf > h5 a:hover,
.cause-inf > h5 a:focus,
.event-inf > h5 a:hover,
.event-inf > h5 a:focus,
.event-inf > a:hover,
.event-inf > a:focus,
.cnt-inf-lst > li a:hover,
.cnt-inf-lst > li a:focus,
.tch-dwn-btn > a:hover,
.tch-dwn-btn > a:focus,
.tch-thmb > a:hover,
.tch-thmb > a:focus,
.lst-cas > h6 a:hover,
.lst-cas > h6 a:focus,
.widget ul li > a:hover,
.widget ul li > a:focus,
.tag-clouds > a:hover,
.tag-clouds > a:focus,
.service-detail-nav > ul li:hover > a,
.service-detail-nav > ul li.active > a,
.service-detail-nav > ul li > a:focus,
.product-inf > h5 a:hover,
.product-inf > h5 a:focus,
.product-detail-tabs > ul li a.nav-link:hover,
.product-detail-tabs > ul li a.nav-link:focus,
.product-detail-tabs > ul li a.nav-link.active,
.rsnp-mnu ul > li > a:focus,
.rsnp-mnu ul > li:hover > a,
.rsnp-mnu ul > li.active > a,
.rspn-srch > button:hover,
.rsnp-mnu ul li.menu-item-has-children.active:before,
header.style1 .scl1 > a:hover,
header.style1 .scl1 > a:focus,
.rspn-cnt > span a:hover,
.rspn-cnt > span a:focus,
.widget > h5 + div > ul li:before,
.widget > h5 + div > ul li:hover > a,
.widget > h5 + div > ul li > a:focus,
.cont-frm a:hover,
.cont-frm a:focus,
.em-pagination a:hover,
.em-pagination a:focus,
.em-pagination span,
.woocommerce form .form-row label abbr,
.woocommerce form .form-row .required,
.woocommerce form .form-row.woocommerce-invalid label,
.woocommerce-info::before, 
.woocommerce-message::before,
.woocommerce-info a, 
.woocommerce-message a,
.woocommerce table.shop_table td.product-name a:hover,
.woocommerce table.shop_table td.product-name a:focus,
.woocommerce table.shop_table td.product-price,
.woocommerce table.shop_table td.product-subtotal,
.woocommerce .star-rating::before,
.woocommerce .star-rating span,
.woocommerce .star-rating + a,
form.cart + a.compare:hover,
form.cart + a.compare:focus,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active a, 
.woocommerce div.product .woocommerce-tabs ul.tabs li a:hover,
.woocommerce div.product .woocommerce-tabs ul.tabs li a:focus,
.woocommerce-MyAccount-navigation > ul > li a:hover,
.woocommerce-MyAccount-navigation > ul > li a:focus,
.woocommerce-MyAccount-navigation > ul > li.is-active a,
.woocommerce-MyAccount-content p a,
.woocommerce-account .addresses .title .edit,
.widget table a,
table th a:hover,
table th a:focus, footer .rcnt-bx .rcnt-inf h6,
p a,
dl a,
dd a,
.pagination .page-link.active,
.post-info > a,
.ltst-prd-inf > h6 a:hover,
.ltst-prd-inf > h6 a:focus,
.woocommerce ul.product_list_widget li a + del + ins,
.woocommerce ul.product_list_widget li:hover img + span.product-title,
.woocommerce ul.product_list_widget li a:focus img + span.product-title,
#cancel-comment-reply-link,
.woocommerce div.product form.cart .group_table td label a:hover,
.woocommerce div.product form.cart .group_table td label a:focus,
.ins,
.woocommerce div.product p.price, 
.woocommerce div.product span.price,
.woocommerce ul.products li.product .price,
.woocommerce div.product form.cart .group_table td.woocommerce-grouped-product-list-item__price > span,
h2 + table td a,
h2 + table th a,
div.sticky .post-bx .post-inf::before, 
div.category-sticky .post-bx .post-inf::before, 
div.tag-sticky-2 .post-bx .post-inf::before, 
.style1 nav > div ul ul li a:hover,
div.post-bx.lst .post-inf > a:hover,
div.post-bx.lst .post-inf > a:focus,
.widget > ul li span.rss-date, 
.widget > div > ul li span.rss-date,
.widget > ul li:before, 
.widget > div > ul li:before,
.wp-block-calendar table#wp-calendar tfoot a,
.wp-block-calendar table#wp-calendar tbody a,
.blog-detail-desc > h2 + ul li a,
.blog-detail-desc > h2 + ol li a, a:hover, .widget_recent_comments a:hover, .widget .srch-frm button i, body .pst-shr-tgs .tag-clouds a:hover, header.style1.alim nav > div > ul > li ul li a:hover, .alim .sec-title-inner > h3, .thm-clr, nav div > ul li:hover > a, nav div > ul li a:focus, nav div > ul li:hover > a:before, nav div > ul li a:focus:before, .sec-title-inner > h3, .srv-tl > h2 span, .serv-box > i, .serv-info > h4 a:hover, .serv-info > h4 a:focus, .team-info > h4, .evnt-info > h4 a:hover, .evnt-info > h4 a:focus, .pst-mta > li.thm-clr, .prayer-times > li span.thm-clr, .wdgt-box > ul li:hover > a, .wdgt-box > ul li a:focus, .srch-btn:hover, .srch-btn:focus, .owl-carousel .owl-nav button.owl-next:hover, .owl-carousel .owl-nav button.owl-prev:hover, .owl-carousel .owl-nav button.owl-next:focus, .owl-carousel .owl-nav button.owl-prev:focus, .hstry-desc > span, .hstry-desc > strong span, .team-info2 > h4, .sec-title-inner2 > h3, .srv-box2 > i, .srv-info2 > a, .fea-info2 > a, .breadcrumbs > li a:hover, .breadcrumbs > li a:focus, .contact-info-box > a:hover, .contact-info-box > a:focus, .cont-title > span, .blog-info > a, .blog-info > h4 a:hover, .blog-info > h4 a:focus, .pst-mta2 > li a:hover, .pst-mta2 > li a:focus, .event-info > h4 a:hover, .event-info > h4 a:focus, .event-mta > li i, .srv-ttl > i, .msn-desc > h3, .fltr-lnks > li a:hover, .fltr-lnks > li a:focus, .fltr-lnks > li.active > a, .prtfl-info > a:hover, .prtfl-info > a:focus, .tag-clouds > a:hover, .tag-clouds > a:focus, .cmt-inf > a, .rcnt-inf > h6 a:hover, .rcnt-inf > h6 a:focus, .contact-btn i, .header-search > form button:hover, .header-search > form button:focus, .rsnp-mnu ul > li > a:focus, .rsnp-mnu ul > li:hover > a, .rsnp-mnu ul > li.active > a, .rspn-srch > button:hover, .rsnp-mnu ul li.menu-item-has-children.active:before, .rspn-cnt > span a:hover, .rspn-cnt > span a:focus, .rspn-srch > button:hover, .rspn-srch > button:focus, .evnt-info > h4 a:hover, .evnt-info > h4 a:focus, .expns-info > h4 a:hover, .expns-info > h4 a:focus, .fea-car > .row > div:nth-child(2) .fea-info2 > a:hover, .fea-car > .row > div:nth-child(2) .fea-info2 > a:focus, .alim .srv-tl > h2 strong, .alim .hstry-desc > .excerpt-about p strong, .donate-block .black-layer3 .sec-title-inner2 > span,.single .event-detail-desc > ul li:before, .widget i.fa.fa-bookmark-o, .ele_hijri_date p, .widget ul:not(.cont-info-list2) li a:before, .thm-clr, nav ul li:hover > a, nav ul li.active > a, nav ul li > a:focus, .rsnp-mnu ul > li:hover > a, .rsnp-mnu ul > li.active-parent > a, .rsnp-mnu ul > li.active > a, .rsnp-mnu ul > li > a:focus, .topbar-info-list > li a:hover, .topbar-info-list > li a:focus, .social-links > a:hover, .social-links > a:focus, header.style3 .social-links > a:hover, header.style3 .social-links > a:focus, .bg-color1 .social-links > a:hover, .bg-color1 .social-links > a:focus, .plyr .player .volume > div:hover, .plyr .player .volume > div:focus, .prod-info > h3 a:hover, .prod-info > h3 a:focus, .prod-info > a, .serv-box > a, .course-inner > h4 a:hover, .course-inner > h4 a:focus, .team-info > h3 a:hover, .team-info > h3 a:focus, .event-info > h3 a:hover, .event-info > h3 a:focus, .post-info > h3 a:hover, .post-info > h3 a:focus, .post-meta > li a:hover, .post-meta > li a:focus, .widget ul li > a:before, .widget ul li:hover > a, .widget ul li > a:focus, .bottom-bar p a, .serv-info > h3, .event-wrap2 > a, .event-info2 > h3 a:hover, .event-info2 > h3 a:focus, .sec-title-inner > p.thm-clr, .urgent-donat-info > h3 a:hover, .urgent-donat-info > h3 a:focus, .urgent-donat-meta > li.thm-clr, .post-info2 > h3 a:hover, .post-info2 > h3 a:focus, .learn-top-inner > a, .learn-post-info > h4 a:hover, .learn-post-info > h4 a:focus, .learn-post-info > a, .course-info2 > h3 a:hover, .course-info2 > h3 a:focus, .white-layer .fact-inner > h5, .team-info2 > h3 a:hover, .team-info2 > h3 a:focus, .post-info3 > h3 a:hover, .post-info3 > h3 a:focus, .post-meta3 > li.thm-clr, .social-links3 a i, .social-links3 > a:hover, .social-links3 > a:focus, .black-layer .social-links3 > a:hover, .black-layer .social-links3 > a:focus, .bottom-links > li a:hover, .bottom-links > li a:focus, .bottom-inner > p a:hover, .bottom-inner > p a:focus, ol.breadcrumb > li.breadcrumb-item a:hover, ol.breadcrumb > li.breadcrumb-item a:focus, .team-detail-info-list > li, .experties-list > li a:before, .experties-list > li a:hover, .experties-list > li a:focus, .sermon-info-list > li:before, .services-info-list > li:before, .sermons-btns2 > a, .sermons-btns2 > a i, .gallery-info > h3 a:hover, .gallery-info > h3 a:focus, .cart-table td h5 a:hover, .cart-table td h5 a:focus, [type="checkbox"]:not(:checked) + label:after, [type="checkbox"]:checked + label:after, .cont-info-box > p a:hover, .cont-info-box > p a:focus, .comment-detail > a, .author-social-inner > a:hover, .author-social-inner > a:focus, .tags-links > a:hover, .tags-links > a:focus, .author-info > h4 a:hover, .author-info > h4 a:focus, .comment-detail > h4 a:hover, .comment-detail > h4 a:focus, .mini-post-info > h4 a:hover, .mini-post-info > h4 a:focus, .widget2 ul li:hover, .widget2 ul li:hover > a, .widget2 ul li a:focus, .widget2 ul.cate-list li:hover, .widget2 ul.cate-list li:hover > a, .widget2 ul.cate-list li a:focus, .mini-cause-info > h4 a:hover, .mini-cause-info > h4 a:focus, .widget2 ul li:hover a::before, .widget2 ul li a:focus:before, .rspn-srch > button:hover, .rspn-srch > button:focus, .rspn-cnt > span a:hover, .rspn-cnt > span a:focus,
.woocommerce-page.woocommerce div.product p.price,
.single-product.woocommerce .posted_in > a:hover, 
.single-product.woocommerce .sku_wrapper > a:hover,
.single-product.woocommerce .posted_in > a:focus, 
.single-product.woocommerce .sku_wrapper > a:focus,
.scl1 > a:hover,
.scl1 > a:focus,
.woocommerce .cart_totals table.shop_table td span.amount,
body .campaign-raised .amount, 
body .campaign-figures .amount, 
body .donors-count, 
body .time-left, 
body .charitable-form-field a:not(.button), 
body .charitable-form-fields .charitable-fieldset a:not(.button), 
body .charitable-notice, 
body .charitable-notice .errors a,
.wp-calendar-nav > span a:hover,
.wp-calendar-nav > span a:focus,
.widget2 ul:not(.insta-list) li.recentcomments > span.comment-author-link > a:hover,
.widget2 ul:not(.insta-list) li.recentcomments > span.comment-author-link > a:focus,
.post-detail-info ul li a,
.post-detail-info ol li a,
.post-detail-info p a,
.comment-respond > form > p a:hover,
.comment-respond > form > p a:focus,
#cancel-comment-reply-link:hover,
#cancel-comment-reply-link:focus, .post-meta4 .sl-wrapper a.liked
		{
			color:'.esc_attr($color_primary).'; 
		}';
		
		/* Theme - PRIMARY - Brown  border Color */
		$default_html .= '.theme-brd-clr,
.dnt-lst > a:hover,
.dnt-lst > a:focus,
.abt-vdo.style2:before,
.serv-bx2:hover .serv-inf2,
.pagination > li:hover,
.pagination > li.active,
.pillar-box > span:before,
.pillar-box > span span,
.video-box > a:hover,
.video-box > a:focus,
.about-video > a:hover,
.about-video > a:focus,
.post-share:hover > i,
.pillar-box2 > span:before,
.pillar-box2 > span:after,
ul.pagination > li.page-item.active a.page-link, 
ul.pagination > li.page-item a.page-link.active, 
ul.pagination > li.page-item a.page-link:hover, 
ul.pagination > li.page-item a.page-link:focus,
.sermons-btns2 > a i,
.product-detail-tabs > ul li a.nav-link:hover,
.product-detail-tabs > ul li a.nav-link:focus,
.product-detail-tabs > ul li a.nav-link.active,
.wp-block-button .wp-block-button__link:hover,
.wp-block-button .wp-block-button__link:focus, .plr-box.alim > i::after, .thm-brd-clr, .plr-box > i::after, .testi-itm, .hstry-img:before, .thm-layer .team-box2 > img, .plr-box:hover > i, .srv-box2:hover, .style5 .namaz-drp button#dropdownMenuButton, .thm-brd-clr, .pillar-box > span:before, .pillar-box > span span, .video-box > a:hover, .video-box > a:focus, .about-video > a:hover, .about-video > a:focus, .post-share:hover > i, .pillar-box2 > span:before, .pillar-box2 > span:after, ul.pagination > li.page-item.active a.page-link, ul.pagination > li.page-item a.page-link:hover, ul.pagination > li.page-item a.page-link:focus, .sermons-btns2 > a i, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:hover, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:focus, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link.active,
.pagination-wrap > span.em-pagination > a:hover,
.pagination-wrap > span.em-pagination > a:focus,
.pagination-wrap > span.em-pagination > a.next:hover,
.pagination-wrap > span.em-pagination > a.prev:hover,
.pagination-wrap > span.em-pagination > a.next:focus,
.pagination-wrap > span.em-pagination > a.prev:focus,
.pagination-wrap > span.em-pagination > strong,
body .charitable-donation-form .donation-amount.selected, 
body .charitable-donation-amount-form .donation-amount.selected, 
body .charitable-notice, 
body .charitable-drag-drop-images li:hover a.remove-image, 
body .supports-drag-drop .charitable-drag-drop-dropzone.drag-over,
.is-style-outline .wp-block-button__link:hover,
.is-style-outline .wp-block-button__link:focus, .feat-cap > h2 + p:before, .v3 .feat-cap > h2 + p:before
		{
			border-color: '.esc_attr($color_primary).';
		}';
		
		$default_html .= '.testi-desc
		{
			border-top-color: '.esc_attr($color_primary).';
		}';
		
		
		/* Theme - SECONDARY */
		
		$default_html .= '.green-bg,
.green-bg-layer:before,
.theme-btn.theme-bg:before,
.theme-btn.theme-bg:after,
.serv-bx:hover .srv-inf.theme-bg,
.owl-carousel .owl-nav > button:hover,
.owl-carousel .owl-nav > button:focus, .widget.blue-bg2.style2,.lg-mnu-inr, .fea-prd-prc:before, .package-box.active:before, .rcnt-pst:before, 
.cont-frm .form-submit input:hover,
.cont-frm .form-submit input:focus,
.em-booking-login-form > input[type="submit"]:hover,		
.em-booking-buttons input[type="submit"]:hover,
.em-booking-login-form > input[type="submit"]:focus,
.em-booking-buttons input[type="submit"]:focus,
.cont-frm input.wpcf7-submit:hover,
.cont-frm input.wpcf7-submit:focus,
.woocommerce ul.products li.product a:hover, 
.woocommerce div.product form.cart .button:hover, 
.woocommerce .cart .button:hover, 
.woocommerce .cart input.button:hover, 
#add_payment_method .wc-proceed-to-checkout a.checkout-button:hover, 
.woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover, 
.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button:hover, 
.woocommerce #respond input#submit.alt:hover, 
.woocommerce a.button.alt:hover, 
.woocommerce button.button.alt:hover, 
.woocommerce input.button.alt:hover, 
.woocommerce .woocommerce-error .button:hover, 
.woocommerce .woocommerce-info .button:hover, 
.woocommerce .woocommerce-message .button:hover, 
.woocommerce-page .woocommerce-error .button:hover, 
.woocommerce-page .woocommerce-info .button:hover, 
.woocommerce-page .woocommerce-message .button:hover, 
.woocommerce #respond input#submit:hover, 
.woocommerce a.button:hover, 
.woocommerce button.button:hover, 
.woocommerce input.button:hover,

.woocommerce ul.products li.product a:focus, 
.woocommerce div.product form.cart .button:focus, 
.woocommerce .cart .button:focus, 
.woocommerce .cart input.button:focus, 
#add_payment_method .wc-proceed-to-checkout a.checkout-button:focus, 
.woocommerce-cart .wc-proceed-to-checkout a.checkout-button:focus, 
.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button:focus, 
.woocommerce #respond input#submit.alt:focus, 
.woocommerce a.button.alt:focus, 
.woocommerce button.button.alt:focus, 
.woocommerce input.button.alt:focus, 
.woocommerce .woocommerce-error .button:focus, 
.woocommerce .woocommerce-info .button:focus, 
.woocommerce .woocommerce-message .button:focus, 
.woocommerce-page .woocommerce-error .button:focus, 
.woocommerce-page .woocommerce-info .button:focus, 
.woocommerce-page .woocommerce-message .button:focus, 
.woocommerce #respond input#submit:focus, 
.woocommerce a.button:focus, 
.woocommerce button.button:focus, 
.woocommerce input.button:focus,
.woocommerce a.remove:hover, 
.woocommerce a.remove:focus,
.blue-bg,
.tagcloud > a:hover,
.tagcloud > a:focus,
.lg-mnu-sec,
.post-password-form input[type="submit"]:hover,
.post-password-form input[type="submit"]:focus,
.theme-bg .newsletter-form > button,
.theme-bg .newsletter-form form p:nth-last-of-type(1) input,
.lgn-rgstr-frm input[type="submit"]:hover,
.lgn-rgstr-frm input[type="submit"]:focus,
.wp-block-tag-cloud > a:hover,
.wp-block-tag-cloud > a:focus,
form.wp-block-search button:hover,
form.wp-block-search button:focus,
.wp-block-tag-cloud > a:hover,
.wp-block-tag-cloud > a:focus, header.style2 .topbar, .rspn-mnu-btn, .green-bg, .green-bg-layer:before, .theme-btn.theme-bg:before, .theme-btn.theme-bg:after, .serv-bx:hover .srv-inf.theme-bg, .owl-carousel .owl-nav > button:hover, .owl-carousel .owl-nav > button:focus, input.mailpoet_submit, footer .wpcf7 input[type="submit"]:hover, .dnt-lst a.brd-rd30.active, .single-product .btn-primary:hover, .btn-primary:hover, .secndry-btn, .secndry-bg, .secndry-btn, .team-box:after, .contact-info-box:hover > i, .pagination > li.active > a, .pagination > li a:hover, .pagination > li a:focus, .msn-desc > ul li:before, .prtfl-box:before, .fltr-lnks > li a:before, .thm-btn:before, .secndry-btn:before, .news_ticker_sec span, .namaz-drp button#dropdownMenuButton
		{
			background-color: '.esc_attr($color_secondary).';
		}';
		
		$default_html .= '.green-clr, .alim .srv-tl > h2, 
.serv-bx:hover > i.theme-clr,
.serv-bx > h5 a:hover,
.serv-bx > h5 a:focus,
.error-page-inner > p a:hover,
.error-page-inner > p a:focus,
.woocommerce-MyAccount-content p a:hover,
.woocommerce-MyAccount-content p a:focus,
.woocommerce-account .addresses .title .edit:hover,
.woocommerce-account .addresses .title .edit:focus, .menu-sec nav > div > ul > li > a:focus, .error-page-inner > h1, .error-page-inner > span, .green-clr, .serv-bx:hover > i.theme-clr, .serv-bx > h5 a:hover, .serv-bx > h5 a:focus, .error-page-inner > p a:hover, .error-page-inner > p a:focus, .style2 nav > div ul li:hover , .rspn-cnt .inf-lst > li i, .woocommerce button.button.alt:hover, 
.woocommerce-page button.button.alt:hover,
.woocommerce a.button.alt:hover, 
.woocommerce-page a.button.alt:hover,
.woocommerce a.button:hover, 
.woocommerce-page a.button:hover,
.woocommerce button.button:hover,
.post-inf > h5, .event-bx > h5, .alim .hstry-desc > .excerpt-about p, .sidebar_wrapper .widget > h5, body .widget > h5, .rcnt-inf > span,
.woocommerce-page button.button:hover, .woocommerce div.product p.price, .woocommerce div.product span.price, .pr-tm-bx > span i, .secndry-clr, .plr-box > i, .pilr-info > h4, .sec-title-inner > span, .sec-title-inner > h3 span, .srv-tl > h2, .serv-info > h4, .team-scl > a, .evnt-info > h4, .pry-tim-hed > span, .testi-info > h4, .sec-title-inner2 > span, .srv-info2 > h4, .srv-info2 > a:hover, .srv-info2 > a:focus, .contact-info-box > i, .blog-info > a:hover, .blog-info > a:focus, .pagination > li a, .srv-ttl > h4, .msn-desc > ul li, .cmt-inf > a:hover, .cmt-inf > a:focus,.abot-sec a.secndry-btn:hover, .alim .sec-title-inner > h3 span, .dnt-sec-wrp .dnt-frm li i, .pr-tm-bx > h6, footer .rcnt-bx .rcnt-inf h6 a:hover
		{
			color: '.esc_attr($color_secondary).';
		}';
		
		/* Theme - PRIMARY - Brown Color */
		$default_html .= '.green-brd-clr, .plr-box.alim > i, .namaz-drp button#dropdownMenuButton
		{
			border-color: '.esc_attr($color_secondary).';
		}';
		
		/* Theme - PRIMARY - Brown Color */
		$default_html .= '#triangle-right
		{
			border-left: 25px solid '.esc_attr($color_secondary).';
		}';
		
		$default_html .= '</style>';

		/* Return All */
		return $default_html;
	}
	

	/* Add Style to Frontend */

	function tabligh_add_font_code(){

		/* Color Scheme */
		echo tabligh_color_scheme_default();

	}

	/* Add Style in Footer */

	global $pagenow;

	if( $GLOBALS['pagenow'] != 'wp-login.php' ){

		if(!is_admin()){

			add_action('wp_head', 'tabligh_add_font_code');
			add_action('wp_head', 'tabligh_color_scheme_default');

		}

	}
	/* get pattern url */
	function tabligh_get_pattern($patter_id){
		
		switch ($patter_id) {
			case 1:
				return esc_url(get_template_directory_uri().'/framework/images/pattern/pattern-1.png');
				break;
			case 2:
				return esc_url(get_template_directory_uri().'/framework/images/pattern/pattern-2.png');
				break;
			case 3:
				return esc_url(get_template_directory_uri().'/framework/images/pattern/pattern-3.png');
				break;
			case 4:
				return esc_url(get_template_directory_uri().'/framework/images/pattern/pattern-4.png');
				break;
			case 5:
				return esc_url(get_template_directory_uri().'/framework/images/pattern/pattern-5.png');
				break;
			case 6:
				return esc_url(get_template_directory_uri().'/framework/images/pattern/pattern-6.png');
				break;
			default:
				return esc_url(get_template_directory_uri().'/framework/images/pattern/pattern-1.png');
		}
	}
?>