<?php

	/*	
	*	Core Scripts
	*	---------------------------------------------------------------------
	*	This file manage to embed the stylesheet and javascript to each page
	*	based on the content of that page.
	*	---------------------------------------------------------------------
	*/

	/* Theme Check Recommendation */
	if ( ! isset( $content_width ) ) $content_width = 1170;
	
	/* 1. Add Theme Support */
	if(function_exists('add_theme_support')){
		
		/* Custom background Support */
		$args = array(
			'default-color'          => '',
			'default-image'          => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		);

		/* Custom Header Support */
		$defaults = array(
			'default-image'          => '',
			'random-default'         => false,
			'width'                  => 950,
			'height'                 => 200,
			'flex-height'            => false,
			'flex-width'             => false,
			'default-text-color'     => '',
			'header-text'            => true,
			'uploads'                => true,
			'wp-head-callback'       => '',
			'admin-head-callback'    => '',
			'admin-preview-callback' => '',
		);
		
		add_theme_support( "custom-header", $args );
		
		add_theme_support( "custom-background", $args );

		add_theme_support( 'html5', array('search-form', 'comment-form', 'comment-list',) );

		add_theme_support( 'post-formats', array('aside', 'image', 'video', 'audio', 'quote', 'link', 'gallery') );
		
		/* enable featured image */
		
		add_theme_support('post-thumbnails');
		
		/*  enable editor style */
		
		add_editor_style('editor-style.css');
		
		/* enable navigation menu */
		register_nav_menus(array('header-menu'=>esc_html__('Header Menu', 'tabligh'), 'footer-menu'=> esc_html__('Footer Menu', 'tabligh')));
		
		add_theme_support( 'title-tag' );
		
		/*  Add Another theme support */
		add_theme_support( 'automatic-feed-links' );	
	}
	
	
	/* 2. enable theme to support the localization */
	add_action('init', 'tabligh_word_translation');
	
	function tabligh_word_translation(){
		
		load_theme_textdomain( 'tabligh', get_template_directory() .'/languages/' );		
	}

	/* 3. excerpt filter */
	add_filter('excerpt_length','tabligh_excerpt_length');
	
	function tabligh_excerpt_length(){
		
		return 50;
	}
	
	/* 4. Custom Post type Feed */
	add_filter('request', 'tabligh_myfeed_request');
	function tabligh_myfeed_request($qv) {
		
		if (isset($qv['feed']) && !isset($qv['post_type']))
		$qv['post_type'] = array('post'); /* array('post','team') */
		return $qv;
	}

	/* 5. Translate the wpml shortcode */
	function tabligh_webtreats_lang_test( $atts, $content = null ) {
		extract(shortcode_atts(array( 'lang' => '' ), $atts));
		
		$tabligh_lang_active = ICL_LANGUAGE_CODE;
		
		if($lang == $tabligh_lang_active){
			return $content;
		}
	}
	
	/* Themeforest Recommendation - 1170 */
	if ( ! isset( $tabligh_content_width ) ){ $tabligh_content_width = 1170; }

	
	/* 6. Sidebar Controls */
	add_action( 'widgets_init', 'tabligh_sidebars_init' );
	function tabligh_sidebars_init() {
	
		/* Variable Redux Options */
		global $tabligh_options;
		
		/* Footer Sidebar */
		register_sidebar( array(
			'name' => esc_html__( 'Footer', 'tabligh' ),
			'id' => 'footer-sidebar',
			'description' => esc_html__( 'Add Widgets For Footer Section.', 'tabligh' ),
			'before_widget' => '<div class="col-md-6 col-sm-6 col-lg-4"><div class="widget w-100 %2$s">',		
			'before_title'  => '<h3 class = "widget-title" itemprop="headline">',
			'after_title'   => '</h3>',
			'after_widget'  => '</div></div>',
		) );
		
		/* Default Sidebar */
		register_sidebar( array(
			'name' => esc_html__( 'Default Pages Sidebar', 'tabligh' ),
			'id' => 'default-sidebar',
			'description' => esc_html__( 'Sidebar for Index, Search, Archive Pages.', 'tabligh' ),
			'before_widget' => '<div class="widget2 w-100 %2$s">',
			'before_title'  => '<h3 class = "widget-title2">',
			'after_title'   => '</h3>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 1 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 1 - Space 1', 'tabligh' ),
			'id' => 'footer-1-space-1',
			'description' => esc_html__( 'Use This To Place Widget of Style 1 - Location 1.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 2 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 1 - Space 2', 'tabligh' ),
			'id' => 'footer-1-space-2',
			'description' => esc_html__( 'Use This To Place Widget of Style 1 - Location 2.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 3 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 1 - Space 3', 'tabligh' ),
			'id' => 'footer-1-space-3',
			'description' => esc_html__( 'Use This To Place Widget of Style 1 - Location 3.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 4 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 1 - Space 4', 'tabligh' ),
			'id' => 'footer-1-space-4',
			'description' => esc_html__( 'Use This To Place Widget of Style 1 - Location 4.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 2 - Space 1*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 2 - Space 1', 'tabligh' ),
			'id' => 'footer-2-space-1',
			'description' => esc_html__( 'Use This To Place Widget of Style 2 - Location 1.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 2 - Space 2*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 2 - Space 2', 'tabligh' ),
			'id' => 'footer-2-space-2',
			'description' => esc_html__( 'Use This To Place Widget of Style 2 - Location 2.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 2 - Space 3*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 2 - Space 3', 'tabligh' ),
			'id' => 'footer-2-space-3',
			'description' => esc_html__( 'Use This To Place Widget of Style 2 - Location 3.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 2 - Space 4*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 2 - Space 4', 'tabligh' ),
			'id' => 'footer-2-space-4',
			'description' => esc_html__( 'Use This To Place Widget of Style 2 - Location 4.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 2 - Space 5*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 2 - Space 5', 'tabligh' ),
			'id' => 'footer-2-space-5',
			'description' => esc_html__( 'Use This To Place Widget of Style 2 - Location 5.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 3 - Space 1*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 3 - Space 1', 'tabligh' ),
			'id' => 'footer-3-space-1',
			'description' => esc_html__( 'Use This To Place Widget of Style 3 - Location 1.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 3 - Space 2*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 3 - Space 2', 'tabligh' ),
			'id' => 'footer-3-space-2',
			'description' => esc_html__( 'Use This To Place Widget of Style 3 - Location 2.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 3 - Space 3*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 3 - Space 3', 'tabligh' ),
			'id' => 'footer-3-space-3',
			'description' => esc_html__( 'Use This To Place Widget of Style 3 - Location 3.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 3 - Space 4*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 3 - Space 4', 'tabligh' ),
			'id' => 'footer-3-space-4',
			'description' => esc_html__( 'Use This To Place Widget of Style 3 - Location 4.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 3 - Space 5*/
		register_sidebar( array(
			'name' => esc_html__( 'Footer Style 3 - Space 5', 'tabligh' ),
			'id' => 'footer-3-space-5',
			'description' => esc_html__( 'Use This To Place Widget of Style 3 - Location 5.', 'tabligh' ),
			'before_widget' => '<div class="widget-box widget style2 %2$s">',
			'before_title'  => '<h4 class = "widget-title">',
			'after_title'   => '</h4>',
			'after_widget'  => '</div>',
		) );
		

		/* Function For Generating Dynamic Sidebars */
		
		if (function_exists('register_sidebar')){	

			/* Fetch Value From Theme Options Panel */
			$unlimited_sidebars_var = array();
			$unlimited_sidebars_var = isset($tabligh_options['multi-text']) ? $tabligh_options['multi-text'] : array();
			

			if(is_array($unlimited_sidebars_var)){
				/* Loop For all added sidebars */
				foreach($unlimited_sidebars_var as $single_sidebars_var){
	
					if(!empty($single_sidebars_var)){

						static $counter = 0;
							/* Generate Sidebars Against Added names */
							register_sidebar(
								array(
									'name' => esc_attr($single_sidebars_var), /* Name Added By User In Options Panel */
									'id' => str_replace(' ', '-', strtolower($single_sidebars_var)),
									'description' => esc_html__( 'Place Your Widgets Here.' , 'tabligh'),
									'before_widget' =>'<div class="widget-box widget style2 %2$s">',
									'before_title' => '<h5 class = "widget-title">',
									'after_title' => '</h5>',
									'after_widget' => '</div>'
								)
							);
						$counter++;
					}
				} /* end foreach */
			} /* endif */
		}/* endif */
	}/* end function */	
	
	
	/* 7. Default Fonts Enqueue
	* If Redux Not Installed Then Add Default Font From Here 
	*/
	if ( !class_exists( 'ReduxFramework' )){

		function tabligh_default_font_default() {
			wp_enqueue_style( 'tabligh_defaut_font_one', 'https://fonts.googleapis.com/css2?family=Montserrat:wght@100;200;300;400;500;600;700;800&display=swap', false );
			wp_enqueue_style( 'tabligh_defaut_font_two', 'https://fonts.googleapis.com/css2?family=Philosopher:ital,wght@0,400;0,700;1,400;1,700', false ); 			
		}
		add_action( 'wp_enqueue_scripts', 'tabligh_default_font_default' );
	}
	
	/* 8. Disable RevSlider/Visual Composer Update Notices */
	function tabligh_disable_version(){
		/* Revolution Slider */
		if (function_exists('set_revslider_as_theme')) {
			set_revslider_as_theme();
		}
	}
	
	/* 9. Page/Post Secondary Header Control */
	function tabligh_secondary_header($post_id = '', $title = ''){
		
		global $tabligh_options, $post;
		
		
		
		$breadcrumbs = isset($tabligh_options['breadcrumbs']) ? $tabligh_options['breadcrumbs'] : 1;
		
		/* Secondary Header */
		$secondary_header = 'display';
		
		/* Header Background Image */		
		$inner_header_bg = isset($tabligh_options['inner_header_bg']) ? $tabligh_options['inner_header_bg'] : '';		
		if(!empty($inner_header_bg['url'])){
			$header_img_url = $inner_header_bg['url'];
		}else{
			$header_img_url = '';
		}

		/* Header Check */
		if(is_search() || is_404() || is_archive() || is_single()){ 
			
			if(class_exists('woocommerce')){ if(is_shop() || is_checkout() || is_cart()){ $secondary_header = 'display'; } }
			
			$secondary_header = 'display';
			
		}else{
			
			$secondary_header = get_post_meta( get_the_ID($post->ID), 'secondary_header', true );
		}
		
		// check if ingeniofy plugin is active or not
		if(in_array('ingeniofy/index.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
			if(!is_404() && !is_search()){ $secondary_header = get_post_meta( get_the_ID($post->ID), 'secondary_header', true ); }
		}else{
			$secondary_header = 'display';
		}

		/* Detail Pages Will Always Show Inner Header */
		if(is_single() || is_archive() || is_404() || is_search() || is_home()){ $secondary_header = 'display';} 
		
		
		/* For WooCommerce Default Pages */
		if(class_exists('woocommerce')){ if(is_shop() || is_cart() || is_checkout()){ $secondary_header = 'display';}  }
		
		$theme_header = isset($tabligh_options['select-header-layout']) ? $tabligh_options['select-header-layout'] : 'default';
		
		if(is_404()){ 
		
			$page_header = 'default';
		
		}else{
		
			$page_header = get_post_meta( get_the_ID($post->ID), 'page_header_style', true );
		}
		
		if($page_header == 'default' && $theme_header == 'header3'){ $header_class = 'pt-180'; }elseif($page_header == 'header3'){ $header_class = 'pt-180'; }else{ $header_class = 'pt-80'; }  ?>
		
		<?php if($secondary_header == 'display'){ ?>
		
		<section>
			<div class="w-100 <?php echo esc_html($header_class);?> black-layer pb-70 opc85 position-relative">
				<div class="fixed-bg" style="background-image: url(<?php echo esc_url($header_img_url);?>)"></div>
				<div class="container">
					<div class="page-title-wrap text-center w-100">
						<div class="page-title-inner d-inline-block">
						<?php  /* Only For Archives */
							if(is_archive()){
									if(class_exists('WooCommerce') && is_shop()){
										echo '<h1 class="mb-0">'.esc_html__('Our Products','tabligh').'</h1>';
									}else{
										the_archive_title( '<h1 class="mb-0">', '</h1>');
									}
							}else{ /* for all pages */ 
								if(class_exists('WooCommerce') && is_product()){
										echo '<h1 class="mb-0">'.esc_html__('Our Products','tabligh').'</h1>'; 
									}else{ ?>
										<h1 class="mb-0"><?php printf( esc_html__( '%s', 'tabligh' ), $title );?></h1>
							   <?php }
							} 
							/* Breadcrumbs */
							if($breadcrumbs == 1){  tabligh_breadcrumbs(); }
						?>
						</div>
					</div><!-- Page Title Wrap -->
				</div>
			</div>
		</section>
		<?php }
	}
	/* 10. Page/Post Pagination Class Frontend */
	add_filter('next_posts_link_attributes', 'tabligh_posts_link_attributes');
	add_filter('previous_posts_link_attributes', 'tabligh_posts_link_attributes');

	function tabligh_posts_link_attributes() {
		return 'class="page-link"';
	}
	
	/* 11. Add Boxed Class For Boxed Layout */
	add_filter( 'body_class','tabligh_body_classes' );
	function tabligh_body_classes( $classes ) {
		
		global $post;
		
		/* function removed */
		 
		return $classes;
		 
	}
	/* 12. Remove Revolution Slider Meta Box Inside Page & Post */
	if ( is_admin() ) {

		function tabligh_remove_revolution_slider_meta_boxes() {
			remove_meta_box( 'mymetabox_revslider_0', 'page', 'normal' );
			remove_meta_box( 'mymetabox_revslider_0', 'post', 'normal' );
		}

		add_action( 'do_meta_boxes', 'tabligh_remove_revolution_slider_meta_boxes' );
		
	}
	

	/* 14. Author Intro Box */
	function tabligh_author_intro_box(){
		
		global $post;
		
		/* Detect if it is a single post with a post author */
		if ( is_single() && isset( $post->post_author ) ) {
			
			/* Get author's display name  */
			$display_name = get_the_author_meta( 'display_name', $post->post_author );
			
			if ( empty( $display_name ) )
			$display_name = get_the_author_meta( 'nickname', $post->post_author );
			
			/* Get author's biographical information or description */
			$user_description = get_the_author_meta( 'user_description', $post->post_author );
			
			/* Get author's website URL  */
			$user_website = get_the_author_meta('url', $post->post_author);
			
			/* Get link to the author archive page */
			$user_posts = get_author_posts_url( get_the_author_meta( 'ID' , $post->post_author));
			
			/* Post Author ID */
			$author_id = $post->post_author;
			
			/* initialize Variable  */
			$return_content = '';
			
			if(!empty($user_description)){
				$return_content .= '
					<div class="pst-athr">
						'.get_avatar( $author_id, 160 , '', '', array('class' => 'brd-rd50')).'
						<div class="pst-athr-inf">
							<h6 class="mb-0">'.esc_html__('AUTHOR MESSAGE:','tabligh').'</h6>
							<div class="athr-scl">';
								if(get_the_author_meta('googleplus')) {
								$return_content .= '<a href="'.esc_url(get_the_author_meta('googleplus')).'" title="'.esc_attr__('Google Plus','tabligh').'" data-toggle="tooltip" data-placement="top" target="_blank"><i class="fa fa-google-plus"></i></a>';
								}
								if(get_the_author_meta('twitter')) {
									$return_content .= '<a href="'.esc_url(get_the_author_meta('twitter')).'" title="'.esc_attr__('Twitter','tabligh').'" data-toggle="tooltip" data-placement="top" target="_blank"><i class="fa fa-twitter"></i></a>';
								}
								if(get_the_author_meta('linkedin')) {
									$return_content .= '<a href="'.esc_url(get_the_author_meta('linkedin')).'" title="'.esc_attr__('Linkedin','tabligh').'" data-toggle="tooltip" data-placement="top" target="_blank"><i class="fa fa-linkedin"></i></a>';
								}
								if(get_the_author_meta('facebook')) {
									$return_content .= '<a href="'.esc_url(get_the_author_meta('facebook')).'" title="'.esc_attr__('Facebook','tabligh').'" data-toggle="tooltip" data-placement="top" target="_blank"><i class="fa fa-facebook"></i></a>';
								}
							$return_content .= '
							</div>';
							if(!empty($user_description)){ 
								$return_content .= '<p class="mb-0">'.strip_tags($user_description).'</p>';
							}
							$return_content .= '
						</div>
					</div>';
					
			} /* endif */
		}	
		
		return $return_content;
	}
	

	/* 15. Custom Comments Form */
	function tabligh_comment_form_temp($tabligh_commenter, $req, $aria_req ){
		
		global $post;
		
		$tabligh_comment_form = array( 
			'fields' => apply_filters( 'comment_form_default_fields', array(
				'author' => '<div class="col-md-6 col-sm-12 col-lg-6">' .						
							'<input id="author" name="author" placeholder="'.esc_attr__('Full Name *','tabligh').'" type="text" value="' .
							esc_attr( $tabligh_commenter['comment_author'] ) . '" size="30" tabindex="1" />' .						
							'</div>',
							
				'email'  => '<div class="col-md-6 col-sm-12 col-lg-6">' .
							'<input id="email" name="email" placeholder="'.esc_attr__('Email *','tabligh').'" type="text" value="' . esc_attr(  $tabligh_commenter['comment_author_email'] ) . '" size="30" tabindex="2" />' .						
							'</div>',
							
				'subject'    => '<div class="col-md-12 col-sm-12 col-lg-12">' .
							'<input id="url" placeholder="'.esc_attr__('Subject *','tabligh').'" name="subject" type="text" value="' . esc_url( $tabligh_commenter['comment_author_url'] ) . '" size="30" tabindex="3" />' .
							'</div>' ) ),
				'comment_field' => '' .
							'<div class="col-md-12 col-sm-12 col-lg-12">'.												
							'<textarea cols="60" rows="10" placeholder="'.esc_attr__('Comments *','tabligh').'" id="comment" name="comment" aria-required="true"></textarea></div>' .
							'',
			'title_reply_before' => '<h3 class="mb-0">',
			'title_reply' => esc_html__('Leave Your Comments','tabligh'),
			'title_reply_after' => '</h3>',
			'class_form' => 'row mrg5',
			'class_submit' => 'thm-btn thm-bg',
			
		);
		
		comment_form($tabligh_comment_form, $post->ID);  
	}
	
/* 

	* ThemeForest Recommendation
	
	* "after_setup_theme" hook added
	
	* Calling required files/functions through setup function
	
	* Intialize Custom Functions On Theme Setup
	
	*/
		
		
	add_action( 'after_setup_theme', 'tabligh_theme_setup' );

	function tabligh_theme_setup() {

		/* Decalare WooCommerce Support */
		add_theme_support( 'woocommerce' );
		/* Add Lightbox */
		add_theme_support( 'wc-product-gallery-lightbox' );
		/* Product Zoom Feature */
		add_theme_support( 'wc-product-gallery-zoom' );
		
		
		add_action('woocommerce_before_main_content', 'tabligh_wrapper_start', 10);
	
		add_action('woocommerce_after_main_content', 'tabligh_wrapper_end', 10);
	
		add_action('woocommerce_before_main_content', 'tabligh_woocommerce_remove_breadcrumb');
	
		add_action( 'woo_custom_breadcrumb', 'tabligh_woocommerce_custom_breadcrumb' );	
		
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating');	
		
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 15 );	

	}

	/**************  Declare WooCommerce Support  **************************/ 
	
	function tabligh_wrapper_start() {
	
		global $post;
		
		/* Get Inner Header */ 
		if(function_exists('tabligh_secondary_header')) {
			tabligh_secondary_header($post->ID, get_the_title()); 
		}  ?>
		<section>
			<div class="spacing">
				<div class="container">
					<div class="product-detail-box">	
		<?php 
	}
		  
	function tabligh_wrapper_end() {
		
			echo '</div>
				</div>
			</div>
		</section>';
	}
	
	/*  Reposition WooCommerce breadcrumb */
	function tabligh_woocommerce_remove_breadcrumb(){
		remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
	}

	/*  Custom WooCommerce breadcrumb */
	function tabligh_woocommerce_custom_breadcrumb(){
		woocommerce_breadcrumb();
	}
	/* Move Product Tag Above Title */
	function tabligh_wc_single_product(){
		/* Product Tags */
		$product_cats = wp_get_post_terms( get_the_ID(), 'product_tag' );
		if ( $product_cats && ! is_wp_error ( $product_cats ) ){ ?>
		   <span class="tagged_as custom-block">
				<?php esc_html_e('Tags: ','tabligh');
					foreach($product_cats as $single_cat){ ?>
						<a href="<?php echo esc_url(get_category_link($single_cat->term_id));?>" rel="tag"><?php echo esc_attr($single_cat->name); ?></a>
				<?php } ?>
			</span>
			<?php
		}
	}
	add_action( 'woocommerce_single_product_summary', 'tabligh_wc_single_product', 2 );
	
	/* Social Shares of Product */
	add_action( 'woocommerce_share', 'tabligh_woocommerce_social_share_icons', 10 );
	function tabligh_woocommerce_social_share_icons() {
		if ( function_exists( 'tabligh_post_social_shares' ) ) {
			global $product;
			$id = $product->get_id();
		
			echo '<div class="scl1"><span>'.esc_html__('Share This Post:','tabligh').'</span>'; echo tabligh_post_social_shares($id); echo '</div>';
		}
	}
	/* Change product title to h3 */
	remove_action('woocommerce_single_product_summary','woocommerce_template_single_title',5);
	add_action('woocommerce_single_product_summary', 'tabligh_woocommerce_my_single_title',5);

	if ( ! function_exists( 'tabligh_woocommerce_my_single_title' ) ) {
	   function tabligh_woocommerce_my_single_title() {
	?>
				<h3 class="product_title entry-title mb-0"><span><?php the_title(); ?></span></h3>
	<?php
		}
	}
	
	/* Change product columns to 4 */
    add_filter('loop_shop_columns', 'tabligh_loop_columns');
    if (!function_exists('tabligh_loop_columns')) {
    	function tabligh_loop_columns() {
    		return 4; // 4 products per row
    	}
    }
	
	function tabligh_background($image_name = ''){
		return 'background-image: url('.get_template_directory_uri().'/assets/images/'.$image_name.')';
	}
	
	/* custom css class to sub menu */
	add_action('nav_menu_submenu_css_class', 'tabligh_submenu_css_class');
	function tabligh_submenu_css_class() {
		return array('sub-menu', 'mb-0', 'list-unstyled');
	}
?>