<?php

	/*	
	*	Comment File
	*	---------------------------------------------------------------------
	*	This file return the comment list to the selected post_type
	*	---------------------------------------------------------------------
	*/
	 
	function tabligh_get_comment_list( $comment, $args, $depth ) {
	
		$GLOBALS['comment'] = $comment;
		
		switch ( $comment->comment_type ) :
			case 'pingback'  :
			case 'trackback' :
			?>
				<li class="post pingback">	
					<p>
						<?php esc_html_e( 'Pingback:', 'tabligh'); ?>
						<?php comment_author_link(); ?>
						<?php edit_comment_link( esc_html_e('(Edit)', 'tabligh'), ' ' ); ?>
					</p>
					</li>
			<?php
				break;
				
			default :
			?>
				<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
					<div class="thumb">
						<?php echo get_avatar( $comment, 60 ); ?>
					</div>
					<div class="text">
						<h4><?php echo get_comment_author_link(); ?></h4>
						<?php comment_text(); ?>
						<div class="post-time">
							<ul>
								<li><p><?php echo get_comment_time();?> - <?php echo get_comment_date();?></p></li>
								<li><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></li>
							</ul>
						</div>
					</div>
				
			<?php
				break;
		endswitch;
		
	}
	
	/* Customized Comment Layout */
	function tabligh_comments($comment, $args, $depth) {
	
    if ( 'div' === $args['style'] ) {
        $tag       = 'div';
        $add_below = 'comment';
    } else {
        $tag       = 'li';
        $add_below = 'div-comment';
    }?>

    <<?php echo esc_html($tag); ?>><?php 
    if ( 'div' != $args['style'] ) { ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment d-flex flex-wrap pat-bg gray-layer opc9 position-relative back-blend-multiply gray-bg w-100" style = "<?php echo tabligh_background('pattern-bg.jpg'); ?>"><?php
    }  
	                                          
		echo '<div class="comment-img">';
        if ( $args['avatar_size'] != 0 ) { 
            $check_avatar = get_avatar( $comment, 170 , '', '', array('class' => 'img-fluid w-100')); 
            if($check_avatar !== false){?>
                <?php  echo get_avatar( $comment, 170 , '', '', array('class' => 'img-fluid w-100')); 
            }
    	} 
		echo '</div>';
		
        if ( $comment->comment_approved == '0' ) { ?>
            <em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'tabligh' ); ?></em><br/><?php 
        } ?>
		
		<div class="comment-detail">
			<h4 class="mb-0"><?php echo get_comment_author(); ?></h4>
			<small class="thm-clr">
			<?php /* translators: 1: date, 2: time */
                printf('%s', get_comment_date()); ?> <?php esc_html_e('AT ','tabligh'); ?><?php echo get_comment_time( ); ?>
			</small>
			<?php comment_text(); ?>
			<?php
			comment_reply_link( 
				array_merge( 
					$args, 
					array( 
						'add_below' => $add_below, 
						'depth'     => $depth, 
						'max_depth' => $args['max_depth'],
						'reply_text' => __('Reply Comment <i class="fas fa-caret-right"></i>', 'tabligh'),
					) 
				) 
			);
   
			if ( 'div' != $args['style'] ) :
				echo '</div>';
			endif;
		echo '</div>';
	}
?>
