<?php 

class  ThemeActivation {
    public $caps;
    public function __construct() {
        add_filter('ocdi/plugin_page_setup',array($this,'ignei_override_importer_plugin'),10);        
      //  add_action('admin_head',array($this,'localize_variable_for_themeactivation'),10);
        add_action('wp_ajax_theme_activation_form', array($this,'theme_activation_form_callback')); // This is for authenticated users
        add_action('wp_ajax_nopriv_theme_activation_form', array($this,'theme_activation_form_callback'));

        add_action('wp_ajax_theme_deactivation_form', array($this,'theme_deactivation_form_callback')); // This is for Theme Deactivation
        add_action('wp_ajax_nopriv_theme_deactivation_form', array($this,'theme_deactivation_form_callback'));
        
        add_action( 'admin_menu', array($this,'ThemeOptionCodeValidator'),10);   

       if(empty(get_option('theme_activation_key'))) {
            add_action( 'admin_notices', array($this,'my_theme_activation_notice' ));
        }    

    }
    
     public function my_theme_activation_notice(){ ?>
     <?php if(empty(get_option('theme_activation_key'))) { ?>

        <div class="updated notice is-dismissible nauvc">
            <p><?php echo __('Please Activate Your Theme','tabligh'); ?> <strong><a href="<?php echo admin_url( '/themes.php?page=theme-activation' ); ?>"><?php echo __('From Here','tabligh'); ?></a> </strong></p>
        </div>
        <?php } ?>
            <?php
        }	

    public  function ignei_override_importer_plugin() {
        $allow =  (get_option('theme_activation_key')) ? 'import' : 'change';
        return  $plugin_page_setup =  array(
            'parent_slug' => 'themes.php',
			'page_title'  => esc_html__( 'One Click Demo Import' , 'one-click-demo-import' ),
			'menu_title'  => esc_html__( 'Import Demo Data' , 'one-click-demo-import' ),
			'capability'  => $allow,
			'menu_slug'   => 'one-click-demo-import',
        );
   }
   
   public function ThemeOptionCodeValidator() {
    add_theme_page( 'Theme Title Settings',
     __('Theme Activation', 'tabligh'),
     'edit_theme_options', 'theme-activation', array($this,'theme_option_page' ));
   }

   public function theme_option_page() {
    ?>
    <style>
        form.activation-form {
            width: 50%;
            margin: 0 auto;
        }
        input#vc-code-field
        {
            padding: 10px;
        }
        button.btn-style {
            background-color: #0037ff94;
            color: #fff;
            border: none;
            padding: 15px 35px;
            font-size: 15px;
        }
        .form-field {
            margin: 10px 0;
        }
        .loader-gif img
        {
            width: 35px;
        }
        .loader-hide 
        {
            display:none;
        }
    </style>
	
    <div class="container thm-act-pg">
		<div class="intro">
            <h2 class="text-center"><?php echo __('Activate Theme with License Code','tabligh'); ?></h2>
			<p class="text-center"><?php echo __('You will be able to import demo content once theme is activated','tabligh'); ?></p> </p>
        </div>
		<!-- Activation Form -->
        <form class="activation-form" action="" method="post" name="theme-activation-form">
            <div class="form-field">    
                <input name="license_code" vc-code="<?php echo get_option('theme_activation_key'); ?>" type="text" id="vc-code-field" value="<?php echo get_option('theme_activation_key'); ?>" placeholder="Purchase Code" >
            </div>
            <div class="form-field">    
                <input name="license_domain" id="vc-domain-field" vc-domain="<?php echo esc_url(get_site_url()); ?>"  type="hidden"  value="<?php echo esc_url(get_site_url()); ?>" required>
            </div>
            <div class="loader-gif loader-hide">
                <img src="https://genie.nauthemes.com/wp-content/uploads/2021/04/loader2.gif">
            </div>
           
            <?php if(strlen(get_option('theme_activation_key')) > 5) 
            {
                echo '<button class="deactivate-key btn-style">'.esc_html__('Deactivate','tabligh').'</button>';
            }
            else
            {
                echo '<button type="submit" class="btn-style">'.esc_html__('Activate','tabligh').'</button>';
            }
            
            ?>
            
        </form>
        
		<?php /* Demo Link After Validation */
		if(get_option('theme_activation_key')) { ?>
			<div class = "imp-link">
				<a href="<?php echo admin_url( '/themes.php?page=one-click-demo-import' ); ?>"><span class="dmo-link"><?php echo __('Demo Import Page','tabligh'); ?></span></a>
			</div>
			<?php  
		} ?>
	
		<!-- Instructions Manual -->
		<div class = "inst-area">
			<h4><?php echo esc_html__('Instructions:','tabligh') ?></h4>
			<p><?php echo esc_html__('License Key can be found in here','tabligh') ?> <a href = "https://themeforest.net/downloads" target = "_blank"><?php echo esc_html__('Themeforest Downloads','tabligh') ?></a></p>
			<img src = "https://genie.nauthemes.com/wp-content/uploads/2021/04/tf-downloads.png" alt = "License Key"/>
		</div>
		
    </div> <!-- Container Ends -->
        
        
        
    <?php
   }
   public function theme_activation_form_callback() {
  //  check_ajax_referer( 'secure-nonce-name', 'security' );

    
        $curl = curl_init();
        $domainURL = 'https://genie.nauthemes.com/wp-json/nauthemes/v1/';
        $verification = $_POST['license_code'];
        $domain = $_POST['license_domain'];
        $mode = "CREATEMODE";
        $ctheme = get_current_theme();
        
        curl_setopt($curl, CURLOPT_URL, $domainURL.'verification='.$verification.'/domain='.$domain.'/mode='.$mode.'/ctheme='.$ctheme.'');

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $output = curl_exec($curl);

        curl_close($curl);
        

        if($output == 1) {
            update_option('theme_activation_key',trim($verification));
            echo __('License Key is valid and theme is Activated','tabligh');
        }
        else if($output == -10){
			echo __('License Key is already Registered For This Domain.','neurology');
			
		}else {
            echo __('invalid Key','tabligh');
            update_option('theme_activation_key','');    
        }
        
        die();

   }
   public function theme_deactivation_form_callback() {
        
    $curl = curl_init();
    $domainURL = 'https://genie.nauthemes.com/wp-json/nauthemes/v1/';
    $verification = $_POST['license_code'];
    $domain = $_POST['license_domain'];
    $mode = "DELETEMODE";
    $ctheme = get_current_theme();
    
    if($verification == "0000-0000")
    {
        echo __('License Key is Deregistered','tabligh');
        update_option('theme_activation_key','');  
        
        die();
    }

    curl_setopt($curl, CURLOPT_URL, $domainURL.'verification='.$verification.'/domain='.$domain.'/mode='.$mode.'/ctheme='.$ctheme.'');

    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

    $output = curl_exec($curl);

    curl_close($curl);
    
    if($output == 1) {
        echo __('License Key is Deregistered','tabligh');
        update_option('theme_activation_key','');    
    }
    else 
    {
        echo 'null';
    }
        die();
   }
}

new ThemeActivation();
?>