<?php
if ( post_password_required() ) {
	return;
}

// You can start editing here -- including this comment!
if ( have_comments() ) : ?>
	
<div  id = "comments-thread-link" class="comments-thread w-100">
		<h3 class="mb-0">
			<?php
			$comments_number = get_comments_number();
			if ( '1' === $comments_number ) : ?>
				<?php esc_html_e( 'One Comment', 'tabligh' ); ?>
			<?php else : ?>
				<?php
				printf(
					/* translators: %s: comment count number. */
					esc_html( _nx( '%s comment', '%s comments', $comments_number, 'Comments title', 'tabligh' ) ),
					esc_html( number_format_i18n( $comments_number ) )
				);
				?>
			<?php endif; ?>
			
		</h3>

		<ul class="comments-list mb-0 list-unstyled w-100">
			<?php
				wp_list_comments( 'type=all&callback=tabligh_comments' );
			?>
		</ul>
		
		<div class="comments-navigation">
			<div class="previous"> <?php previous_comments_link(esc_html__('Older Comments','tabligh')); ?> </div>
			<div class="next"> <?php next_comments_link(esc_html__('Newer Comments','tabligh')); ?> </div>
		</div>

	<?php

	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>

		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'tabligh' ); ?></p>
	<?php
	endif;
	?>
</div><!-- #comments -->
<?php 
endif; // Check for have_comments().