<?php

class Supplero_Merlin_Config {

    private $config = [];
    private $wizard;

    public function __construct() {
        $this->init();
        add_action('merlin_import_files', [$this, 'import_files']);
        add_action('merlin_after_all_import', [$this, 'after_import_setup'], 10, 1);
        add_filter('merlin_generate_child_functions_php', [$this, 'render_child_functions_php']);
    }

    public function import_files(){
            return array(
                array(
					'import_file_name'           => 'home 1',
					'home'                       => 'home-1',
					'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
					'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
					'rev_sliders'                => [
                    ],
					'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_1.jpg'),
					'preview_url'                => 'https://demo2.wpopal.com/supplero/home-1',
					'colors'                     => '{}',
					'themeoptions'               => '{"supplero_options_blog_style":"standard","supplero_options_single_product_gallery_layout":"horizontal","supplero_options_wocommerce_block_style":"1","supplero_options_social_share":"1","supplero_options_social_share_facebook":"1","supplero_options_social_share_twitter":"1","supplero_options_social_share_google-plus":"","supplero_options_social_share_email":"1","supplero_options_social_share_linkedin":"1","supplero_options_single_product_content_meta":""}',
				),

                array(
					'import_file_name'           => 'home 2',
					'home'                       => 'home-2',
					'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
					'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
					'rev_sliders'                => [
                    ],
					'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_2.jpg'),
					'preview_url'                => 'https://demo2.wpopal.com/supplero/home-2',
					'colors'                     => '{}',
					'themeoptions'               => '{"supplero_options_blog_style":"standard","supplero_options_single_product_gallery_layout":"horizontal","supplero_options_wocommerce_block_style":"1","supplero_options_social_share":"1","supplero_options_social_share_facebook":"1","supplero_options_social_share_twitter":"1","supplero_options_social_share_google-plus":"","supplero_options_social_share_email":"1","supplero_options_social_share_linkedin":"1","supplero_options_single_product_content_meta":"","wocommerce_block_style":3}',
				),

                array(
					'import_file_name'           => 'home 3',
					'home'                       => 'home-3',
					'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
					'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
					'rev_sliders'                => [
                    ],
					'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_3.jpg'),
					'preview_url'                => 'https://demo2.wpopal.com/supplero/home-3',
					'colors'                     => '{}',
					'themeoptions'               => '{"supplero_options_blog_style":"standard","supplero_options_single_product_gallery_layout":"horizontal","supplero_options_wocommerce_block_style":"1","supplero_options_social_share":"1","supplero_options_social_share_facebook":"1","supplero_options_social_share_twitter":"1","supplero_options_social_share_google-plus":"","supplero_options_social_share_email":"1","supplero_options_social_share_linkedin":"1","supplero_options_single_product_content_meta":"","wocommerce_block_style":3}',
				),

                array(
					'import_file_name'           => 'home 4',
					'home'                       => 'home-4',
					'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
					'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
					'rev_sliders'                => [
                    ],
					'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_4.jpg'),
					'preview_url'                => 'https://demo2.wpopal.com/supplero/home-4',
					'colors'                     => '{}',
					'themeoptions'               => '{"supplero_options_blog_style":"standard","supplero_options_single_product_gallery_layout":"horizontal","supplero_options_wocommerce_block_style":"1","supplero_options_social_share":"1","supplero_options_social_share_facebook":"1","supplero_options_social_share_twitter":"1","supplero_options_social_share_google-plus":"","supplero_options_social_share_email":"1","supplero_options_social_share_linkedin":"1","supplero_options_single_product_content_meta":"","wocommerce_block_style":3}',
				),

                array(
					'import_file_name'           => 'home 5',
					'home'                       => 'home-5',
					'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
					'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
					'rev_sliders'                => [
                    ],
					'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_5.jpg'),
					'preview_url'                => 'https://demo2.wpopal.com/supplero/home-5',
					'colors'                     => '{}',
					'themeoptions'               => '{"supplero_options_blog_style":"standard","supplero_options_single_product_gallery_layout":"horizontal","supplero_options_wocommerce_block_style":"1","supplero_options_social_share":"1","supplero_options_social_share_facebook":"1","supplero_options_social_share_twitter":"1","supplero_options_social_share_google-plus":"","supplero_options_social_share_email":"1","supplero_options_social_share_linkedin":"1","supplero_options_single_product_content_meta":"","wocommerce_block_style":2}',
				),

                array(
					'import_file_name'           => 'home 6',
					'home'                       => 'home-6',
					'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
					'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
					'rev_sliders'                => [
                    ],
					'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_6.jpg'),
					'preview_url'                => 'https://demo2.wpopal.com/supplero/home-6',
					'colors'                     => '{}',
					'themeoptions'               => '{"supplero_options_blog_style":"standard","supplero_options_single_product_gallery_layout":"horizontal","supplero_options_wocommerce_block_style":"1","supplero_options_social_share":"1","supplero_options_social_share_facebook":"1","supplero_options_social_share_twitter":"1","supplero_options_social_share_google-plus":"","supplero_options_social_share_email":"1","supplero_options_social_share_linkedin":"1","supplero_options_single_product_content_meta":"","wocommerce_block_style":3}',
				),

                array(
					'import_file_name'           => 'home 7',
					'home'                       => 'home-7',
					'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
					'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
					'rev_sliders'                => [
                    ],
					'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home_7.jpg'),
					'preview_url'                => 'https://demo2.wpopal.com/supplero/home-7',
					'colors'                     => '{}',
					'themeoptions'               => '{"supplero_options_blog_style":"standard","supplero_options_single_product_gallery_layout":"horizontal","supplero_options_wocommerce_block_style":"1","supplero_options_social_share":"1","supplero_options_social_share_facebook":"1","supplero_options_social_share_twitter":"1","supplero_options_social_share_google-plus":"","supplero_options_social_share_email":"1","supplero_options_social_share_linkedin":"1","supplero_options_single_product_content_meta":"","wocommerce_block_style":2}',
				),
            );           
        }

    public function after_import_setup($selected_import) {
        $selected_import = ($this->import_files())[$selected_import];
        $check_oneclick  = get_option('supplero_check_oneclick', []);

        $this->set_demo_menus();
        wp_delete_post(1, true);

        // setup Home page
        $home = get_page_by_path($selected_import['home']);
        if ($home) {
            update_option('show_on_front', 'page');
            update_option('page_on_front', $home->ID);
        }

        // Setup Breadcrumb
        if (!isset($check_oneclick['breadcrumb'])) {
            $this->enable_breadcrumb();
            $check_oneclick['breadcrumb'] = true;
        }

        // Setup Options
        $options   = $this->get_all_options();
        $newColors = json_decode($selected_import['colors']);
        if (count($newColors) > 0) {
            foreach ($newColors as $key => $value) {
                $options['elementor']['system_colors'] = $this->set_color_kit($options['elementor']['system_colors'], $key, $value);
            }
        }
        // Elementor
        $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
        update_post_meta($active_kit_id, '_elementor_page_settings', $options['elementor']);

        // Setup Options
        if (isset($selected_import['themeoptions'])) {
            $options = json_decode($selected_import['themeoptions'], true);
            foreach ($options as $key => $option) {
                if (count($options) > 0) {
                    foreach ($option as $k => $v) {
                        update_option($k, $v);
                    }
                }
            }
        }

        if (!isset($check_oneclick['elementor'])) {
            $this->fixelementor();
            $check_oneclick['elementor'] = true;
        }

        \Elementor\Plugin::$instance->files_manager->clear_cache();

        $this->setup_header_footer($selected_import['home']);
        if (!isset($check_oneclick['logo'])) {
            set_theme_mod('custom_logo', 289);
            $check_oneclick['logo'] = true;
        }

        $this->license_elementor_pro();

        update_option('supplero_check_oneclick', $check_oneclick);
    }

    private function init() {
        $this->wizard = new Merlin(
            $config = array(
                // Location / directory where Merlin WP is placed in your theme.
                'merlin_url'         => 'merlin',
                // The wp-admin page slug where Merlin WP loads.
                'parent_slug'        => 'themes.php',
                // The wp-admin parent page slug for the admin menu item.
                'capability'         => 'manage_options',
                // The capability required for this menu to be displayed to the user.
                'dev_mode'           => true,
                // Enable development mode for testing.
                'license_step'       => false,
                // EDD license activation step.
                'license_required'   => false,
                // Require the license activation step.
                'license_help_url'   => '',
                'directory'          => '/inc/merlin',
                // URL for the 'license-tooltip'.
                'edd_remote_api_url' => '',
                // EDD_Theme_Updater_Admin remote_api_url.
                'edd_item_name'      => '',
                // EDD_Theme_Updater_Admin item_name.
                'edd_theme_slug'     => '',
                // EDD_Theme_Updater_Admin item_slug.
            ),
            $strings = array(
                'admin-menu'          => esc_html__('Theme Setup', 'supplero'),

                /* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
                'title%s%s%s%s'       => esc_html__('%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'supplero'),
                'return-to-dashboard' => esc_html__('Return to the dashboard', 'supplero'),
                'ignore'              => esc_html__('Disable this wizard', 'supplero'),

                'btn-skip'                 => esc_html__('Skip', 'supplero'),
                'btn-next'                 => esc_html__('Next', 'supplero'),
                'btn-start'                => esc_html__('Start', 'supplero'),
                'btn-no'                   => esc_html__('Cancel', 'supplero'),
                'btn-plugins-install'      => esc_html__('Install', 'supplero'),
                'btn-child-install'        => esc_html__('Install', 'supplero'),
                'btn-content-install'      => esc_html__('Install', 'supplero'),
                'btn-import'               => esc_html__('Import', 'supplero'),
                'btn-license-activate'     => esc_html__('Activate', 'supplero'),
                'btn-license-skip'         => esc_html__('Later', 'supplero'),

                /* translators: Theme Name */
                'license-header%s'         => esc_html__('Activate %s', 'supplero'),
                /* translators: Theme Name */
                'license-header-success%s' => esc_html__('%s is Activated', 'supplero'),
                /* translators: Theme Name */
                'license%s'                => esc_html__('Enter your license key to enable remote updates and theme support.', 'supplero'),
                'license-label'            => esc_html__('License key', 'supplero'),
                'license-success%s'        => esc_html__('The theme is already registered, so you can go to the next step!', 'supplero'),
                'license-json-success%s'   => esc_html__('Your theme is activated! Remote updates and theme support are enabled.', 'supplero'),
                'license-tooltip'          => esc_html__('Need help?', 'supplero'),

                /* translators: Theme Name */
                'welcome-header%s'         => esc_html__('Welcome to %s', 'supplero'),
                'welcome-header-success%s' => esc_html__('Hi. Welcome back', 'supplero'),
                'welcome%s'                => esc_html__('This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'supplero'),
                'welcome-success%s'        => esc_html__('You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'supplero'),

                'child-header'         => esc_html__('Install Child Theme', 'supplero'),
                'child-header-success' => esc_html__('You\'re good to go!', 'supplero'),
                'child'                => esc_html__('Let\'s build & activate a child theme so you may easily make theme changes.', 'supplero'),
                'child-success%s'      => esc_html__('Your child theme has already been installed and is now activated, if it wasn\'t already.', 'supplero'),
                'child-action-link'    => esc_html__('Learn about child themes', 'supplero'),
                'child-json-success%s' => esc_html__('Awesome. Your child theme has already been installed and is now activated.', 'supplero'),
                'child-json-already%s' => esc_html__('Awesome. Your child theme has been created and is now activated.', 'supplero'),

                'plugins-header'         => esc_html__('Install Plugins', 'supplero'),
                'plugins-header-success' => esc_html__('You\'re up to speed!', 'supplero'),
                'plugins'                => esc_html__('Let\'s install some essential WordPress plugins to get your site up to speed.', 'supplero'),
                'plugins-success%s'      => esc_html__('The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'supplero'),
                'plugins-action-link'    => esc_html__('Advanced', 'supplero'),

                'import-header'      => esc_html__('Import Content', 'supplero'),
                'import'             => esc_html__('Let\'s import content to your website, to help you get familiar with the theme.', 'supplero'),
                'import-action-link' => esc_html__('Advanced', 'supplero'),

                'ready-header'      => esc_html__('All done. Have fun!', 'supplero'),

                /* translators: Theme Author */
                'ready%s'           => esc_html__('Your theme has been all set up. Enjoy your new theme by %s.', 'supplero'),
                'ready-action-link' => esc_html__('Extras', 'supplero'),
                'ready-big-button'  => esc_html__('View your website', 'supplero'),
                'ready-link-1'      => sprintf('<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__('Explore WordPress', 'supplero')),
                'ready-link-2'      => sprintf('<a href="%1$s" target="_blank">%2$s</a>', 'https://themebeans.com/contact/', esc_html__('Get Theme Support', 'supplero')),
                'ready-link-3'      => sprintf('<a href="%1$s">%2$s</a>', admin_url('customize.php'), esc_html__('Start Customizing', 'supplero')),
            )
        );

        add_action('widgets_init', [$this, 'widgets_init']);
    }

    public function render_child_functions_php() {
        $output
            = "<?php
/**
 * Theme functions and definitions.
 */
		 ";

        return $output;
    }

    public function widgets_init() {
        require_once get_parent_theme_file_path('/inc/merlin/includes/recent-post.php');
        register_widget('Supplero_WP_Widget_Recent_Posts');
        if (supplero_is_woocommerce_activated()) {
            require_once get_parent_theme_file_path('/inc/merlin/includes/class-wc-widget-layered-nav.php');
            register_widget('Supplero_Widget_Layered_Nav');
        }
    }

    private function setup_header_footer($id) {
        $this->reset_header_footer();
        $options = ($this->get_all_header_footer())[$id];

        foreach ($options['header'] as $header_options) {
            $header = get_page_by_path($header_options['slug'], OBJECT, 'elementor_library');
            if ($header) {
                update_post_meta($header->ID, '_elementor_conditions', $header_options['conditions']);
            }
        }

        foreach ($options['footer'] as $footer_options) {
            $footer = get_page_by_path($footer_options['slug'], OBJECT, 'elementor_library');
            if ($footer) {
                update_post_meta($footer->ID, '_elementor_conditions', $footer_options['conditions']);
            }
        }

        $cache = new ElementorPro\Modules\ThemeBuilder\Classes\Conditions_Cache();
        $cache->regenerate();
    }

    private function get_all_header_footer() {
        return [
            'home-1' => [
                'header' => [
                    [
                        'slug'       => 'headerbuilder-1',
                        'conditions' => ['include/general'],
                    ]
                ],
                'footer' => [
                    [
                        'slug'       => 'footerbuilder-1',
                        'conditions' => ['include/general'],
                    ]
                ]
            ],
            'home-2' => [
                'header' => [
                    [
                        'slug'       => 'headerbuilder-2',
                        'conditions' => ['include/general'],
                    ]
                ],
                'footer' => [
                    [
                        'slug'       => 'footerbuilder-2',
                        'conditions' => ['include/general'],
                    ]
                ]
            ],
            'home-3' => [
                'header' => [
                    [
                        'slug'       => 'headerbuilder-3',
                        'conditions' => ['include/general'],
                    ]
                ],
                'footer' => [
                    [
                        'slug'       => 'footerbuilder-1',
                        'conditions' => ['include/general'],
                    ]
                ]
            ],
            'home-4' => [
                'header' => [
                    [
                        'slug'       => 'headerbuilder-4',
                        'conditions' => ['include/general'],
                    ]
                ],
                'footer' => [
                    [
                        'slug'       => 'footerbuilder-3',
                        'conditions' => ['include/general'],
                    ]
                ]
            ],
            'home-5' => [
                'header' => [
                    [
                        'slug'       => 'headerbuilder-5',
                        'conditions' => ['include/general'],
                    ]
                ],
                'footer' => [
                    [
                        'slug'       => 'footerbuilder-1',
                        'conditions' => ['include/general'],
                    ]
                ]
            ],
            'home-6' => [
                'header' => [
                    [
                        'slug'       => 'headerbuilder-6',
                        'conditions' => ['include/general'],
                    ]
                ],
                'footer' => [
                    [
                        'slug'       => 'footerbuilder-4',
                        'conditions' => ['include/general'],
                    ]
                ]
            ],
            'home-7' => [
                'header' => [
                    [
                        'slug'       => 'headerbuilder-3',
                        'conditions' => ['include/general'],
                    ]
                ],
                'footer' => [
                    [
                        'slug'       => 'footerbuilder-1',
                        'conditions' => ['include/general'],
                    ]
                ]
            ],
        ];
    }

    private function reset_header_footer() {
        $footer_args = array(
            'post_type'      => 'elementor_library',
            'posts_per_page' => -1,
            'meta_query'     => array(
                array(
                    'key'     => '_elementor_template_type',
                    'compare' => 'IN',
                    'value'   => ['footer', 'header']
                ),
            )
        );
        $footer      = new WP_Query($footer_args);
        while ($footer->have_posts()) : $footer->the_post();
            update_post_meta(get_the_ID(), '_elementor_conditions', []);
        endwhile;
        wp_reset_postdata();
    }

    private function fixelementor() {
        $datas = json_decode(file_get_contents(get_parent_theme_file_path('dummy-data/ejson.json')), true);
        $query = new WP_Query(array(
            'post_type'      => [
                'page',
                'elementor_library',
            ],
            'posts_per_page' => -1
        ));
        while ($query->have_posts()): $query->the_post();
            global $post;
            $postid = get_the_ID();
            if (get_post_meta($post->ID, '_elementor_edit_mode', true) === 'builder') {
                $data = json_decode(get_post_meta($postid, '_elementor_data', true));
                if (!boolval($data)) {
                    if (isset($datas[$post->post_name])) {
                        update_post_meta($postid, '_elementor_data', wp_slash(wp_json_encode($datas[$post->post_name])));
                    }
                }
            }
        endwhile;
        wp_reset_postdata();
    }

    private function license_elementor_pro() {
        if (defined('ELEMENTOR_PRO_VERSION')) {
            $data = [
                'success'          => true,
                'license'          => 'valid',
                'item_id'          => false,
                'item_name'        => 'Elementor Pro',
                'is_local'         => false,
                'license_limit'    => '1000',
                'site_count'       => '1000',
                'activations_left' => 1,
                'expires'          => 'lifetime',
                'customer_email'   => 'info@wpopal.com'
            ];
            update_option('elementor_pro_license_key', 'Licence Hacked');
            ElementorPro\License\API::set_license_data($data, '+2 years');
        }
    }

    private function set_color_kit($system_colors, $id, $value) {
        foreach ($system_colors as $key => $color) {
            if ($key === $id) {
                $system_colors[$key] = $value;
            }
        }
        return $system_colors;
    }

    private function enable_breadcrumb() {
        $options  = get_option('wpseo_titles', []);
        $settings = [
            'breadcrumbs-enable' => true,
            'breadcrumbs-home'   => 'Home',
            'breadcrumbs-sep'    => '<i class="supplero-icon-angle-right"></i>',
        ];
        $settings = wp_parse_args($settings, $options);
        update_option('wpseo_titles', $settings);
    }

    public function get_all_options(){
            $options = [];
            $options['elementor'] = json_decode('{"system_colors":[{"_id":"primary","title":"Primary","color":"#f2cb1f"},{"_id":"primary_hover","title":"Primary Hover","color":"#c7a21e"},{"_id":"secondary","title":"Secondary","color":"#DA5454"},{"_id":"secondary_hover","title":"Secondary Hover","color":"#D43B3B"},{"_id":"text","title":"Text","color":"#666666"},{"_id":"accent","title":"Heading","color":"#000000"},{"_id":"lighter","title":"Lighter","color":"#999999"},{"_id":"border","title":"Border","color":"#E8E8E9"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom"},{"_id":"secondary","title":"Secondary","typography_typography":"custom"},{"_id":"text","title":"Text","typography_typography":"custom"},{"_id":"accent","title":"Accent","typography_typography":"custom"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"supplero","site_description":"Just another WordPress site","page_title_selector":"h1.entry-title","activeItemIndex":1,"body_background_background":"classic","body_background_color":"#F7F7F7","container_width":{"unit":"px","size":1290,"sizes":[]},"space_between_widgets":{"unit":"px","size":0,"sizes":[]},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":12,"sizes":[]},"button_typography_font_weight":"700","button_typography_text_transform":"uppercase","button_border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_hover_text_color":"#FFFFFF","__globals__":{"button_background_color":"globals/colors?id=primary","button_text_color":"globals/colors?id=accent","button_hover_background_color":"globals/colors?id=primary_hover"},"button_padding":{"unit":"px","top":"17","right":"33","bottom":"17","left":"33","isLinked":false},"button_typography_line_height":{"unit":"em","size":1.8,"sizes":[]}}', true);
            return $options;
        }

    public function set_demo_menus() {
        $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

        set_theme_mod(
            'nav_menu_locations',
            array(
                'primary'  => $main_menu->term_id,
                'handheld' => $main_menu->term_id,
            )
        );
    }

    private function get_data_elementor(){
        return json_decode('{"description_product":[{"id":"f9d38cc","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"aaa5037","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"2ec65a6","elType":"widget","settings":{"editor":"<p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\/p><p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui.<\/p>","_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"6919d20","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"4d94922","elType":"column","settings":{"_column_size":50,"_inline_size":55.7522000000000019781509763561189174652099609375,"_inline_size_tablet":100,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/H7-video-1.png","id":4605},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"hide_mobile":"hidden-phone"},"elements":[{"id":"820a4af","elType":"widget","settings":{"space":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"0d2c545","elType":"column","settings":{"_column_size":50,"_inline_size":44.24799999999999755573298898525536060333251953125,"_inline_size_tablet":100,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"20d6484","elType":"widget","settings":{"title":"Product Features","header_size":"h4","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"a599b3c","elType":"widget","settings":{"title":"01. <span style=\"font-weight:500; color:#000;\">super light<\/span>","header_size":"h5","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"7834af2","elType":"widget","settings":{"editor":"Excepteur sint occaecat cupidatat non proident.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore. et dolore magna aliqua. ","_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"894b5c1","elType":"widget","settings":{"title":"02. <span style=\"font-weight:500; color:#000;\">PRECISION<\/span>","header_size":"h5","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"ba05d8b","elType":"widget","settings":{"editor":"Excepteur sint occaecat cupidatat non proident.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore. et dolore magna aliqua. ","_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"972bd80","elType":"widget","settings":{"title":"02. <span style=\"font-weight:500; color:#000;\">Smooth<\/span>","header_size":"h5","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"4538747","elType":"widget","settings":{"editor":"Excepteur sint occaecat cupidatat non proident.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore. et dolore magna aliqua. "},"elements":[],"widgetType":"text-editor"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false}],"megamenu6649":[{"id":"42ea3a6","elType":"section","settings":{"gap":"no","structure":"20","background_background":"classic","background_color":"#2C3238","padding":{"unit":"px","top":"40","right":"40","bottom":"40","left":"40","isLinked":true},"content_width":{"unit":"px","size":1290,"sizes":[]},"stretch_section":"section-stretched","html_tag":"div"},"elements":[{"id":"3ba802b","elType":"column","settings":{"_column_size":50,"_inline_size":63.81000000000000227373675443232059478759765625,"space_between_widgets":0},"elements":[{"id":"950cd3d","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"97ab187","elType":"column","settings":{"_column_size":33,"_inline_size":34.2105600000000009686118573881685733795166015625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9a1cd73","elType":"widget","settings":{"title":"Energy & Endurance","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"a362ff5","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"55d4bed","elType":"widget","settings":{"icon_list":[{"text":"Sports drinks","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Gels","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Energy bars","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Cereals","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Caffeine","selected_icon":{"value":"","library":""},"_id":"6c0e180","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"4c7b237","elType":"column","settings":{"_column_size":33,"_inline_size":32.89470000000000027284841053187847137451171875,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"5772bc9","elType":"widget","settings":{"title":"Power & Muscle","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"eda0afe","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"3155c31","elType":"widget","settings":{"icon_list":[{"text":"Whey Protein","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Multi component Protein","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Casein (night protein)","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Vegan ","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"6a0c696","elType":"column","settings":{"_column_size":33,"_inline_size":32.409999999999996589394868351519107818603515625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d617df1","elType":"widget","settings":{"title":"Regeneration ","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"1266335","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"6976d55","elType":"widget","settings":{"icon_list":[{"text":"Shakes\/Powder","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Ready-to-drink","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Regeneration bars","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Supplements ","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true},{"id":"6594e43","elType":"section","settings":{"gap":"no","structure":"30","html_tag":"div"},"elements":[{"id":"637d4cd","elType":"column","settings":{"_column_size":33,"_inline_size":34.2105600000000009686118573881685733795166015625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f74225e","elType":"widget","settings":{"title":"Performance-Optimiser ","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"5e95559","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"800f945","elType":"widget","settings":{"icon_list":[{"text":"Carboloading","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Salt loss","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Muscle acidosis","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Bloodflow","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Ultra\/Expedition ","selected_icon":{"value":"","library":""},"_id":"6c0e180","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"9122709","elType":"column","settings":{"_column_size":33,"_inline_size":32.89470000000000027284841053187847137451171875,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9e88931","elType":"widget","settings":{"title":"Creatine ","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"f0ba0bf","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"c76e8f5","elType":"widget","settings":{"icon_list":[{"text":"BCAA","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Hydrolysate\/Peptides","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Essential","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Glutamine","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Beta-alanine ","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"401c5ce"}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"15f95c4","elType":"column","settings":{"_column_size":33,"_inline_size":32.409999999999996589394868351519107818603515625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"e01be46","elType":"widget","settings":{"title":"Figure & Shape","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"4430d96","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"2899711","elType":"widget","settings":{"icon_list":[{"text":"Zero sports drinks","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Bars\/Snacks","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Drinks (ready to go) ","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"22723c9","elType":"column","settings":{"_column_size":50,"_inline_size":36.18999999999999772626324556767940521240234375,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/banner_magamenu.jpg","id":5693},"background_position":"center center","align":"center","background_size":"cover","padding":{"unit":"px","top":"50","right":"50","bottom":"0","left":"50","isLinked":false},"custom_css":"selector {\n    overflow: hidden;\n}"},"elements":[{"id":"d3ca0db","elType":"widget","settings":{"editor":"New in","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"d463de4","elType":"widget","settings":{"title":"Truth In <br> Every Bottle","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align":"center"},"elements":[],"widgetType":"heading"},{"id":"8c253f1","elType":"widget","settings":{"editor":"10% Off first order","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":2,"__globals__":{"text_color":""},"align":"center","text_color":"#CA6C62"},"elements":[],"widgetType":"text-editor"},{"id":"deb1c50","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_z_index":2,"size":"xs","button_text_color":"#FFFFFF","background_color":"#FFFFFF33","align":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"},{"id":"f88b555","elType":"widget","settings":{"space":{"unit":"px","size":190,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"a97ff91","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/img_megamenu.png","id":5752},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":475,"sizes":[]},"_position":"absolute","_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":-55,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false}],"banner-shop":[{"id":"f9647ac","elType":"section","settings":{"gap":"narrow","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/banner_shop-1.jpg","id":6069},"background_position":"center center","background_position_tablet":"center right","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_devices":["desktop","tablet"],"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"padding":{"unit":"px","top":"40","right":"30","bottom":"40","left":"135","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"40","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"e253deb","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"46784c9","elType":"widget","settings":{"editor":"<div>quality supplements<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"8","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#2D3EBE","_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"46439c1","elType":"widget","settings":{"title":"Support your <br>\nworkout","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":35,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":5,"vertical":0,"blur":10,"color":"rgba(0,0,0,0.3)"},"_margin":{"unit":"px","top":"10","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"bd4a1d7","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":5,"vertical":0,"blur":10,"color":"rgba(0,0,0,0.3)"},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","button_box_shadow_box_shadow_type":"yes","button_box_shadow_box_shadow":{"horizontal":0,"vertical":5,"blur":10,"spread":0,"color":"rgba(0, 0, 0, 0.3)"},"text_padding":{"unit":"px","top":"8","right":"15","bottom":"8","left":"15","isLinked":false},"icon_button_size":{"unit":"px","size":8,"sizes":[]},"__globals__":{"style_button_hover_background":"globals\/colors?id=primary_hover"}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"megamenu1508":[{"id":"b23973b","elType":"section","settings":{"gap":"no","structure":"20","background_background":"classic","background_color":"#2C3238","padding":{"unit":"px","top":"40","right":"40","bottom":"40","left":"40","isLinked":true},"content_width":{"unit":"px","size":1290,"sizes":[]},"stretch_section":"section-stretched","html_tag":"div"},"elements":[{"id":"2615266","elType":"column","settings":{"_column_size":50,"_inline_size":63.81000000000000227373675443232059478759765625,"space_between_widgets":0},"elements":[{"id":"65ced86","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"9c9a3db","elType":"column","settings":{"_column_size":33,"_inline_size":34.2105600000000009686118573881685733795166015625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"7864d07","elType":"widget","settings":{"title":"Shop Layouts","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"43eaa8e","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"6bfa3b9","elType":"widget","settings":{"icon_list":[{"text":"Shop - Fullwidth","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/?woocommerce_archive_layout=canvas&woocommerce_catalog_columns=4","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop - Left Sidebar","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop - Right Sidebar","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/?woocommerce_archive_sidebar=right","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop - Category Banner","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/creatine\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop - Listview","selected_icon":{"value":"","library":""},"_id":"6c0e180","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/?layout=list","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"2e6ee4f","elType":"column","settings":{"_column_size":33,"_inline_size":32.89470000000000027284841053187847137451171875,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"e4f4f8a","elType":"widget","settings":{"title":"Power & Muscle","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"481c6bd","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"47322c9","elType":"widget","settings":{"icon_list":[{"text":"Whey Protein","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Multi component Protein","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Casein (night protein)","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Vegan ","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"fb7be61","elType":"column","settings":{"_column_size":33,"_inline_size":32.409999999999996589394868351519107818603515625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f17dc42","elType":"widget","settings":{"title":"Regeneration ","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"9c48d49","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"9e12e8a","elType":"widget","settings":{"icon_list":[{"text":"Shakes\/Powder","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Ready-to-drink","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Regeneration bars","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Supplements ","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true},{"id":"a2a392a","elType":"section","settings":{"gap":"no","structure":"30","html_tag":"div"},"elements":[{"id":"15e297e","elType":"column","settings":{"_column_size":33,"_inline_size":34.2105600000000009686118573881685733795166015625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3eb1d51","elType":"widget","settings":{"title":"Performance-Optimiser ","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"13377a7","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"a55bd91","elType":"widget","settings":{"icon_list":[{"text":"Carboloading","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Salt loss","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Muscle acidosis","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Bloodflow","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Ultra\/Expedition ","selected_icon":{"value":"","library":""},"_id":"6c0e180","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"1fa0915","elType":"column","settings":{"_column_size":33,"_inline_size":32.89470000000000027284841053187847137451171875,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f796809","elType":"widget","settings":{"title":"Creatine ","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"a369f29","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"5f8f321","elType":"widget","settings":{"icon_list":[{"text":"BCAA","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Hydrolysate\/Peptides","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Essential","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Glutamine","selected_icon":{"value":"","library":""},"_id":"77975a6","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Beta-alanine ","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"401c5ce"}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"a9fd1ca","elType":"column","settings":{"_column_size":33,"_inline_size":32.409999999999996589394868351519107818603515625,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"1ac355d","elType":"widget","settings":{"title":"Figure & Shape","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"da7862d","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"61d7314","elType":"widget","settings":{"icon_list":[{"text":"Zero sports drinks","selected_icon":{"value":"","library":""},"_id":"fafa797","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Bars\/Snacks","selected_icon":{"value":"","library":""},"_id":"c638e8b","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Drinks (ready to go) ","selected_icon":{"value":"","library":""},"_id":"1a65db5","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"space_between":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"a0cbc88","elType":"column","settings":{"_column_size":50,"_inline_size":36.18999999999999772626324556767940521240234375,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/banner_magamenu.jpg","id":5693},"background_position":"center center","align":"center","background_size":"cover","padding":{"unit":"px","top":"50","right":"50","bottom":"0","left":"50","isLinked":false},"custom_css":"selector {\n    overflow: hidden;\n}"},"elements":[{"id":"71d84ef","elType":"widget","settings":{"editor":"New in","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"7a10e14","elType":"widget","settings":{"title":"Truth In <br> Every Bottle","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align":"center"},"elements":[],"widgetType":"heading"},{"id":"8a7543a","elType":"widget","settings":{"editor":"10% Off first order","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":2,"__globals__":{"text_color":""},"align":"center","text_color":"#CA6C62"},"elements":[],"widgetType":"text-editor"},{"id":"6e4ae0e","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_z_index":2,"size":"xs","button_text_color":"#FFFFFF","background_color":"#FFFFFF33","align":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"},{"id":"a8324dd","elType":"widget","settings":{"space":{"unit":"px","size":190,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"b7f6481","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/img_megamenu.png","id":5752},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":475,"sizes":[]},"_position":"absolute","_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":-55,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false}],"megamenu2813":[{"id":"b7cde61","elType":"section","settings":{"gap":"no","structure":"40","background_background":"classic","background_color":"#2C3238","padding":{"unit":"px","top":"40","right":"40","bottom":"40","left":"40","isLinked":true},"html_tag":"div"},"elements":[{"id":"08b0e1c","elType":"column","settings":{"_column_size":25,"_inline_size":21.4876000000000004774847184307873249053955078125,"space_between_widgets":0},"elements":[{"id":"bd14d86","elType":"widget","settings":{"title":"Energy & Endurance","header_size":"h4","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"c91883b","elType":"widget","settings":{"text":"Divider","color":"#424A54"},"elements":[],"widgetType":"divider"},{"id":"8f06ddf","elType":"widget","settings":{"icon_list":[{"text":"Sports drinks","selected_icon":{"value":"","library":""},"_id":"fafa797"},{"text":"Gels","selected_icon":{"value":"","library":""},"_id":"c638e8b"},{"text":"Energy bars","selected_icon":{"value":"","library":""},"_id":"1a65db5"},{"text":"Cereals","selected_icon":{"value":"","library":""},"_id":"77975a6"},{"text":"Caffeine","selected_icon":{"value":"","library":""},"_id":"6c0e180"}],"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"fec5da9","elType":"column","settings":{"_column_size":25,"_inline_size":28.51200000000000045474735088646411895751953125,"space_between_widgets":0},"elements":[],"isInner":false},{"id":"5e83353","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0},"elements":[],"isInner":false},{"id":"6bf2a14","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0},"elements":[],"isInner":false}],"isInner":false}],"breadcrumb":[{"id":"764f1c8","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":260,"sizes":[]},"stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/breadcrumb.jpg","id":5421},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_color":"#000000","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"padding":{"unit":"px","top":"20","right":"30","bottom":"20","left":"30","isLinked":false},"css_classes":"supplero-breadcrumb-build","custom_height_mobile":{"unit":"px","size":200,"sizes":[]},"padding_mobile":{"unit":"px","top":"20","right":"15","bottom":"20","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"81438ae","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"06e9bbe","elType":"widget","settings":{"title":"Blog","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"ae36805","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"theme-page-title"},{"id":"9f47266","elType":"widget","settings":{"align":"center","typography_link_typography":"custom","typography_link_font_size":{"unit":"px","size":14,"sizes":[]},"breadcrumb_last_text":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"link_color":"#9FAAA7","__globals__":{"link_hover_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"breadcrumbs"}],"isInner":false}],"isInner":false}],"landingpage":[{"id":"30b9fe8","elType":"section","settings":{"gap":"no","content_position":"middle","stretch_section":"section-stretched","structure":"30","margin":{"unit":"px","top":"20","right":0,"bottom":"20","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"53ffb11","elType":"column","settings":{"_column_size":33,"_inline_size":40,"_inline_size_tablet":100,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"hide_mobile":"hidden-phone"},"elements":[{"id":"579434f","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"demos ","selected_icon":{"value":"","library":""},"_id":"b0ecd4a","link":{"url":"#demos ","is_external":"","nofollow":"","custom_attributes":""}},{"text":"features","selected_icon":{"value":"","library":""},"link":{"url":"#features","is_external":"","nofollow":"","custom_attributes":""},"_id":"3a9acb2"},{"text":"support","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e32a00a"}],"space_between":{"unit":"px","size":40,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"700","icon_typography_text_transform":"uppercase","hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","__globals__":{"text_color":"globals\/colors?id=accent","text_color_hover":"globals\/colors?id=primary"}},"elements":[],"widgetType":"icon-list"},{"id":"9354906","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo_2.svg","id":3412},"image_size":"full","width":{"unit":"px","size":130,"sizes":[]},"hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"b739104","elType":"column","settings":{"_column_size":33,"_inline_size":20,"_inline_size_tablet":50,"_inline_size_mobile":44,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"7","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"0f096da","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo_2.svg","id":3412},"image_size":"full","align_mobile":"left","width":{"unit":"px","size":130,"sizes":[]},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image"},{"id":"666e4e8","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"demos ","selected_icon":{"value":"","library":""},"_id":"b0ecd4a","link":{"url":"#demos ","is_external":"","nofollow":"","custom_attributes":""}},{"text":"features","selected_icon":{"value":"","library":""},"link":{"url":"#features","is_external":"","nofollow":"","custom_attributes":""},"_id":"3a9acb2"},{"text":"support","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e32a00a"}],"space_between":{"unit":"px","size":40,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"700","icon_typography_text_transform":"uppercase","hide_desktop":"hidden-desktop","hide_mobile":"hidden-phone","__globals__":{"text_color":"globals\/colors?id=accent","text_color_hover":"globals\/colors?id=primary"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"0ec192b","elType":"column","settings":{"_column_size":33,"_inline_size":39.6640000000000014779288903810083866119384765625,"_inline_size_tablet":50,"_inline_size_mobile":56,"space_between_widgets":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"7","isLinked":false}},"elements":[{"id":"a12e4fd","elType":"widget","settings":{"text":"buy theme now","align":"right","size":"xs","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"ed7503c","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"341a997","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_bg-1.jpg","id":4714},"background_position":"center center","background_size":"cover","background_overlay_background":"classic","background_overlay_color":"#8A0006","background_overlay_position":"center center","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"overlay_blend_mode":"multiply","padding":{"unit":"px","top":"150","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector {\n    overflow: hidden;\n}","padding_tablet":{"unit":"px","top":"80","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"dd9fdd2","elType":"section","settings":{"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":530,"sizes":[]},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"custom_height_inner_mobile":{"unit":"px","size":630,"sizes":[]},"background_background":"classic","html_tag":"div"},"elements":[{"id":"ba23f48","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"z_index":5,"_inline_size_tablet":53,"align_mobile":"center"},"elements":[{"id":"b308a05","elType":"widget","settings":{"title":"introducing","header_size":"span","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"8","bottom":"0","left":"8","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#DD3F37","_element_width":"auto","__globals__":{"_background_color":""}},"elements":[],"widgetType":"heading"},{"id":"bb1d582","elType":"widget","settings":{"space":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"b8b83f4","elType":"widget","settings":{"title":"Supplements Store WooCommerce Theme","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":70,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_element_custom_width":{"unit":"px","size":855,"sizes":[]},"_element_custom_width_tablet":{"unit":"px","size":390,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"text_shadow_text_shadow_type":"yes","typography_line_height_tablet":{"unit":"px","size":48,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":40,"sizes":[]},"text_shadow_text_shadow":{"horizontal":3,"vertical":0,"blur":5,"color":"rgba(0, 0, 0, 0.5)"},"_element_width":"initial","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":350,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"6ba91a8","elType":"widget","settings":{"text":"View Demo","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"background_color":"#FFFFFF","align_mobile":"center","button_box_shadow_box_shadow_type":"yes","_z_index":2,"__globals__":{"style_button_hover_background":"globals\/colors?id=primary"}},"elements":[],"widgetType":"button"},{"id":"2c89fe3","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_img-1.png","id":4775},"image_size":"full","align":"left","_position":"absolute","_offset_x":{"unit":"px","size":-295,"sizes":[]},"_offset_orientation_v":"end","width_tablet":{"unit":"px","size":200,"sizes":[]},"motion_fx_motion_fx_scrolling":"yes","motion_fx_scale_effect":"yes","motion_fx_scale_speed":{"unit":"px","size":1,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_offset_x_tablet":{"unit":"px","size":-30,"sizes":[]},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","_animation":"opal-scale-up","animation_duration":"fast"},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true},{"id":"6d2aa8d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_img-3.png","id":4805},"image_size":"full","align":"right","_position":"absolute","_offset_orientation_h":"end","_offset_orientation_v":"end","width_tablet":{"unit":"px","size":420,"sizes":[]},"motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_direction":"negative","motion_fx_translateX_speed":{"unit":"px","size":0.5,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_offset_x_end":{"unit":"px","size":-10,"sizes":[]},"_animation":"opal-move-left","animation_duration":"fast"},"elements":[],"widgetType":"image"},{"id":"dc71809","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_img-2.png","id":4804},"image_size":"full","align":"right","_position":"absolute","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":165,"sizes":[]},"_offset_orientation_v":"end","width_tablet":{"unit":"px","size":475,"sizes":[]},"motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_speed":{"unit":"px","size":0.5,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_offset_x":{"unit":"px","size":-143,"sizes":[]},"_animation":"opal-move-right","animation_duration":"fast"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"1551b5b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"45","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"4188eb8","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"3592d4f","elType":"widget","settings":{"title":"7","typography_typography":"custom","typography_font_size":{"unit":"px","size":120,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":100,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":80,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","_element_vertical_align":"center","__globals__":{"title_color":"globals\/colors?id=secondary"}},"elements":[],"widgetType":"heading"},{"id":"c8fc8b9","elType":"widget","settings":{"title":"Pre-Built<br> Demos","typography_typography":"custom","typography_font_size":{"unit":"px","size":50,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":42,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":36,"sizes":[]},"_element_width":"auto","_element_vertical_align":"center","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"deee6bb","elType":"section","settings":{"content_width":{"unit":"px","size":1860,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_element_id":"demos ","html_tag":"div"},"elements":[{"id":"0671ac8","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"7617302","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_home-1.jpg","id":4962},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-1\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"a5e47b1","elType":"widget","settings":{"text":"Home 01","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-1\/","is_external":"on","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":14,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#DD3F37","text_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_css_classes":"supplero-box-clip-sm","_element_width":"auto","__globals__":{"background_color":""}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"cee676a","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"2e11870","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_home-2.jpg","id":5043},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-2\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"2e5ca19","elType":"widget","settings":{"text":"Home 02","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-2\/","is_external":"on","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":14,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#DD3F37","text_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_css_classes":"supplero-box-clip-sm","_element_width":"auto","__globals__":{"background_color":""}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"ccf3acf","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"c23731c","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_home-3.jpg","id":5044},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-3\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"fdd27be","elType":"widget","settings":{"text":"Home 03","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-3\/","is_external":"on","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":14,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#DD3F37","text_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_css_classes":"supplero-box-clip-sm","_element_width":"auto","__globals__":{"background_color":""}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"0e606b4","elType":"section","settings":{"content_width":{"unit":"px","size":1860,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"c6a41ca","elType":"column","settings":{"_column_size":50,"_inline_size":33.3299999999999982946974341757595539093017578125,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"60620b5","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_home-4.jpg","id":5045},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-4\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"86c6b84","elType":"widget","settings":{"text":"Home 04","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-4\/","is_external":"on","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":14,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#DD3F37","text_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_css_classes":"supplero-box-clip-sm","_element_width":"auto","__globals__":{"background_color":""}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"2a6e7aa","elType":"column","settings":{"_column_size":50,"_inline_size":66.6700000000000017053025658242404460906982421875,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d1c6a54","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_home-5.jpg","id":5046},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-5\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"5fe10b4","elType":"widget","settings":{"text":"Home 05","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-5\/","is_external":"on","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":14,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#DD3F37","text_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_css_classes":"supplero-box-clip-sm","_element_width":"auto","__globals__":{"background_color":""}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"52f3220","elType":"section","settings":{"content_width":{"unit":"px","size":1860,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"057afaf","elType":"column","settings":{"_column_size":50,"_inline_size":66.6700000000000017053025658242404460906982421875,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"f1fba8d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_home-6.jpg","id":5047},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-6\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"621f892","elType":"widget","settings":{"text":"Home 06","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-6\/","is_external":"on","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":14,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#DD3F37","text_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_css_classes":"supplero-box-clip-sm","_element_width":"auto","__globals__":{"background_color":""}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"4217ee2","elType":"column","settings":{"_column_size":50,"_inline_size":33.3299999999999982946974341757595539093017578125,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"e43f99e","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_home-7.jpg","id":5048},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-7\/","is_external":"on","nofollow":"","custom_attributes":""},"hover_animation":"float","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"9e463e7","elType":"widget","settings":{"text":"Home 07","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/home-7\/","is_external":"on","nofollow":"","custom_attributes":""},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":14,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#DD3F37","text_padding":{"unit":"px","top":"5","right":"20","bottom":"5","left":"20","isLinked":false},"_css_classes":"supplero-box-clip-sm","_element_width":"auto","__globals__":{"background_color":""}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"6c3ae7f","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":900,"sizes":[]},"stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_bg-2.png","id":5110},"background_position":"bottom left","background_repeat":"no-repeat","background_overlay_background":"classic","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"custom_height_tablet":{"unit":"px","size":8,"sizes":[]},"background_ypos":{"unit":"%","size":60,"sizes":[]},"background_size_tablet":"initial","background_bg_width_tablet":{"unit":"px","size":0,"sizes":[]},"margin":{"unit":"px","top":"0","right":0,"bottom":"100","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"80","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"_element_id":"features","html_tag":"div"},"elements":[{"id":"d1daf85","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","align":"center","space_between_widgets":0},"elements":[{"id":"fbfc4a3","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_img-6.png","id":5205},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":1624,"sizes":[]},"_position":"absolute","_offset_x":{"size":-29,"unit":"px"},"_offset_y":{"unit":"px","size":-50,"sizes":[]},"width_tablet":{"unit":"px","size":1400,"sizes":[]},"_z_index":2,"motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_speed":{"unit":"px","size":1,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_offset_x_tablet":{"unit":"px","size":-44,"sizes":[]},"_offset_orientation_v":"end","_offset_y_end":{"size":-123,"unit":"px"},"_offset_y_end_tablet":{"unit":"px","size":-38,"sizes":[]},"hide_mobile":"hidden-phone","_animation":"opal-scale-up","animation_duration":"fast"},"elements":[],"widgetType":"image"},{"id":"7eeafbe","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_img-7.png","id":5342},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":1624,"sizes":[]},"_position":"absolute","_offset_x":{"unit":"px","size":-550,"sizes":[]},"_offset_y":{"unit":"px","size":-50,"sizes":[]},"width_tablet":{"unit":"px","size":830,"sizes":[]},"_z_index":2,"motion_fx_motion_fx_scrolling":"yes","motion_fx_translateX_effect":"yes","motion_fx_translateX_direction":"negative","motion_fx_translateX_speed":{"unit":"px","size":1,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_offset_x_tablet":{"unit":"px","size":-478,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":-11,"sizes":[]},"_offset_y_end":{"unit":"px","size":-123,"sizes":[]},"hide_mobile":"hidden-phone","_animation":"opal-scale-up","animation_duration":"fast","_animation_delay":100},"elements":[],"widgetType":"image"},{"id":"bdbdd3b","elType":"widget","settings":{"space":{"unit":"px","size":200,"sizes":[]},"space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"27a017d","elType":"section","settings":{"content_width":{"unit":"px","size":1070,"sizes":[]},"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"b2d7707","elType":"column","settings":{"_column_size":50,"_inline_size":43,"space_between_widgets":0,"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"96b5d22","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_woo.png","id":5121},"image_size":"full","align":"left","_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"9088508","elType":"widget","settings":{"title":"Build exactly the eCommerce website you want","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"text_shadow_text_shadow_type":"yes","text_shadow_text_shadow":{"horizontal":1,"vertical":0,"blur":5,"color":"rgba(255, 255, 255, 0.3)"},"_element_width":"initial","_element_custom_width":{"unit":"px","size":420,"sizes":[]},"align_mobile":"center","_z_index":3},"elements":[],"widgetType":"heading"},{"id":"6325a44","elType":"widget","settings":{"space":{"unit":"px","size":30,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"c76495f","elType":"widget","settings":{"editor":"Start selling anything. WooCommerce is fully customizable and full of functionalities to set up a new store in minutes.","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":1,"vertical":0,"blur":5,"color":"rgba(255, 255, 255, 0.3)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_z_index":3},"elements":[],"widgetType":"text-editor"},{"id":"0e08556","elType":"widget","settings":{"text":"View Shop Page","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"button_text_color":"#FFFFFF","__globals__":{"background_color":"globals\/colors?id=accent","button_background_hover_color":"","style_button_hover_background":"globals\/colors?id=primary"},"align_mobile":"center","_z_index":4,"background_color":"#000000","style_button_hover_background":"#f2cb1f"},"elements":[],"widgetType":"button"},{"id":"5654708","elType":"widget","settings":{"space":{"unit":"px","size":190,"sizes":[]},"space_tablet":{"unit":"px","size":150,"sizes":[]},"space_mobile":{"unit":"px","size":105,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"aa17021","elType":"column","settings":{"_column_size":50,"_inline_size":57,"content_position":"bottom","space_between_widgets":0},"elements":[{"id":"1bad416","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_img-4.png","id":5196},"image_size":"full","align":"left","_z_index":2,"align_mobile":"center","width_tablet":{"unit":"px","size":360,"sizes":[]},"width_mobile":{"unit":"px","size":280,"sizes":[]},"_animation":"opal-scale-up","animation_duration":"fast"},"elements":[],"widgetType":"image"},{"id":"b9d0626","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/ldp_img-5.png","id":5197},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":928,"sizes":[]},"_position":"absolute","_offset_orientation_v":"end","_offset_y_end":{"unit":"px","size":60,"sizes":[]},"width_tablet":{"unit":"px","size":800,"sizes":[]},"width_mobile":{"unit":"px","size":480,"sizes":[]},"_offset_x":{"unit":"px","size":177,"sizes":[]},"_offset_x_tablet":{"unit":"px","size":-80,"sizes":[]},"_offset_x_mobile":{"unit":"px","size":-228,"sizes":[]},"_animation":"opal-move-left","animation_duration":"fast"},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"d9fae8c","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"90","right":"30","bottom":"90","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"15","bottom":"60","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"84ed7a9","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0},"elements":[{"id":"e1c1684","elType":"widget","settings":{"title":"Make nutrition easy with <a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/\" style=\"color:#f3ca20;\"> Supplero <\/a> Theme","align":"center","align_mobile":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":"","sizes":[]},"text_shadow_text_shadow":{"horizontal":1,"vertical":0,"blur":5,"color":"rgba(255, 255, 255, 0.3)"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_z_index":3,"_element_custom_width":{"unit":"px","size":420,"sizes":[]},"__globals__":{"title_color":""},"_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"heading"},{"id":"3240b27","elType":"widget","settings":{"text":"Purchase Theme","_margin":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"_element_width":"auto","_animation":"opal-move-right","animation_duration":"fast"},"elements":[],"widgetType":"button"},{"id":"7fb048a","elType":"widget","settings":{"text":"Live Demo","link":{"url":"#demos","is_external":"","nofollow":"","custom_attributes":""},"background_color":"#FFFFFF","_margin":{"unit":"px","top":"5","right":"5","bottom":"5","left":"5","isLinked":true},"_element_width":"auto","_animation":"opal-move-left","animation_duration":"fast"},"elements":[],"widgetType":"button"},{"id":"f9abe82","elType":"widget","settings":{"editor":"Copyright \u00a9 2021 <a style=\"color: #fff; font-weight: bold;\" href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/\"> Supplero <\/a>. Designed by <span style=\"color: #fff; font-weight: bold;\">OpalThemes.<\/span>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"_margin":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"text_color":""},"text_color":"#FFFFFF70","_animation":"opal-move-up","animation_duration":"fast"},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false}],"headerbuilder-6":[{"id":"47611f47","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","height":"min-height","custom_height":{"unit":"px","size":48,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"2e8ebcc2","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"326d7ce","elType":"widget","settings":{"editor":"<div>Free standard shipping for orders <a href=\"#\">over $340.<\/a><\/div>","__globals__":{"text_color":"globals\/colors?id=lighter","text_color_link":"globals\/colors?id=accent"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"7cd4c5c1","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"628df3e0","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"Find a Retailer","selected_icon":{"value":"","library":""},"_id":"9df4c95","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Customer Services","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"_id":"924d330","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e06d8b8"}],"icon_align":"right","icon_size":{"unit":"px","size":3,"sizes":[]},"text_indent":{"unit":"px","size":13,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=lighter","icon_color":"globals\/colors?id=lighter"},"icon_height":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"65d4f7b5","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":80,"sizes":[]},"stretch_section":"section-stretched","structure":"33","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"content_width":{"unit":"px","size":1800,"sizes":[]},"html_tag":"div"},"elements":[{"id":"261783d7","elType":"column","settings":{"_column_size":25,"_inline_size":27,"content_position":"center","align_tablet":"space-between","space_between_widgets":0},"elements":[{"id":"48e3bc7","elType":"widget","settings":{"icon_menu_size":{"unit":"px","size":16,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"supplero-vertical-menu"},{"id":"d1f64be","elType":"widget","settings":{"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/","is_external":"","nofollow":"","custom_attributes":""},"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo_2.svg","id":3412},"width":{"unit":"px","size":120,"sizes":[]},"_css_classes":"logo","_element_width":"auto"},"elements":[],"widgetType":"image"},{"id":"6de77067","elType":"widget","settings":{"show_cart":"yes","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false},{"id":"40d3de75","elType":"column","settings":{"_column_size":50,"_inline_size":46,"space_between_widgets":0,"hide_mobile":"hidden-phone","content_position":"center","align":"center"},"elements":[{"id":"b90ec2c","elType":"widget","settings":{"border_width":{"unit":"px","size":2,"sizes":[]},"background_form":"#FFFFFF","_element_width":"initial","_element_custom_width":{"unit":"px","size":630,"sizes":[]}},"elements":[],"widgetType":"supplero-search"}],"isInner":false},{"id":"2e89bdf8","elType":"column","settings":{"_column_size":25,"_inline_size":27,"content_position":"center","align":"flex-end","space_between_widgets":0,"hide_mobile":"hidden-phone"},"elements":[{"id":"31daef9a","elType":"widget","settings":{"show_divider":"yes","show_account":"yes","show_wishlist":"yes","show_cart":"yes","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"_element_width":"auto","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"20","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"_padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_border_width_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"border_width_tablet":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false}],"isInner":false},{"id":"3eb773f6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_mobile":"hidden-phone","content_width":{"unit":"px","size":1800,"sizes":[]},"html_tag":"div"},"elements":[{"id":"3a4484c8","elType":"column","settings":{"_column_size":50,"_inline_size":70,"content_position":"center","space_between_widgets":0,"background_color":"#1C2127"},"elements":[{"id":"21f0e204","elType":"widget","settings":{"menu_title_color":"#FFFFFF","__globals__":{"menu_title_color_action":"globals\/colors?id=primary"},"nav_menu_aligrment":"left"},"elements":[],"widgetType":"supplero-nav-menu"}],"isInner":false},{"id":"7cda65e4","elType":"column","settings":{"_column_size":50,"_inline_size":30,"content_position":"center","space_between_widgets":0,"background_color":"#1C2127","align":"flex-end","padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4467fb3e","elType":"widget","settings":{"icon_list":[{"text":"Ask our experts:","selected_icon":{"value":"fas fa-phone-alt","library":"fa-solid"},"_id":"4a4888c"}],"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_size_tablet":{"unit":"px","size":0,"sizes":[]},"text_indent":{"unit":"px","size":5,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"5","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-5","isLinked":false},"_element_width":"auto","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]},"__globals__":{"text_color":""},"text_color":"#FFFFFF","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"icon-list"},{"id":"35f68a6a","elType":"widget","settings":{"editor":"<div><a href=\"tel:1-888-333-5226\">1-888-333-5226<\/a><\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"700","_element_width":"auto","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]},"__globals__":{"text_color_link":"globals\/colors?id=primary"},"align_tablet":"right"},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false}],"headerbuilder-5":[{"id":"8ce9f89","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","height":"min-height","custom_height":{"unit":"px","size":48,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"328b29f","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"3093611","elType":"widget","settings":{"editor":"<div>Free standard shipping for orders <a href=\"#\">over $340.<\/a><\/div>","__globals__":{"text_color":"globals\/colors?id=lighter","text_color_link":"globals\/colors?id=accent"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"9096d52","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"f88acab","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"Find a Retailer","selected_icon":{"value":"","library":""},"_id":"9df4c95","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Customer Services","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"_id":"924d330","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e06d8b8"}],"icon_align":"right","icon_size":{"unit":"px","size":3,"sizes":[]},"text_indent":{"unit":"px","size":13,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=lighter","icon_color":"globals\/colors?id=lighter"},"icon_height":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"e65858a","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":80,"sizes":[]},"stretch_section":"section-stretched","structure":"33","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"content_width":{"unit":"px","size":1800,"sizes":[]},"html_tag":"div"},"elements":[{"id":"1f4908d","elType":"column","settings":{"_column_size":25,"_inline_size":27,"_inline_size_tablet":100,"content_position":"center","align_tablet":"space-between","space_between_widgets":0},"elements":[{"id":"bec9da8","elType":"widget","settings":{"icon_menu_size":{"unit":"px","size":16,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-vertical-menu"},{"id":"8597304","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"width":{"unit":"px","size":121,"sizes":[]},"_element_width":"auto"},"elements":[],"widgetType":"theme-site-logo"},{"id":"ebf107a","elType":"widget","settings":{"show_cart":"yes","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false},{"id":"78531a2","elType":"column","settings":{"_column_size":50,"_inline_size":46,"space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","content_position":"center","align":"center"},"elements":[{"id":"431bcda","elType":"widget","settings":{"border_width":{"unit":"px","size":2,"sizes":[]},"background_form":"#FFFFFF","_element_width":"initial","_element_custom_width":{"unit":"px","size":630,"sizes":[]}},"elements":[],"widgetType":"supplero-search"}],"isInner":false},{"id":"5d10fec","elType":"column","settings":{"_column_size":25,"_inline_size":27,"content_position":"center","align":"flex-end","space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"a55e917","elType":"widget","settings":{"show_divider":"yes","show_account":"yes","show_wishlist":"yes","show_cart":"yes","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"_element_width":"auto","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"20","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false}],"isInner":false},{"id":"e523b22","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"33","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","content_width":{"unit":"px","size":1800,"sizes":[]},"html_tag":"div"},"elements":[{"id":"5dfd5bf","elType":"column","settings":{"_column_size":25,"_inline_size":18.6099999999999994315658113919198513031005859375,"content_position":"center","space_between_widgets":0,"background_background":"classic","background_color":"#1C2127","__globals__":{"background_color":""}},"elements":[{"id":"2544480","elType":"widget","settings":{"menu":"menu-category","nav_menu_aligrment":"left","menu_title_color":"#000000","__globals__":{"menu_title_color_action":"globals\/colors?id=lighter","menu_title_color_hover":"globals\/colors?id=accent","_background_color":"globals\/colors?id=primary","menu_title_color":"globals\/colors?id=accent","sub_menu_color":""},"layout_style":"layout-2","menu_title_color_hover":"#999999","menu_title_color_action":"#999999","_background_background":"classic","show_full_menu":"yes"},"elements":[],"widgetType":"supplero-nav-menu"}],"isInner":false},{"id":"342386a","elType":"column","settings":{"_column_size":50,"_inline_size":56.3900000000000005684341886080801486968994140625,"content_position":"center","space_between_widgets":0,"background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"35","isLinked":false}},"elements":[{"id":"5a201b5","elType":"widget","settings":{"menu_title_color":"#FFFFFF","__globals__":{"menu_title_color_action":"globals\/colors?id=primary"},"menu":"main-menu","nav_menu_aligrment":"left"},"elements":[],"widgetType":"supplero-nav-menu"}],"isInner":false},{"id":"3157e69","elType":"column","settings":{"_column_size":25,"_inline_size":null,"content_position":"center","space_between_widgets":0,"background_background":"classic","background_color":"#1C2127","align":"flex-end","padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"6e728f8","elType":"widget","settings":{"icon_list":[{"text":"Ask our experts:","selected_icon":{"value":"fas fa-phone-alt","library":"fa-solid"},"_id":"4a4888c"}],"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_size_tablet":{"unit":"px","size":0,"sizes":[]},"text_indent":{"unit":"px","size":5,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"5","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-5","isLinked":false},"_element_width":"auto","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]},"__globals__":{"text_color":""},"text_color":"#FFFFFF","_css_classes":"supplero-contact-phone"},"elements":[],"widgetType":"icon-list"},{"id":"3236380","elType":"widget","settings":{"editor":"<div><a href=\"tel:1-888-333-5226\">1-888-333-5226<\/a><\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"700","_element_width":"auto","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]},"__globals__":{"text_color_link":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false}],"headerbuilder-4":[{"id":"b9a4516","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":48,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_mobile":"hidden-phone","background_background":"classic","html_tag":"div"},"elements":[{"id":"22f8cde","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"9307cc1","elType":"widget","settings":{"editor":"<div>Free standard shipping for orders <a href=\"#\">over $340.<\/a><\/div>","__globals__":{"text_color":"globals\/colors?id=lighter","text_color_link":""},"text_color":"#999999","text_color_link":"#FFFFFF"},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"94f9064","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"93d38b2","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"Find a Retailer","selected_icon":{"value":"","library":""},"_id":"9df4c95","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Customer Services","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"_id":"924d330","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e06d8b8"}],"icon_align":"right","icon_size":{"unit":"px","size":3,"sizes":[]},"text_indent":{"unit":"px","size":13,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=lighter","icon_color":"globals\/colors?id=lighter"},"icon_height":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"26ecf1a","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":80,"sizes":[]},"stretch_section":"section-stretched","structure":"30","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"98db31d","elType":"column","settings":{"_column_size":33,"_inline_size":40,"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"content_position":"center","space_between_widgets":0,"hide_mobile":"hidden-phone"},"elements":[{"id":"83501fc","elType":"widget","settings":{"icon_list":[{"text":"Ask our experts:","selected_icon":{"value":"fas fa-phone-alt","library":"fa-solid"},"_id":"4a4888c"}],"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_size_tablet":{"unit":"px","size":0,"sizes":[]},"text_indent":{"unit":"px","size":5,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"5","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-5","isLinked":false},"_element_width":"auto","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-list"},{"id":"84c0813","elType":"widget","settings":{"editor":"<div><a href=\"tel:1-888-333-5226\">1-888-333-5226<\/a><\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"700","_element_width":"auto","_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"%","size":100,"sizes":[]},"__globals__":{"text_color_link":"globals\/colors?id=primary"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"a953822","elType":"column","settings":{"_column_size":33,"_inline_size":19.33200000000000073896444519050419330596923828125,"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"_inline_size_mobile":100,"content_position":"center","align":"center","align_mobile":"space-between","space_between_widgets":0},"elements":[{"id":"bc65f4e","elType":"widget","settings":{"icon_menu_size":{"unit":"px","size":16,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"supplero-vertical-menu"},{"id":"efb1f6c","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo_2.svg","id":3412},"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/","is_external":"","nofollow":"","custom_attributes":""},"width":{"unit":"px","size":122,"sizes":[]},"_element_width":"auto"},"elements":[],"widgetType":"image"},{"id":"dd35461","elType":"widget","settings":{"show_cart":"yes","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false},{"id":"a1f63f2","elType":"column","settings":{"_column_size":33,"_inline_size":40,"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"content_position":"center","align":"flex-end","space_between_widgets":0,"hide_mobile":"hidden-phone"},"elements":[{"id":"a1f95eb","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-search","library":"supplero-icon"},"size":{"unit":"px","size":16,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"__dynamic__":{"link":"[elementor-tag id=\"516a206\" name=\"popup\" settings=\"%7B%22popup%22%3A%222087%22%7D\"]"},"hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"icon"},{"id":"f75b537","elType":"widget","settings":{"show_account":"yes","show_wishlist":"yes","show_cart":"yes","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"_element_width":"auto","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false}],"isInner":false},{"id":"42ed9d2","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":60,"sizes":[]},"stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"bd4ce63","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"8eb9d2e","elType":"widget","settings":{"menu":"main-menu"},"elements":[],"widgetType":"supplero-nav-menu"}],"isInner":false}],"isInner":false}],"headerbuilder-3":[{"id":"10ebee5","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":48,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_mobile":"hidden-phone","background_background":"classic","html_tag":"div"},"elements":[{"id":"22a5b33","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"892e557","elType":"widget","settings":{"editor":"<div>Free standard shipping for orders <a href=\"#\">over $340.<\/a><\/div>","__globals__":{"text_color":"globals\/colors?id=lighter","text_color_link":""},"text_color":"#999999","text_color_link":"#FFFFFF"},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"002dd55","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"61b7a1d","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"Find a Retailer","selected_icon":{"value":"","library":""},"_id":"9df4c95","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Customer Services","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"_id":"924d330","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e06d8b8"}],"icon_align":"right","icon_size":{"unit":"px","size":3,"sizes":[]},"text_indent":{"unit":"px","size":13,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=lighter","icon_color":"globals\/colors?id=lighter"},"icon_height":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"d0d3f67","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"33","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"height":"min-height","custom_height":{"unit":"px","size":80,"sizes":[]},"html_tag":"div","padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"css_classes":"sticky-header","sticky":"top","sticky_on":["desktop"],"sticky_effects_offset":80,"custom_css":"header.sticky-header {\r\n    --header-height: 80px;\r\n    \/*--opacity: 0.90;*\/\r\n    --shrink-me: 0.80;\r\n    --sticky-background-color: #ffffff;\r\n    --transition: .3s ease-in-out;\r\n\r\n    transition: background-color var(--transition),\r\n                background-image var(--transition),\r\n                backdrop-filter var(--transition),\r\n                opacity var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects {\r\n    \/*background-color: var(--sticky-background-color) !important;*\/\r\n    background-image: none !important;\r\n    opacity: var(--opacity) !important;\r\n    -webkit-backdrop-filter: blur(10px);\r\n    backdrop-filter: blur(10px);\r\n    box-shadow: 0 8px 20px 0 rgba(0,0,0,.1);\r\n}\r\nheader.sticky-header > .elementor-container {\r\n    transition: min-height var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects > .elementor-container {\r\n    min-height: calc(var(--header-height) * var(--shrink-me))!important;\r\n    height: calc(var(--header-height) * var(--shrink-me));\r\n}\r\nheader.sticky-header .elementor-nav-menu .elementor-item {\r\n    transition: padding var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects .elementor-nav-menu .elementor-item {\r\n    padding-bottom: 10px!important;\r\n    padding-top: 10px!important;\r\n}\r\nheader.sticky-header > .elementor-container .logo img {\r\n    transition: max-width var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects .logo img {\r\n    max-width: calc(100% * var(--shrink-me));\r\n}"},"elements":[{"id":"f2cd722","elType":"column","settings":{"_column_size":25,"_inline_size":18,"space_between_widgets":0,"_inline_size_tablet":100,"content_position":"center","align_tablet":"space-between"},"elements":[{"id":"57af43e","elType":"widget","settings":{"icon_menu_size":{"unit":"px","size":16,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-vertical-menu"},{"id":"ae57533","elType":"widget","settings":{"image_size":"full","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/","is_external":"","nofollow":"","custom_attributes":""},"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo_2.svg","id":3412},"width":{"unit":"px","size":120,"sizes":[]},"_css_classes":"logo","_element_width":"auto"},"elements":[],"widgetType":"image"},{"id":"edae981","elType":"widget","settings":{"show_cart":"yes","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false},{"id":"d33289e","elType":"column","settings":{"_column_size":50,"_inline_size":57,"space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"8983079","elType":"widget","settings":{"nav_menu_aligrment":"left","menu":"main-menu"},"elements":[],"widgetType":"supplero-nav-menu"}],"isInner":false},{"id":"9d2f437","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"content_position":"center","align":"flex-end","hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"dde543b","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-search","library":"supplero-icon"},"size":{"unit":"px","size":16,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","__globals__":{"primary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary"},"__dynamic__":{"link":"[elementor-tag id=\"516a206\" name=\"popup\" settings=\"%7B%22popup%22%3A%222087%22%7D\"]"}},"elements":[],"widgetType":"icon"},{"id":"b4456fc","elType":"widget","settings":{"show_account":"yes","show_wishlist":"yes","show_cart":"yes","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"_element_width":"auto","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false}],"isInner":false}],"headerbuilder-2":[{"id":"4cd3b07","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":48,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"c6ebc00","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"bd6cc26","elType":"widget","settings":{"editor":"<div>Free standard shipping for orders <a href=\"#\">over $340.<\/a><\/div>","__globals__":{"text_color":"globals\/colors?id=lighter","text_color_link":"globals\/colors?id=accent"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"86545df","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"48f256e","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"Find a Retailer","selected_icon":{"value":"","library":""},"_id":"9df4c95","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Customer Services","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"_id":"924d330","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e06d8b8"}],"icon_align":"right","icon_size":{"unit":"px","size":3,"sizes":[]},"text_indent":{"unit":"px","size":13,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=lighter","icon_color":"globals\/colors?id=lighter"},"icon_height":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"ca9f70c","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":80,"sizes":[]},"stretch_section":"section-stretched","structure":"33","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"cd5d0d9","elType":"column","settings":{"_column_size":25,"_inline_size":27,"_inline_size_tablet":100,"content_position":"center","align_tablet":"space-between","space_between_widgets":0},"elements":[{"id":"fc07beb","elType":"widget","settings":{"icon_menu_size":{"unit":"px","size":16,"sizes":[]},"_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-vertical-menu"},{"id":"5142572","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"width":{"unit":"px","size":121,"sizes":[]},"_element_width":"auto"},"elements":[],"widgetType":"theme-site-logo"},{"id":"c27789e","elType":"widget","settings":{"show_cart":"yes","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false},{"id":"10d9ae2","elType":"column","settings":{"_column_size":50,"_inline_size":46,"space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","content_position":"center","align":"center"},"elements":[{"id":"6e52fd9","elType":"widget","settings":{"border_width":{"unit":"px","size":2,"sizes":[]},"background_form":"#FFFFFF","_element_width":"initial","_element_custom_width":{"unit":"px","size":630,"sizes":[]}},"elements":[],"widgetType":"supplero-search"}],"isInner":false},{"id":"bdd7d2c","elType":"column","settings":{"_column_size":25,"_inline_size":27,"content_position":"center","align":"flex-end","space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"12a132e","elType":"widget","settings":{"show_divider":"yes","show_account":"yes","show_wishlist":"yes","show_cart":"yes","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"_element_width":"auto","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"20","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"}},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false}],"isInner":false},{"id":"be2d08f","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"6d353b5","elType":"column","settings":{"_column_size":50,"_inline_size":19,"content_position":"center","space_between_widgets":0},"elements":[{"id":"3648587","elType":"widget","settings":{"menu":"menu-category","nav_menu_aligrment":"left","menu_title_color":"#FFFFFF","__globals__":{"menu_title_color_action":"globals\/colors?id=lighter","menu_title_color_hover":"globals\/colors?id=lighter"},"layout_style":"layout-2"},"elements":[],"widgetType":"supplero-nav-menu"},{"id":"7f6ad9d","elType":"widget","settings":{"width":{"unit":"px","size":1,"sizes":[]},"text":"Divider","color":"#494F57","weight":{"unit":"px","size":20,"sizes":[]},"gap":{"unit":"px","size":0,"sizes":[]},"_element_width":"auto","_position":"absolute","_offset_orientation_h":"end","_offset_y":{"unit":"%","size":"","sizes":[]}},"elements":[],"widgetType":"divider"}],"isInner":false},{"id":"1ab5ab9","elType":"column","settings":{"_column_size":50,"_inline_size":81,"content_position":"center","space_between_widgets":0},"elements":[{"id":"7b77577","elType":"widget","settings":{"nav_menu_aligrment":"left","menu_title_color":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"50","isLinked":false},"__globals__":{"menu_title_color_action":"globals\/colors?id=primary","menu_sub_title_color_hover":"","menu_title_color_hover":""},"menu":"main-menu","menu_title_color_action":"#f2cb1f"},"elements":[],"widgetType":"supplero-nav-menu"}],"isInner":false}],"isInner":false}],"faq":[{"id":"a751145","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","background_color":"#FFFFFF","margin":{"unit":"px","top":"20","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"9b5ba6c","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"60","right":"80","bottom":"80","left":"80","isLinked":false},"padding_tablet":{"unit":"px","top":"60","right":"60","bottom":"40","left":"60","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"20","left":"15","isLinked":false}},"elements":[{"id":"b5db93b","elType":"section","settings":{"gap":"no","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"f20e008","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"25","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"c4042a9","elType":"widget","settings":{"tabs":[{"tab_title":"How do I pay for my order? ","tab_content":"<p>Depending on the country and customer group, different payment methods are available for you. These are Mastercard and Visa for worldwide shipping.<\/p>","_id":"2dfa0c4"},{"tab_title":"How can I change the delivery or billing address?","tab_content":"<p>These are Mastercard and Visa for worldwide shipping. Depending on the country and customer group, different payment methods are available for you.<\/p>","_id":"079ddac"},{"tab_title":"Can I cancel my order?","tab_content":"<p>Depending on the country and customer group, different payment methods are available for you. These are Mastercard and Visa for worldwide shipping.<\/p>","_id":"7eda6ba"},{"tab_title":"What forms of payments are acceptable?","tab_content":"<p>These are Mastercard and Visa for worldwide shipping. Depending on the country and customer group, different payment methods are available for you.<\/p>","_id":"45220f9"}],"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":18,"sizes":[]},"title_typography_font_weight":"700","title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","content_background_color":"","title_background":"","tab_active_color":"","title_background_active":"globals\/colors?id=primary"},"title_color":"#000000","style_theme":"yes","title_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"title_background":"#F4F4F4","content_padding":{"unit":"px","top":"20","right":"35","bottom":"0","left":"50","isLinked":false},"selected_icon":{"value":"supplero-icon- supplero-icon-plus","library":"supplero-icon"},"title_padding":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":false},"selected_active_icon":{"value":"supplero-icon- supplero-icon-minus","library":"supplero-icon"},"border_color":"#02010100"},"elements":[],"widgetType":"accordion"}],"isInner":true},{"id":"a8dedcb","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"25","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"6d16267","elType":"widget","settings":{"tabs":[{"tab_title":"Can I use a coupon?","tab_content":"<p>Depending on the country and customer group, different payment methods are available for you. These are Mastercard and Visa for worldwide shipping.<\/p>","_id":"2dfa0c4"},{"tab_title":"What steps does a normal order go through?","tab_content":"<p>These are Mastercard and Visa for worldwide shipping. Depending on the country and customer group, different payment methods are available for you.<\/p>","_id":"079ddac"},{"tab_title":"My item arrived damaged, what do I do?","tab_content":"<p>These are Mastercard and Visa for worldwide shipping. Depending on the country and customer group, different payment methods are available for you.<\/p>","_id":"7eda6ba"},{"tab_title":"Will all of my items be shipped together?","tab_content":"<p>Depending on the country and customer group, different payment methods are available for you. These are Mastercard and Visa for worldwide shipping.<\/p>","_id":"45220f9"}],"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":18,"sizes":[]},"title_typography_font_weight":"700","title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","title_background_active":"globals\/colors?id=primary"},"selected_icon":{"value":"supplero-icon- supplero-icon-plus","library":"supplero-icon"},"selected_active_icon":{"value":"supplero-icon- supplero-icon-minus","library":"supplero-icon"},"border_color":"#02010100","title_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"style_theme":"yes","title_background":"#F4F4F4","title_padding":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"content_padding":{"unit":"px","top":"20","right":"35","bottom":"0","left":"50","isLinked":false}},"elements":[],"widgetType":"accordion"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"350d711","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"45","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"a6353cc","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"95d0dd5","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/FAQ-01.png","id":4357},"image_size":"full","_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"f8dda16","elType":"widget","settings":{"title":"Wanna Quick Support ?","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":26,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"3f13e46","elType":"widget","settings":{"editor":"<div>We are always here to help the needy peoples any where in the universe please send us your<br>\nproblematic questions..<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.1000000000000000055511151231257827021181583404541015625,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"a544850","elType":"widget","settings":{"text":"contact us now","align":"center","selected_icon":{"value":"fas fa-arrow-right","library":"fa-solid"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"background_color":"#FFFFFF00","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"button_text_color":"globals\/colors?id=accent","border_color":"globals\/colors?id=accent","button_hover_border_color":""},"button_text_color":"#000000","border_color":"#000000","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"bold","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false}],"header-search":[{"id":"2904198","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"content_width":{"unit":"px","size":630,"sizes":[]},"html_tag":"div"},"elements":[{"id":"f018732","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"0f77b42","elType":"widget","settings":{"border_width":{"unit":"px","size":2,"sizes":[]}},"elements":[],"widgetType":"supplero-search"}],"isInner":false}],"isInner":false}],"home-7":[{"id":"fe17453","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"40","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"c832412","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3e86ef0","elType":"widget","settings":{"icon_list":[{"text":"Low price guarantee","selected_icon":{"value":"supplero-icon- supplero-icon-credit-card","library":"supplero-icon"},"_id":"041fcd6"}],"icon_align_tablet":"right","text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":36,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"400"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"01016db","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a1c0ce6","elType":"widget","settings":{"icon_list":[{"text":"  30 day online returns","selected_icon":{"value":"supplero-icon- supplero-icon-undo-alt","library":"supplero-icon"},"_id":"041fcd6"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":36,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"400"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"2e88c8b","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"d318891","elType":"widget","settings":{"icon_list":[{"text":"Free delivery worldwide","selected_icon":{"value":"supplero-icon- supplero-icon-truck","library":"supplero-icon"},"_id":"041fcd6"}],"icon_align_tablet":"right","text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":36,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"400"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"3c0b7b9","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_tablet":50,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[{"id":"80266df","elType":"widget","settings":{"icon_list":[{"text":" Ask our experts: <a  href=\"tel:18883335226\">1-888-333-5226<\/a>","selected_icon":{"value":"supplero-icon- supplero-icon-phone-rotary","library":"supplero-icon"},"_id":"041fcd6"}],"icon_align_tablet":"left","text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":36,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"400"},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"40809ab","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"60","bottom":"0","left":"60","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"84b69b2","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_slideshow_gallery":[{"id":1526,"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-1.jpg"},{"id":3345,"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h7-slider-011_optimized.png"}],"background_slideshow_background_size_mobile":"cover","background_slideshow_background_position_tablet":"center center","background_slideshow_background_position_mobile":"center center","background_slideshow_ken_burns":"yes","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h7-slider-011_optimized.png","id":3345},"background_position":"center center","background_position_mobile":"center left","background_repeat":"no-repeat","background_size":"auto"},"elements":[{"id":"5d99f33","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c01af50","elType":"column","settings":{"_column_size":50,"_inline_size":60.332999999999998408384271897375583648681640625,"space_between_widgets":0,"margin":{"unit":"%","top":"0","right":"0","bottom":"0","left":"45","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"80","bottom":"0","left":"80","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center","padding":{"unit":"px","top":"120","right":"0","bottom":"150","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"30","bottom":"60","left":"30","isLinked":false}},"elements":[{"id":"3051912","elType":"widget","settings":{"editor":"<div>100% whey<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":25,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0.5,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"5","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#DD818D","_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"66c90b2","elType":"widget","settings":{"title":"Unleash<br>\nYour Power","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"_margin":{"unit":"px","top":"20","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":2,"typography_font_size_mobile":{"unit":"px","size":45,"sizes":[]},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":43,"sizes":[]},"_margin_mobile":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"c7c2012","elType":"widget","settings":{"editor":"Gold standard focus and performance","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_z_index":2,"__globals__":{"text_color":""},"text_color":"#FFFFFF","typography_font_weight":"300","typography_line_height":{"unit":"px","size":36,"sizes":[]},"align_mobile":"center","typography_line_height_mobile":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"3829133","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"__globals__":{"background_color":"","button_text_color":""},"align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"bold","typography_letter_spacing":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"text_padding":{"unit":"px","top":"16","right":"32","bottom":"16","left":"32","isLinked":false},"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"5ddd150","elType":"column","settings":{"_column_size":50,"_inline_size":39.56700000000000017053025658242404460906982421875},"elements":[],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"5cdc1e7","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":0,"bottom":"20","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"3ca3eac","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"5d83887","elType":"widget","settings":{"title":"Shop by Sport","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":48,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"ea00d5c","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"50","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"1056c49","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":33,"margin_tablet":{"unit":"px","top":"0","right":"20","bottom":"30","left":"0","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"1a50b2f","elType":"widget","settings":{"icon_list":[{"text":"gym","selected_icon":{"value":"supplero-icon- supplero-icon-gym","library":"supplero-icon"},"_id":"32caa0e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_self_align":"center","icon_height":{"unit":"px","size":50,"sizes":[]},"text_indent":{"unit":"px","size":25,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_text_transform":"capitalize","icon_typography_line_height":{"unit":"px","size":48,"sizes":[]},"_css_classes":"supplero-box-clip style-theme-supplero-yes     Type a message","_background_background":"classic","_background_color":"#FFFFFF","__globals__":{"icon_color":"globals\/colors?id=accent","text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"b3a4320","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":33,"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"30","left":"10","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"a57a8d2","elType":"widget","settings":{"icon_list":[{"text":"Cycling","selected_icon":{"value":"supplero-icon- supplero-icon-cycling","library":"supplero-icon"},"_id":"32caa0e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_self_align":"center","icon_height":{"unit":"px","size":50,"sizes":[]},"text_indent":{"unit":"px","size":25,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_text_transform":"capitalize","icon_typography_line_height":{"unit":"px","size":48,"sizes":[]},"_css_classes":"supplero-box-clip style-theme-supplero-yes     Type a message","_background_background":"classic","_background_color":"#FFFFFF","__globals__":{"icon_color":"globals\/colors?id=accent","text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"87912a0","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":33,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"20","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"7f750a3","elType":"widget","settings":{"icon_list":[{"text":"Football","selected_icon":{"value":"supplero-icon- supplero-icon-football","library":"supplero-icon"},"_id":"32caa0e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_self_align":"center","icon_height":{"unit":"px","size":50,"sizes":[]},"text_indent":{"unit":"px","size":25,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_text_transform":"capitalize","icon_typography_line_height":{"unit":"px","size":48,"sizes":[]},"_css_classes":"supplero-box-clip style-theme-supplero-yes     Type a message","_background_background":"classic","_background_color":"#FFFFFF","__globals__":{"icon_color":"globals\/colors?id=accent","text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"4545364","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":50,"margin_tablet":{"unit":"%","top":"0","right":"10","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"f2a3995","elType":"widget","settings":{"icon_list":[{"text":"Running","selected_icon":{"value":"supplero-icon- supplero-icon-running","library":"supplero-icon"},"_id":"32caa0e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_self_align":"center","icon_height":{"unit":"px","size":50,"sizes":[]},"text_indent":{"unit":"px","size":25,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_text_transform":"capitalize","icon_typography_line_height":{"unit":"px","size":48,"sizes":[]},"_css_classes":"supplero-box-clip style-theme-supplero-yes     Type a message","_background_background":"classic","_background_color":"#FFFFFF","__globals__":{"icon_color":"globals\/colors?id=accent","text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"5809180","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_tablet":50,"margin_tablet":{"unit":"%","top":"0","right":"30","bottom":"0","left":"10","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"20d3983","elType":"widget","settings":{"icon_list":[{"text":"Swimming","selected_icon":{"value":"supplero-icon- supplero-icon-swimming","library":"supplero-icon"},"_id":"32caa0e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}}],"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_self_align":"center","icon_height":{"unit":"px","size":50,"sizes":[]},"text_indent":{"unit":"px","size":25,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_text_transform":"capitalize","icon_typography_line_height":{"unit":"px","size":48,"sizes":[]},"_css_classes":"supplero-box-clip style-theme-supplero-yes     Type a message","_background_background":"classic","_background_color":"#FFFFFF","__globals__":{"icon_color":"globals\/colors?id=accent","text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"17b7d8c","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"1cdfdbe","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"5d613d8","elType":"widget","settings":{"title":"Our Products","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":48,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"30","bottom":"25","left":"30","isLinked":false},"align_tablet":"center","typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"ccf40e2","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":590,"sizes":[]},"structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"reverse_order_tablet":"reverse-tablet","reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"738d19c","elType":"column","settings":{"_column_size":50,"_inline_size":50,"space_between_widgets":0,"background_background":"classic","background_color":"#2D3335","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-1.png","id":536},"background_position":"bottom left","background_repeat":"no-repeat","margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"80","bottom":"280","left":"80","isLinked":false},"__globals__":{"background_color":""},"margin_mobile":{"unit":"px","top":"25","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"80","left":"40","isLinked":false},"padding_mobile":{"unit":"px","top":"60","right":"30","bottom":"30","left":"30","isLinked":false},"align_mobile":"center","_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"background_hover_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-1.png","id":536},"background_hover_position":"bottom right","background_hover_repeat":"no-repeat","background_hover_size":"auto","background_hover_transition":{"unit":"px","size":0.8000000000000000444089209850062616169452667236328125,"sizes":[]},"background_repeat_tablet":"no-repeat","background_repeat_mobile":"no-repeat","background_size_tablet":"cover","background_size_mobile":"auto"},"elements":[{"id":"bbe315c","elType":"widget","settings":{"editor":"<div>In store now<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":25,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0.5,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"_css_classes":"supplero-box-clip","_background_background":"classic","_background_color":"#D20117","_element_width":"auto","_margin":{"unit":"px","top":"0","right":"0","bottom":"010","left":"0","isLinked":false},"__globals__":{"_background_color":""}},"elements":[],"widgetType":"text-editor"},{"id":"c9c3884","elType":"widget","settings":{"title":"Gold Standard <br> Pre-workout","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":36,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":28,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":25,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"9e4445e","elType":"widget","settings":{"editor":"<p>Starting at $16.99<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":1,"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"2efc11a","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","text_padding":{"unit":"px","top":"12","right":"20","bottom":"12","left":"20","isLinked":false},"align_mobile":"center","_z_index":1,"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"},{"id":"821c46a","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-1-1.png","id":624},"image_size":"full","_element_width":"auto","_position":"absolute","_offset_orientation_h":"end","_element_width_tablet":"initial","_element_width_mobile":"auto","_element_custom_width_tablet":{"unit":"px","size":233},"_offset_x_end":{"size":-10,"unit":"%"},"_offset_x_end_tablet":{"size":15,"unit":"%"},"_offset_x_end_mobile":{"size":10,"unit":"%"},"_offset_y":{"size":10,"unit":"%"},"_offset_y_tablet":{"size":-25,"unit":"%"},"_offset_y_end_tablet":{"size":0,"unit":"px"},"_offset_y_end_mobile":{"size":-494.43900000000002137312549166381359100341796875,"unit":"%"},"_offset_y_mobile":{"size":45,"unit":"%"},"motion_fx_mouseTrack_effect":"yes","_z_index":0,"align_mobile":"center","width_mobile":{"unit":"%","size":90,"sizes":[]},"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"image"},{"id":"1932ec7","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-1-1.png","id":624},"image_size":"full","_element_width":"auto","_offset_orientation_h":"end","_element_width_tablet":"initial","_element_width_mobile":"auto","_element_custom_width_tablet":{"unit":"px","size":233},"_offset_x_end":{"size":-10,"unit":"%"},"_offset_x_end_tablet":{"size":15,"unit":"%"},"_offset_x_end_mobile":{"size":10,"unit":"%"},"_offset_y":{"size":10,"unit":"%"},"_offset_y_tablet":{"size":10,"unit":"%"},"_offset_y_end_tablet":{"size":0,"unit":"px"},"_offset_y_end_mobile":{"size":-494.43900000000002137312549166381359100341796875,"unit":"%"},"_offset_y_mobile":{"size":45,"unit":"%"},"motion_fx_mouseTrack_effect":"yes","_z_index":0,"align_mobile":"center","width_mobile":{"unit":"%","size":90,"sizes":[]},"_padding_mobile":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"ad7f0c2","elType":"column","settings":{"_column_size":50,"_inline_size":49.92399999999999948840923025272786617279052734375,"space_between_widgets":0,"margin":{"unit":"px","top":"-70","right":"0","bottom":"-30","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"5490d3b","elType":"widget","settings":{"tabs":[{"tab_title":"New Arrivals    ","_id":"19af9fd","limit":4,"product_type":"best_selling","categories":[],"tag":[],"list_layout":"5"},{"tab_title":"  Featured ","_id":"342930f","product_type":"top_rated","limit":4},{"tab_title":"Best Selller","product_type":"best_selling","_id":"6bc1691","limit":4}],"column":"2","tab_header_padding":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"align_items":"right","header_margin":{"unit":"px","size":5,"sizes":[]},"tab_typography_typography":"custom","tab_typography_font_size":{"unit":"px","size":12,"sizes":[]},"tab_typography_font_weight":"bold","tab_typography_text_transform":"uppercase","tab_typography_line_height":{"unit":"px","size":36,"sizes":[]},"tab_title_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"title_color":"#999999","title_background_hover_color":"#f2cb1f","border_tabs_title_border":"solid","border_tabs_title_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_background_hover_color":"globals\/colors?id=primary","title_background_color":"","title_color":"globals\/colors?id=lighter","border_tabs_title_color":"globals\/colors?id=border","title_hover_color":"globals\/colors?id=accent","title_active_color":"globals\/colors?id=accent","title_background_active_color":"globals\/colors?id=primary"},"column_mobile":"1","align_items_mobile":"center","column_tablet":"2","align_items_tablet":"center","navigation":"none","_margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"product_gutter_mobile":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"supplero-products-tabs"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"6c2ba8b","elType":"section","settings":{"structure":"20","gap":"no","margin":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"stretch_section":"section-stretched","reverse_order_tablet":"reverse-tablet","padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"10","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"4a438c9","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":100,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"92c4056","elType":"widget","settings":{"limit":4,"column":"2","column_mobile":"1","categories":[],"tag":[],"list_layout":"4","navigation":"none","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"supplero-products"}],"isInner":false},{"id":"6da7a13","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"72026c6","elType":"widget","settings":{"column":"1","navigation":"none","column_tablet":"1","limit":1},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"1ab55e1","elType":"section","settings":{"gap":"no","structure":"20","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"stretch_section":"section-stretched","margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_tablet":{"unit":"px","top":"60","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_height":{"unit":"px","size":520,"sizes":[]},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"5e58f75","elType":"column","settings":{"_column_size":50,"_inline_size":null,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/H7-video-1.png","id":4605},"background_position_tablet":"center center","background_repeat_tablet":"no-repeat","background_size_tablet":"cover","background_hover_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h7-layout-01.jpg","id":1814},"background_hover_position":"top center","background_hover_repeat":"no-repeat","background_hover_size":"auto","space_between_widgets":0,"content_position":"center","margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_mouseTrack_effect":"yes"},"elements":[{"id":"4321691","elType":"widget","settings":{"video_link":"https:\/\/www.youtube.com\/watch?v=TcXHOf-ME4E","icon_font":{"value":"supplero-icon- supplero-icon-youtube","library":"supplero-icon"},"video_size":{"unit":"px","size":60,"sizes":[]},"video_height":{"unit":"px","size":20,"sizes":[]},"video_color":"#FF0000","__globals__":{"video_color":"","video_background_color":"","background_wrapper_hover":"","border_wrapper_hover":"","background_wrapper":"","title_hover_color":"","title_color":"","video_hover_color":"","video_hover_background_color":"globals\/colors?id=accent"},"video_width":{"unit":"px","size":20,"sizes":[]},"video_background_color":"#FFFFFF","_margin":{"unit":"px","top":"235","right":"0","bottom":"235","left":"0","isLinked":false}},"elements":[],"widgetType":"supplero-video-popup"}],"isInner":false},{"id":"8e8e459","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false}},"elements":[{"id":"18da2c9","elType":"widget","settings":{"title":"Why Choose Us","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":48,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"e36d91c","elType":"widget","settings":{"editor":"<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do tempor incididunt ut<br> labore et dolore magna aliqua.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"1f5916b","elType":"widget","settings":{"tabs":[{"tab_title":"Largest authentic supplements","tab_content":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\/p>","_id":"021fab8"},{"tab_title":"High quality raw materials","tab_content":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\/p>","_id":"20455dc"},{"tab_title":"Top Rated And Reviewed","tab_content":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\/p>","_id":"8435841"},{"tab_title":"Trusted By Experts","tab_content":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\/p>","_id":"0734c63"},{"tab_title":"Top Bodybuilding Supplement Brands","tab_content":"<p>Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\/p>","_id":"db78997"}],"selected_icon":{"value":"fas fa-check-circle","library":"fa-solid"},"selected_active_icon":{"value":"fas fa-check-circle","library":"fa-solid"},"title_color":"#000000","tab_active_color":"#000000","icon_color":"#DCDCDC","icon_active_color":"#41A825","__globals__":{"content_color":"globals\/colors?id=text","title_color":"globals\/colors?id=accent","tab_active_color":"globals\/colors?id=accent","icon_color":""},"icon_space":{"unit":"px","size":8,"sizes":[]},"title_typography_font_size":{"unit":"px","size":18,"sizes":[]},"title_typography_line_height":{"unit":"px","size":"","sizes":[]},"content_padding":{"unit":"px","top":"0","right":"30","bottom":"10","left":"40","isLinked":false},"style_theme":"yes"},"elements":[],"widgetType":"accordion"}],"isInner":false}],"isInner":false},{"id":"f240f43","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","custom_height":{"unit":"px","size":270,"sizes":[]},"structure":"20","background_background":"classic","background_color":"#FFFFFF","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"80","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"60","right":"30","bottom":"60","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"6908a8e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"31aadac","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":270,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-3.jpg","id":1315},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_background":"classic","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"custom_height_inner_tablet":{"unit":"px","size":460,"sizes":[]},"reverse_order_tablet":"reverse-tablet","reverse_order_mobile":"reverse-mobile","height_inner":"min-height","html_tag":"div"},"elements":[{"id":"f9cff21","elType":"column","settings":{"_column_size":50,"_inline_size":60,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"34","right":"10","bottom":"34","left":"10","isLinked":false},"space_between_widgets_tablet":0},"elements":[{"id":"2ae2c53","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-3-1.png","id":1311},"image_size":"full","align":"center"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"aed31ec","elType":"column","settings":{"_column_size":50,"_inline_size":40,"space_between_widgets":0,"margin":{"unit":"%","top":"13","right":"0","bottom":"25","left":"3","isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":"30","bottom":"10","left":"30","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[{"id":"76f9ca2","elType":"widget","settings":{"editor":"<div>New in<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"4","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"091e45a","elType":"widget","settings":{"title":"Truth In\n","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"4214582","elType":"widget","settings":{"title":"\nEvery Bottle","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"10038ca","elType":"widget","settings":{"title":"10% Off first order","title_color":"#00AAEE","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":""},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"9141633","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"align":"left","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"text_padding":{"unit":"px","top":"8","right":"15","bottom":"8","left":"15","isLinked":false},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","__globals__":{"hover_color":"","button_background_hover_color":""},"align_mobile":"center","hover_color":"#FFFFFF","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"3846441","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4d643f0","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":270,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-2.jpg","id":1277},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_hover_background":"classic","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"custom_height_inner_tablet":{"unit":"px","size":460,"sizes":[]},"height_inner":"min-height","margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"a960a16","elType":"column","settings":{"_column_size":50,"_inline_size":50.7939999999999969304553815163671970367431640625,"space_between_widgets":0,"margin":{"unit":"%","top":"10","right":"0","bottom":"19","left":"28","isLinked":false},"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":100,"margin_mobile":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true}},"elements":[{"id":"7567b79","elType":"widget","settings":{"editor":"<div>Available now<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"a8384ee","elType":"widget","settings":{"title":"Whey Protein\n","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"1e797f8","elType":"widget","settings":{"title":"\nPower Blend","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"7051098","elType":"widget","settings":{"title":"Starting at  $199.00 ","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=primary"},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"e349ab1","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"align":"left","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"text_padding":{"unit":"px","top":"8","right":"15","bottom":"8","left":"15","isLinked":false},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","__globals__":{"hover_color":"","button_background_hover_color":""},"align_mobile":"center","hover_color":"#FFFFFF","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"0ae39ef","elType":"column","settings":{"_column_size":50,"_inline_size":49.2060000000000030695446184836328029632568359375,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"15","right":"15","bottom":"15","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_mobile":{"unit":"px","top":"0","right":"30","bottom":"35","left":"30","isLinked":false}},"elements":[{"id":"14d5e0a","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-2-1.png","id":1292},"image_size":"full","align":"left","align_tablet":"center","align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"01b6267","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"60","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":0,"bottom":"40","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"50","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"bfc9162","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"fa139a6","elType":"widget","settings":{"title":"From Our Blog","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":48,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"7be251e","elType":"widget","settings":{"pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","navigation":"none","post_style":"post-style-2","column_tablet":"2"},"elements":[],"widgetType":"supplero-post-grid"},{"id":"61eebfc","elType":"widget","settings":{"text":"Divider","color":"#E3E3E3","gap":{"unit":"px","size":25,"sizes":[]},"gap_tablet":{"unit":"px","size":10,"sizes":[]},"_margin_tablet":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin":{"unit":"px","top":"25","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"divider"},{"id":"89bdf36","elType":"widget","settings":{"editor":"<div>Proud to partner with<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2,"sizes":[]},"_margin":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"04c70e3","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-1.png","id":934},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"ecdaa11"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-2.png","id":935},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"3334b4f"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-3.png","id":936},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1daf1d8"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-4.png","id":937},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"313b887"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-6.png","id":939},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"ed3dfbd"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-5.png","id":938},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"e1264e6"}],"column":"6","image_opacity":{"unit":"px","size":1,"sizes":[]},"image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"column_tablet":"5","enable_carousel":"yes","navigation":"none","column_mobile":"3","item_spacing":{"unit":"px","size":0,"sizes":[]},"item_spacing_mobile":{"unit":"px","size":0,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"5","bottom":"0","left":"5","isLinked":false},"image_padding_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"supplero-brand"}],"isInner":false}],"isInner":false}],"home-3":[{"id":"aca5dd4","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"15","bottom":"10","left":"15","isLinked":false},"structure":"40","hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"b04ed7f","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"c354d5b","elType":"widget","settings":{"icon_list":[{"text":"Low price guarantee","selected_icon":{"value":"supplero-icon- supplero-icon-credit-card","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_tablet":"right","icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"a9d101b","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"05f532d","elType":"widget","settings":{"icon_list":[{"text":"30 day online returns","selected_icon":{"value":"supplero-icon- supplero-icon-history","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"c46a74d","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"e074964","elType":"widget","settings":{"icon_list":[{"text":"Free delivery worldwide","selected_icon":{"value":"supplero-icon- supplero-icon-truck","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_tablet":"right","icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"1a31aa7","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"915d98d","elType":"widget","settings":{"icon_list":[{"text":"Ask our experts: <a href=\"tel:18883335226\">1-888-333-5226<\/a>","selected_icon":{"value":"supplero-icon- supplero-icon-phone-rotary","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"573e415","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"15","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"faeb4be","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-1.jpg","id":1526},"padding":{"unit":"px","top":"90","right":"0","bottom":"90","left":"0","isLinked":false},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"padding_tablet":{"unit":"px","top":"70","right":"0","bottom":"70","left":"0","isLinked":false}},"elements":[{"id":"7d1ed04","elType":"section","settings":{"content_width":{"unit":"px","size":910,"sizes":[]},"gap":"no","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"aa6a327","elType":"column","settings":{"_column_size":50,"_inline_size":65,"space_between_widgets":0,"_inline_size_tablet":80,"align_mobile":"center","z_index":2},"elements":[{"id":"54dd16d","elType":"widget","settings":{"title":"new in","header_size":"span","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"8","bottom":"0","left":"8","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#1563B7","_element_width":"auto","__globals__":{"_background_color":""}},"elements":[],"widgetType":"heading"},{"id":"70c30d0","elType":"widget","settings":{"space":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"a010078","elType":"widget","settings":{"title":"All-in-one Protein <br> Powder","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_element_custom_width":{"unit":"px","size":445,"sizes":[]},"_element_custom_width_tablet":{"unit":"px","size":390,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"c30eeb0","elType":"widget","settings":{"suffix":"mg","title":"Natural Caffeine","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_line_height":{"unit":"px","size":50,"sizes":[]},"title_color":"#FFFFFF","typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":18,"sizes":[]},"typography_title_line_height":{"unit":"px","size":18,"sizes":[]},"_border_width":{"unit":"px","top":"0","right":"1","bottom":"0","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":27,"sizes":[]},"_typography":"custom","_font_size":{"unit":"px","size":18,"sizes":[]},"_line_height":{"unit":"px","size":20,"sizes":[]},"content_vertical_alignment":"bottom","text_align":"left","text_align_mobile":"center","number_space":{"unit":"px","size":10,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width_mobile":"inherit","_element_custom_width_mobile":{"unit":"%","size":60,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"e00abd3","elType":"widget","settings":{"ending_number":5,"suffix":"g","title":"Amino Acids","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_line_height":{"unit":"px","size":50,"sizes":[]},"title_color":"#FFFFFF","typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":18,"sizes":[]},"typography_title_line_height":{"unit":"px","size":18,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"1","bottom":"0","left":"1","isLinked":false},"_border_color":"#FFFFFF33","_element_width":"initial","_element_custom_width":{"unit":"%","size":46,"sizes":[]},"_typography":"custom","_font_size":{"unit":"px","size":18,"sizes":[]},"_line_height":{"unit":"px","size":20,"sizes":[]},"content_vertical_alignment":"bottom","_padding":{"unit":"px","top":"0","right":"40","bottom":"0","left":"40","isLinked":false},"text_align":"left","number_space":{"unit":"px","size":10,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_border_width_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":50,"sizes":[]},"text_align_mobile":"right","typography_number_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":40,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"a8f78d4","elType":"widget","settings":{"ending_number":31,"suffix":"g","title":"Whey Protein","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":60,"sizes":[]},"typography_number_line_height":{"unit":"px","size":50,"sizes":[]},"title_color":"#FFFFFF","typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":18,"sizes":[]},"typography_title_line_height":{"unit":"px","size":18,"sizes":[]},"_border_width":{"unit":"px","top":"0","right":"1","bottom":"0","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"%","size":27,"sizes":[]},"_typography":"custom","_font_size":{"unit":"px","size":18,"sizes":[]},"_line_height":{"unit":"px","size":20,"sizes":[]},"content_vertical_alignment":"bottom","text_align":"left","number_space":{"unit":"px","size":10,"sizes":[]},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"%","size":50,"sizes":[]},"text_align_mobile":"left","typography_number_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_number_line_height_tablet":{"unit":"px","size":40,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"counter"},{"id":"d1b8ff5","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"align_mobile":"center","_margin":{"unit":"px","top":"50","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"button_background_hover_color":"globals\/colors?id=primary_hover"},"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"d225084","elType":"column","settings":{"_column_size":50,"_inline_size":35,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":20,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"flex-end","z_index":1},"elements":[{"id":"66e8080","elType":"widget","settings":{"title":"<span style=\"font-size:14px;\">from<\/span> <br> $69.99","header_size":"h4","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"26","right":"15","bottom":"35","left":"15","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#DD3F37","_border_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"_element_width":"auto","_position":"absolute","typography_font_size_mobile":{"unit":"px","size":24,"sizes":[]},"_padding_mobile":{"unit":"px","top":"22","right":"15","bottom":"33","left":"15","isLinked":false},"_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_y_mobile":{"unit":"px","size":-60,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"334cefc","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"90","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"487da23","elType":"column","settings":{"_column_size":33,"_inline_size":null,"_inline_size_tablet":100,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[{"id":"6c1edc8","elType":"section","settings":{"content_width":{"unit":"px","size":435,"sizes":[]},"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":220,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-2.jpg","id":2056},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_direction":"negative","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"content_position":"middle","background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]},"background_overlay_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"21450ce","elType":"column","settings":{"_column_size":50,"_inline_size":38,"space_between_widgets":0,"_inline_size_tablet":40,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"padding":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true}},"elements":[{"id":"085c928","elType":"widget","settings":{"editor":"Clearance","text_color":"#FFFFFF","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"0ce8044","elType":"widget","settings":{"title":"Reload <br> Supplements","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"6b2058d","elType":"widget","settings":{"editor":"20% Off ","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","_margin":{"unit":"px","top":"0","right":"0","bottom":"12","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center","typography_line_height":{"unit":"px","size":24,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"68fc7c1","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"size":"xs","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","_z_index":2,"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"6cff78d","elType":"column","settings":{"_column_size":50,"_inline_size":61.99799999999999755573298898525536060333251953125,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"10","isLinked":false},"_inline_size_tablet":60},"elements":[{"id":"f95051f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-2-1.png","id":2057},"image_size":"full","width_tablet":{"unit":"px","size":"","sizes":[]},"width_mobile":{"unit":"px","size":180,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"0ffd750","elType":"column","settings":{"_column_size":33,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[{"id":"0aa9c3e","elType":"section","settings":{"content_width":{"unit":"px","size":435,"sizes":[]},"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":220,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-3.jpg","id":2058},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_direction":"negative","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"content_position":"middle","background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]},"background_overlay_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"a95c0b5","elType":"column","settings":{"_column_size":50,"_inline_size":53,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"padding":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true}},"elements":[{"id":"0e36f35","elType":"widget","settings":{"editor":"What\u2019s hot","text_color":"#FFFFFF","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"73e8cda","elType":"widget","settings":{"title":"Best-selling <br> Protein Products","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"9e9a55c","elType":"widget","settings":{"editor":"Up to 50% off","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","_margin":{"unit":"px","top":"0","right":"0","bottom":"12","left":"0","isLinked":false},"__globals__":{"text_color":""},"align_mobile":"center","text_color":"#2DBCFE","typography_line_height":{"unit":"px","size":24,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"0fd82bc","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"size":"xs","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","_z_index":2,"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"227c4b6","elType":"column","settings":{"_column_size":50,"_inline_size":46.99799999999999755573298898525536060333251953125,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":100},"elements":[{"id":"ef0c998","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-3-1.png","id":2059},"image_size":"full","width_tablet":{"unit":"px","size":92,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"62041e7","elType":"column","settings":{"_column_size":33,"_inline_size":null,"_inline_size_tablet":50,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"10b8168","elType":"section","settings":{"content_width":{"unit":"px","size":435,"sizes":[]},"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":220,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-4.jpg","id":2060},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_direction":"negative","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"content_position":"middle","background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]},"background_overlay_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"586a225","elType":"column","settings":{"_column_size":50,"_inline_size":40,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"padding":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true}},"elements":[{"id":"48e6de0","elType":"widget","settings":{"editor":"Available now","text_color":"#FFFFFF","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"6d4ff2f","elType":"widget","settings":{"title":"Gold Standard <br> 100% Whey","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"bebf053","elType":"widget","settings":{"editor":"From $199.00 ","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","_margin":{"unit":"px","top":"0","right":"0","bottom":"12","left":"0","isLinked":false},"__globals__":{"text_color":""},"align_mobile":"center","text_color":"#E22033","typography_line_height":{"unit":"px","size":24,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"38e645d","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"size":"xs","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","_z_index":2,"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"0a651b1","elType":"column","settings":{"_column_size":50,"_inline_size":59.99799999999999755573298898525536060333251953125,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":100},"elements":[{"id":"6300c4a","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-4-1.png","id":2061},"image_size":"full","width_tablet":{"unit":"px","size":150,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"1ff28da","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"90","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"a23cca1","elType":"column","settings":{"_column_size":50,"_inline_size":45.171300000000002228262019343674182891845703125,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"45","left":"0","isLinked":false},"align_mobile":"center","padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"329a88e","elType":"widget","settings":{"editor":"About Us","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"align":"left","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"5bc94b5","elType":"widget","settings":{"title":"Supporting Athletes Since 1995","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":40,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":35,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":410,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"38d60ba","elType":"widget","settings":{"editor":"Whether you are an elite sportsperson, a gym purist or a complete beginner, we can help you achieve things you never thought possible.","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":520,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"ff7b66e","elType":"widget","settings":{"editor":"<p>As the premier sports nutrition brand in the UK, we have been supporting British athletes, fitness and healthy lifestyles for over two decades. Since 1995, we\'ve helped millions of people push harder, go faster and further. Break limits and personal bests.<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":520,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"340bc0e","elType":"widget","settings":{"text":"view our products","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"hover_color":"","button_hover_border_color":""},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"5be4e88","elType":"column","settings":{"_column_size":50,"_inline_size":54.82900000000000062527760746888816356658935546875,"content_position":"bottom","space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_bg-1.jpg","id":2279},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"gradient","background_overlay_color":"#F7F7F7","background_overlay_color_stop":{"unit":"%","size":8,"sizes":[]},"background_overlay_color_b":"#F2295B00","background_overlay_color_b_stop":{"unit":"%","size":8,"sizes":[]},"background_overlay_gradient_angle":{"unit":"deg","size":90,"sizes":[]},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"px","top":"80","right":"0","bottom":"80","left":"0","isLinked":false}},"elements":[{"id":"db66b59","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"206c112","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_tablet":80,"content_position":"bottom","space_between_widgets":0,"background_background":"classic","background_color":"#F2CB1F","padding":{"unit":"px","top":"10","right":"15","bottom":"15","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"5","right":"0","bottom":"15","left":"0","isLinked":false},"css_classes":"supplero-box-clip","_inline_size_mobile":91},"elements":[{"id":"77cc50d","elType":"widget","settings":{"ending_number":5,"prefix":"2,","suffix":"M","title":"bottles sold","text_align":"left","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":40,"sizes":[]},"typography_number_line_height":{"unit":"px","size":"","sizes":[]},"number_space":{"unit":"px","size":0,"sizes":[]},"_typography":"custom","_font_size":{"unit":"px","size":24,"sizes":[]},"typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":14,"sizes":[]},"typography_title_font_weight":"700","typography_title_text_transform":"uppercase","typography_title_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"5","right":"15","bottom":"5","left":"15","isLinked":false},"_element_width":"auto","__globals__":{"number_color":"globals\/colors?id=accent","title_color":"globals\/colors?id=accent"},"typography_number_font_size_mobile":{"unit":"px","size":36,"sizes":[]},"_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"typography_title_font_size_mobile":{"unit":"px","size":12,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"2d19761","elType":"widget","settings":{"ending_number":961,"suffix":"K","title":"customers served","text_align":"left","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":40,"sizes":[]},"typography_number_line_height":{"unit":"px","size":"","sizes":[]},"number_space":{"unit":"px","size":0,"sizes":[]},"_typography":"custom","_font_size":{"unit":"px","size":24,"sizes":[]},"typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":14,"sizes":[]},"typography_title_font_weight":"700","typography_title_text_transform":"uppercase","typography_title_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"15","bottom":"5","left":"15","isLinked":false},"_element_width":"auto","__globals__":{"number_color":"globals\/colors?id=accent","title_color":"globals\/colors?id=accent"},"typography_number_font_size_mobile":{"unit":"px","size":36,"sizes":[]},"_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"typography_title_font_size_mobile":{"unit":"px","size":12,"sizes":[]}},"elements":[],"widgetType":"counter"}],"isInner":true},{"id":"78b9183","elType":"column","settings":{"_column_size":50,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"8d0f1d8","elType":"section","settings":{"gap":"no","content_position":"middle","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"html_tag":"div"},"elements":[{"id":"dd25643","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-5.jpg","id":2702},"background_position":"center center","background_size":"cover","padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"column_link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000"},"elements":[{"id":"134664d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-5-1.png","id":2710},"image_size":"full","motion_fx_rotateZ_effect":"yes"},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"ee9650e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"90","right":"30","bottom":"90","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"50","left":"15","isLinked":false}},"elements":[{"id":"ead4939","elType":"section","settings":{"content_width":{"unit":"px","size":395,"sizes":[]},"gap":"no","html_tag":"div"},"elements":[{"id":"2fb61fe","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"c87c0f5","elType":"widget","settings":{"title":"New Mass Tech 100% Strength","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":40,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":35,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_element_width":"initial","_element_custom_width":{"unit":"px","size":410,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"abe813b","elType":"widget","settings":{"editor":"Pre-workout energy amplifier","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"d319ee5","elType":"widget","settings":{"title":"24g Protein ","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"6e600c3","elType":"widget","settings":{"editor":"Helps Build & Maintain Muscle","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"e5c248f","elType":"widget","settings":{"title":"1125 Calories","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"d7bbc77","elType":"widget","settings":{"editor":" Helps Boost Calorie Intake","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"338a457","elType":"widget","settings":{"title":"215g Carbs ","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"e84c847","elType":"widget","settings":{"editor":"Helps Fuel Intense Workouts","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"5239b85","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"hover_color":"","button_hover_border_color":""},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"5a66512","elType":"section","settings":{"gap":"no","content_position":"middle","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"90","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"57fc253","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"90","right":"30","bottom":"90","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"50","left":"15","isLinked":false}},"elements":[{"id":"a4b2039","elType":"section","settings":{"content_width":{"unit":"px","size":395,"sizes":[]},"gap":"no","html_tag":"div"},"elements":[{"id":"e3ed0c2","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"35043ee","elType":"widget","settings":{"title":"Shatter <br> Pre-workout ","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":40,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":35,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_element_width":"initial","_element_custom_width":{"unit":"px","size":410,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"8668b0a","elType":"widget","settings":{"editor":"Non-stimulant performance amplifier","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"f0f80e8","elType":"widget","settings":{"title":"24g Protein ","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"5929a05","elType":"widget","settings":{"editor":"Helps Build & Maintain Muscle","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"4ee47bc","elType":"widget","settings":{"title":"1125 Calories","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"62d262e","elType":"widget","settings":{"editor":" Helps Boost Calorie Intake","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"def3b9e","elType":"widget","settings":{"title":"215g Carbs ","header_size":"h4","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"895ffc6","elType":"widget","settings":{"editor":"Helps Fuel Intense Workouts","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"0e4ec0b","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"hover_color":"","button_hover_border_color":""},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"f6d10ad","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-6.jpg","id":2843},"background_position":"center center","background_size":"cover","padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"column_link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000"},"elements":[{"id":"3caf392","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-6-1.png","id":2844},"image_size":"full","motion_fx_rotateZ_effect":"yes","motion_fx_rotateZ_direction":"negative"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"eb821a6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"90","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"66ec0f8","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align_mobile":"center"},"elements":[{"id":"25d2735","elType":"widget","settings":{"title":"Our Products","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"align":"left","typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"_z_index":2,"_element_width":"auto"},"elements":[],"widgetType":"heading"},{"id":"bbf785f","elType":"widget","settings":{"tabs":[{"tab_title":"New Arrivals  ","_id":"cfa73f9","limit":4},{"tab_title":"Featured ","_id":"acfe3b4","limit":4,"orderby":"menu_order"},{"tab_title":"Best Selller","_id":"6e6fe61","limit":4,"product_type":"best_selling"}],"column":"4","column_tablet":"3","column_mobile":"2","product_gutter":{"unit":"px","size":30,"sizes":[]},"product_gutter_tablet":{"unit":"px","size":20,"sizes":[]},"product_gutter_mobile":{"unit":"px","size":15,"sizes":[]},"tab_header_padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_items":"right","align_items_mobile":"center","header_margin":{"unit":"px","size":1,"sizes":[]},"tab_typography_typography":"custom","tab_typography_font_size":{"unit":"px","size":12,"sizes":[]},"tab_typography_font_weight":"bold","tab_typography_text_transform":"uppercase","tab_typography_line_height":{"unit":"px","size":36,"sizes":[]},"tab_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"tab_title_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"border_tabs_title_border":"solid","border_tabs_title_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"navigation":"none","_margin":{"unit":"px","top":"-40","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=lighter","title_hover_color":"globals\/colors?id=accent","border_tabs_title_color":"globals\/colors?id=border","title_hover_border_color":"globals\/colors?id=primary","title_background_hover_color":"globals\/colors?id=primary","title_active_color":"globals\/colors?id=accent","title_background_active_color":"globals\/colors?id=primary","title_active_border_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"supplero-products-tabs"},{"id":"c33156b","elType":"widget","settings":{"text":"view all products","align":"center","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"_margin":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"button_text_color":"","button_background_hover_color":"","border_color":"globals\/colors?id=accent"},"border_color":"#000000","icon_button_size":{"unit":"px","size":8,"sizes":[]},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"c233256","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"da6732b","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_bg-2.jpg","id":3253},"background_position":"top center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_color":"#8A0006","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"overlay_blend_mode":"multiply","padding":{"unit":"px","top":"90","right":"0","bottom":"90","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"70","right":"0","bottom":"50","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"877e791","elType":"section","settings":{"gap":"no","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"76e58a9","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"3e55548","elType":"widget","settings":{"editor":"why choose us","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":""},"text_color":"#FFFFFFB8"},"elements":[],"widgetType":"text-editor"},{"id":"bc1d0b4","elType":"widget","settings":{"title":"Premium Quality","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":""},"title_color":"#FFFFFF"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"2d641f9","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"65","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"2fb5694","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"3045907","elType":"widget","settings":{"title_text":"High Quality Raw Materials","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do tempor.","title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_typography":"custom","_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter"},"selected_icon":{"value":"supplero-icon- supplero-icon-material","library":"supplero-icon"},"icon_size":{"unit":"px","size":60,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"dc18a3a","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"b32936a","elType":"widget","settings":{"title_text":"Top Rated And Reviewed","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do tempor.","title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_typography":"custom","_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter"},"selected_icon":{"value":"supplero-icon- supplero-icon-top-rated","library":"supplero-icon"},"icon_size":{"unit":"px","size":60,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"37ebd1a","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3db543e","elType":"widget","settings":{"title_text":"Trusted By Experts","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do tempor.","title_bottom_space":{"unit":"px","size":15,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_typography":"custom","_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter"},"selected_icon":{"value":"supplero-icon- supplero-icon-experts","library":"supplero-icon"},"icon_size":{"unit":"px","size":60,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true},{"id":"0be4822","elType":"widget","settings":{"text":"Divider","color":"#FFFFFF33","_margin":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"divider"},{"id":"cde882c","elType":"section","settings":{"gap":"no","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"084dbd6","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"4bc5a5a","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/brand_white-1.png","id":4611},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"42aced7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/brand_white-2.png","id":4612},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"e336f27"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/brand_white-3.png","id":4613},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"4ac8eb7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/brand_white-4.png","id":4614},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"16fab77"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/brand_white-5.png","id":4615},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"fc2bd94"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/brand_white-6.png","id":4616},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1b76abe"}],"column":"6","column_mobile":"3","item_spacing_mobile":{"unit":"px","size":0,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"enable_carousel":"yes","navigation":"none","item_spacing":{"unit":"px","size":0,"sizes":[]},"column_tablet":"5","item_spacing_tablet":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"supplero-brand"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"9532bb3","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"591962c","elType":"column","settings":{"_column_size":50,"_inline_size":31.782900000000001483613232267089188098907470703125,"space_between_widgets":0,"_inline_size_tablet":33,"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"02fbe3a","elType":"widget","settings":{"editor":"OUR LOCATIONS","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"a92d321","elType":"widget","settings":{"title":"Find a Store <br> Near You","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"af7e7ce","elType":"widget","settings":{"editor":"Come in and see us at one of our three Auckland stores to check out our range and get advice from our friendly team.","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":330,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=text"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"4b5587e","elType":"widget","settings":{"text":"VIEW ALL LOCATIONS","align":"left","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"_margin":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"button_text_color":"","button_background_hover_color":"","border_color":"globals\/colors?id=accent"},"border_color":"#000000","align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"6bf44f6","elType":"column","settings":{"_column_size":50,"_inline_size":68.2169999999999987494447850622236728668212890625,"space_between_widgets":0,"_inline_size_tablet":67,"content_position":"bottom"},"elements":[{"id":"7ccad82","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h3_banner-1.jpg","id":5216},"subtitle":"9066 Green Lake Drive Chevy, MD 20815","title":"<a href=\"tel:0180033358\">(+84)-1800-33358<\/a>","button":"Altona North","button_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"box_padding_tablet":{"unit":"px","top":"20","right":"10","bottom":"20","left":"10","isLinked":false},"box_padding_mobile":{"unit":"px","top":"20","right":"15","bottom":"20","left":"15","isLinked":false},"box_margin_tablet":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"box_margin_mobile":{"unit":"px","top":"15","right":"15","bottom":"15","left":"15","isLinked":true},"image_width":{"unit":"px","size":"","sizes":[]},"min-height_mobile":{"unit":"px","size":300,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_element_width":"initial","_element_width_mobile":"inherit","_element_custom_width":{"unit":"%","size":50,"sizes":[]}},"elements":[],"widgetType":"supplero-banner"},{"id":"2cb827f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h3_banner-2.jpg","id":5217},"subtitle":"9066 Green Lake Drive Chevy, MD 20815","title":"<a href=\"tel:0180033358\">(+84)-1800-33358<\/a>","button":"America","button_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"box_padding_tablet":{"unit":"px","top":"20","right":"10","bottom":"20","left":"10","isLinked":false},"box_padding_mobile":{"unit":"px","top":"20","right":"15","bottom":"20","left":"15","isLinked":false},"box_margin_tablet":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"box_margin_mobile":{"unit":"px","top":"15","right":"15","bottom":"15","left":"15","isLinked":true},"image_width":{"unit":"%","size":100,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width":"initial","_element_width_mobile":"inherit","_element_custom_width":{"unit":"%","size":50,"sizes":[]},"min-height_mobile":{"unit":"px","size":300,"sizes":[]}},"elements":[],"widgetType":"supplero-banner"}],"isInner":false}],"isInner":false}],"home-6":[{"id":"1f96e2a","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"20","custom_height":{"unit":"px","size":560,"sizes":[]},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"87477e5","elType":"column","settings":{"_column_size":50,"_inline_size":18.39999999999999857891452847979962825775146484375,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"30","left":"0","isLinked":false},"_inline_size_tablet":40,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"f70eab0","elType":"widget","settings":{"nav-vertiacl-config":"style-2","menu":"shop-by-categories"},"elements":[],"widgetType":"supplero-nav-vertiacl-menu"}],"isInner":false},{"id":"a48262e","elType":"column","settings":{"_column_size":50,"_inline_size":81.599999999999994315658113919198513031005859375,"space_between_widgets":0,"background_background":"slideshow","background_slideshow_gallery":[{"id":3355,"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-slider-01_optimized.png"}],"padding":{"unit":"px","top":"110","right":"110","bottom":"110","left":"210","isLinked":false},"margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_inline_size_tablet":100,"space_between_widgets_tablet":0,"padding_tablet":{"unit":"px","top":"60","right":"30","bottom":"60","left":"80","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"80","right":"15","bottom":"80","left":"15","isLinked":false}},"elements":[{"id":"c5d0ee2","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"505f20e","elType":"column","settings":{"_column_size":50,"_inline_size":50,"align_mobile":"center","space_between_widgets":0,"_inline_size_tablet":76,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets_tablet":0},"elements":[{"id":"6cdd363","elType":"widget","settings":{"editor":"<div>for elite athletes<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":25,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"8","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#0083A9","_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"4d5be36","elType":"widget","settings":{"space":{"unit":"px","size":2,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"bacbea8","elType":"widget","settings":{"title":"Changing the\ngame in sports\nnutrition","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_margin":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":430,"sizes":[]},"_element_width":"initial","_element_width_tablet":"initial","_element_width_mobile":"inherit","_element_custom_width_tablet":{"unit":"px","size":312}},"elements":[],"widgetType":"heading"},{"id":"f4ca340","elType":"widget","settings":{"editor":"<p>24g of pure protein for enhanced lean muscle.<\/p>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"__globals__":{"text_color":""},"align_mobile":"center","typography_font_weight":"300"},"elements":[],"widgetType":"text-editor"},{"id":"377f57d","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"align":"left","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"__globals__":{"hover_color":"","button_background_hover_color":"","background_color":"globals\/colors?id=primary","button_text_color":"globals\/colors?id=accent"},"button_text_color":"#000000","background_color":"#f2cb1f","hover_color":"#FFFFFF","align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"1f9bcd1","elType":"column","settings":{"_column_size":50,"_inline_size":50,"space_between_widgets":0},"elements":[],"isInner":true}],"isInner":true},{"id":"29f5276","elType":"widget","settings":{"title":"30<span style=\"font-size:25px; font-weight: 400; \" >%<\/span> <br>\nOff","title_color":"#FFFFFF","_padding":{"unit":"px","top":"35","right":"30","bottom":"35","left":"40","isLinked":false},"_background_background":"classic","_background_color":"#EF6938","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_border_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"_element_width":"initial","__globals__":{"_background_color":""},"typography_typography":"custom","typography_font_weight":"bold","typography_text_transform":"uppercase","_element_custom_width":{"unit":"px","size":130,"sizes":[]},"_position":"absolute","_offset_x":{"size":929,"unit":"px"},"_offset_y":{"size":-47,"unit":"px"},"_offset_x_tablet":{"size":59.98400000000000176214598468504846096038818359375,"unit":"%"},"_offset_y_tablet":{"size":-33,"unit":"px"},"typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":25,"sizes":[]},"_padding_tablet":{"unit":"px","top":"30","right":"15","bottom":"30","left":"35","isLinked":false},"_padding_mobile":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":true},"_element_width_mobile":"initial","_offset_x_mobile":{"size":73,"unit":"%"},"_offset_y_mobile":{"size":-20,"unit":"%"}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"09fd4a1","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"912111f","elType":"column","settings":{"_column_size":50,"_inline_size":18.39999999999999857891452847979962825775146484375,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"c84126f","elType":"widget","settings":{"title":"Deals This Week","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_background_background":"classic","_background_color":"#FFFFFF","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"3","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=secondary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"9e42411","elType":"widget","settings":{"limit":3,"column":"1","order":"asc","product_layout":"list","list_layout":"4","enable_carousel":"yes","navigation":"arrows","style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-7,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":7,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-7,"sizes":[]},"prev_horizontal":"right","prev_horizontal_value":{"unit":"%","size":17,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border","title_color":"globals\/colors?id=accent"},"product_type":"on_sale","products_time_title_typography_typography":"custom","products_time_title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"padding_time_sale":{"unit":"px","top":"8","right":"30","bottom":"8","left":"30","isLinked":false},"time_sale_spacing":{"unit":"px","size":25,"sizes":[]},"title_sale_spacing":{"unit":"px","size":14,"sizes":[]}},"elements":[],"widgetType":"supplero-products"},{"id":"94fd9e2","elType":"widget","settings":{"title":"Pick For You","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_background_background":"classic","_background_color":"#FFFFFF","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"3","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=primary"},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"9abb344","elType":"widget","settings":{"limit":4,"column":"1","product_layout":"list","navigation":"arrows","style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-6,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":0,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-6,"sizes":[]},"prev_horizontal":"right","prev_horizontal_value":{"unit":"%","size":15,"sizes":[]},"_css_classes":"supplero-box-clip","_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"_padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_background_background":"classic","_background_color":"#FFFFFF"},"elements":[],"widgetType":"supplero-products"},{"id":"769057d","elType":"widget","settings":{"title":"Special Offers","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_background_background":"classic","_background_color":"#FFFFFF","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"3","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=primary"},"_margin":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"f47c805","elType":"widget","settings":{"limit":4,"column":"1","product_layout":"list","navigation":"arrows","style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-6,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":0,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-6,"sizes":[]},"prev_horizontal":"right","prev_horizontal_value":{"unit":"%","size":15,"sizes":[]},"_css_classes":"supplero-box-clip","_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"_padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_background_background":"classic","_background_color":"#FFFFFF"},"elements":[],"widgetType":"supplero-products"}],"isInner":false},{"id":"733d03d","elType":"column","settings":{"_column_size":50,"_inline_size":81.599999999999994315658113919198513031005859375,"space_between_widgets":0,"background_color":"#FFFFFF","margin":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"533ba6e","elType":"widget","settings":{"title":"Most Popular","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_background_background":"classic","_background_color":"#FFFFFF","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"90af4ec","elType":"widget","settings":{"column":"5","enable_carousel":"yes","navigation":"arrows","product_gutter":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":false},"_background_background":"classic","_background_color":"#FFFFFF","_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-19,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":1,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-19,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value":{"unit":"%","size":95,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"next_vertical_value_mobile":{"unit":"%","size":35,"sizes":[]},"next_horizontal_value_mobile":{"unit":"%","size":-8,"sizes":[]},"prev_vertical_value_mobile":{"unit":"%","size":35,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"%","size":-8,"sizes":[]},"next_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"prev_horizontal_value_tablet":{"unit":"%","size":90,"sizes":[]},"column_tablet":"3","next_vertical_value_tablet":{"unit":"%","size":-22,"sizes":[]},"prev_vertical_value_tablet":{"unit":"%","size":-22,"sizes":[]},"icon_size":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"supplero-products"},{"id":"15f3204","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"30","margin":{"unit":"px","top":"30","right":0,"bottom":"30","left":0,"isLinked":false},"__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"z_index":0,"overflow":"hidden","margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"629d527","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d010074","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":250,"sizes":[]},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-layout-11.png","id":1425},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_hover_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-layout-11.png","id":1425},"background_hover_position":"center right","background_hover_repeat":"no-repeat","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"60","bottom":"0","left":"60","isLinked":false},"motion_fx_translateY_effect":"yes","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_overlay_hover_background":"classic","margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"d2da34c","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"%","top":"14","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[{"id":"f2a3f5e","elType":"widget","settings":{"editor":"<div>Exclusive items<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"3536d82","elType":"widget","settings":{"title":"members","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"edcc185","elType":"widget","settings":{"title":"save","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"e95afe6","elType":"widget","settings":{"title":"10% more","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"5","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=primary"},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"1a356e3","elType":"widget","settings":{"text":"join us ","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"text_padding":{"unit":"px","top":"8","right":"16","bottom":"8","left":"16","isLinked":false},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","__globals__":{"background_color":"","button_background_hover_color":"","hover_color":""},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":true},{"id":"18ab67d","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"z_index":0,"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"z_index_tablet":0,"space_between_widgets_tablet":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"73b588e","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":250,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-3.jpg","id":1315},"background_position":"center center","background_repeat":"no-repeat","background_size":"auto","background_hover_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-layout-22.png","id":1435},"background_hover_position":"center left","background_hover_repeat":"no-repeat","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"background_overlay_background":"classic","background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_size_tablet":"cover","margin_tablet":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"z_index":0,"z_index_tablet":2,"reverse_order_tablet":"reverse-tablet","custom_height_inner_tablet":{"unit":"px","size":415,"sizes":[]},"overflow":"hidden","background_repeat_tablet":"no-repeat","reverse_order_mobile":"reverse-mobile","margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"55df110","elType":"column","settings":{"_column_size":50,"_inline_size":50,"_inline_size_tablet":100,"content_position":"center","content_position_tablet":"center","space_between_widgets_tablet":0,"space_between_widgets":0},"elements":[{"id":"4947063","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-3-1.png","id":1311},"image_size":"full","align_tablet":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-40","isLinked":false},"_margin_tablet":{"unit":"px","top":"10","right":"0","bottom":"8","left":"0","isLinked":false},"_z_index":2,"width":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"235f991","elType":"column","settings":{"_column_size":50,"_inline_size":50,"space_between_widgets":0,"margin":{"unit":"%","top":"","right":"","bottom":"","left":"","isLinked":true},"_inline_size_tablet":100,"padding_tablet":{"unit":"px","top":"50","right":"40","bottom":"10","left":"90","isLinked":false},"space_between_widgets_tablet":0,"padding":{"unit":"%","top":"20","right":"0","bottom":"22","left":"10","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true}},"elements":[{"id":"bdc01f4","elType":"widget","settings":{"editor":"<div>New in<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"c4c056b","elType":"widget","settings":{"title":"Truth In\n","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"839611f","elType":"widget","settings":{"title":"\nEvery Bottle","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"ee552f5","elType":"widget","settings":{"title":"10% Off first order","title_color":"#00AAEE","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":""},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"97949df","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"align":"left","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"text_padding":{"unit":"px","top":"8","right":"15","bottom":"8","left":"15","isLinked":false},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","__globals__":{"hover_color":"","button_background_hover_color":""},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":true},{"id":"8ba6fdd","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"_inline_size_tablet":50,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[{"id":"221729b","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":250,"sizes":[]},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-2.jpg","id":2056},"background_position":"center center","background_repeat":"no-repeat","background_size":"auto","background_hover_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-layout-33.png","id":1436},"background_hover_position":"center right","background_hover_repeat":"no-repeat","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"structure":"20","background_motion_fx_motion_fx_scrolling":"yes","background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"custom_height_inner_tablet":{"unit":"px","size":415,"sizes":[]},"overflow":"hidden","background_repeat_tablet":"no-repeat","background_size_tablet":"cover","margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"915ad7a","elType":"column","settings":{"_column_size":50,"_inline_size":60,"space_between_widgets":0,"margin":{"unit":"%","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"40","bottom":"10","left":"90","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"%","top":"17","right":"0","bottom":"18","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"z_index":0},"elements":[{"id":"0130b6f","elType":"widget","settings":{"editor":"<div>Clearance<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"fa2222d","elType":"widget","settings":{"title":"Reload","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"edd3962","elType":"widget","settings":{"title":"Supplements","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"b99b775","elType":"widget","settings":{"title":"20% Off","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=primary"},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"1a12cc9","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"text_padding":{"unit":"px","top":"8","right":"15","bottom":"8","left":"15","isLinked":false},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","__globals__":{"hover_color":"","button_background_hover_color":""},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"f377bf7","elType":"column","settings":{"_column_size":50,"_inline_size":40,"space_between_widgets":0,"_inline_size_tablet":100,"content_position":"center"},"elements":[{"id":"09002af","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-layout-3.png","id":1698},"image_size":"full","_margin":{"unit":"px","top":"0","right":"-50","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":true}],"isInner":true},{"id":"3460cf9","elType":"widget","settings":{"title":"New Arrivals","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_background_background":"classic","_background_color":"#FFFFFF","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"2305031","elType":"widget","settings":{"column":"5","enable_carousel":"yes","navigation":"arrows","product_gutter":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"_background_background":"classic","_background_color":"#FFFFFF","_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-19,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":1,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-19,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value":{"unit":"%","size":95,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"next_vertical_value_mobile":{"unit":"%","size":35,"sizes":[]},"next_horizontal_value_mobile":{"unit":"%","size":-8,"sizes":[]},"prev_vertical_value_mobile":{"unit":"%","size":35,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"%","size":-8,"sizes":[]},"next_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"prev_horizontal_value_tablet":{"unit":"%","size":90,"sizes":[]},"column_tablet":"3","next_vertical_value_tablet":{"unit":"%","size":-22,"sizes":[]},"prev_vertical_value_tablet":{"unit":"%","size":-22,"sizes":[]},"icon_size":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"supplero-products"},{"id":"9113993","elType":"section","settings":{"layout":"full_width","gap":"no","custom_height_inner":{"unit":"px","size":240,"sizes":[]},"structure":"40","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_bg-2.jpg","id":1330},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_mouseTrack_effect":"yes","background_position_tablet":"center right","background_size_tablet":"auto","background_size_mobile":"cover","padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"30","left":"15","isLinked":false},"margin":{"unit":"px","top":"30","right":0,"bottom":"30","left":0,"isLinked":false},"height_inner":"min-height","html_tag":"div"},"elements":[{"id":"1f687c5","elType":"column","settings":{"_column_size":25,"_inline_size":22.60000000000000142108547152020037174224853515625,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_img-1.png","id":1334},"background_position":"center left","background_repeat":"no-repeat","background_size":"auto","hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","content_position":"center"},"elements":[{"id":"891c684","elType":"widget","settings":{"space":{"unit":"px","size":150,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"494813a","elType":"column","settings":{"_column_size":25,"_inline_size":23.553999999999998493649400188587605953216552734375,"content_position":"center","space_between_widgets":0,"_inline_size_tablet":38,"content_position_tablet":"center","align_mobile":"center","space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"40","right":"10","bottom":"40","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"ba75d39","elType":"widget","settings":{"editor":"<div>end of month sale<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":25,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"5","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#D43B3B","_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"cc27560","elType":"widget","settings":{"title":"Whey Protein at\nAmazing Prices","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":36,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"_margin":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"b234b97","elType":"column","settings":{"_column_size":25,"_inline_size":15.8879999999999999005240169935859739780426025390625,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":22,"content_position_tablet":"center","align_mobile":"center","margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"e05cd75","elType":"widget","settings":{"space":{"unit":"px","size":40,"sizes":[]},"space_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"76ff19d","elType":"widget","settings":{"title":"Starting at ","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":36,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"11d4c08","elType":"widget","settings":{"title":"$199.00 ","title_color":"#61CC60","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"3c247b8","elType":"column","settings":{"_column_size":25,"_inline_size":37.9560000000000030695446184836328029632568359375,"space_between_widgets":0,"padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"_inline_size_tablet":40,"content_position":"center","content_position_tablet":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets_tablet":0},"elements":[{"id":"e71ad01","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_img-2.png","id":1389},"image_size":"full","align":"left","motion_fx_mouseTrack_effect":"yes","motion_fx_translateX_effect":"yes","motion_fx_mouseTrack_speed":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true},{"id":"083ee53","elType":"widget","settings":{"title":"Best Seller","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":60,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_background_background":"classic","_background_color":"#FFFFFF","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","_border_color":"globals\/colors?id=border"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"461ae6f","elType":"widget","settings":{"column":"5","enable_carousel":"yes","navigation":"arrows","product_gutter":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":true},"_background_background":"classic","_background_color":"#FFFFFF","_margin_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"style_arrow":"style-2","next_vertical":"top","next_vertical_value":{"unit":"%","size":-19,"sizes":[]},"next_horizontal":"right","next_horizontal_value":{"unit":"%","size":1,"sizes":[]},"prev_vertical":"top","prev_vertical_value":{"unit":"%","size":-19,"sizes":[]},"prev_horizontal":"left","prev_horizontal_value":{"unit":"%","size":95,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"next_vertical_value_mobile":{"unit":"%","size":35,"sizes":[]},"next_horizontal_value_mobile":{"unit":"%","size":-8,"sizes":[]},"prev_vertical_value_mobile":{"unit":"%","size":35,"sizes":[]},"prev_horizontal_value_mobile":{"unit":"%","size":-8,"sizes":[]},"next_horizontal_value_tablet":{"unit":"%","size":"","sizes":[]},"prev_horizontal_value_tablet":{"unit":"%","size":90,"sizes":[]},"column_tablet":"3","next_vertical_value_tablet":{"unit":"%","size":-22,"sizes":[]},"prev_vertical_value_tablet":{"unit":"%","size":-22,"sizes":[]},"icon_size":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"1b2c484","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"80","right":0,"bottom":"80","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"20","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"1e8d807","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"f699bbe","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-1.png","id":934},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"56d9677"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-2.png","id":935},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"47acec8"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-3.png","id":936},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"58fa0c4"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-4.png","id":937},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"ff561a7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-5.png","id":938},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"8410606"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-6.png","id":939},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"08e8f69"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-brand-7.png","id":1598},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1ee6c77"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h6-brand-08.png","id":1601},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"d7ef879"}],"column":"6","image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"enable_carousel":"yes","navigation":"none","_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"autoplay_speed":4000,"column_mobile":"3","column_tablet":"5","brand_align_tablet":"center","brand_align_mobile":"center","item_spacing_mobile":{"unit":"px","size":0,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"5","bottom":"0","left":"5","isLinked":false},"item_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"supplero-brand"}],"isInner":false}],"isInner":false},{"id":"ef1f2d8","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"50","padding":{"unit":"px","top":"40","right":"30","bottom":"40","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"background_background":"classic","background_color":"#FFFFFF","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"0","left":"30","isLinked":false},"html_tag":"div"},"elements":[{"id":"c182363","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"content_position":"center","_inline_size_tablet":35,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"10","isLinked":false}},"elements":[{"id":"b8982d2","elType":"widget","settings":{"title_text":"FREE Shipping","description_text":"On all orders over $50 delivered<br>\n within Australia. ","position":"left","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter","hover_primary_color":"globals\/colors?id=secondary_hover"},"selected_icon":{"value":"supplero-icon- supplero-icon-shipping-fast","library":"supplero-icon"},"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"icon_space":{"unit":"px","size":20,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"8377e34","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":33,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false}},"elements":[{"id":"6f7b1c3","elType":"widget","settings":{"title_text":"International Delivery ","description_text":"International delivery available. ","position":"left","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter","hover_primary_color":"globals\/colors?id=secondary_hover"},"selected_icon":{"value":"supplero-icon- supplero-icon-globe-asia","library":"supplero-icon"},"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"icon_space":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"f586162","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"content_position":"center","_inline_size_tablet":31,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false}},"elements":[{"id":"cc2112a","elType":"widget","settings":{"title_text":"Easy Returns","description_text":" We make exchanging and<br> returning simple. ","position":"left","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter","hover_primary_color":"globals\/colors?id=secondary_hover"},"selected_icon":{"value":"supplero-icon- supplero-icon-undo-alt","library":"supplero-icon"},"icon_size":{"unit":"px","size":40,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"icon_space":{"unit":"px","size":20,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"1c3b835","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_tablet":"flex-end","space_between_widgets_tablet":0},"elements":[{"id":"58b3e1a","elType":"widget","settings":{"title_text":"Delivery Insurance","description_text":" Insurance on shipping included. ","position":"left","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter","hover_primary_color":"globals\/colors?id=secondary_hover"},"selected_icon":{"value":"supplero-icon- supplero-icon-box-alt","library":"supplero-icon"},"icon_size":{"unit":"px","size":40,"sizes":[]},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":250,"sizes":[]},"_element_width_mobile":"inherit","icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"icon_space":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"f98073f","elType":"column","settings":{"_column_size":20,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"align":"center","_inline_size_tablet":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"content_position":"center"},"elements":[{"id":"fdac529","elType":"widget","settings":{"title_text":"Premium Quality","description_text":"100% Guaranteed Original <br>Products","position":"left","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=lighter","hover_primary_color":"globals\/colors?id=secondary_hover"},"selected_icon":{"value":"supplero-icon- supplero-icon-medal","library":"supplero-icon"},"icon_size":{"unit":"px","size":40,"sizes":[]},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":250,"sizes":[]},"_element_width_mobile":"inherit","icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"icon_space":{"unit":"px","size":20,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false}],"home-2":[{"id":"e9fc4c6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"20","right":"30","bottom":"20","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"15","bottom":"10","left":"15","isLinked":false},"structure":"40","hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"5a8dcfd","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d819dcd","elType":"widget","settings":{"icon_list":[{"text":"Low price guarantee","selected_icon":{"value":"supplero-icon- supplero-icon-credit-card","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_tablet":"right","icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"890de41","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4149462","elType":"widget","settings":{"icon_list":[{"text":"30 day online returns","selected_icon":{"value":"supplero-icon- supplero-icon-history","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"0ec4cf8","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"7871f26","elType":"widget","settings":{"icon_list":[{"text":"Free delivery worldwide","selected_icon":{"value":"supplero-icon- supplero-icon-truck","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_tablet":"right","icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"084784f","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"314dc28","elType":"widget","settings":{"icon_list":[{"text":"Ask our experts: <a href=\"tel:18883335226\">1-888-333-5226<\/a>","selected_icon":{"value":"supplero-icon- supplero-icon-phone-rotary","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"3bb556c","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"0405faf","elType":"column","settings":{"_column_size":50,"_inline_size":69.1666666999999932841092231683433055877685546875,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-1.jpg","id":1219},"background_size":"cover","background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"0","bottom":"80","left":"0","isLinked":false},"background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"content_position":"center","align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"background_position":"center center","background_repeat":"no-repeat"},"elements":[{"id":"9bcca54","elType":"section","settings":{"content_width":{"unit":"px","size":1015,"sizes":[]},"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"6605ae9","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"70","isLinked":false},"z_index":2,"_inline_size_tablet":100,"align_mobile":"center","margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"70","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"7f882dd","elType":"widget","settings":{"title":"which is your favourite?","header_size":"span","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"8","bottom":"0","left":"8","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#004D1B","_element_width":"auto","__globals__":{"_background_color":""}},"elements":[],"widgetType":"heading"},{"id":"9b5ea51","elType":"widget","settings":{"space":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"69778ff","elType":"widget","settings":{"title":"Recipes for athletic performance","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_element_width_tablet":"initial","_element_custom_width_tablet":{"unit":"px","size":390,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"d8b7240","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","__globals__":{"style_button_hover_background":"globals\/colors?id=primary","hover_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"f3f4ede","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","align":"center","space_between_widgets":0,"_inline_size_tablet":100,"_inline_size_mobile":93,"align_mobile":"center","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false}},"elements":[{"id":"385ae35","elType":"widget","settings":{"title":"<span style=\"font-size:14px;\">from<\/span> <br> $69.99","header_size":"h4","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"26","right":"15","bottom":"35","left":"15","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#DD3F37","_border_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"_element_width":"auto","_position":"absolute","_offset_orientation_h":"end","motion_fx_mouseTrack_effect":"yes","motion_fx_mouseTrack_speed":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"075baf9","elType":"widget","settings":{"space":{"unit":"px","size":250,"sizes":[]},"space_mobile":{"unit":"px","size":180,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"bde3b27","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-1-1.png","id":1241},"image_size":"full","_element_width":"initial","_element_custom_width":{"unit":"px","size":373,"sizes":[]},"_position":"absolute","_offset_orientation_h":"end","_offset_x":{"size":-1,"unit":"px"},"_offset_x_end":{"unit":"px","size":"","sizes":[]},"_offset_y":{"size":-64,"unit":"px"},"motion_fx_translateY_effect":"yes","motion_fx_translateY_direction":"negative","motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"width_tablet":{"unit":"px","size":300,"sizes":[]},"width_mobile":{"unit":"px","size":200,"sizes":[]},"_offset_x_end_tablet":{"size":"","unit":"px"},"_offset_x_end_mobile":{"unit":"px","size":0,"sizes":[]},"_offset_y_tablet":{"size":-45.23400000000000176214598468504846096038818359375,"unit":"px"}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"17da445","elType":"column","settings":{"_column_size":50,"_inline_size":30.832999999999998408384271897375583648681640625,"space_between_widgets":0,"z_index":2},"elements":[{"id":"c12325f","elType":"section","settings":{"content_width":{"unit":"px","size":435,"sizes":[]},"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":205,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-2.jpg","id":1277},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_direction":"negative","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","padding":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"content_position":"middle","background_motion_fx_devices":["desktop","tablet"],"margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"d8cf16b","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"86a3454","elType":"widget","settings":{"editor":"Available now","text_color":"#FFFFFF","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"ed15f4a","elType":"widget","settings":{"title":"Whey Protein <br> Power Blend","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"62aa917","elType":"widget","settings":{"editor":"Starting at  $199.00 ","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=primary"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"1ccea79","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"size":"xs","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","_z_index":2,"icon_button_size":{"unit":"px","size":8,"sizes":[]},"style_button_hover_background":"#f2cb1f","__globals__":{"button_background_hover_color":"","style_button_hover_background":"globals\/colors?id=primary","button_text_color":"","hover_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"6c67430","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":100},"elements":[{"id":"13d3e9f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-2-1.png","id":1292},"image_size":"full","width_tablet":{"unit":"px","size":120,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true},{"id":"4a38512","elType":"section","settings":{"content_width":{"unit":"px","size":505,"sizes":[]},"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":205,"sizes":[]},"structure":"20","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-3.jpg","id":1315},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","padding":{"unit":"px","top":"30","right":"15","bottom":"30","left":"15","isLinked":false},"content_position":"middle","background_motion_fx_devices":["desktop","tablet"],"reverse_order_tablet":"reverse-tablet","reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"a5ad8ef","elType":"column","settings":{"_column_size":50,"_inline_size":59.99799999999999755573298898525536060333251953125,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":100},"elements":[{"id":"e7f0f6f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_banner-3-1.png","id":1311},"image_size":"full","width_tablet":{"unit":"px","size":120,"sizes":[]},"align":"left"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"0408f7a","elType":"column","settings":{"_column_size":50,"_inline_size":40,"space_between_widgets":0,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"c4963b1","elType":"widget","settings":{"editor":"New in","text_color":"#FFFFFF","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"52f5cd2","elType":"widget","settings":{"title":"Truth In <br> Every Bottle","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"e790dae","elType":"widget","settings":{"editor":"10% Off first order","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":""},"text_color":"#00AAEE","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"3bb7431","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"size":"xs","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","_z_index":2,"icon_button_size":{"unit":"px","size":8,"sizes":[]},"__globals__":{"hover_color":"globals\/colors?id=accent","style_button_hover_background":"globals\/colors?id=primary"}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"1777fb7","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"2805c02","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"border_color":"#E3E3E3","padding":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"34f230f","elType":"widget","settings":{"editor":"Proud to partner with","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"align":"center","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"8ace7f6","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-1.png","id":934},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"42aced7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-2.png","id":935},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"e336f27"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-3.png","id":936},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"4ac8eb7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-4.png","id":937},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"16fab77"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-6.png","id":939},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"fc2bd94"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-5.png","id":938},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1b76abe"}],"column":"6","column_mobile":"3","item_spacing_mobile":{"unit":"px","size":0,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"enable_carousel":"yes","navigation":"none","item_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"supplero-brand"}],"isInner":false}],"isInner":false},{"id":"7cd3947","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"b646db3","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"0093339","elType":"widget","settings":{"editor":"Products in Focus","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"a18d2a2","elType":"widget","settings":{"title":"Top Selling","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"1b56ab7","elType":"widget","settings":{"column":"3","column_tablet":"2","column_mobile":"1","product_gutter":{"unit":"px","size":30,"sizes":[]},"product_gutter_mobile":{"unit":"px","size":15,"sizes":[]},"grid_layout_special":"yes","order":"asc","product_layout":"list","list_layout":"3","limit":5},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"5e7c4c3","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"4daa09a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_bg-1.jpg","id":1162},"background_repeat":"no-repeat","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"padding":{"unit":"px","top":"70","right":"0","bottom":"70","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"background_position":"center center","background_size":"cover","background_overlay_background":"classic","background_overlay_color":"#8A0006","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"overlay_blend_mode":"multiply"},"elements":[{"id":"4b5c50b","elType":"section","settings":{"gap":"no","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"75574ce","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"a540b33","elType":"widget","settings":{"editor":"popular categories","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"align":"center","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":""},"align_mobile":"center","text_color":"#FFFFFFB8"},"elements":[],"widgetType":"text-editor"},{"id":"05db9ba","elType":"widget","settings":{"title":"Shop by Category","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":""},"align_mobile":"center","title_color":"#FFFFFF","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"143f36c","elType":"widget","settings":{"categories_list":[{"_id":"f002bc7","categories":"creatine","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h2_ct-1.jpg","id":4521}},{"categories":"endurance-energy","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h2_ct-2.jpg","id":4522},"_id":"e47e4db"},{"categories":"hot-offers","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h2_ct-3.jpg","id":4523},"_id":"723985c"},{"categories":"vegan-nutrition","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h2_ct-4.jpg","id":4524},"_id":"3ce9e4e"},{"categories":"weight-gainers","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-10.jpg","id":2540},"_id":"8ffce3d"}],"product_cate_layout":"2","column":"4","enable_carousel":"yes","image_height":{"unit":"px","size":230,"sizes":[]}},"elements":[],"widgetType":"supplero-product-categories"},{"id":"bc45220","elType":"widget","settings":{"categories":"accusantium","categories_list":[]},"elements":[],"widgetType":"supplero-product-categories"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"0850cbd","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"4090042","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_repeat":"no-repeat","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"padding":{"unit":"px","top":"70","right":"0","bottom":"90","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"background_color":"#FFFFFF","background_position":"center center","background_size":"cover","background_overlay_background":"classic"},"elements":[{"id":"4a81b20","elType":"section","settings":{"gap":"no","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"d258abb","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"d7287a9","elType":"widget","settings":{"editor":"<p>Latest Added<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"align":"center","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"da1ec3b","elType":"widget","settings":{"title":"New Arrivals","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"fd3d438","elType":"widget","settings":{"limit":12,"column":"6","column_tablet":"3","column_mobile":"2","product_gutter":{"unit":"px","size":30,"sizes":[]},"product_gutter_mobile":{"unit":"px","size":15,"sizes":[]},"enable_carousel":"yes"},"elements":[],"widgetType":"supplero-products"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"83a5bf4","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_overlay_background":"classic","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"b152161","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_bg-2.jpg","id":1330},"background_position":"center center","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_color":"#1D212D","background_overlay_opacity":{"unit":"px","size":0.440000000000000002220446049250313080847263336181640625,"sizes":[]}},"elements":[{"id":"c7ac9e6","elType":"section","settings":{"gap":"no","content_position":"middle","structure":"40","padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"0b29ab1","elType":"column","settings":{"_column_size":25,"_inline_size":20.92999999999999971578290569595992565155029296875,"_inline_size_tablet":100,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_img-1.png","id":1334},"background_position":"center left","background_position_tablet":"center right","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","background_repeat":"no-repeat"},"elements":[{"id":"871de0f","elType":"widget","settings":{"space":{"unit":"px","size":150,"sizes":[]},"space_tablet":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"69e3b85","elType":"column","settings":{"_column_size":25,"_inline_size":25.81400000000000005684341886080801486968994140625,"_inline_size_tablet":40,"align_mobile":"center","space_between_widgets":0,"padding":{"unit":"px","top":"50","right":"20","bottom":"60","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"962e3ca","elType":"widget","settings":{"title":"end of month sale","header_size":"span","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"8","bottom":"0","left":"8","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#DD3F37","_element_width":"auto","__globals__":{"_background_color":""}},"elements":[],"widgetType":"heading"},{"id":"3cba116","elType":"widget","settings":{"title":"Whey Protein at Amazing Prices","align_mobile":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":36,"sizes":[]},"__globals__":{"title_color":""},"_margin":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"bdb6bd3","elType":"column","settings":{"_column_size":25,"_inline_size":13.67999999999999971578290569595992565155029296875,"_inline_size_tablet":18,"content_position":"bottom","align":"flex-end","space_between_widgets":0,"padding":{"unit":"px","top":"50","right":"0","bottom":"60","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"79db7f3","elType":"widget","settings":{"editor":"Starting at ","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":""},"align_mobile":"center","text_color":"#FFFFFF","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"363c2c5","elType":"widget","settings":{"editor":"$199.00 ","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"700","__globals__":{"text_color":""},"align_mobile":"center","text_color":"#61CC60","typography_line_height":{"unit":"px","size":35,"sizes":[]}},"elements":[],"widgetType":"text-editor"}],"isInner":true},{"id":"9243acb","elType":"column","settings":{"_column_size":25,"_inline_size":39.57600000000000051159076974727213382720947265625,"_inline_size_tablet":42,"space_between_widgets":0,"padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"50","left":"15","isLinked":false}},"elements":[{"id":"e786ca0","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_img-2.png","id":1389},"image_size":"full","motion_fx_mouseTrack_effect":"yes","motion_fx_mouseTrack_speed":{"unit":"px","size":0.299999999999999988897769753748434595763683319091796875,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"3063762","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"9f77a36","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"794027a","elType":"widget","settings":{"editor":"testimonials ","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"5d91df7","elType":"widget","settings":{"title":"What Customer Say","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"ce9d91d","elType":"section","settings":{"gap":"no","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"content_position":"middle","html_tag":"div"},"elements":[{"id":"f1ace1a","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_video-1.jpg","id":1129},"padding":{"unit":"px","top":"150","right":"0","bottom":"150","left":"0","isLinked":false}},"elements":[{"id":"220b5a3","elType":"widget","settings":{"video_link":"https:\/\/www.youtube.com\/watch?v=XHOmBV4js_E","icon_font":{"value":"fab fa-youtube","library":"fa-brands"},"video_size":{"unit":"px","size":50,"sizes":[]},"video_width":{"unit":"px","size":20,"sizes":[]},"video_height":{"unit":"px","size":20,"sizes":[]},"video_background_color":"#FFFFFF","__globals__":{"video_color":"","video_hover_background_color":""},"video_color":"#FF0000","video_hover_background_color":"#000000"},"elements":[],"widgetType":"supplero-video-popup"}],"isInner":true},{"id":"a47a6ae","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h2_video-2.jpg","id":1130},"padding":{"unit":"px","top":"150","right":"0","bottom":"150","left":"0","isLinked":false}},"elements":[{"id":"e6df82c","elType":"widget","settings":{"video_link":"https:\/\/www.youtube.com\/watch?v=XHOmBV4js_E","icon_font":{"value":"fab fa-youtube","library":"fa-brands"},"video_size":{"unit":"px","size":50,"sizes":[]},"video_width":{"unit":"px","size":20,"sizes":[]},"video_height":{"unit":"px","size":20,"sizes":[]},"video_background_color":"#FFFFFF","__globals__":{"video_color":""},"video_color":"#FF0000","video_hover_background_color":"#000000"},"elements":[],"widgetType":"supplero-video-popup"}],"isInner":true}],"isInner":true},{"id":"5e9a04b","elType":"widget","settings":{"testimonials":[{"testimonial_content":"\u201cDiscount Supplements is probably the best protein supplement company in the UK in every respect. Thoroughly recommended.\u201d","testimonial_name":"Ken Haywood ","testimonial_job":"Cunningham Store","_id":"7d06daa","testimonial_rating":5},{"testimonial_content":"\u201cGood product good price prompt efficient service. Gives you energy to workout harder and longer. Many thanks for your help.\u201d ","testimonial_name":"Brian G. Moore  ","testimonial_job":"Gym Mod","_id":"2c66ebb","testimonial_rating":5},{"testimonial_content":"\"I am completely blown away. Gym, fitness saved my business. Gym, fitness is great. If you aren\'t sure, always go for gym, fitness.\"","testimonial_name":"John Stone ","testimonial_job":"Fitness Club","_id":"a98dc5c","testimonial_rating":5}],"column":"3","padding_estimonial_wrapper":{"unit":"px","top":"40","right":"40","bottom":"40","left":"40","isLinked":true},"color_testimonial_wrapper":"#FFFFFF","column_tablet":"2","margin_testimonial_wrapper_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"testimonial_alignment":"left","enable_carousel":"yes"},"elements":[],"widgetType":"supplero-testimonials"}],"isInner":false}],"isInner":false}],"footerbuilder-4":[{"id":"88683d5","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"60","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"80","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"20","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"ce61e9a","elType":"column","settings":{"_column_size":16,"_inline_size":21,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"40","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"89a529c","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo-3.svg","id":291},"image_size":"full","align":"left","width":{"unit":"px","size":125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"image"},{"id":"d7297bf","elType":"widget","settings":{"editor":"<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"1999b4d","elType":"widget","settings":{"icon_list":[{"text":"9066 Green Lake Drive Chevy, MD 20815","_id":"055c902","selected_icon":{"value":"supplero-icon- supplero-icon-map-marker","library":"supplero-icon"}}],"text_color":"#FFFFFF","icon_align_mobile":"center","icon_color":"#FFFFFF","__globals__":{"icon_color_hover":"globals\/colors?id=primary","text_color_hover":"globals\/colors?id=primary"}},"elements":[],"widgetType":"icon-list"},{"id":"bc7cc94","elType":"widget","settings":{"icon_list":[{"text":"(+84)-1800-33358","selected_icon":{"value":"","library":""},"_id":"055c902","link":{"url":"Tel:(+84)-1800-33358","is_external":"","nofollow":"","custom_attributes":""}}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":24,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_line_height":{"unit":"px","size":48,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":-0.59999999999999997779553950749686919152736663818359375,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary","text_color_hover":"globals\/colors?id=primary_hover"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"},{"id":"8946c70","elType":"widget","settings":{"icon_list":[{"text":"contact@example.com","selected_icon":{"value":"far fa-envelope","library":"fa-regular"},"_id":"055c902","link":{"url":"gmail:contact@example.com","is_external":"","nofollow":"","custom_attributes":""}}],"icon_color":"#FFFFFF","text_color":"#FFFFFF","icon_align_mobile":"center","__globals__":{"text_color_hover":"globals\/colors?id=primary","icon_color_hover":"globals\/colors?id=primary"}},"elements":[],"widgetType":"icon-list"},{"id":"7f88e03","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"09e0e99","link":{"url":"https:\/\/www.facebook.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"9e621af","link":{"url":"https:\/\/www.youtube.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"eb0ff73","link":{"url":"https:\/\/twitter.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"_id":"388889b","social_icon":{"value":"fab fa-instagram","library":"fa-brands"},"link":{"url":"https:\/\/www.instagram.com\/","is_external":"true","nofollow":"","custom_attributes":""}}],"align":"left","icon_color":"custom","icon_primary_color":"#02010100","icon_secondary_color":"#4C5764","icon_size":{"unit":"px","size":15,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-8","isLinked":false},"__globals__":{"hover_secondary_color":"globals\/colors?id=primary"},"align_mobile":"center"},"elements":[],"widgetType":"social-icons"}],"isInner":false},{"id":"f4c7114","elType":"column","settings":{"_column_size":16,"_inline_size":16,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":30,"space_between_widgets_tablet":0,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"a602039","elType":"widget","settings":{"title":"Customer Service","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.20000000000000017763568394002504646778106689453125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=text"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"ed0309e","elType":"widget","settings":{"icon_list":[{"text":"Informed Sport","selected_icon":{"value":"","library":""},"_id":"c9ca7b0","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/fast-food-choices-influence-kids-soda-and-calorie-consumption-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Loyalty points","selected_icon":{"value":"","library":""},"_id":"2ea89c1","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/new-report-abortions-in-us-drop-to-lowest-level-since-1974-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Testimonials","selected_icon":{"value":"","library":""},"_id":"17e5eea","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/many-doctors-use-wrong-test-to-diagnose-kids-food-allergies\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Expert Panel","selected_icon":{"value":"","library":""},"_id":"0384224","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product\/enormous-wooden-pants\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":5,"sizes":[]},"text_indent":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"9bab395","elType":"column","settings":{"_column_size":16,"_inline_size":14,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":20,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"833cc3b","elType":"widget","settings":{"title":"Information","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.20000000000000017763568394002504646778106689453125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=text"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"09bf242","elType":"widget","settings":{"icon_list":[{"text":"About us","selected_icon":{"value":"","library":""},"_id":"c9ca7b0","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/about-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Blog","selected_icon":{"value":"","library":""},"_id":"2ea89c1","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/blog\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Check out","selected_icon":{"value":"","library":""},"_id":"17e5eea","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/more-than-half-of-older-americans-skip-dental-checkups-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"_id":"0384224","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Service","selected_icon":{"value":"","library":""},"_id":"923f838","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/many-doctors-use-wrong-test-to-diagnose-kids-food-allergies-2\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":5,"sizes":[]},"text_indent":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"f19f164","elType":"column","settings":{"_column_size":16,"_inline_size":15,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":25,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"fc5c304","elType":"widget","settings":{"title":"My Account","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.20000000000000017763568394002504646778106689453125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=text"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"f5ba1ff","elType":"widget","settings":{"icon_list":[{"text":"My Account","selected_icon":{"value":"","library":""},"_id":"c9ca7b0","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/my-account\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"_id":"2ea89c1","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shopping cart","selected_icon":{"value":"","library":""},"_id":"17e5eea","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/cart\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop","selected_icon":{"value":"","library":""},"_id":"0384224","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":5,"sizes":[]},"text_indent":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"c78cfee","elType":"column","settings":{"_column_size":16,"_inline_size":13.653999999999999914734871708787977695465087890625,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":25,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"1225c84","elType":"widget","settings":{"title":"categories","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.20000000000000017763568394002504646778106689453125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=text"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"f8abf81","elType":"widget","settings":{"icon_list":[{"text":"Protein","selected_icon":{"value":"","library":""},"_id":"c9ca7b0","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/hormone-dramatically-increases-insulin-production-possible-diabetes-breakthrough-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Sports Nutrition","selected_icon":{"value":"","library":""},"_id":"2ea89c1","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/can-breakfast-help-keep-us-thin-nutrition-science-is-tricky\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Weight Loss","selected_icon":{"value":"","library":""},"_id":"17e5eea","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/fitness-blogger-says-weight-gain-led-to-happier-and-healthier-life-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Well-being","selected_icon":{"value":"","library":""},"_id":"0384224","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product\/awesome-leather-coat\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Food & Drink","selected_icon":{"value":"","library":""},"_id":"95376fb","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/many-doctors-use-wrong-test-to-diagnose-kids-food-allergies-2\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":5,"sizes":[]},"text_indent":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"9fd9827","elType":"column","settings":{"_column_size":16,"_inline_size":19,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f914a19","elType":"widget","settings":{"title":"subscribe us","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.20000000000000017763568394002504646778106689453125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=text"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"dcfa2a0","elType":"widget","settings":{"editor":"<div>Sign up for offers and exclusive discounts.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"ad97538","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","placeholder":"Email address...","_id":"a0d3ffd","width_mobile":"100"}],"step_next_label":"Next","step_previous_label":"Previous","button_text":"subscribe","email_to":"admin@admin.com","email_subject":"New message from \"supplero\"","email_content":"[all-fields]","email_from":"email@dev3.wpopal.com","email_from_name":"supplero","email_to_2":"admin@admin.com","email_subject_2":"New message from \"supplero\"","email_content_2":"[all-fields]","email_from_2":"email@dev3.wpopal.com","email_from_name_2":"supplero","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","button_align":"start","button_align_mobile":"center","selected_button_icon":{"value":"fas fa-arrow-right","library":"fa-solid"},"button_icon_align":"right","button_icon_indent":{"unit":"px","size":15,"sizes":[]},"field_border_color":"#02010100","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"field_text_padding":{"unit":"px","top":"10","right":"20","bottom":"10","left":"20","isLinked":false},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":12,"sizes":[]},"button_typography_font_weight":"bold","button_typography_text_transform":"uppercase","button_background_color":"#f2cb1f","button_text_color":"#000000","button_background_hover_color":"#c7a21e","button_border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"__globals__":{"button_background_color":"globals\/colors?id=primary","button_text_color":"globals\/colors?id=accent","button_background_hover_color":"globals\/colors?id=primary_hover","field_border_color_focus":""},"button_text_padding":{"unit":"px","top":"15","right":"20","bottom":"15","left":"20","isLinked":false},"button_background_color_style_2":{"unit":"px","top":"8","right":"20","bottom":"8","left":"20","isLinked":false},"icon_button_size":{"unit":"px","size":10,"sizes":[]},"style_button_form":"yes"},"elements":[],"widgetType":"form"}],"isInner":false}],"isInner":false},{"id":"7cbbecc","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#1C2127","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"border_color":"#33383D","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"__globals__":{"border_color":""},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"478345a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"1deeff8","elType":"widget","settings":{"text":"Divider","color":"#33383D","gap":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"divider"},{"id":"e29924b","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"b44c6a9","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center"},"elements":[{"id":"5ea101c","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2021&nbsp;<a style=\"color: #f2cb1f;\" href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/\">Supplero<\/a>. All Rights Reserved.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"30","left":"0","isLinked":false},"typography_font_weight":"400","__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"}],"isInner":true},{"id":"a97b37f","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center"},"elements":[{"id":"bd8990e","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/footer-03.png","id":687},"image_size":"full","align":"right","align_mobile":"center","_margin":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"link_to":"custom","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false}],"headerbuilder-1":[{"id":"ae28bba","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","height":"min-height","custom_height":{"unit":"px","size":48,"sizes":[]},"stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"68245ed","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"5c3859c","elType":"widget","settings":{"editor":"<div>Free standard shipping for orders <a href=\"#\">over $340.<\/a><\/div>","text_color_link":"#FFFFFF","__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"8b771c9","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"8a54656","elType":"widget","settings":{"view":"inline","icon_list":[{"text":"Find a Retailer","selected_icon":{"value":"","library":""},"_id":"9df4c95","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Customer Services","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"_id":"924d330","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"About Us","selected_icon":{"value":"fas fa-circle","library":"fa-solid"},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e06d8b8"}],"icon_align":"right","icon_size":{"unit":"px","size":3,"sizes":[]},"text_indent":{"unit":"px","size":13,"sizes":[]},"__globals__":{"text_color_hover":"globals\/colors?id=primary","text_color":"globals\/colors?id=lighter","icon_color":"globals\/colors?id=lighter"},"icon_height":{"unit":"px","size":18,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"ad73632","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"structure":"30","gap":"no","height":"min-height","custom_height":{"unit":"px","size":60,"sizes":[]},"stretch_section":"section-stretched","background_background":"classic","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"__globals__":{"background_color":"globals\/colors?id=primary"},"html_tag":"div","css_classes":"sticky-header","sticky":"top","sticky_on":["desktop"],"sticky_effects_offset":60,"custom_css":"header.sticky-header {\r\n    --header-height: 60px;\r\n    \/*--opacity: 0.90;*\/\r\n    --shrink-me: 0.80;\r\n    --sticky-background-color: #ffffff;\r\n    --transition: .3s ease-in-out;\r\n\r\n    transition: background-color var(--transition),\r\n                background-image var(--transition),\r\n                backdrop-filter var(--transition),\r\n                opacity var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects {\r\n    \/*background-color: var(--sticky-background-color) !important;*\/\r\n    background-image: none !important;\r\n    opacity: var(--opacity) !important;\r\n    -webkit-backdrop-filter: blur(10px);\r\n    backdrop-filter: blur(10px);\r\n    box-shadow: 0 8px 20px 0 rgba(0,0,0,.1);\r\n}\r\nheader.sticky-header > .elementor-container {\r\n    transition: min-height var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects > .elementor-container {\r\n    \/*min-height: calc(var(--header-height) * var(--shrink-me))!important;*\/\r\n    \/*height: calc(var(--header-height) * var(--shrink-me));*\/\r\n}\r\nheader.sticky-header .elementor-nav-menu .elementor-item {\r\n    transition: padding var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects .elementor-nav-menu .elementor-item {\r\n    padding-bottom: 10px!important;\r\n    padding-top: 10px!important;\r\n}\r\nheader.sticky-header > .elementor-container .logo img {\r\n    transition: max-width var(--transition);\r\n}\r\nheader.sticky-header.elementor-sticky--effects .logo img {\r\n    max-width: calc(100% * var(--shrink-me));\r\n}","padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"0ba5b45","elType":"column","settings":{"_column_size":33,"_inline_size":14.0999999999999996447286321199499070644378662109375,"content_position":"center","space_between_widgets":0,"_inline_size_tablet":100,"align_tablet":"space-between"},"elements":[{"id":"1b37916","elType":"widget","settings":{"icon_menu_size":{"unit":"px","size":16,"sizes":[]},"icon_menu_color_hover":"#FFFFFF","_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-vertical-menu"},{"id":"ede0c6c","elType":"widget","settings":{"__dynamic__":{"image":"[elementor-tag id=\"\" name=\"site-logo\" settings=\"%7B%7D\"]","link":"[elementor-tag id=\"\" name=\"site-url\" settings=\"%7B%7D\"]"},"width":{"unit":"px","size":121,"sizes":[]},"_element_width":"auto"},"elements":[],"widgetType":"theme-site-logo"},{"id":"fad8c9f","elType":"widget","settings":{"show_cart":"yes","icon_color_hover":"#FFFFFF","_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_element_width":"auto","hide_desktop":"hidden-desktop"},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false},{"id":"a7163e0","elType":"column","settings":{"_column_size":33,"_inline_size":60.231999999999999317878973670303821563720703125,"space_between_widgets":0,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","content_position":"center"},"elements":[{"id":"6c1ec9b","elType":"widget","settings":{"nav_menu_aligrment":"left","show_divider":"yes","__globals__":{"menu_title_color_hover":"globals\/colors?id=accent","menu_sub_title_color_hover":"","menu_sub_title_color_action":"globals\/colors?id=primary","menu_title_color_action":"globals\/colors?id=accent","menu_title_color":""},"menu":"main-menu","menu_sub_title_color_action":"#f2cb1f","show_divider_top":"yes","menu_title_color_hover":"#000000","menu_title_color_action":"#000000","show_background":"yes","background_color_hover":"#00000020"},"elements":[],"widgetType":"supplero-nav-menu"}],"isInner":false},{"id":"d71ab6f","elType":"column","settings":{"_column_size":33,"_inline_size":25,"space_between_widgets":0,"content_position":"center","align":"flex-end","hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone","custom_css":"@media (min-width: 768px){\n    .elementor-712 .elementor-element.elementor-element-a7163e0 {\n    width: 60.9%;\n}\n}"},"elements":[{"id":"5da6653","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-search","library":"supplero-icon"},"hover_primary_color":"#00000020","size":{"unit":"px","size":16,"sizes":[]},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"_border_color":"#D9B61C","_element_width":"auto","__globals__":{"primary_color":"","secondary_color":"globals\/colors?id=accent"},"__dynamic__":{"link":"[elementor-tag id=\"11374f9\" name=\"popup\" settings=\"%7B%22popup%22%3A%222087%22%7D\"]"},"view":"stacked","shape":"square","icon_padding":{"unit":"px","size":18,"sizes":[],"isLinked":false,"top":"22","right":"20","bottom":"22","left":"20"},"primary_color":"#00000000"},"elements":[],"widgetType":"icon"},{"id":"8acd8c6","elType":"widget","settings":{"show_divider":"yes","show_account":"yes","show_wishlist":"yes","show_cart":"yes","icon_color_divider":"#D9B61C","icon_padding":{"unit":"px","top":"16","right":"20","bottom":"16","left":"20","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"1","bottom":"0","left":"1","isLinked":false},"_border_color":"#D9B61C","_element_width":"auto","background_color_hover":"#00000020","__globals__":{"icon_color_hover":"globals\/colors?id=accent"}},"elements":[],"widgetType":"supplero-header-group"}],"isInner":false}],"isInner":false},{"id":"6c558d57","elType":"section","settings":{"gap":"no","height":"min-height","custom_height":{"unit":"px","size":260,"sizes":[]},"stretch_section":"section-stretched","background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/breadcrumb.jpg","id":5421},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_background":"classic","background_overlay_color":"#000000","background_overlay_opacity":{"unit":"px","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"padding":{"unit":"px","top":"20","right":"30","bottom":"20","left":"30","isLinked":false},"css_classes":"supplero-breadcrumb-build","custom_height_mobile":{"unit":"px","size":200,"sizes":[]},"padding_mobile":{"unit":"px","top":"20","right":"15","bottom":"20","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"456f019d","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","space_between_widgets":0},"elements":[{"id":"7994cae","elType":"widget","settings":{"title":"Blog","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"57654023","elType":"widget","settings":{"__dynamic__":{"title":"[elementor-tag id=\"\" name=\"page-title\" settings=\"%7B%22include_context%22%3A%22%22%2C%22show_home_title%22%3A%22%22%2C%22before%22%3A%22%22%2C%22after%22%3A%22%22%2C%22fallback%22%3A%22%22%7D\"]"},"title":"Add Your Heading Text Here","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"theme-page-title"},{"id":"5d7bb95a","elType":"widget","settings":{"align":"center","typography_link_typography":"custom","typography_link_font_size":{"unit":"px","size":14,"sizes":[]},"breadcrumb_last_text":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"link_color":"#9FAAA7","__globals__":{"link_hover_color":"globals\/colors?id=primary"}},"elements":[],"widgetType":"breadcrumbs"}],"isInner":false}],"isInner":false}],"footerbuilder-3":[{"id":"1c10084","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"91817d2","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"0","bottom":"60","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"6cf961c","elType":"widget","settings":{"title_text":"Sign up now & get 10% off","description_text":"Be the first to know about our new arrivals andv exclusive offers.","_element_custom_width":{"unit":"px","size":600,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":30,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent","primary_color":"globals\/colors?id=primary"},"selected_icon":{"value":"supplero-icon- supplero-icon-envelope","library":"supplero-icon"},"icon_space":{"unit":"px","size":10,"sizes":[]},"icon_size":{"unit":"px","size":30,"sizes":[]},"title_bottom_space":{"unit":"px","size":10,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"title_color":"#000000","icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":36,"sizes":[]},"text_align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"10","bottom":"30","left":"10","isLinked":false}},"elements":[],"widgetType":"icon-box"},{"id":"ad5782a","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","placeholder":"Email address...","width":"75","_id":"c4d7772"}],"button_width":"25","step_next_label":"Next","step_previous_label":"Previous","button_text":"subscribe","selected_button_icon":{"value":"fas fa-arrow-right","library":"fa-solid"},"button_icon_align":"right","email_to":"admin@admin.com","email_subject":"New message from \"supplero\"","email_content":"[all-fields]","email_from":"email@dev3.wpopal.com","email_from_name":"supplero","email_to_2":"admin@admin.com","email_subject_2":"New message from \"supplero\"","email_content_2":"[all-fields]","email_from_2":"email@dev3.wpopal.com","email_from_name_2":"supplero","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","column_gap":{"unit":"px","size":0,"sizes":[]},"field_border_color":"#E1E1E1","field_border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":false},"field_text_padding":{"unit":"px","top":"15","right":"20","bottom":"15","left":"20","isLinked":false},"field_text_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":12,"sizes":[]},"button_typography_font_weight":"bold","button_typography_text_transform":"uppercase","button_border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"_element_width":"initial","_element_custom_width":{"unit":"px","size":580,"sizes":[]},"__globals__":{"button_background_color":"globals\/colors?id=primary","button_text_color":"globals\/colors?id=accent","field_border_color_focus":"globals\/colors?id=primary","button_background_hover_color":"globals\/colors?id=primary_hover"},"button_text_padding":{"unit":"px","top":"19","right":"0","bottom":"20","left":"0","isLinked":false},"button_icon_indent":{"unit":"px","size":10,"sizes":[]},"button_background_color_style_2":{"unit":"px","top":"15","right":"20","bottom":"15","left":"20","isLinked":false},"icon_button_size":{"unit":"px","size":10,"sizes":[]},"style_button_form":"yes"},"elements":[],"widgetType":"form"},{"id":"ebd91c4","elType":"widget","settings":{"text":"Divider","_padding":{"unit":"px","top":"40","right":"0","bottom":"60","left":"0","isLinked":false},"__globals__":{"color":"globals\/colors?id=border"},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"divider"},{"id":"292f364","elType":"section","settings":{"gap":"no","structure":"40","html_tag":"div"},"elements":[{"id":"b2edfc7","elType":"column","settings":{"_column_size":25,"_inline_size":49,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"60","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":43,"margin_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"270d23b","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo_2.svg","id":3412},"image_size":"full","align":"left","width":{"unit":"px","size":125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"image"},{"id":"b167f44","elType":"widget","settings":{"editor":"<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=text"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"4e8773b","elType":"section","settings":{"gap":"no","structure":"20","padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"bee61e8","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":100},"elements":[{"id":"f7ab940","elType":"widget","settings":{"editor":"<div>Customer service<\/div>","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"0b78fe8","elType":"widget","settings":{"icon_list":[{"text":"(+84)-1800-33358","selected_icon":{"value":"","library":""},"_id":"3a6c889","link":{"url":"Tel:1800-33358","is_external":"","nofollow":"","custom_attributes":""}}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":24,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_line_height":{"unit":"px","size":48,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent","text_color_hover":"globals\/colors?id=primary"},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"a96222a","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"_inline_size_tablet":100,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false}},"elements":[{"id":"62fced8","elType":"widget","settings":{"editor":"<div>We accept<\/div>","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_font_weight":"400","_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"a4b4ded","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/footer-03.png","id":687},"image_size":"full","align":"left","align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":true},{"id":"c072121","elType":"column","settings":{"_column_size":25,"_inline_size":17,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":19,"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"4e59500","elType":"widget","settings":{"title":"Information","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"400","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"241c39c","elType":"widget","settings":{"icon_list":[{"text":"About us","selected_icon":{"value":"","library":""},"_id":"bffe55a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/about-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Blog","selected_icon":{"value":"","library":""},"_id":"eaacbdf","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/blog\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Check out ","selected_icon":{"value":"","library":""},"_id":"9a9233f","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/checkout\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"_id":"f0730d1","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Service","selected_icon":{"value":"","library":""},"_id":"900a28a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/can-breakfast-help-keep-us-thin-nutrition-science-is-tricky-2\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":5,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_family":"Poppins","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"400","__globals__":{"icon_color":"","text_color":"globals\/colors?id=text","text_color_hover":"globals\/colors?id=primary"},"_element_width_mobile":"initial","icon_align_mobile":"center","_element_custom_width_mobile":{"unit":"px","size":90,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"ce52604","elType":"column","settings":{"_column_size":25,"_inline_size":17.7530000000000001136868377216160297393798828125,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":20,"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"space_between_widgets":0},"elements":[{"id":"9b42f91","elType":"widget","settings":{"title":"My Account","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"400","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"bec1bbd","elType":"widget","settings":{"icon_list":[{"text":"My Account","selected_icon":{"value":"","library":""},"_id":"bffe55a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/my-account\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"_id":"eaacbdf","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shopping cart","selected_icon":{"value":"","library":""},"_id":"9a9233f","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/cart\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop","selected_icon":{"value":"","library":""},"_id":"f0730d1","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":5,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_family":"Poppins","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"400","__globals__":{"icon_color":"","text_color":"globals\/colors?id=text","text_color_hover":"globals\/colors?id=primary"},"_element_width_mobile":"auto","icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"a60b54c","elType":"column","settings":{"_column_size":25,"_inline_size":16,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":18,"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets":0},"elements":[{"id":"0b73ab4","elType":"widget","settings":{"title":"categories","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"400","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"348aef3","elType":"widget","settings":{"icon_list":[{"text":"Protein","selected_icon":{"value":"","library":""},"_id":"bffe55a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/biosimilars-create-opportunities-for-sustainable-cancer-care-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Sports Nutrition","selected_icon":{"value":"","library":""},"_id":"eaacbdf","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/can-breakfast-help-keep-us-thin-nutrition-science-is-tricky-2\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Weight Loss","selected_icon":{"value":"","library":""},"_id":"9a9233f","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/fitness-blogger-says-weight-gain-led-to-happier-and-healthier-life\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Well-being","selected_icon":{"value":"","library":""},"_id":"f0730d1","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/rising-cost-of-diabetes-care-concerns-patients-and-doctors\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Food & Drink","selected_icon":{"value":"","library":""},"_id":"900a28a","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/many-doctors-use-wrong-test-to-diagnose-kids-food-allergies-2\/","is_external":"","nofollow":"","custom_attributes":""}}],"space_between":{"unit":"px","size":5,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_family":"Poppins","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_font_weight":"400","__globals__":{"icon_color":"","text_color":"globals\/colors?id=text","text_color_hover":"globals\/colors?id=primary"},"_element_width_mobile":"auto","icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"f2ed71a","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"40","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"7900659","elType":"column","settings":{"_column_size":50,"_inline_size":65.4260000000000019326762412674725055694580078125,"content_position":"center","space_between_widgets":0,"padding":{"unit":"px","top":"35","right":"0","bottom":"35","left":"0","isLinked":false}},"elements":[{"id":"9ac4703","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2021 <a class=\"site-url\" style=\"color: #f2cb1f;\" href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\">Supplero<\/a> . All Rights Reserved.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"align_mobile":"center","__globals__":{"text_color":""}},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"c61c5e7","elType":"column","settings":{"_column_size":50,"_inline_size":34.534999999999996589394868351519107818603515625,"content_position":"center","space_between_widgets":0},"elements":[{"id":"9d3ce62","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"add3c4f","link":{"url":"https:\/\/www.facebook.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"84603bd","link":{"url":"https:\/\/www.youtube.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"c038d7e","link":{"url":"https:\/\/twitter.com\/","is_external":"true","nofollow":"","custom_attributes":""}},{"_id":"62fef2c","social_icon":{"value":"fab fa-instagram","library":"fa-brands"},"link":{"url":"https:\/\/www.instagram.com\/","is_external":"true","nofollow":"","custom_attributes":""}}],"align":"right","icon_color":"custom","icon_primary_color":"#F2F2F2","icon_secondary_color":"#000000","icon_size":{"unit":"px","size":16,"sizes":[]},"icon_padding":{"unit":"em","size":0.8000000000000000444089209850062616169452667236328125,"sizes":[]},"__globals__":{"hover_primary_color":"globals\/colors?id=primary","icon_primary_color":"","icon_secondary_color":"globals\/colors?id=accent","hover_secondary_color":"globals\/colors?id=secondary"},"align_mobile":"center","border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true}},"elements":[],"widgetType":"social-icons"}],"isInner":false}],"isInner":false}],"footerbuilder-1":[{"id":"3a381f7","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"30","background_background":"classic","padding":{"unit":"px","top":"40","right":"30","bottom":"40","left":"30","isLinked":false},"__globals__":{"background_color":"globals\/colors?id=primary"},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"40","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"d814f7d","elType":"column","settings":{"_column_size":33,"_inline_size":33.3299999999999982946974341757595539093017578125,"content_position":"center","space_between_widgets":0,"border_width":{"unit":"px","top":"0","right":"1","bottom":"0","left":"0","isLinked":false},"border_color":"#FF000066","margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":31,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f87c55b","elType":"widget","settings":{"icon_list":[{"text":"9066 Green Lake Drive Chevy, MD 20815","selected_icon":{"value":"supplero-icon- supplero-icon-map-marker","library":"supplero-icon"},"_id":"872a200"}],"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_family":"Poppins","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":24,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent","icon_color":"globals\/colors?id=accent"},"text_indent":{"unit":"px","size":5,"sizes":[]},"icon_align_mobile":"center","icon_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"4892415","elType":"column","settings":{"_column_size":33,"_inline_size":33.4069999999999964757080306299030780792236328125,"align":"center","space_between_widgets":0,"border_width":{"unit":"px","top":"0","right":"1","bottom":"0","left":"1","isLinked":false},"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"padding":{"unit":"px","top":"5","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"border_color":""},"border_border":"solid","_inline_size_tablet":38,"border_width_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"margin_mobile":{"unit":"px","top":"2","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"border_color":"#D9B61C"},"elements":[{"id":"caf8a83","elType":"widget","settings":{"title":"(+84)-1800-33358","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-1,"sizes":[]},"_element_width":"auto","__globals__":{"title_color":"globals\/colors?id=accent"},"align_tablet":"right","align_mobile":"center"},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"41824fa","elType":"column","settings":{"_column_size":33,"_inline_size":32.90299999999999869260136620141565799713134765625,"content_position":"center","align":"flex-end","space_between_widgets":0,"border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"border_color":"#FF000066","margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"_inline_size_tablet":31,"align_mobile":"center","margin_mobile":{"unit":"px","top":"5","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"10","isLinked":false}},"elements":[{"id":"66a25f1","elType":"widget","settings":{"icon_list":[{"text":"contact@example.com","_id":"6b41db8","selected_icon":{"value":"supplero-icon- supplero-icon-envelope","library":"supplero-icon"}}],"icon_size":{"unit":"px","size":15,"sizes":[]},"icon_self_align":"left","icon_typography_typography":"custom","icon_typography_font_family":"Poppins","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":24,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"auto","__globals__":{"text_color":"globals\/colors?id=accent","icon_color":"globals\/colors?id=accent"},"text_indent":{"unit":"px","size":5,"sizes":[]},"icon_align_mobile":"center","_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"-15","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"icon-list"},{"id":"2642288","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"37dbb3d","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"7960f8e","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"3e700a5","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"_id":"a0312d5","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}}],"shape":"square","icon_color":"custom","icon_primary_color":"#B65C5C00","icon_secondary_color":"#000000","icon_size":{"unit":"px","size":16,"sizes":[]},"_element_width":"auto","__globals__":{"icon_secondary_color":"globals\/colors?id=accent","hover_primary_color":"","hover_secondary_color":""},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hover_secondary_color":"#FFFFFF"},"elements":[],"widgetType":"social-icons"}],"isInner":false}],"isInner":false},{"id":"29430d7","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"50","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"75","right":"30","bottom":"60","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"15","bottom":"50","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"3c6802c","elType":"column","settings":{"_column_size":20,"_inline_size":25,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"margin_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"5517c55","elType":"widget","settings":{"editor":"<div>Customer Service<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"text_color":"#FFFFFF"},"elements":[],"widgetType":"text-editor"},{"id":"f982f40","elType":"widget","settings":{"icon_list":[{"text":"Informed Sport","selected_icon":{"value":"","library":""},"_id":"39940ba","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Loyalty points","selected_icon":{"value":"","library":""},"_id":"5f12253","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Testimonials","selected_icon":{"value":"","library":""},"_id":"113df6e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Expert Panel","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e3a6f6f"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary_hover"},"space_between_mobile":{"unit":"px","size":-5,"sizes":[]},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"7209dcc","elType":"column","settings":{"_column_size":20,"_inline_size":16.60000000000000142108547152020037174224853515625,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"b72f15b","elType":"widget","settings":{"editor":"<div>Information<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"text_color":"#FFFFFF"},"elements":[],"widgetType":"text-editor"},{"id":"96833a8","elType":"widget","settings":{"icon_list":[{"text":"About us","selected_icon":{"value":"","library":""},"_id":"39940ba","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/about-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Blog","selected_icon":{"value":"","library":""},"_id":"5f12253","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/blog\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Check out","selected_icon":{"value":"","library":""},"_id":"113df6e","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/checkout\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"e3a6f6f"},{"text":"Service","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"99d259d"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary_hover"},"space_between_mobile":{"unit":"px","size":-5,"sizes":[]},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"eabc31a","elType":"column","settings":{"_column_size":20,"_inline_size":16.60000000000000142108547152020037174224853515625,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"8c96278","elType":"widget","settings":{"editor":"<div>My Account<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"text_color":"#FFFFFF"},"elements":[],"widgetType":"text-editor"},{"id":"9b60d9c","elType":"widget","settings":{"icon_list":[{"text":"My Account","selected_icon":{"value":"","library":""},"_id":"39940ba","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/my-account\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"_id":"5f12253","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shopping cart","selected_icon":{"value":"","library":""},"_id":"113df6e","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"e3a6f6f"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary_hover"},"space_between_mobile":{"unit":"px","size":-5,"sizes":[]},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"dae6472","elType":"column","settings":{"_column_size":20,"_inline_size":16.602000000000000312638803734444081783294677734375,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":33.3299999999999982946974341757595539093017578125,"margin_tablet":{"unit":"px","top":"40","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"69b47cc","elType":"widget","settings":{"editor":"<div>categories<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"text_color":"#FFFFFF"},"elements":[],"widgetType":"text-editor"},{"id":"9ba9d78","elType":"widget","settings":{"icon_list":[{"text":"Protein","selected_icon":{"value":"","library":""},"_id":"39940ba","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Sports Nutrition","selected_icon":{"value":"","library":""},"_id":"5f12253","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Weight Loss","selected_icon":{"value":"","library":""},"_id":"113df6e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Well-being","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e3a6f6f"},{"text":"Food & Drink","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"99d259d"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter","text_color_hover":"globals\/colors?id=primary_hover"},"space_between_mobile":{"unit":"px","size":-5,"sizes":[]},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"3f84c92","elType":"column","settings":{"_column_size":20,"_inline_size":25,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"e7be3f6","elType":"widget","settings":{"editor":"<div>subscribe us<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","text_color":"#FFFFFF"},"elements":[],"widgetType":"text-editor"},{"id":"bf261bf","elType":"widget","settings":{"editor":"<div>Sign up for offers and exclusive discounts.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"23","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"10688d2","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","field_label":"Email","placeholder":"Email address...","_id":"37ecc53"}],"button_width":"50","step_next_label":"Next","step_previous_label":"Previous","button_text":"subscribe","selected_button_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"button_icon_align":"right","email_to":"admin@admin.com","email_subject":"New message from \"supplero\"","email_content":"[all-fields]","email_from":"email@dev3.wpopal.com","email_from_name":"supplero","email_to_2":"admin@admin.com","email_subject_2":"New message from \"supplero\"","email_content_2":"[all-fields]","email_from_2":"email@dev3.wpopal.com","email_from_name_2":"supplero","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","show_labels":"","button_icon_indent":{"unit":"px","size":13,"sizes":[]},"column_gap":{"unit":"px","size":40,"sizes":[]},"label_color":"#AAAAAA","label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":14,"sizes":[]},"label_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"field_text_padding":{"unit":"px","top":"10","right":"20","bottom":"10","left":"20","isLinked":false},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":12,"sizes":[]},"button_typography_text_transform":"uppercase","button_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_text_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"__globals__":{"previous_button_text_color":"globals\/colors?id=accent","button_background_color":"globals\/colors?id=primary","button_text_color":"globals\/colors?id=accent","button_background_hover_color":""},"icon_button_size":{"unit":"px","size":8,"sizes":[]},"style_button_form":"yes","button_background_color_style_2":{"unit":"px","top":"10","right":"20","bottom":"10","left":"20","isLinked":false},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]},"button_background_color":"#f2cb1f","button_text_color":"#000000","previous_button_text_color":"#000000"},"elements":[],"widgetType":"form"}],"isInner":false}],"isInner":false},{"id":"9f35c3e","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"04e0229","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"43098bb","elType":"widget","settings":{"text":"Divider","color":"#E8E8E929","gap":{"unit":"px","size":0,"sizes":[]},"__globals__":{"color":""}},"elements":[],"widgetType":"divider"}],"isInner":false}],"isInner":false},{"id":"adf8f9b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"45","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"45","right":"15","bottom":"50","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"3398e86","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"content_position":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"a94dfda","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo-3.svg","id":291},"image_size":"full","align":"left","width":{"unit":"%","size":40,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"center","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/","is_external":"","nofollow":"","custom_attributes":""}},"elements":[],"widgetType":"image"},{"id":"380bc29","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2021 <a href=\"#\"><span style=\"color: #f2cb1f;\">Supplero.<\/span><\/a> All Rights Reserved.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"a761567","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"content_position":"center","padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"59b2bbc","elType":"widget","settings":{"editor":"<div>We accept<\/div>","align":"right","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=text"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"994c29f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/footer-03.png","id":687},"image_size":"full","align":"right","align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false}],"footerbuilder-2":[{"id":"30a64d6","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"80","right":"30","bottom":"70","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"30","bottom":"60","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"15","bottom":"45","left":"15","isLinked":false},"reverse_order_tablet":"reverse-tablet","reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"cc97afb","elType":"column","settings":{"_column_size":50,"_inline_size":30,"space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"0","right":"1","bottom":"0","left":"0","isLinked":false},"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"_inline_size_tablet":72,"border_width_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"2ddb0db","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/logo_2.svg","id":3412},"image_size":"full","align":"left","link_to":"custom","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/","is_external":"","nofollow":"","custom_attributes":""},"width":{"unit":"%","size":40,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"image"},{"id":"40f564b","elType":"widget","settings":{"editor":"<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":310,"sizes":[]},"align_mobile":"center","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":500,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"74d78f6","elType":"widget","settings":{"social_icon_list":[{"social_icon":{"value":"fab fa-facebook","library":"fa-brands"},"_id":"d220d13","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-twitter","library":"fa-brands"},"_id":"c45ed8c","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"4865b2b","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}},{"social_icon":{"value":"fab fa-youtube","library":"fa-brands"},"_id":"bb97856","link":{"url":"#","is_external":"true","nofollow":"","custom_attributes":""}}],"shape":"square","align":"left","icon_color":"custom","icon_primary_color":"#F2F2F2","icon_secondary_color":"#000000","hover_primary_color":"#f2cb1f","__globals__":{"icon_secondary_color":"globals\/colors?id=accent","hover_primary_color":"globals\/colors?id=primary_hover","hover_secondary_color":""},"icon_size":{"unit":"px","size":16,"sizes":[]},"icon_padding":{"unit":"em","size":0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"45","left":"0","isLinked":false},"align_mobile":"center","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"social-icons"},{"id":"398e33d","elType":"widget","settings":{"editor":"<div>Customer service<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"54b8fbf","elType":"widget","settings":{"title":"(+84)-1800-33358","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":41,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":-0.5,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center"},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"5cc8354","elType":"column","settings":{"_column_size":50,"_inline_size":70,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"82f2c8a","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"555397c","elType":"column","settings":{"_column_size":50,"_inline_size":61,"space_between_widgets":0,"background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"20","right":"45","bottom":"10","left":"40","isLinked":false},"_inline_size_tablet":55,"padding_tablet":{"unit":"px","top":"20","right":"20","bottom":"10","left":"20","isLinked":false},"align_mobile":"center"},"elements":[{"id":"21bb633","elType":"widget","settings":{"editor":"<div>subscribe us<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"6fad11e","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"email","field_type":"email","required":"true","field_label":"Email","placeholder":"Email address...","_id":"37ecc53","width":"66","width_tablet":"60"}],"button_width":"33","step_next_label":"Next","step_previous_label":"Previous","button_text":"subscribe","selected_button_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"button_icon_align":"right","email_to":"admin@admin.com","email_subject":"New message from \"supplero\"","email_content":"[all-fields]","email_from":"email@dev3.wpopal.com","email_from_name":"supplero","email_to_2":"admin@admin.com","email_subject_2":"New message from \"supplero\"","email_content_2":"[all-fields]","email_from_2":"email@dev3.wpopal.com","email_from_name_2":"supplero","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","show_labels":"","button_icon_indent":{"unit":"px","size":13,"sizes":[]},"column_gap":{"unit":"px","size":0,"sizes":[]},"label_color":"#AAAAAA","label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":14,"sizes":[]},"label_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"field_text_padding":{"unit":"px","top":"10","right":"20","bottom":"10","left":"20","isLinked":false},"button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":12,"sizes":[]},"button_typography_text_transform":"uppercase","button_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"__globals__":{"previous_button_text_color":"globals\/colors?id=accent","button_background_color":"globals\/colors?id=primary","button_text_color":"globals\/colors?id=accent","button_background_hover_color":""},"field_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"button_width_tablet":"40","button_align_tablet":"stretch","button_text_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_button_size":{"unit":"px","size":8,"sizes":[]},"style_button_form":"yes","button_background_color_style_2":{"unit":"px","top":"9","right":"20","bottom":"10","left":"20","isLinked":false},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":450,"sizes":[]},"button_background_color":"#f2cb1f","button_text_color":"#000000","previous_button_text_color":"#000000"},"elements":[],"widgetType":"form"}],"isInner":true},{"id":"33d371c","elType":"column","settings":{"_column_size":50,"_inline_size":38.88199999999999789679350215010344982147216796875,"space_between_widgets":0,"content_position":"center","background_background":"classic","background_overlay_position":"initial","background_overlay_xpos":{"unit":"px","size":183,"sizes":[]},"background_overlay_repeat":"no-repeat","background_overlay_size":"initial","background_overlay_bg_width":{"unit":"%","size":36,"sizes":[]},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"css_classes":"supplero-box-clip","__globals__":{"background_color":"globals\/colors?id=primary"},"_inline_size_tablet":45,"padding_mobile":{"unit":"px","top":"30","right":"30","bottom":"30","left":"30","isLinked":false},"z_index":0},"elements":[{"id":"0632e86","elType":"widget","settings":{"icon_list":[{"text":"Ask <br> our experts","selected_icon":{"value":"supplero-icon- supplero-icon-comments","library":"supplero-icon"},"_id":"bdcf0f1"}],"icon_size":{"unit":"px","size":40,"sizes":[]},"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"icon_typography_font_weight":"bold","icon_typography_text_transform":"uppercase","icon_typography_line_height":{"unit":"px","size":20,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"icon_color":"globals\/colors?id=accent","text_color":"globals\/colors?id=accent"},"icon_align_mobile":"center","_z_index":0},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true},{"id":"c93fa63","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"40","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c811a8a","elType":"column","settings":{"_column_size":33,"_inline_size":34.15599999999999880628820392303168773651123046875,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"146702e","elType":"widget","settings":{"editor":"<div>Information<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"52ff21a","elType":"widget","settings":{"icon_list":[{"text":"About us","selected_icon":{"value":"","library":""},"_id":"39940ba","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/about-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Blog","selected_icon":{"value":"","library":""},"_id":"5f12253","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/blog\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Check out","selected_icon":{"value":"","library":""},"_id":"113df6e","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/checkout\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"e3a6f6f"},{"text":"Service","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"99d259d"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=text","text_color_hover":"globals\/colors?id=primary_hover"},"space_between_mobile":{"unit":"px","size":-5,"sizes":[]},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"eeef014","elType":"column","settings":{"_column_size":33,"_inline_size":37.5,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"83b4858","elType":"widget","settings":{"editor":"<div>My Account<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"acb9245","elType":"widget","settings":{"icon_list":[{"text":"My Account","selected_icon":{"value":"","library":""},"_id":"39940ba","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/my-account\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Contact","selected_icon":{"value":"","library":""},"_id":"5f12253","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/sample-page\/contact-us\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shopping cart","selected_icon":{"value":"","library":""},"_id":"113df6e","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Shop","selected_icon":{"value":"","library":""},"link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"_id":"e3a6f6f"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=text","text_color_hover":"globals\/colors?id=primary_hover"},"space_between_mobile":{"unit":"px","size":-5,"sizes":[]},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"1275ba2","elType":"column","settings":{"_column_size":33,"_inline_size":27.971000000000000085265128291212022304534912109375,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"5102079","elType":"widget","settings":{"editor":"<div>categories<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":3.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"4337f9b","elType":"widget","settings":{"icon_list":[{"text":"Protein","selected_icon":{"value":"","library":""},"_id":"39940ba","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Sports Nutrition","selected_icon":{"value":"","library":""},"_id":"5f12253","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Weight Loss","selected_icon":{"value":"","library":""},"_id":"113df6e","link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""}},{"text":"Well-being","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"e3a6f6f"},{"text":"Food & Drink","selected_icon":{"value":"","library":""},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"_id":"99d259d"}],"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"icon_typography_line_height":{"unit":"px","size":30,"sizes":[]},"icon_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=text","text_color_hover":"globals\/colors?id=primary_hover"},"space_between_mobile":{"unit":"px","size":-5,"sizes":[]},"icon_align_mobile":"center"},"elements":[],"widgetType":"icon-list"}],"isInner":true}],"isInner":true},{"id":"9f16ddc","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/deco_footer-2.png","id":1098},"image_size":"full","align":"center","motion_fx_translateX_speed":{"unit":"px","size":0.5,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_element_width":"auto","_position":"absolute","_offset_orientation_h":"end","_offset_x":{"size":"","unit":"%"},"_offset_x_end":{"unit":"px","size":15,"sizes":[]},"_offset_y":{"size":-28,"unit":"px"},"_offset_x_end_tablet":{"unit":"px","size":5,"sizes":[]},"_offset_y_tablet":{"unit":"px","size":-28,"sizes":[]},"hide_mobile":"hidden-phone","_z_index":0},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"3e67d2b","elType":"section","settings":{"layout":"full_width","gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#FFFFFF","html_tag":"div"},"elements":[{"id":"3f1bef8","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"58ff52b","elType":"widget","settings":{"text":"Divider","gap":{"unit":"px","size":0,"sizes":[]},"__globals__":{"color":"globals\/colors?id=border"}},"elements":[],"widgetType":"divider"}],"isInner":false}],"isInner":false},{"id":"1e010fd","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"30","right":"30","bottom":"35","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"15","bottom":"35","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"9f81330","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f51b9c5","elType":"widget","settings":{"editor":"<div>Copyright \u00a9 2021 <a href=\"#\"><span style=\"color: #f2cb1f;\">Supplero.<\/span><\/a> All Rights Reserved.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"}],"isInner":false},{"id":"2648cd4","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center","align":"flex-end","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"align_mobile":"center","margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a38d7d3","elType":"widget","settings":{"editor":"<div>We accept<\/div>","align":"right","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=text"},"align_mobile":"center","_padding":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"c30d392","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/footer-03.png","id":687},"image_size":"full","align":"right","align_mobile":"center","_element_width":"auto"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false}],"home-1":[{"id":"ff61520","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"15","bottom":"10","left":"15","isLinked":false},"structure":"40","hide_mobile":"hidden-phone","html_tag":"div"},"elements":[{"id":"84560ce","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"8607849","elType":"widget","settings":{"icon_list":[{"text":"Low price guarantee","selected_icon":{"value":"supplero-icon- supplero-icon-credit-card","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_tablet":"right","icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"526bf83","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"336292b","elType":"widget","settings":{"icon_list":[{"text":"30 day online returns","selected_icon":{"value":"supplero-icon- supplero-icon-history","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"dcfd528","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"ebe8143","elType":"widget","settings":{"icon_list":[{"text":"Free delivery worldwide","selected_icon":{"value":"supplero-icon- supplero-icon-truck","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_tablet":"right","icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"5a6de93","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"994443f","elType":"widget","settings":{"icon_list":[{"text":"Ask our experts: <a href=\"tel:18883335226\">1-888-333-5226<\/a>","selected_icon":{"value":"supplero-icon- supplero-icon-phone-rotary","library":"supplero-icon"},"_id":"d495b2e"}],"text_indent":{"unit":"px","size":10,"sizes":[]},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":16,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"icon_align_mobile":"center","icon_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false},{"id":"6e472dd","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"06893f1","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_bg-1.jpg","id":3978},"background_position":"center center","background_overlay_background":"classic","background_overlay_color":"#730307","background_overlay_opacity":{"unit":"px","size":0.88000000000000000444089209850062616169452667236328125,"sizes":[]},"overlay_blend_mode":"multiply","padding":{"unit":"px","top":"70","right":"0","bottom":"70","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"background_overlay_hover_background":"classic","background_overlay_hover_opacity":{"unit":"px","size":1,"sizes":[]}},"elements":[{"id":"12e3f7a","elType":"section","settings":{"gap":"no","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"ea09289","elType":"column","settings":{"_column_size":50,"_inline_size":44.18599999999999994315658113919198513031005859375,"content_position":"center","align_mobile":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"45","left":"0","isLinked":false}},"elements":[{"id":"debfdd6","elType":"widget","settings":{"space":{"unit":"px","size":2,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"6273600","elType":"widget","settings":{"editor":"<div>cyber monday sale<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"500","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":20,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"3","right":"8","bottom":"3","left":"8","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#DD3F37","_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"6d82efe","elType":"widget","settings":{"title":"Boost your immune system today","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"_margin":{"unit":"px","top":"10","right":"0","bottom":"10","left":"0","isLinked":false},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"_element_custom_width":{"unit":"px","size":445,"sizes":[]},"_element_custom_width_tablet":{"unit":"px","size":390,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"text_shadow_text_shadow":{"horizontal":0,"vertical":0,"blur":10,"color":"rgba(106.87499999999999, 93.9611058601134, 63.195652173913025, 0.51)"},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":380,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"7fa7326","elType":"widget","settings":{"editor":"24g of pure protein for enhanced lean muscle.  ","align_mobile":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":18,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":24,"sizes":[]},"__globals__":{"text_color":""}},"elements":[],"widgetType":"text-editor"},{"id":"d273450","elType":"widget","settings":{"text":"Shop Now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"align_mobile":"center","_margin":{"unit":"px","top":"50","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"button_background_hover_color":"globals\/colors?id=primary_hover"},"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"1b036dc","elType":"column","settings":{"_column_size":50,"_inline_size":55.81400000000000005684341886080801486968994140625,"content_position":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"bbd334d","elType":"widget","settings":{"title":"30<span style=\"font-size:14px;\">%<\/span> <br>  OFF","header_size":"h4","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"26","right":"32","bottom":"35","left":"32","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#DD3F37","_border_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"_element_width":"auto","_position":"absolute","typography_font_size_mobile":{"unit":"px","size":24,"sizes":[]},"_padding_mobile":{"unit":"px","top":"22","right":"25","bottom":"25","left":"25","isLinked":false},"_offset_x":{"unit":"px","size":"","sizes":[]},"_offset_y_mobile":{"unit":"px","size":-60,"sizes":[]},"_margin":{"unit":"px","top":"65","right":"0","bottom":"0","left":"0","isLinked":false},"motion_fx_mouseTrack_effect":"yes","motion_fx_mouseTrack_speed":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"ec64e4d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_img-1.png","id":4029},"image_size":"full","align":"left","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"f5ebc6b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"effbd3e","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"a06ba97","elType":"widget","settings":{"categories_list":[{"_id":"f97a641","categories_name":"Whey Protein ","categories":"food-products","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/8.png","id":229}},{"categories_name":"Sports Nutrition","categories":"hot-offers","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/19.png","id":240},"_id":"aee7362"},{"categories_name":"Weight Loss  ","categories":"protein-bars-cookies","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/23.png","id":243},"_id":"98a0fb9"},{"categories_name":"Well-Being","categories":"weight-gainers","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/17.png","id":238},"_id":"2c64782"},{"categories_name":"Vitamins ","categories":"vegan-nutrition","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/16.png","id":237},"_id":"6570c2b"},{"categories_name":"Food & Drink","categories":"weight-management","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/29.png","id":249},"_id":"4f0b2c9"}],"column":"6","column_tablet":"3","column_mobile":"2","product_gutter":{"unit":"px","size":10,"sizes":[]},"box_padding":{"unit":"px","top":"15","right":"5","bottom":"15","left":"5","isLinked":false},"box_padding_mobile":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"image_width":{"unit":"%","size":30,"sizes":[]}},"elements":[],"widgetType":"supplero-product-categories"}],"isInner":false}],"isInner":false},{"id":"8471374","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"1230d23","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"80f1e4c","elType":"widget","settings":{"editor":"SHOP OUR NEW RELEASES ","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"}},"elements":[],"widgetType":"text-editor"},{"id":"d661dd4","elType":"widget","settings":{"title":"Our Products","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"e3cfccf","elType":"widget","settings":{"limit":8,"column":"4","column_tablet":"3","column_mobile":"2","product_gutter":{"unit":"px","size":30,"sizes":[]},"product_gutter_mobile":{"unit":"px","size":15,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"supplero-products"},{"id":"415c9c7","elType":"widget","settings":{"text":"view all products","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"align":"center","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"button_text_color":"#000000","background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#000000","__globals__":{"button_text_color":"globals\/colors?id=accent","border_color":"globals\/colors?id=accent","hover_color":"","button_hover_border_color":"","button_background_hover_color":""},"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"94e79c8","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"145341e","elType":"column","settings":{"_column_size":50,"_inline_size":59.68990000000000151203494169749319553375244140625,"space_between_widgets":0,"background_background":"classic","background_color":"#2D3335","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-1.png","id":536},"background_position":"bottom center","background_repeat":"no-repeat","background_hover_background":"classic","background_hover_position":"bottom right","background_hover_repeat":"no-repeat","background_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"80","bottom":"30","left":"80","isLinked":false},"background_hover_position_mobile":"bottom center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"30","bottom":"10","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"15","bottom":"0","left":"15","isLinked":false},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000"},"elements":[{"id":"d23b5b1","elType":"widget","settings":{"editor":"<div>In store now<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":18,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_padding":{"unit":"px","top":"3","right":"10","bottom":"3","left":"10","isLinked":false},"_css_classes":"supplero-box-clip","_background_background":"classic","_background_color":"#D20117","_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"2958d55","elType":"widget","settings":{"title":"Gold Standard <br> Pre-workout","align":"left","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":36,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":2,"__globals__":{"title_color":""}},"elements":[],"widgetType":"heading"},{"id":"a7c25d3","elType":"widget","settings":{"editor":"Starting at $16.99","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"_z_index":2,"__globals__":{"text_color":"globals\/colors?id=primary_hover"}},"elements":[],"widgetType":"text-editor"},{"id":"82b4722","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_z_index":2,"size":"xs","button_text_color":"#FFFFFF","background_color":"#FFFFFF33","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"},{"id":"a35e0df","elType":"widget","settings":{"space":{"unit":"px","size":160,"sizes":[]},"space_mobile":{"unit":"px","size":200,"sizes":[]}},"elements":[],"widgetType":"spacer"},{"id":"f5de6d5","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-1-1.png","id":624},"image_size":"full","motion_fx_motion_fx_scrolling":"yes","motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_element_width":"auto","_position":"absolute","_offset_orientation_h":"end","_offset_x_end":{"unit":"px","size":0,"sizes":[]},"_offset_y":{"unit":"px","size":"","sizes":[]},"width_tablet":{"unit":"px","size":250,"sizes":[]},"width_mobile":{"unit":"px","size":180,"sizes":[]},"_offset_x_end_mobile":{"size":0,"unit":"px"},"_offset_orientation_v":"end","_offset_y_end_mobile":{"size":0,"unit":"px"}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"3ef4a64","elType":"column","settings":{"_column_size":50,"_inline_size":40.31000000000000227373675443232059478759765625,"space_between_widgets":0},"elements":[{"id":"58fc824","elType":"section","settings":{"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":170,"sizes":[]},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-2.jpg","id":660},"background_position":"center center","background_size":"cover","background_hover_background":"classic","background_hover_position":"center right","margin":{"unit":"px","top":"0","right":0,"bottom":"30","left":0,"isLinked":false},"padding":{"unit":"px","top":"40","right":"60","bottom":"40","left":"60","isLinked":false},"custom_height_inner_tablet":{"unit":"px","size":150,"sizes":[]},"background_hover_position_mobile":"center center","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"15","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"15","bottom":"50","left":"15","isLinked":false},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","html_tag":"div"},"elements":[{"id":"da94794","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"95a28e5","elType":"widget","settings":{"editor":"Exclusive items","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"2adeb5c","elType":"widget","settings":{"title":"members","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"d7d0a20","elType":"widget","settings":{"title":"save","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"7128857","elType":"widget","settings":{"title":"10% more","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"b8fb9c9","elType":"widget","settings":{"text":"join us ","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_z_index":2,"size":"xs","button_text_color":"#FFFFFF","background_color":"#FFFFFF33","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true},{"id":"15fdf56","elType":"section","settings":{"gap":"no","height_inner":"min-height","custom_height_inner":{"unit":"px","size":210,"sizes":[]},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-3.jpg","id":754},"background_position":"center center","background_size":"cover","background_hover_background":"classic","background_hover_position":"center right","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"20","right":"40","bottom":"20","left":"40","isLinked":false},"structure":"20","custom_height_inner_tablet":{"unit":"px","size":150,"sizes":[]},"background_hover_position_mobile":"center center","padding_tablet":{"unit":"px","top":"50","right":"15","bottom":"50","left":"15","isLinked":false},"background_overlay_hover_background":"classic","background_overlay_hover_color":"#000000","html_tag":"div"},"elements":[{"id":"e44de89","elType":"column","settings":{"_column_size":50,"_inline_size":59.61500000000000198951966012828052043914794921875,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":40,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[{"id":"dfc56bd","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-3-1.png","id":784},"image_size":"full","align":"left","motion_fx_translateY_effect":"yes","motion_fx_translateY_direction":"negative","motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"align_mobile":"center"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"7bdb085","elType":"column","settings":{"_column_size":50,"_inline_size":40.38300000000000267164068645797669887542724609375,"space_between_widgets":0,"_inline_size_tablet":60},"elements":[{"id":"b90f385","elType":"widget","settings":{"editor":"Exclusive items","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"e8a2805","elType":"widget","settings":{"title":"Premium Lux <br> Pack","header_size":"h3","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"b038192","elType":"widget","settings":{"title":" $199.00 ","header_size":"h3","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"title_color":"#0BB6FF","typography_font_weight":"300","align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"1ebfdec","elType":"widget","settings":{"text":"shop now","link":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/shop\/","is_external":"","nofollow":"","custom_attributes":""},"selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"_z_index":2,"size":"xs","button_text_color":"#FFFFFF","background_color":"#FFFFFF33","icon_button_size":{"unit":"px","size":8,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"2af9e37","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"30","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"dc0bdac","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"e70302e","elType":"widget","settings":{"title":"Best Selling","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"eaea954","elType":"widget","settings":{"limit":4,"column":"1","column_tablet":"1","product_layout":"list"},"elements":[],"widgetType":"supplero-products"}],"isInner":false},{"id":"f19f085","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false}},"elements":[{"id":"f9234f6","elType":"widget","settings":{"title":"Latest Deals","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"9ef14d8","elType":"widget","settings":{"limit":1,"column":"1","column_tablet":"1","order":"asc","product_layout":"list","list_layout":"4"},"elements":[],"widgetType":"supplero-products"}],"isInner":false},{"id":"da077f8","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"99accc3","elType":"widget","settings":{"title":"Recommended","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":24,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"heading"},{"id":"c34834c","elType":"widget","settings":{"limit":4,"column":"1","column_tablet":"1","orderby":"popularity","product_layout":"list"},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"8ed7f0f","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"70","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"50a1288","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-4.jpg","id":1071},"background_repeat":"no-repeat","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"padding":{"unit":"px","top":"70","right":"0","bottom":"70","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"background_position":"center center","background_size":"cover","background_overlay_background":"classic","background_overlay_color":"#8A0006","overlay_blend_mode":"multiply","background_overlay_opacity":{"unit":"px","size":0.88000000000000000444089209850062616169452667236328125,"sizes":[]},"background_overlay_hover_background":"classic","background_overlay_hover_opacity":{"unit":"px","size":1,"sizes":[]}},"elements":[{"id":"e9e0ed3","elType":"section","settings":{"gap":"no","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"ebac65c","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"0428424","elType":"widget","settings":{"editor":"testimonials","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"align":"center","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"__globals__":{"text_color":""},"align_mobile":"center","text_color":"#FFFFFF"},"elements":[],"widgetType":"text-editor"},{"id":"1342924","elType":"widget","settings":{"title":"Real Reviews From <br> Real Customers","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":36,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":32,"sizes":[]},"typography_line_height":{"unit":"px","size":45,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":34,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":""},"align_mobile":"center","title_color":"#FFFFFF"},"elements":[],"widgetType":"heading"},{"id":"63d044d","elType":"widget","settings":{"testimonials":[{"testimonial_content":"\u201cDiscount Supplements is probably the best protein supplement company in the UK in every respect. Thoroughly recommended.\u201d","testimonial_name":"Ken Haywood ","testimonial_job":"Cunningham Store","_id":"7d06daa","testimonial_rating":5},{"testimonial_content":"\u201cGood product good price prompt efficient service. Gives you energy to workout harder and longer. Many thanks for your help.\u201d ","testimonial_name":"Brian G. Moore  ","testimonial_job":"Gym Mod","_id":"2c66ebb","testimonial_rating":5},{"testimonial_content":"\"I am completely blown away. Gym, fitness saved my business. Gym, fitness is great. If you aren\'t sure, always go for gym, fitness.\"","testimonial_name":"John Stone ","testimonial_job":"Fitness Club","_id":"a98dc5c","testimonial_rating":5}],"column":"3","padding_estimonial_wrapper":{"unit":"px","top":"40","right":"40","bottom":"40","left":"40","isLinked":true},"color_testimonial_wrapper":"#FFFFFF","column_tablet":"2","margin_testimonial_wrapper_mobile":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"testimonial_alignment":"left","enable_carousel":"yes"},"elements":[],"widgetType":"supplero-testimonials"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"d346f37","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"0","right":0,"bottom":"40","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"45","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"052b0df","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"c855026","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-1.png","id":934},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"42aced7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-2.png","id":935},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"e336f27"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-3.png","id":936},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"4ac8eb7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-4.png","id":937},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"16fab77"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-6.png","id":939},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"fc2bd94"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-5.png","id":938},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1b76abe"}],"column":"6","column_mobile":"3","item_spacing_mobile":{"unit":"px","size":5,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"enable_carousel":"yes","navigation":"none"},"elements":[],"widgetType":"supplero-brand"}],"isInner":false}],"isInner":false}],"contact-us":[{"id":"f198e47","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"20","right":0,"bottom":"80","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":0,"bottom":"40","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"d1312c9","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"80","right":"80","bottom":"70","left":"80","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"10","bottom":"30","left":"10","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[{"id":"89fd6d5","elType":"widget","settings":{"editor":"<div>Whether you have a question about products, ingredients, pricing or anything else, our team has answers.<\/div>","align":"center","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"400","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":540,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"1c98508","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"b4136e4","elType":"column","settings":{"_column_size":50,"_inline_size":31,"space_between_widgets":0,"margin":{"unit":"px","top":"15","right":"60","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"15","right":"20","bottom":"15","left":"15","isLinked":false}},"elements":[{"id":"32d8be4","elType":"widget","settings":{"view":"stacked","title_text":"Telephone","description_text":"(+84)-1800-33358","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":18,"sizes":[]},"icon_padding":{"unit":"px","size":17,"sizes":[]},"title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":12,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":24,"sizes":[]},"description_typography_font_weight":"bold","description_typography_line_height":{"unit":"px","size":"","sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":-0.6999999999999999555910790149937383830547332763671875,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=primary","primary_color":"globals\/colors?id=accent","secondary_color":"globals\/colors?id=primary"},"selected_icon":{"value":"supplero-icon- supplero-icon-phone-rotary","library":"supplero-icon"}},"elements":[],"widgetType":"icon-box"},{"id":"2ec4bfc","elType":"widget","settings":{"view":"stacked","title_text":"Email","description_text":"support@example.com","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":18,"sizes":[]},"icon_padding":{"unit":"px","size":17,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":12,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":18,"sizes":[]},"description_typography_font_weight":"400","description_typography_line_height":{"unit":"px","size":"","sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"","primary_color":"globals\/colors?id=accent","secondary_color":"globals\/colors?id=primary","_border_color":"globals\/colors?id=border"},"_padding_mobile":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false},"primary_color":"#000000","secondary_color":"#f2cb1f","title_color":"#000000","description_color":"#666666","_border_color":"#E8E8E9","selected_icon":{"value":"supplero-icon- supplero-icon-envelope-open","library":"supplero-icon"}},"elements":[],"widgetType":"icon-box"},{"id":"fca9f1b","elType":"widget","settings":{"view":"stacked","title_text":"Address","description_text":"9066 Green Lake Drive Chevy,<br>\nMD 20815","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":18,"sizes":[]},"icon_padding":{"unit":"px","size":17,"sizes":[]},"title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":16,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":12,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"500","description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=accent","primary_color":"globals\/colors?id=accent","secondary_color":"globals\/colors?id=primary","_border_color":"globals\/colors?id=border"},"_padding_mobile":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false},"selected_icon":{"value":"supplero-icon- supplero-icon-location-circle","library":"supplero-icon"}},"elements":[],"widgetType":"icon-box"},{"id":"9231c1b","elType":"widget","settings":{"view":"stacked","title_text":"9:00 am <a style=\"color:#666666;\" >until <\/a> 5:00pm","description_text":"Monday <a style=\"color:#666666;\" >thru <\/a>  Friday.","position":"left","icon_space":{"unit":"px","size":20,"sizes":[]},"icon_size":{"unit":"px","size":18,"sizes":[]},"icon_padding":{"unit":"px","size":17,"sizes":[]},"content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":5,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_font_weight":"bold","title_typography_line_height":{"unit":"px","size":12,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":-0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_font_weight":"bold","description_typography_line_height":{"unit":"px","size":"","sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":-0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"_padding":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent","description_color":"globals\/colors?id=accent","primary_color":"globals\/colors?id=accent","secondary_color":"globals\/colors?id=primary","_border_color":"globals\/colors?id=border"},"_padding_mobile":{"unit":"px","top":"20","right":"0","bottom":"20","left":"0","isLinked":false},"selected_icon":{"value":"supplero-icon- supplero-icon-clock-1","library":"supplero-icon"}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"5299cbf","elType":"column","settings":{"_column_size":50,"_inline_size":69,"space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"1","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"_inline_size_tablet":50,"padding_tablet":{"unit":"px","top":"0","right":"20","bottom":"1","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"10","bottom":"0","left":"10","isLinked":false},"border_width_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a762282","elType":"widget","settings":{"title":"Send Us a Message","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_font_weight":"bold","typography_line_height":{"unit":"px","size":30,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"1a531ba","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"custom_id":"name","placeholder":"Your name","_id":"0486389"},{"custom_id":"email","field_type":"email","required":"true","placeholder":"Your email","width":"50","_id":"24a0767"},{"custom_id":"field_6bedbf8","field_type":"number","required":"true","placeholder":"Phone number","width":"50","_id":"6bedbf8"},{"custom_id":"message","field_type":"textarea","placeholder":"Message","_id":"966eab6","rows":7}],"button_align":"start","step_next_label":"Next","step_previous_label":"Previous","button_text":"Send message","selected_button_icon":{"value":"fas fa-arrow-right","library":"fa-solid"},"button_icon_align":"right","email_to":"admin@admin.com","email_subject":"New message from \"Wordpress One-Click\"","email_content":"[all-fields]","email_from":"email@dev3.wpopal.com","email_from_name":"Wordpress One-Click","email_to_2":"admin@admin.com","email_subject_2":"New message from \"Wordpress One-Click\"","email_content_2":"[all-fields]","email_from_2":"email@dev3.wpopal.com","email_from_name_2":"Wordpress One-Click","email_reply_to_2":"admin@admin.com","mailchimp_fields_map":[],"drip_fields_map":[],"activecampaign_fields_map":[],"getresponse_fields_map":[],"convertkit_fields_map":[],"mailerlite_fields_map":[],"success_message":"The form was sent successfully.","error_message":"An error occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","column_gap":{"unit":"px","size":20,"sizes":[]},"row_gap":{"unit":"px","size":20,"sizes":[]},"field_background_color":"#F3F3F3","field_border_color":"#F3F3F3","field_border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"button_background_color":"#f2cb1f","button_text_color":"#000000","__globals__":{"field_border_color":"","button_background_color":"globals\/colors?id=primary","button_text_color":"globals\/colors?id=accent","textarea_border_color":"","textarea_border_color_active":"","textarea_background":"","field_border_color_focus":"globals\/colors?id=accent","textarea_color":"","field_text_color":"globals\/colors?id=accent"},"button_align_mobile":"center","button_icon_indent":{"unit":"px","size":10,"sizes":[]},"field_typography_typography":"custom","field_typography_font_size":{"unit":"px","size":14,"sizes":[]},"field_typography_font_weight":"400","field_typography_line_height":{"unit":"px","size":20,"sizes":[]},"field_border_color_focus":"#D43B3B","button_background_color_style_2":{"unit":"px","top":"16","right":"25","bottom":"16","left":"25","isLinked":false},"style_button_form":"yes"},"elements":[],"widgetType":"form"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"de77154","elType":"section","settings":{"layout":"full_width","gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"0","right":0,"bottom":"-35","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"3802a23","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"9ee095f","elType":"widget","settings":{"address":"London Eye, London, United Kingdom","height":{"unit":"px","size":450,"sizes":[]}},"elements":[],"widgetType":"google_maps"}],"isInner":false}],"isInner":false}],"about-us":[{"id":"0159f24","elType":"section","settings":{"content_width":{"unit":"px","size":460,"sizes":[]},"gap":"no","stretch_section":"section-stretched","background_background":"classic","background_color":"#1C2127","background_motion_fx_translateY_effect":"yes","background_overlay_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/about_bg-1-1.jpg","id":5694},"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"background_overlay_hover_opacity":{"unit":"px","size":"","sizes":[]},"css_filters_hover_brightness":{"unit":"px","size":64,"sizes":[]},"margin":{"unit":"px","top":"-60","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"145","right":"30","bottom":"190","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"0","bottom":"100","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"80","right":"15","bottom":"100","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"-20","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c14997a","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"a613b77","elType":"widget","settings":{"title":"About Us","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":45,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":40,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"103639e","elType":"widget","settings":{"editor":"<div>We\u2019re all made of something special. So tell us \u2014 what\u2019s your secret ingredient?<\/div>","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_family":"Poppins","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"}],"isInner":false}],"isInner":false},{"id":"3d654fe","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"margin":{"unit":"px","top":"-60","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"-30","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"50","left":0,"isLinked":false},"background_background":"classic","html_tag":"div"},"elements":[{"id":"e3dc00c","elType":"column","settings":{"_column_size":50,"_inline_size":45.171300000000002228262019343674182891845703125,"space_between_widgets":0,"padding":{"unit":"px","top":"60","right":"30","bottom":"60","left":"80","isLinked":false},"align_mobile":"center","padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"40","left":"15","isLinked":false},"background_background":"classic","background_color":"#FFFFFF","padding_tablet":{"unit":"px","top":"60","right":"35","bottom":"60","left":"40","isLinked":false}},"elements":[{"id":"ccdece2","elType":"widget","settings":{"editor":"Who we are","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"align":"left","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"90f8737","elType":"widget","settings":{"title":"Supporting Athletes Since 1995","align":"left","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":410,"sizes":[]},"align_mobile":"center","_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"71af825","elType":"widget","settings":{"editor":"Whether you are an elite sportsperson, a gym purist or a complete beginner, we can help you achieve things you never thought possible.","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"efd86e1","elType":"widget","settings":{"editor":"<p>As the premier sports nutrition brand in the UK, we have been supporting British athletes, fitness and healthy lifestyles for over two decades. Since 1995, we\'ve helped millions of people push harder, go faster and further. Break limits and personal bests.<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"457d81b","elType":"widget","settings":{"text":"view our products","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":13,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"hover_color":"","button_background_hover_color":"","button_hover_border_color":"","style_button_hover_background":"globals\/colors?id=accent"},"align_mobile":"center","text_padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"icon_button_size":{"unit":"px","size":9,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false},{"id":"6b873d8","elType":"column","settings":{"_column_size":50,"_inline_size":54.82900000000000062527760746888816356658935546875,"content_position":"bottom","space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_bg-1.jpg","id":2279},"background_position":"center center","background_size":"cover","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"gradient","background_overlay_color":"#FFFFFF","background_overlay_color_stop":{"unit":"%","size":8,"sizes":[]},"background_overlay_color_b":"#F2295B00","background_overlay_color_b_stop":{"unit":"%","size":8,"sizes":[]},"background_overlay_gradient_angle":{"unit":"deg","size":90,"sizes":[]},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"px","top":"80","right":"0","bottom":"80","left":"0","isLinked":false},"background_size_mobile":"initial","background_bg_width_mobile":{"unit":"px","size":0,"sizes":[]},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"eef0bd8","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"8167e40","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_tablet":80,"content_position":"bottom","space_between_widgets":0,"background_background":"classic","background_color":"#F2CB1F","padding":{"unit":"px","top":"10","right":"15","bottom":"15","left":"15","isLinked":false},"padding_tablet":{"unit":"px","top":"5","right":"0","bottom":"15","left":"0","isLinked":false},"css_classes":"supplero-box-clip"},"elements":[{"id":"4943ba4","elType":"widget","settings":{"ending_number":5,"prefix":"2,","suffix":"M","title":"bottles sold","text_align":"left","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":40,"sizes":[]},"typography_number_line_height":{"unit":"px","size":"","sizes":[]},"number_space":{"unit":"px","size":0,"sizes":[]},"_typography":"custom","_font_size":{"unit":"px","size":24,"sizes":[]},"typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":14,"sizes":[]},"typography_title_font_weight":"700","typography_title_text_transform":"uppercase","typography_title_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"5","right":"15","bottom":"5","left":"15","isLinked":false},"_element_width":"auto","__globals__":{"number_color":"globals\/colors?id=accent","title_color":"globals\/colors?id=accent"},"typography_number_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"typography_title_font_size_mobile":{"unit":"px","size":12,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_number_line_height_mobile":{"unit":"px","size":21,"sizes":[]}},"elements":[],"widgetType":"counter"},{"id":"a4b62ed","elType":"widget","settings":{"ending_number":961,"suffix":"K","title":"customers served","text_align":"left","typography_number_typography":"custom","typography_number_font_size":{"unit":"px","size":40,"sizes":[]},"typography_number_line_height":{"unit":"px","size":"","sizes":[]},"number_space":{"unit":"px","size":0,"sizes":[]},"_typography":"custom","_font_size":{"unit":"px","size":24,"sizes":[]},"typography_title_typography":"custom","typography_title_font_size":{"unit":"px","size":14,"sizes":[]},"typography_title_font_weight":"700","typography_title_text_transform":"uppercase","typography_title_line_height":{"unit":"px","size":20,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"15","bottom":"5","left":"15","isLinked":false},"_element_width":"auto","__globals__":{"number_color":"globals\/colors?id=accent","title_color":"globals\/colors?id=accent"},"typography_number_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"typography_title_font_size_mobile":{"unit":"px","size":12,"sizes":[]},"typography_number_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_number_line_height_mobile":{"unit":"px","size":20,"sizes":[]},"number_space_tablet":{"unit":"px","size":3,"sizes":[]},"number_space_mobile":{"unit":"px","size":5,"sizes":[]}},"elements":[],"widgetType":"counter"}],"isInner":true},{"id":"90a3b6f","elType":"column","settings":{"_column_size":50,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"963e5eb","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"30","padding":{"unit":"px","top":"85","right":"30","bottom":"100","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"1d607a6","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"54fee95","elType":"widget","settings":{"title_text":"High Quality Raw Materials","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do tempor.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_mobile":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"initial","_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":275,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]},"__globals__":{"primary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent","hover_primary_color":""},"selected_icon":{"value":"supplero-icon- supplero-icon-material","library":"supplero-icon"},"icon_size":{"unit":"px","size":60,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"primary_color":"#f2cb1f","hover_animation":"shrink","title_color":"#000000"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"7679f1f","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9c5b84d","elType":"widget","settings":{"title_text":"Top Rated And Reviewed","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do tempor.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_mobile":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"initial","_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":275,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]},"__globals__":{"primary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent"},"selected_icon":{"value":"supplero-icon- supplero-icon-top-rated","library":"supplero-icon"},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"shrink"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"48314e4","elType":"column","settings":{"_column_size":33,"_inline_size":null,"align":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"fac2028","elType":"widget","settings":{"title_text":"Trusted By Experts","description_text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do tempor.","icon_space":{"unit":"px","size":30,"sizes":[]},"icon_space_mobile":{"unit":"px","size":15,"sizes":[]},"title_typography_typography":"custom","title_typography_font_family":"Poppins","title_typography_font_size":{"unit":"px","size":20,"sizes":[]},"title_typography_line_height":{"unit":"px","size":24,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_family":"Poppins","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":24,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"initial","_element_width_tablet":"initial","_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":275,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":400,"sizes":[]},"__globals__":{"primary_color":"globals\/colors?id=primary","title_color":"globals\/colors?id=accent"},"selected_icon":{"value":"supplero-icon- supplero-icon-experts","library":"supplero-icon"},"icon_size":{"unit":"px","size":60,"sizes":[]},"title_typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"shrink"},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false},{"id":"d9282b5","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"0726646","elType":"column","settings":{"_column_size":50,"_inline_size":49,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/about_image-1.jpg","id":397},"background_position":"bottom center","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_motion_fx_scrolling":"yes","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_position_tablet":"bottom center","background_size_tablet":"cover"},"elements":[{"id":"221b9cf","elType":"widget","settings":{"space":{"unit":"px","size":540,"sizes":[]},"space_mobile":{"unit":"px","size":440,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":false},{"id":"f5d36c5","elType":"column","settings":{"_column_size":50,"_inline_size":51,"content_position":"center","space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"80","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"30","bottom":"50","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"30","bottom":"50","left":"30","isLinked":false},"align_mobile":"center"},"elements":[{"id":"24ad99c","elType":"widget","settings":{"editor":"<div>how it works<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"1b3bf5f","elType":"widget","settings":{"title":"Pushing the limits <br>\nof science and human <br>\npotential ","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"37aeea1","elType":"widget","settings":{"editor":"<div>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit.<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":440,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"49a5c85","elType":"widget","settings":{"text":"watch now","selected_icon":{"value":"far fa-play-circle","library":"fa-regular"},"icon_indent":{"unit":"px","size":15,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"bold","typography_text_transform":"uppercase","typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_radius":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"text_padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=accent","button_text_color":"globals\/colors?id=accent","button_background_hover_color":"","button_hover_border_color":"","style_button_hover_background":"globals\/colors?id=accent"},"align_mobile":"center","button_text_color":"#000000","border_color":"#000000","icon_button_size":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"9335c8b","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"70","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"1cb09aa","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"779102c","elType":"widget","settings":{"editor":"<div>our team<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.399999999999999911182158029987476766109466552734375,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"37a1124","elType":"widget","settings":{"title":"Meet Our Experts","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_custom_width":{"unit":"px","size":440,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"align":"center","typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"0906f02","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"40","margin":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"4797beb","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"94e3a9f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/about_image-2.jpg","id":540},"name":"Kevin Hart","job":"Nutrition Expert","description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore ","facebook":"https:\/\/www.facebook.com\/opalwordpress","twitter":"https:\/\/twitter.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","google":"https:\/\/plus.google.com\/u\/0\/+WPOpal","_css_classes":"supplero-box-clip","team_align":"left","__globals__":{"name_text_color_hover":"globals\/colors?id=accent"}},"elements":[],"widgetType":"supplero-team-box"}],"isInner":false},{"id":"9b849ba","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"2f63bcd","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/about_image-3.jpg","id":541},"name":"John Stone","job":"Nutrition Expert","description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore ","facebook":"https:\/\/www.facebook.com\/opalwordpress","twitter":"https:\/\/twitter.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","google":"https:\/\/plus.google.com\/u\/0\/+WPOpal","team_align":"left","__globals__":{"name_text_color_hover":"globals\/colors?id=accent"}},"elements":[],"widgetType":"supplero-team-box"}],"isInner":false},{"id":"b16564d","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"40","right":"15","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"aaadffa","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/about_image-4.jpg","id":542},"name":"Jack Reaper","job":"Nutrition Expert","description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore ","facebook":"https:\/\/www.facebook.com\/opalwordpress","twitter":"https:\/\/twitter.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","google":"https:\/\/plus.google.com\/u\/0\/+WPOpal","team_align":"left","__globals__":{"name_text_color_hover":"globals\/colors?id=accent"}},"elements":[],"widgetType":"supplero-team-box"}],"isInner":false},{"id":"3dcb902","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"2d44f0d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/about_image-5.jpg","id":543},"name":"Leon S. Kenedy","job":"Nutrition Expert","description":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore ","facebook":"https:\/\/www.facebook.com\/opalwordpress","twitter":"https:\/\/twitter.com\/opalwordpress","youtube":"https:\/\/www.youtube.com\/user\/WPOpalTheme","google":"https:\/\/plus.google.com\/u\/0\/+WPOpal","team_align":"left","__globals__":{"name_text_color_hover":"globals\/colors?id=accent"}},"elements":[],"widgetType":"supplero-team-box"}],"isInner":false}],"isInner":false},{"id":"4259e21","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"70","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"158879d","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"fb54d95","elType":"widget","settings":{"text":"Divider","gap":{"unit":"px","size":10,"sizes":[]},"__globals__":{"color":"globals\/colors?id=border"}},"elements":[],"widgetType":"divider"}],"isInner":false}],"isInner":false},{"id":"b1cdb44","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":0,"bottom":"20","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"454c8f2","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"c5c90a6","elType":"widget","settings":{"editor":"<div>Proud to partner with<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"0c20ff1","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-1.png","id":934},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"42aced7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-2.png","id":935},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"e336f27"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-3.png","id":936},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"4ac8eb7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-4.png","id":937},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"16fab77"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-6.png","id":939},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"fc2bd94"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-5.png","id":938},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1b76abe"}],"column":"6","column_mobile":"3","item_spacing_mobile":{"unit":"px","size":0,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"enable_carousel":"yes","navigation":"none"},"elements":[],"widgetType":"supplero-brand"}],"isInner":false}],"isInner":false}],"home-5":[{"id":"a6861d8","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","structure":"30","padding":{"unit":"px","top":"30","right":"30","bottom":"0","left":"30","isLinked":false},"custom_height":{"unit":"px","size":560,"sizes":[]},"overflow":"hidden","background_background":"classic","background_color":"#FFFFFF","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"column_position":"stretch","margin_mobile":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"96df543","elType":"column","settings":{"_column_size":33,"_inline_size":50,"space_between_widgets":0,"background_background":"classic","background_position":"center center","background_repeat":"no-repeat","background_hover_position":"center right","background_hover_repeat":"no-repeat","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-1-1.jpg","id":1376},"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_brightness":{"unit":"px","size":80,"sizes":[]},"background_overlay_hover_position":"center right","background_overlay_hover_repeat":"no-repeat","css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-1-1.jpg","id":1376},"background_size":"cover","background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_position_tablet":"center center","background_repeat_tablet":"no-repeat","background_size_tablet":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]}},"elements":[{"id":"66fc98a","elType":"section","settings":{"gap":"no","structure":"20","reverse_order_mobile":"reverse-mobile","html_tag":"div"},"elements":[{"id":"7800ff1","elType":"column","settings":{"_column_size":50,"_inline_size":46,"space_between_widgets":0,"padding":{"unit":"%","top":"31","right":"0","bottom":"18","left":"23","isLinked":false},"padding_tablet":{"unit":"px","top":"125","right":"0","bottom":"160","left":"40","isLinked":false},"padding_mobile":{"unit":"px","top":"20","right":"20","bottom":"50","left":"20","isLinked":false}},"elements":[{"id":"6a9cc2e","elType":"widget","settings":{"title":"Refreshing <br>\nflavors","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_z_index":1,"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":45,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":40,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"3377a64","elType":"widget","settings":{"editor":"<div>with a powerful synergistic impact<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"341d10d","elType":"widget","settings":{"editor":"<div>Starting at $199.00<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_font_weight":"300","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_z_index":1,"__globals__":{"text_color":"globals\/colors?id=primary"},"texteditor_shadow_text_shadow_type":"yes","texteditor_shadow_text_shadow":{"horizontal":0,"vertical":0,"blur":10,"color":"rgba(255, 255, 255, 0.3)"},"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":20,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":20,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"a518154","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":22,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","__globals__":{"button_background_hover_color":"","hover_color":"","style_button_hover_background":"globals\/colors?id=primary_hover"},"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"b4927a4","elType":"column","settings":{"_column_size":50,"_inline_size":54,"space_between_widgets":0,"content_position":"center","margin_mobile":{"unit":"px","top":"50","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"70","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"30fcc64","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_image-1-4.png","id":2322},"image_size":"full","_padding":{"unit":"px","top":"0","right":"4","bottom":"0","left":"0","isLinked":false},"motion_fx_translateY_direction":"negative","motion_fx_translateY_speed":{"unit":"px","size":3,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center","width_mobile":{"unit":"%","size":90,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"c41a3c8","elType":"column","settings":{"_column_size":33,"_inline_size":25,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"background_background":"classic","background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"space_between_widgets_tablet":0,"padding_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"ff25c41","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":266,"sizes":[]},"overflow":"hidden","structure":"20","background_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-2.jpg","id":1600},"background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"reverse_order_mobile":"reverse-mobile","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-2.jpg","id":1600},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_size_tablet":"cover","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"html_tag":"div"},"elements":[{"id":"19a6164","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"%","top":"15","right":"0","bottom":"27","left":"30","isLinked":false},"css_filters_hover_css_filter":"custom","css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"padding_tablet":{"unit":"px","top":"35","right":"0","bottom":"60","left":"30","isLinked":false},"content_position_tablet":"center","padding_mobile":{"unit":"px","top":"0","right":"20","bottom":"50","left":"20","isLinked":false},"z_index":1},"elements":[{"id":"5b0b517","elType":"widget","settings":{"editor":"<div>Don\u2019t miss out<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"2e7550d","elType":"widget","settings":{"title":"Boost your \nimmunity","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_z_index":1,"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":25,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"5320d24","elType":"widget","settings":{"editor":"<div>50% Off<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"fab2a9c","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":10,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","text_padding":{"unit":"px","top":"8","right":"17","bottom":"8","left":"17","isLinked":false},"__globals__":{"button_background_hover_color":"","hover_color":"","style_button_hover_background":"globals\/colors?id=primary_hover"},"_z_index":1,"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"da2c783","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_css_filter":"custom","css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"content_position":"center","margin_mobile":{"unit":"px","top":"50","right":"0","bottom":"0","left":"0","isLinked":false},"z_index":0},"elements":[{"id":"700220a","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_image-2.png","id":1602},"image_size":"full","_padding":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true},{"id":"0534b55","elType":"section","settings":{"gap":"no","custom_height_inner":{"unit":"px","size":266,"sizes":[]},"overflow":"hidden","margin":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"structure":"20","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-3.jpg","id":1663},"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"margin_tablet":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-3.jpg","id":1663},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_direction":"negative","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"html_tag":"div"},"elements":[{"id":"c308b96","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_css_filter":"custom","css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"content_position":"center","margin_mobile":{"unit":"px","top":"35","right":"0","bottom":"10","left":"0","isLinked":false},"z_index":0},"elements":[{"id":"2df5d1d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_image-3.png","id":1664},"image_size":"full","align_tablet":"right","align_mobile":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-115","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-100","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"b6107eb","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"%","top":"23","right":"10","bottom":"30","left":"9","isLinked":false},"css_filters_hover_css_filter":"custom","css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"padding_tablet":{"unit":"px","top":"50","right":"0","bottom":"65","left":"30","isLinked":false},"content_position_tablet":"center","padding_mobile":{"unit":"px","top":"0","right":"20","bottom":"50","left":"20","isLinked":false},"z_index":1},"elements":[{"id":"d18ddc9","elType":"widget","settings":{"editor":"<div>Limited offer<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"1c3102f","elType":"widget","settings":{"title":"Save up to \nhalf price","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center","typography_font_size_mobile":{"unit":"px","size":25,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"66071b5","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":12,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","text_padding":{"unit":"px","top":"8","right":"17","bottom":"9","left":"17","isLinked":false},"__globals__":{"button_background_hover_color":"","hover_color":"","style_button_hover_background":"globals\/colors?id=primary_hover"},"_z_index":1,"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"ab0a5fa","elType":"column","settings":{"_column_size":33,"_inline_size":24.666000000000000369482222595252096652984619140625,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"background_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-4.jpg","id":1702},"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"padding":{"unit":"px","top":"40","right":"30","bottom":"60","left":"30","isLinked":false},"_inline_size_tablet":50,"css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"20","bottom":"50","left":"20","isLinked":false},"content_position":"center","padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"55","left":"30","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-4.jpg","id":1702},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_size_tablet":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]}},"elements":[{"id":"46b0671","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_image-4.png","id":1703},"image_size":"full","align":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_z_index":0,"motion_fx_translateY_direction":"negative","motion_fx_translateY_speed":{"unit":"px","size":1,"sizes":[]},"motion_fx_devices":["desktop","tablet"]},"elements":[],"widgetType":"image"},{"id":"b653a2b","elType":"widget","settings":{"editor":"<div>Now available<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_z_index":1,"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"79b99f1","elType":"widget","settings":{"title":"The Choice of \nChampions","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_z_index":1,"align":"center","_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":25,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"cd4e340","elType":"widget","settings":{"editor":"<div>10% Off first order<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_z_index":1,"align":"center"},"elements":[],"widgetType":"text-editor"},{"id":"e3626ca","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":13,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","text_padding":{"unit":"px","top":"8","right":"16","bottom":"8","left":"16","isLinked":false},"__globals__":{"button_background_hover_color":"","hover_color":"","style_button_hover_background":"globals\/colors?id=primary_hover"},"_z_index":1,"align":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"87b6154","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","height":"min-height","custom_height":{"unit":"px","size":160,"sizes":[]},"stretch_section":"section-stretched","structure":"40","background_background":"classic","background_color":"#FFFFFF","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"custom_height_tablet":{"unit":"px","size":300,"sizes":[]},"padding_mobile":{"unit":"px","top":"50","right":"15","bottom":"50","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"af6261c","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"87dcec1","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-shipping-fast","library":"supplero-icon"},"title_text":"FREE Shipping","description_text":"On all orders over $50 delivered within Australia. ","position":"left","icon_space":{"unit":"px","size":25,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter","title_color":"globals\/colors?id=accent"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"bd6db71","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"b5e6633","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-globe-asia","library":"supplero-icon"},"title_text":"International Delivery","description_text":"International delivery available. ","position":"left","icon_space":{"unit":"px","size":25,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter","title_color":"globals\/colors?id=accent"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"9c81bd3","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"40","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"db0895b","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-undo-alt","library":"supplero-icon"},"title_text":"Easy Returns","description_text":"We make exchanging and\nreturning simple. ","position":"left","icon_space":{"unit":"px","size":25,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter","title_color":"globals\/colors?id=accent"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow"},"elements":[],"widgetType":"icon-box"}],"isInner":false},{"id":"af79230","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center"},"elements":[{"id":"35ed72a","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-box-alt","library":"supplero-icon"},"title_text":"Delivery Insurance","description_text":"Insurance on shipping included. ","position":"left","icon_space":{"unit":"px","size":25,"sizes":[]},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter","title_color":"globals\/colors?id=accent"},"icon_space_mobile":{"unit":"px","size":5,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow"},"elements":[],"widgetType":"icon-box"}],"isInner":false}],"isInner":false},{"id":"133b071","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"808196e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"5e3e6a5","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"c30e42e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-5.jpg","id":1818},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_hover_position":"center right","background_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"background_position_mobile":"top center","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_hover_position_mobile":"top center","background_hover_bg_width_mobile":{"unit":"px","size":0,"sizes":[]}},"elements":[{"id":"e19957b","elType":"widget","settings":{"space_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"eaf8735","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"%","top":"12","right":"14","bottom":"22","left":"12","isLinked":false},"css_classes":"supplero-box-clip","padding_tablet":{"unit":"%","top":"12","right":"10","bottom":"12","left":"10","isLinked":false}},"elements":[{"id":"4e7f81e","elType":"widget","settings":{"title":"Whey \nProtein","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"98dd596","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/protein\/\">Protein Powders<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"4b2d2f7","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/uncategorized\/\">Plant Based Protein<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"db2d512","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/protein-bars-cookies\/\">Protein Bars<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"45b2b2e","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/protein\/\">Protein Shake and Takes<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"0849203","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/protein-bars-cookies\/\">Protein Shots<\/a><\/div>","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"90","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"aba5cc4","elType":"widget","settings":{"text":"view all ","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"border_color":"globals\/colors?id=accent","button_background_hover_color":"","button_hover_border_color":"","style_button_hover_background":"globals\/colors?id=accent"},"text_padding":{"unit":"px","top":"15","right":"31","bottom":"15","left":"31","isLinked":false},"border_color":"#000000","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"a6c88c6","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"79530a9","elType":"widget","settings":{"limit":4,"column":"2","column_tablet":"2","column_mobile":"1","product_gutter_tablet":{"unit":"px","size":30,"sizes":[]},"list_layout":"4","product_gutter_mobile":{"unit":"px","size":15,"sizes":[]},"navigation":"none"},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"9ae8f26","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"122492c","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"b8b0686","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"b626583","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-6-1.jpg","id":2468},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_hover_position":"center left","background_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"background_position_mobile":"top center","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_hover_position_mobile":"top center"},"elements":[{"id":"5ffb88a","elType":"widget","settings":{"space_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"32ee45b","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"%","top":"12","right":"14","bottom":"22","left":"12","isLinked":false},"css_classes":"supplero-box-clip","padding_tablet":{"unit":"%","top":"12","right":"10","bottom":"12","left":"10","isLinked":false}},"elements":[{"id":"84c289d","elType":"widget","settings":{"title":"Recovery \n& Repair","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"left","typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":185,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"25","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"1eda015","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/endurance-energy\/\">Repair Shots<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"5839c38","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/creatine\/\">Recovery Shake and Takes<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"5bd45b5","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/endurance-energy\/\">Recovery Powder<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"582fa51","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/creatine\/\">Plant Based Protein<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"bf79437","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/endurance-energy\/\">Protein Bars<\/a><\/div>","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"90","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"da6fee7","elType":"widget","settings":{"text":"view all ","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"border_color":"globals\/colors?id=accent","button_background_hover_color":"","button_hover_border_color":"","style_button_hover_background":"globals\/colors?id=accent"},"text_padding":{"unit":"px","top":"15","right":"31","bottom":"15","left":"31","isLinked":false},"border_color":"#000000","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"28b98a9","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"c1e0e26","elType":"widget","settings":{"limit":4,"column":"2","column_tablet":"2","column_mobile":"1","product_gutter_tablet":{"unit":"px","size":30,"sizes":[]},"product_type":"best_selling","product_gutter_mobile":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"1931462","elType":"section","settings":{"gap":"no","custom_height":{"unit":"px","size":250,"sizes":[]},"column_position":"stretch","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"margin":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":true},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"57f41bf","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_position":"center center","background_repeat":"no-repeat","background_size":"cover","margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"content_position":"center","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-7.jpg","id":1940},"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-7.jpg","id":1940},"background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]}},"elements":[{"id":"d731ebc","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"11bfc31","elType":"column","settings":{"_column_size":50,"_inline_size":46,"content_position":"center","space_between_widgets":0,"padding":{"unit":"px","top":"35","right":"20","bottom":"45","left":"75","isLinked":false},"_inline_size_tablet":55,"padding_tablet":{"unit":"px","top":"30","right":"20","bottom":"30","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"277e457","elType":"widget","settings":{"editor":"<div>What\u2019s hot<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"c9694b9","elType":"widget","settings":{"title":"Best-selling <br>\nProtein Products","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"d38f342","elType":"widget","settings":{"editor":"<div>Up to 50% off<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":""},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1,"text_color":"#F2414F","align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"8c77899","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":12,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","text_padding":{"unit":"px","top":"9","right":"15","bottom":"9","left":"15","isLinked":false},"__globals__":{"button_background_hover_color":"","hover_color":"","style_button_hover_background":"globals\/colors?id=primary_hover"},"_z_index":1,"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"c383839","elType":"column","settings":{"_column_size":50,"_inline_size":54,"content_position":"center","space_between_widgets":0,"_inline_size_tablet":45,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"26d532c","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_image-5.png","id":1949},"image_size":"full","align":"center","motion_fx_mouseTrack_speed":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"a75677d","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"content_position":"center","background_background":"classic","background_overlay_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-8.jpg","id":1977},"background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-8.jpg","id":1977},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_hover_background":"classic","__globals__":{"background_overlay_hover_color":"globals\/colors?id=accent"},"background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_hover_opacity":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]}},"elements":[{"id":"6e0f73f","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"01f3d46","elType":"column","settings":{"_column_size":50,"_inline_size":46,"content_position":"center","space_between_widgets":0,"padding":{"unit":"px","top":"30","right":"20","bottom":"40","left":"75","isLinked":false},"_inline_size_tablet":55,"padding_tablet":{"unit":"px","top":"30","right":"20","bottom":"30","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"962e8de","elType":"widget","settings":{"editor":"<div>Clearance<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":16,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"4d788f8","elType":"widget","settings":{"title":"The fully loaded <br>\nPower Whey","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"heading"},{"id":"c3118dc","elType":"widget","settings":{"editor":"<div>From $45.55<\/div>","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_weight":"300","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=primary"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_z_index":1,"align_mobile":"center"},"elements":[],"widgetType":"text-editor"},{"id":"01ce429","elType":"widget","settings":{"text":"shop now","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":12,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#FFFFFF33","text_padding":{"unit":"px","top":"9","right":"15","bottom":"9","left":"15","isLinked":false},"__globals__":{"button_background_hover_color":"","hover_color":"","style_button_hover_background":"globals\/colors?id=primary_hover"},"_z_index":1,"align_mobile":"center","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true},{"id":"3810a6a","elType":"column","settings":{"_column_size":50,"_inline_size":54,"content_position":"center","space_between_widgets":0,"_inline_size_tablet":45,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false}},"elements":[{"id":"f0e11d0","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_image-6.png","id":1996},"image_size":"full","align":"left","align_mobile":"center","motion_fx_mouseTrack_direction":"negative","motion_fx_mouseTrack_speed":{"unit":"px","size":0.1000000000000000055511151231257827021181583404541015625,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"d7c2b71","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"2c0ed6b","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d259ce5","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"0b51b9e","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-9-1.jpg","id":2518},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_hover_position":"center left","background_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"background_position_mobile":"top center","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_hover_position_mobile":"top center"},"elements":[{"id":"24236ff","elType":"widget","settings":{"space_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"6a452e8","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"%","top":"12","right":"14","bottom":"22","left":"12","isLinked":false},"css_classes":"supplero-box-clip","padding_tablet":{"unit":"%","top":"12","right":"10","bottom":"12","left":"10","isLinked":false}},"elements":[{"id":"4e9dce0","elType":"widget","settings":{"title":"Vitamins \n& Minerals","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"left","typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":200,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"32","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"8f2c715","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/hot-offers\/\" data-wplink-edit=\"true\">Vitamin D3<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"58e0513","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/hot-offers\/\">Daily Multivitamin<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"3aae29d","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/hot-offers\/\">Daily Omega-3<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"4a05505","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/food-products\/\">Selenium<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"d205e34","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/hot-offers\/\">Chromium<\/a><\/div>","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"90","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"96d4701","elType":"widget","settings":{"text":"view all ","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"border_color":"globals\/colors?id=accent","button_background_hover_color":"","button_hover_border_color":"","style_button_hover_background":"globals\/colors?id=accent"},"text_padding":{"unit":"px","top":"15","right":"31","bottom":"15","left":"31","isLinked":false},"border_color":"#000000","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"a6a717c","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"742ec68","elType":"widget","settings":{"limit":4,"column":"2","column_tablet":"2","column_mobile":"1","product_gutter_tablet":{"unit":"px","size":30,"sizes":[]},"product_type":"top_rated","product_gutter_mobile":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"dc6e80e","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","margin":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"214e030","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d5cffe5","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"96e85ac","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home5_bg-10.jpg","id":2540},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_hover_position":"center left","background_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"background_position_mobile":"top center","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_hover_position_mobile":"top center"},"elements":[{"id":"72c3986","elType":"widget","settings":{"space_mobile":{"unit":"px","size":400,"sizes":[]}},"elements":[],"widgetType":"spacer"}],"isInner":true},{"id":"aebb289","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#FFFFFF","padding":{"unit":"%","top":"12","right":"14","bottom":"22","left":"12","isLinked":false},"css_classes":"supplero-box-clip","padding_tablet":{"unit":"%","top":"12","right":"9","bottom":"12","left":"9","isLinked":false}},"elements":[{"id":"bd5f06c","elType":"widget","settings":{"title":"Energy & \nEndurance","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":40,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"align_mobile":"left","typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_element_width_mobile":"initial","_element_custom_width":{"unit":"px","size":215,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"f39fa5c","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/uncategorized\/\">Xplode Shots<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"cab27d0","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/vegan-nutrition\/\">Energy Gels<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"da14ebc","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/uncategorized\/\">Hydration<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"ecbc7ff","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/vegan-nutrition\/\">Beta-Alanine<\/a><\/div>","_border_border":"solid","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"38fa1a1","elType":"widget","settings":{"editor":"<div><a href=\"https:\/\/demo2wpopal.b-cdn.net\/supplero\/product-category\/uncategorized\/\">Creatine Monohydrate<\/a><\/div>","_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"__globals__":{"_border_color":"globals\/colors?id=border"},"typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_line_height":{"unit":"px","size":50,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"90","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"ab18caf","elType":"widget","settings":{"text":"view all ","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":20,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"background_color":"#FFFFFF","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"__globals__":{"border_color":"globals\/colors?id=accent","button_background_hover_color":"","button_hover_border_color":"","style_button_hover_background":"globals\/colors?id=accent"},"text_padding":{"unit":"px","top":"15","right":"31","bottom":"15","left":"31","isLinked":false},"border_color":"#000000","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"afce9e7","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"7c8a76f","elType":"widget","settings":{"limit":4,"column":"2","column_tablet":"2","column_mobile":"1","product_gutter_tablet":{"unit":"px","size":30,"sizes":[]},"product_type":"best_selling","product_gutter_mobile":{"unit":"px","size":15,"sizes":[]}},"elements":[],"widgetType":"supplero-products"}],"isInner":false}],"isInner":false},{"id":"cbcacd1","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"35","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"6ef3761","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/home5_bg-11-5.jpg","id":6563},"background_position":"top center","background_position_tablet":"bottom right","background_xpos_tablet":{"unit":"px","size":-1000,"sizes":[]},"background_repeat":"no-repeat","background_size":"cover","background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_color":"#8A0006","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_css_filter":"custom","overlay_blend_mode":"multiply","padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"2394bbb","elType":"section","settings":{"structure":"20","padding":{"unit":"px","top":"80","right":"30","bottom":"80","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"80","right":"0","bottom":"80","left":"0","isLinked":false},"gap":"no","html_tag":"div"},"elements":[{"id":"e712c99","elType":"column","settings":{"_column_size":50,"_inline_size":33.332999999999998408384271897375583648681640625,"_inline_size_tablet":100,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4bcaf21","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-comment","library":"supplero-icon"},"title_text":"Here\'s what <br> our happy clients <br> are saying","description_text":"","primary_color":"#FFFFFF","icon_space":{"unit":"px","size":20,"sizes":[]},"text_align":"left","text_align_tablet":"center","title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":40,"sizes":[]},"title_typography_line_height":{"unit":"px","size":40,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"title_typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"title_typography_line_height_mobile":{"unit":"px","size":30,"sizes":[]},"icon_space_mobile":{"unit":"px","size":0,"sizes":[]},"icon_size_mobile":{"unit":"px","size":30,"sizes":[]},"title_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"798e6e5","elType":"column","settings":{"_column_size":50,"_inline_size":66.667000000000001591615728102624416351318359375,"_inline_size_tablet":100,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"margin_tablet":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"align_mobile":"center","padding_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false}},"elements":[{"id":"a778f3a","elType":"widget","settings":{"testimonials":[{"testimonial_rating":"5","testimonial_content":"\u201cGood product good price prompt efficient service. Gives you energy to workout harder and longer. Many thanks for your help.\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/avatar-1.jpg","id":4297},"testimonial_name":"Brian G. Moore ","testimonial_job":"Gym Mod","_id":"c973293","testimonial_link":{"url":"#"}},{"testimonial_rating":5,"testimonial_content":"\u201cBest supplements best results. Colton is an amazing consultant with tons of knowledge! Always has the right suggestions!\u201d ","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/avatar-2.jpg","id":4298},"testimonial_name":"Kevin Hart","testimonial_job":"Bodybuilding","_id":"9f7535d","testimonial_link":{"url":"#"}},{"testimonial_rating":5,"testimonial_content":"\u201cDiscount Supplements is probably the best protein supplement company in the UK in every respect. Thoroughly recommended.\u201d","testimonial_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/avatar-4.jpg","id":5525},"testimonial_name":"Ken Haywood","testimonial_job":"Cunningham Store","_id":"a5a2566","testimonial_link":{"url":"#"}}],"testimonial_alignment":"left","content_content_color":"#FFFFFF","name_text_color":"#FFFFFF","_element_custom_width":{"unit":"px","size":370,"sizes":[]},"column":"2","padding_estimonial_wrapper":{"unit":"px","top":"0","right":"30","bottom":"0","left":"0","isLinked":false},"enable_carousel":"yes","navigation":"none","autoplay_speed":1500,"column_tablet":"2","column_mobile":"1","padding_estimonial_wrapper_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"content_typography_typography":"custom","content_typography_font_family":"Poppins","content_typography_font_size":{"unit":"px","size":20,"sizes":[]},"content_typography_line_height":{"unit":"px","size":30,"sizes":[]},"content_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"content_spacing":{"unit":"px","top":"35","right":"0","bottom":"38","left":"0","isLinked":false},"content_spacing_mobile":{"unit":"px","top":"15","right":"0","bottom":"15","left":"0","isLinked":false},"name_typography_typography":"custom","name_typography_font_family":"Poppins","name_typography_font_size":{"unit":"px","size":16,"sizes":[]},"name_typography_line_height":{"unit":"px","size":24,"sizes":[]},"name_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"name_text_color_hover":"globals\/colors?id=primary_hover"},"testimonial_alignment_mobile":"center","content_typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"content_typography_line_height_mobile":{"unit":"px","size":25,"sizes":[]}},"elements":[],"widgetType":"supplero-testimonials"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"59efd58","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"7dcc077","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"51c748e","elType":"widget","settings":{"title":"Our Products","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"c13356f","elType":"widget","settings":{"tabs":[{"tab_title":"New Arrivals  ","_id":"cfa73f9","limit":4,"product_layout":"list","list_layout":"5"},{"tab_title":"Featured ","_id":"acfe3b4","limit":4,"product_layout":"list","list_layout":"5","categories":[],"product_type":"top_rated"},{"tab_title":"Best Selller","_id":"6e6fe61","limit":4,"product_layout":"list","list_layout":"5","categories":[],"product_type":"best_selling"}],"column":"4","column_tablet":"2","column_mobile":"1","product_gutter":{"unit":"px","size":30,"sizes":[]},"product_gutter_tablet":{"unit":"px","size":20,"sizes":[]},"product_gutter_mobile":{"unit":"px","size":15,"sizes":[]},"tab_header_padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_items":"right","align_items_mobile":"center","header_margin":{"unit":"px","size":1,"sizes":[]},"tab_typography_typography":"custom","tab_typography_font_size":{"unit":"px","size":12,"sizes":[]},"tab_typography_font_weight":"bold","tab_typography_text_transform":"uppercase","tab_typography_line_height":{"unit":"px","size":36,"sizes":[]},"tab_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"tab_title_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"border_tabs_title_border":"solid","border_tabs_title_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"enable_carousel":"yes","_margin":{"unit":"px","top":"-40","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=lighter","title_hover_color":"globals\/colors?id=accent","border_tabs_title_color":"globals\/colors?id=border","title_hover_border_color":"globals\/colors?id=primary","title_background_hover_color":"globals\/colors?id=primary","title_active_color":"globals\/colors?id=accent","title_background_active_color":"globals\/colors?id=primary","title_active_border_color":"globals\/colors?id=primary"},"tab_header_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"dots_vertical_value_tablet":{"unit":"px","size":-35,"sizes":[]}},"elements":[],"widgetType":"supplero-products-tabs"}],"isInner":false}],"isInner":false},{"id":"5805cc1","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"40","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_tablet":{"unit":"px","top":"95","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"70","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"3cc69f1","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"5279a86","elType":"widget","settings":{"text":"Divider","gap":{"unit":"px","size":10,"sizes":[]},"__globals__":{"color":"globals\/colors?id=border"}},"elements":[],"widgetType":"divider"}],"isInner":false}],"isInner":false},{"id":"f85ad88","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"55","right":0,"bottom":"45","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"55","right":0,"bottom":"45","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"50","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"6c496ce","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"eed98d0","elType":"widget","settings":{"editor":"<div>Proud to partner with<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"b59d1a4","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-1.png","id":934},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"42aced7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-2.png","id":935},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"e336f27"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-3.png","id":936},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"4ac8eb7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-4.png","id":937},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"16fab77"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-6.png","id":939},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"fc2bd94"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-5.png","id":938},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1b76abe"}],"column":"6","column_mobile":"3","item_spacing_mobile":{"unit":"px","size":0,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"enable_carousel":"yes","navigation":"none"},"elements":[],"widgetType":"supplero-brand"}],"isInner":false}],"isInner":false}],"home-4":[{"id":"4f7b4cd","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"-60","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"5a2fffc","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home4_bg-2.jpg","id":3065},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_motion_fx_translateY_effect":"yes","background_motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"background_motion_fx_devices":["desktop","tablet"],"background_overlay_background":"classic","background_overlay_color":"#9F0129","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"overlay_blend_mode":"multiply","background_overlay_hover_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_brightness":{"unit":"px","size":90,"sizes":[]},"background_overlay_hover_transition":{"unit":"px","size":0.40000000000000002220446049250313080847263336181640625,"sizes":[]},"padding":{"unit":"px","top":"70","right":"0","bottom":"70","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"0","bottom":"40","left":"0","isLinked":false},"background_hover_background":"classic"},"elements":[{"id":"b56a332","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"22e4675","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position_tablet":"center","space_between_widgets":0,"padding":{"unit":"px","top":"0","right":"25","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"0a67076","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home4_image-3.png","id":3066},"image_size":"full","align":"right","align_mobile":"center"},"elements":[],"widgetType":"image"},{"id":"0f426e2","elType":"widget","settings":{"title":"<span style=\"font-size:18px; font-weight: 400\">Starting at<\/span> <br> $39.99","header_size":"h4","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":30,"sizes":[]},"_padding":{"unit":"px","top":"28","right":"14","bottom":"37","left":"22","isLinked":false},"_z_index":2,"_background_background":"classic","_background_color":"#01C671","_border_radius":{"unit":"%","top":"50","right":"50","bottom":"50","left":"50","isLinked":true},"_element_width":"auto","_position":"absolute","typography_font_size_mobile":{"unit":"px","size":24,"sizes":[]},"_padding_mobile":{"unit":"px","top":"22","right":"15","bottom":"33","left":"15","isLinked":false},"_offset_x":{"size":150,"unit":"px"},"_offset_y_mobile":{"size":50,"unit":"px"},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_box_shadow_box_shadow_type":"yes","_box_shadow_box_shadow":{"horizontal":0,"vertical":5,"blur":10,"spread":0,"color":"rgba(0, 0, 0, 0.3)"},"_offset_x_tablet":{"size":120,"unit":"px"},"_offset_x_mobile":{"size":110,"unit":"px"},"_offset_y":{"size":50,"unit":"px"},"_offset_y_tablet":{"size":50,"unit":"px"},"motion_fx_mouseTrack_effect":"yes","motion_fx_mouseTrack_speed":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"9fb41c1","elType":"column","settings":{"_column_size":50,"_inline_size":null,"align_mobile":"center","space_between_widgets":0,"padding":{"unit":"px","top":"35","right":"30","bottom":"60","left":"95","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"40","left":"40","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"30","bottom":"50","left":"30","isLinked":false}},"elements":[{"id":"1d97a9d","elType":"widget","settings":{"editor":"<div>don\u2019t miss<\/div>","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":14,"sizes":[]},"typography_font_weight":"bold","typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":24,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_padding":{"unit":"px","top":"0","right":"15","bottom":"0","left":"5","isLinked":false},"_css_classes":"supplero-box-clip-sm","_background_background":"classic","_background_color":"#E60822","_element_width":"auto"},"elements":[],"widgetType":"text-editor"},{"id":"3e23cae","elType":"widget","settings":{"title":"Health Pack <br>\n24\/7","align_mobile":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":60,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":45,"sizes":[]},"typography_line_height":{"unit":"px","size":60,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":45,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"10","right":"0","bottom":"15","left":"0","isLinked":false},"_element_custom_width":{"unit":"px","size":360,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":50,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":50,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"498249e","elType":"widget","settings":{"editor":"<div>Advanced multivitamin, probiotic, fatty acids and minerals formula<\/div>","align_mobile":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"300","typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_element_width":"initial","_element_width_tablet":"initial","_element_custom_width":{"unit":"px","size":370,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"825e07e","elType":"widget","settings":{"text":"shop now","align_mobile":"center","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":25,"sizes":[]},"icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"a3005ef","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"65","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"116e695","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"c50c0ce","elType":"widget","settings":{"editor":"<div>shop by categories<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.5,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"13e38d8","elType":"widget","settings":{"title":"Popular Categories","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"40","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"bff96ca","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"html_tag":"div"},"elements":[{"id":"44fe702","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4fab199","elType":"widget","settings":{"categories":"accusantium","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h1_banner-2.jpg","id":660},"show_decor":"yes","categories_list":[]},"elements":[],"widgetType":"supplero-product-categories"},{"id":"1fa0086","elType":"widget","settings":{"categories_list":[{"_id":"cb514f6","categories_name":"Whey Protein","categories":"protein","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/home4_image-1.jpg","id":4662}}],"alignment":"","product_cate_layout":"2","column":"1","column_tablet":"1","alignment_tablet":"center","alignment_mobile":"center","column_mobile":"1","image_height_tablet":{"unit":"px","size":350,"sizes":[]},"image_height_mobile":{"unit":"px","size":230,"sizes":[]}},"elements":[],"widgetType":"supplero-product-categories"}],"isInner":false},{"id":"c3fe927","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"space_between_widgets":0,"margin_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"068e058","elType":"widget","settings":{"categories":"accusantium","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/h3_banner-6-1.png","id":2844},"show_decor":"yes","categories_list":[]},"elements":[],"widgetType":"supplero-product-categories"},{"id":"2aa2b95","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"13f0ac1","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"042278e","elType":"widget","settings":{"categories_list":[{"_id":"86827a2","categories_name":"Pre-Workout","categories":"creatine","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/home4_image-2-1.jpg","id":4684}}],"product_cate_layout":"2","column_tablet":"1","alignment":"","alignment_tablet":"center","alignment_mobile":"center","column_mobile":"1"},"elements":[],"widgetType":"supplero-product-categories"}],"isInner":true}],"isInner":true},{"id":"c149638","elType":"section","settings":{"structure":"20","gap":"no","margin":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"20","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"15","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"893639a","elType":"column","settings":{"_column_size":50,"_inline_size":null,"align_mobile":"center","space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"7.5","bottom":"0","left":"0","isLinked":false},"_inline_size_mobile":50,"margin_tablet":{"unit":"px","top":"0","right":"10","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"1c29909","elType":"widget","settings":{"categories_list":[{"_id":"8f41b10","categories_name":"energy","categories":"uncategorized","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h2_ct-3.jpg","id":4523}}],"product_cate_layout":"2","column_tablet":"1","column_mobile":"1","alignment":"","alignment_mobile":"center"},"elements":[],"widgetType":"supplero-product-categories"}],"isInner":true},{"id":"140882b","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"7.5","isLinked":false},"_inline_size_mobile":50,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"10","isLinked":false}},"elements":[{"id":"66831fb","elType":"widget","settings":{"categories_list":[{"_id":"8f41b10","categories_name":"recovery","categories":"uncategorized","category_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/h2_ct-4.jpg","id":4524}}],"product_cate_layout":"2","column_tablet":"1","column_mobile":"1","alignment":"","alignment_mobile":"center"},"elements":[],"widgetType":"supplero-product-categories"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"381cf77","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"65","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"19de3f6","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"76dceaa","elType":"widget","settings":{"title":"Our Products","align_mobile":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]}},"elements":[],"widgetType":"heading"},{"id":"2db5348","elType":"widget","settings":{"tabs":[{"tab_title":"New Arrivals  ","_id":"cfa73f9","limit":8},{"tab_title":"Featured ","_id":"acfe3b4","limit":8,"product_type":"best_selling"},{"tab_title":"Best Selller","_id":"6e6fe61","limit":8,"product_type":"top_rated"}],"column":"4","column_tablet":"3","column_mobile":"2","product_gutter":{"unit":"px","size":30,"sizes":[]},"product_gutter_tablet":{"unit":"px","size":20,"sizes":[]},"product_gutter_mobile":{"unit":"px","size":15,"sizes":[]},"tab_header_padding":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"align_items":"right","align_items_mobile":"center","header_margin":{"unit":"px","size":1,"sizes":[]},"tab_typography_typography":"custom","tab_typography_font_size":{"unit":"px","size":12,"sizes":[]},"tab_typography_font_weight":"bold","tab_typography_text_transform":"uppercase","tab_typography_line_height":{"unit":"px","size":36,"sizes":[]},"tab_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"tab_title_padding":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"border_tabs_title_border":"solid","border_tabs_title_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"navigation":"none","_margin":{"unit":"px","top":"-40","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=lighter","title_hover_color":"globals\/colors?id=accent","border_tabs_title_color":"globals\/colors?id=border","title_hover_border_color":"globals\/colors?id=primary","title_background_hover_color":"globals\/colors?id=primary","title_active_color":"globals\/colors?id=accent","title_background_active_color":"globals\/colors?id=primary","title_active_border_color":"globals\/colors?id=primary"},"tab_header_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"tab_typography_line_height_tablet":{"unit":"px","size":"","sizes":[]}},"elements":[],"widgetType":"supplero-products-tabs"},{"id":"e65e8ba","elType":"widget","settings":{"text":"view all products","align":"center","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":15,"sizes":[]},"background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"_margin":{"unit":"px","top":"20","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"button_text_color":"","button_background_hover_color":"","border_color":"globals\/colors?id=accent","style_button_hover_background":"globals\/colors?id=accent"},"border_color":"#000000","icon_button_size":{"unit":"px","size":8,"sizes":[]}},"elements":[],"widgetType":"button"}],"isInner":false}],"isInner":false},{"id":"a690846","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"80","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"overflow":"hidden","margin_mobile":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"dfceb8b","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_motion_fx_devices":["desktop","tablet"],"background_hover_background":"classic","background_overlay_position":"center center","background_overlay_repeat":"no-repeat","background_overlay_size":"cover","background_overlay_opacity":{"unit":"px","size":1,"sizes":[]},"background_overlay_hover_opacity":{"unit":"px","size":1,"sizes":[]},"css_filters_hover_brightness":{"unit":"px","size":60,"sizes":[]},"background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home4_bg-1.jpg","id":2905},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","background_overlay_hover_color":"#0201014D","background_overlay_hover_background":"classic"},"elements":[{"id":"cf7a6bc","elType":"section","settings":{"gap":"no","z_index":1,"overflow":"hidden","html_tag":"div"},"elements":[{"id":"7502c30","elType":"column","settings":{"_column_size":100,"_inline_size":null,"align":"center","align_mobile":"center","space_between_widgets":0,"padding":{"unit":"px","top":"75","right":"0","bottom":"85","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"20","bottom":"50","left":"20","isLinked":false}},"elements":[{"id":"b53b2df","elType":"widget","settings":{"editor":"<div>best offer<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_z_index":1,"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"2626c7c","elType":"widget","settings":{"title":"Deal Of The Day","align":"center","title_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height":{"unit":"px","size":"","sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false},"_z_index":1,"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":"","sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"bb67945","elType":"widget","settings":{"editor":"<div>70% Off all Whey Protein products for the next 02 day only<\/div>","align":"center","text_color":"#FFFFFF","typography_typography":"custom","typography_font_size":{"unit":"px","size":24,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"15","left":"0","isLinked":false},"_element_width":"initial","_element_custom_width":{"unit":"px","size":470,"sizes":[]},"_z_index":1,"typography_font_size_tablet":{"unit":"px","size":20,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":17,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":23,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"4f5083a","elType":"widget","settings":{"editor":"<div>Limited Quantities. hurry up!<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.5,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_z_index":1},"elements":[],"widgetType":"text-editor"},{"id":"0be46bf","elType":"widget","settings":{"due_date":"2021-01-31 18:46","custom_labels":"yes","label_days":"Days","label_hours":"hrs","label_minutes":"mins","label_seconds":"secs","container_width":{"unit":"%","size":30,"sizes":[]},"container_width_tablet":{"unit":"%","size":50,"sizes":[]},"container_width_mobile":{"unit":"%","size":100,"sizes":[]},"digits_typography_typography":"custom","digits_typography_font_size":{"unit":"px","size":40,"sizes":[]},"digits_typography_font_weight":"bold","digits_typography_line_height":{"unit":"px","size":20,"sizes":[]},"digits_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":12,"sizes":[]},"label_typography_text_transform":"uppercase","label_typography_line_height":{"unit":"px","size":1,"sizes":[]},"label_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width_mobile":"initial","_element_custom_width_mobile":{"unit":"px","size":320,"sizes":[]},"__globals__":{"box_background_color":"globals\/colors?id=secondary"},"_z_index":1,"label_padding":{"unit":"px","size":20,"sizes":[]},"digits_typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"digits_typography_font_size_mobile":{"unit":"px","size":25,"sizes":[]},"digits_typography_line_height_mobile":{"unit":"px","size":10,"sizes":[]}},"elements":[],"widgetType":"countdown"},{"id":"c6251f0","elType":"widget","settings":{"text":"view all deals","align":"center","selected_icon":{"value":"supplero-icon- supplero-icon-arrow-supplero","library":"supplero-icon"},"icon_align":"right","icon_indent":{"unit":"px","size":23,"sizes":[]},"typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"button_text_color":"#FFFFFF","background_color":"#02010100","border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"border_color":"#FFFFFF","text_padding":{"unit":"px","top":"15","right":"30","bottom":"15","left":"30","isLinked":false},"_margin":{"unit":"px","top":"35","right":"0","bottom":"0","left":"0","isLinked":false},"__globals__":{"border_color":"","button_background_hover_color":"","button_hover_border_color":"globals\/colors?id=primary_hover","hover_color":"","style_button_hover_background":"globals\/colors?id=primary_hover"},"_z_index":1,"icon_button_size":{"unit":"px","size":8,"sizes":[]},"style_button_hover_background":"#c7a21e"},"elements":[],"widgetType":"button"},{"id":"bfa487f","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home4_image-1.png","id":2934},"image_size":"full","_z_index":0,"motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_position":"absolute","_offset_x":{"size":-495,"unit":"px"},"_offset_x_tablet":{"unit":"px","size":-290,"sizes":[]},"_offset_x_mobile":{"unit":"px","size":-230,"sizes":[]},"_offset_y":{"size":-20,"unit":"px"},"_offset_y_mobile":{"unit":"px","size":40,"sizes":[]},"_offset_y_end":{"unit":"px","size":0,"sizes":[]},"motion_fx_translateX_direction":"negative","motion_fx_translateX_speed":{"unit":"px","size":1,"sizes":[]}},"elements":[],"widgetType":"image"},{"id":"2626f5d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/home4_image-2.png","id":2935},"image_size":"full","_z_index":0,"motion_fx_translateY_speed":{"unit":"px","size":2,"sizes":[]},"motion_fx_devices":["desktop","tablet"],"_position":"absolute","_offset_x":{"size":515,"unit":"px"},"_offset_x_tablet":{"unit":"px","size":390,"sizes":[]},"_offset_x_end":{"unit":"px","size":104,"sizes":[]},"_offset_y":{"size":5,"unit":"px"},"motion_fx_translateX_speed":{"unit":"px","size":1,"sizes":[]}},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"dd196af","elType":"section","settings":{"content_width":{"unit":"px","size":1800,"sizes":[]},"gap":"no","stretch_section":"section-stretched","padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"html_tag":"div"},"elements":[{"id":"ae7f129","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0,"background_background":"classic","background_color":"#1C2127","padding":{"unit":"px","top":"40","right":"0","bottom":"40","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"40","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"20","bottom":"50","left":"20","isLinked":false}},"elements":[{"id":"90d937c","elType":"section","settings":{"content_width":{"unit":"px","size":1320,"sizes":[]},"gap":"no","structure":"40","html_tag":"div"},"elements":[{"id":"75ac869","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"align_mobile":"center","margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"895e451","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-shipping-fast","library":"supplero-icon"},"title_text":"FREE Shipping","description_text":"On all orders over $50 delivered within Australia. ","position":"left","icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter"},"icon_space":{"unit":"px","size":25,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow"},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"5a6a758","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"align_mobile":"center","margin_tablet":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"b293c1f","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-globe-asia","library":"supplero-icon"},"title_text":"International Delivery","description_text":"International delivery available. ","position":"left","icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter"},"icon_space":{"unit":"px","size":25,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow"},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"c3a47ab","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"align_mobile":"center","margin_tablet":{"unit":"px","top":"30","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"10e6331","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-undo-alt","library":"supplero-icon"},"title_text":"Easy Returns","description_text":"We make exchanging and\nreturning simple. ","position":"left","icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter"},"icon_space":{"unit":"px","size":25,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow"},"elements":[],"widgetType":"icon-box"}],"isInner":true},{"id":"ec90241","elType":"column","settings":{"_column_size":25,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"_inline_size_tablet":50,"align_mobile":"center","margin_tablet":{"unit":"px","top":"30","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"b297b59","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-box-alt","library":"supplero-icon"},"title_text":"Delivery Insurance","description_text":"Insurance on shipping included. ","position":"left","icon_size":{"unit":"px","size":40,"sizes":[]},"title_bottom_space":{"unit":"px","size":0,"sizes":[]},"title_color":"#FFFFFF","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":14,"sizes":[]},"title_typography_line_height":{"unit":"px","size":20,"sizes":[]},"title_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":14,"sizes":[]},"description_typography_line_height":{"unit":"px","size":20,"sizes":[]},"description_typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_element_width":"initial","_element_custom_width":{"unit":"px","size":270,"sizes":[]},"__globals__":{"description_color":"globals\/colors?id=lighter","hover_primary_color":""},"icon_space":{"unit":"px","size":25,"sizes":[]},"icon_space_mobile":{"unit":"px","size":10,"sizes":[]},"_element_custom_width_mobile":{"unit":"px","size":320,"sizes":[]},"link":{"url":"#","is_external":"","nofollow":"","custom_attributes":""},"hover_animation":"grow","description_color":"#999999"},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"d9eca93","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"65","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"45","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"50","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"77294db","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"918c6fa","elType":"widget","settings":{"editor":"<div>Products in Focus<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2.5,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=lighter"},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"879307e","elType":"widget","settings":{"title":"Pick For You","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":40,"sizes":[]},"typography_line_height":{"unit":"px","size":48,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"35","left":"0","isLinked":false},"__globals__":{"title_color":"globals\/colors?id=accent"},"typography_font_size_mobile":{"unit":"px","size":28,"sizes":[]},"typography_line_height_mobile":{"unit":"px","size":28,"sizes":[]},"typography_font_size_tablet":{"unit":"px","size":30,"sizes":[]},"typography_line_height_tablet":{"unit":"px","size":35,"sizes":[]},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"250243c","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"263f081","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"7109a4f","elType":"widget","settings":{"product_layout":"list","column_mobile":"1","product_gutter":{"unit":"px","size":30,"sizes":[]},"categories":[],"enable_carousel":"yes","navigation":"none","limit":3},"elements":[],"widgetType":"supplero-products"}],"isInner":true}],"isInner":true},{"id":"ad31aec","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"20","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"5","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"e69470a","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"999d65a","elType":"widget","settings":{"product_layout":"list","column_mobile":"1","product_gutter":{"unit":"px","size":30,"sizes":[]},"product_type":"best_selling","enable_carousel":"yes","navigation":"none","limit":3},"elements":[],"widgetType":"supplero-products"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"7e31947","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","margin":{"unit":"px","top":"70","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"0","left":"15","isLinked":false},"content_width":{"unit":"px","size":1800,"sizes":[]},"margin_mobile":{"unit":"px","top":"40","right":0,"bottom":"0","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"c35f13c","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"eeca428","elType":"widget","settings":{"column_tablet":"2","item_spacing":{"unit":"px","size":0,"sizes":[]},"pagination_page_limit":"5","pagination_prev_label":"&laquo; Previous","pagination_next_label":"Next &raquo;","enable_carousel":"yes","navigation":"none"},"elements":[],"widgetType":"supplero-post-grid"}],"isInner":false}],"isInner":false},{"id":"3e80db0","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"45","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"stretch_section":"section-stretched","border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"30","bottom":"45","left":"30","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"30","bottom":"45","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"15","bottom":"45","left":"15","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=border"},"html_tag":"div"},"elements":[{"id":"4702e91","elType":"column","settings":{"_column_size":100,"_inline_size":null,"space_between_widgets":0},"elements":[{"id":"2999201","elType":"widget","settings":{"editor":"<div>Proud to partner with<\/div>","align":"center","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_text_transform":"uppercase","typography_line_height":{"unit":"px","size":36,"sizes":[]},"typography_letter_spacing":{"unit":"px","size":2,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"0","bottom":"50","left":"0","isLinked":false},"__globals__":{"text_color":"globals\/colors?id=lighter"},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"10","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"20","left":"0","isLinked":false}},"elements":[],"widgetType":"text-editor"},{"id":"9048fdd","elType":"widget","settings":{"brands":[{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-1.png","id":934},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"42aced7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-2.png","id":935},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"e336f27"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-3.png","id":936},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"4ac8eb7"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-4.png","id":937},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"16fab77"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-6.png","id":939},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"fc2bd94"},{"brand_title":"Brand Name","type_brand":"image","brand_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/brand-5.png","id":938},"selected_icon":{"value":"fas fa-star","library":"fa-solid"},"_id":"1b76abe"}],"column":"6","column_mobile":"3","item_spacing_mobile":{"unit":"px","size":0,"sizes":[]},"image_padding_mobile":{"unit":"px","top":"0","right":"10","bottom":"0","left":"10","isLinked":false},"image_opacity_hover":{"unit":"px","size":0.200000000000000011102230246251565404236316680908203125,"sizes":[]},"enable_carousel":"yes","navigation":"none"},"elements":[],"widgetType":"supplero-brand"}],"isInner":false}],"isInner":false}],"demo":[{"id":"e8041d4","elType":"section","settings":{"gap":"no","stretch_section":"section-stretched","structure":"20","html_tag":"div"},"elements":[{"id":"94042ee","elType":"column","settings":{"_column_size":50,"_inline_size":27.132000000000001449507180950604379177093505859375,"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"7bb7110","elType":"widget","settings":{"image_size":"full"},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"6c73fe2","elType":"column","settings":{"_column_size":50,"_inline_size":72.86799999999999499777914024889469146728515625,"_inline_size_tablet":100},"elements":[{"id":"34b53e4","elType":"section","settings":{"gap":"no","structure":"20","html_tag":"div"},"elements":[{"id":"97d772f","elType":"column","settings":{"_column_size":50,"_inline_size":70},"elements":[{"id":"cb41690","elType":"widget","settings":{"slides":[{"heading":"Slide 1 Heading","description":"Lorem ipsum dolor sit amet consectetur adipiscing elit dolor","button_text":"Click Here","background_color":"#833ca3","_id":"bd2affc","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/avatar-4.jpg","id":5525}},{"heading":"Slide 1 Heading","description":"Lorem ipsum dolor sit amet consectetur adipiscing elit dolor","button_text":"Click Here","background_color":"#833ca3","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/avatar-4.jpg","id":5525},"_id":"3515289"},{"heading":"Slide 1 Heading","description":"Lorem ipsum dolor sit amet consectetur adipiscing elit dolor","button_text":"Click Here","background_color":"#833ca3","background_image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2021\/01\/avatar-4.jpg","id":5525},"_id":"65cb68d"}],"navigation":"dots"},"elements":[],"widgetType":"slides"}],"isInner":true},{"id":"d8f7bb2","elType":"column","settings":{"_column_size":50,"_inline_size":29.998999999999998777866494492627680301666259765625},"elements":[{"id":"25726e0","elType":"widget","settings":{"skin":"cover","layout":"left","title":"This is the heading","description":"Lorem ipsum dolor sit amet consectetur adipiscing elit dolor","button":"Click Here"},"elements":[],"widgetType":"call-to-action"}],"isInner":true}],"isInner":true},{"id":"c18ca26","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"30","right":0,"bottom":"30","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"1abf684","elType":"column","settings":{"_column_size":33,"_inline_size":null},"elements":[{"id":"2e2480c","elType":"widget","settings":{"skin":"cover","layout":"left","title":"This is the heading","description":"Lorem ipsum dolor sit amet consectetur adipiscing elit dolor","button":"Click Here"},"elements":[],"widgetType":"call-to-action"}],"isInner":true},{"id":"f3fa6a5","elType":"column","settings":{"_column_size":33,"_inline_size":null,"space_between_widgets_tablet":0},"elements":[{"id":"2655e9c","elType":"widget","settings":{"skin":"cover","layout":"left","title":"This is the heading","description":"Lorem ipsum dolor sit amet consectetur adipiscing elit dolor","button":"Click Here"},"elements":[],"widgetType":"call-to-action"}],"isInner":true},{"id":"56e2644","elType":"column","settings":{"_column_size":33,"_inline_size":null},"elements":[{"id":"89893dc","elType":"widget","settings":{"skin":"cover","layout":"left","title":"This is the heading","description":"Lorem ipsum dolor sit amet consectetur adipiscing elit dolor","button":"Click Here"},"elements":[],"widgetType":"call-to-action"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"e3f59b0","elType":"section","settings":{"gap":"no","structure":"30","margin":{"unit":"px","top":"100","right":0,"bottom":"100","left":0,"isLinked":true},"html_tag":"div"},"elements":[{"id":"8450c77","elType":"column","settings":{"_column_size":33,"_inline_size":null,"border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"margin":{"unit":"px","top":"10","right":"10","bottom":"12","left":"10","isLinked":false},"padding":{"unit":"px","top":"12","right":"0","bottom":"7","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=accent"}},"elements":[{"id":"beef28c","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"-20","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"18","isLinked":false},"html_tag":"div"},"elements":[{"id":"0fc4566","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-10","isLinked":false}},"elements":[{"id":"2c376b3","elType":"widget","settings":{"title_text":"free shipping wordwire","description_text":"","position":"left","text_align":"left","_margin":{"unit":"px","top":"0","right":"-20","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"selected_icon":{"value":"fas fa-truck","library":"fa-solid"},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_weight":"500","title_typography_text_transform":"uppercase","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"22f3565","elType":"column","settings":{"_column_size":33,"_inline_size":null,"border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"margin":{"unit":"px","top":"10","right":"10","bottom":"12","left":"10","isLinked":false},"padding":{"unit":"px","top":"12","right":"0","bottom":"8","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=accent"}},"elements":[{"id":"56f5b9c","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"-20","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"18","isLinked":false},"html_tag":"div"},"elements":[{"id":"a79597e","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-10","isLinked":false}},"elements":[{"id":"7bb40b1","elType":"widget","settings":{"title_text":"free shipping wordwire","description_text":"","position":"left","text_align":"left","_margin":{"unit":"px","top":"0","right":"-20","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"selected_icon":{"value":"fas fa-truck","library":"fa-solid"},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_weight":"500","title_typography_text_transform":"uppercase","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false},{"id":"22a802c","elType":"column","settings":{"_column_size":33,"_inline_size":null,"border_border":"solid","border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"margin":{"unit":"px","top":"10","right":"10","bottom":"12","left":"10","isLinked":false},"padding":{"unit":"px","top":"12","right":"0","bottom":"8","left":"0","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=accent"}},"elements":[{"id":"7380706","elType":"section","settings":{"gap":"no","margin":{"unit":"px","top":"-20","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"18","isLinked":false},"html_tag":"div"},"elements":[{"id":"406bda2","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-10","isLinked":false}},"elements":[{"id":"ec24a7b","elType":"widget","settings":{"title_text":"free shipping wordwire","description_text":"","position":"left","text_align":"left","_margin":{"unit":"px","top":"0","right":"-20","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_border_border":"solid","_border_width":{"unit":"px","top":"1","right":"1","bottom":"1","left":"1","isLinked":true},"selected_icon":{"value":"fas fa-truck","library":"fa-solid"},"icon_size":{"unit":"px","size":40,"sizes":[]},"title_typography_typography":"custom","title_typography_font_weight":"500","title_typography_text_transform":"uppercase","__globals__":{"title_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-box"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"5a3931c","elType":"section","settings":{"html_tag":"div"},"elements":[{"id":"0f9fd1c","elType":"column","settings":{"_column_size":100,"_inline_size":null},"elements":[{"id":"f662294","elType":"widget","settings":{"tabs":[{"tab_title":"#Product Tab 1","_id":"c94e4e6","limit":4,"categories":["endurance-energy"],"product_layout":"list","list_layout":"5"},{"tab_title":"#Product Tab 2","_id":"1570b85","limit":4,"categories":["food-products"],"product_layout":"list","list_layout":"5"}],"column":"4"},"elements":[],"widgetType":"supplero-products-tabs"}],"isInner":false}],"isInner":false},{"id":"bd27599","elType":"section","settings":{"structure":"20","html_tag":"div"},"elements":[{"id":"3dfcb68","elType":"column","settings":{"_column_size":50,"_inline_size":null},"elements":[{"id":"1e4c692","elType":"widget","settings":{"selected_icon":{"value":"supplero-icon- supplero-icon-gym","library":"supplero-icon"},"view":"stacked","shape":"square","size":{"unit":"px","size":40,"sizes":[]},"icon_padding":{"unit":"px","top":"15","right":"15","bottom":"15","left":"15","isLinked":true,"size":"","sizes":[]},"_element_width":"auto","__globals__":{"secondary_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon"},{"id":"099e1f1","elType":"widget","settings":{"icon_list":[{"text":"List Item #1","selected_icon":{"value":"","library":""},"_id":"522e24c"}],"divider_weight":{"unit":"px","size":9,"sizes":[]},"divider_width":{"unit":"%","size":58,"sizes":[]},"icon_typography_typography":"custom","icon_typography_line_height":{"unit":"px","size":70,"sizes":[]},"_css_classes":"supplero-box-clip-sm","_background_hover_background":"classic","_element_width":"auto","_element_vertical_align":"center","__globals__":{"_background_hover_color":"globals\/colors?id=primary","divider_color":"globals\/colors?id=secondary_hover"}},"elements":[],"widgetType":"icon-list"}],"isInner":false},{"id":"dc4a736","elType":"column","settings":{"_column_size":50,"_inline_size":null,"content_position":"center"},"elements":[{"id":"105181c","elType":"widget","settings":{"icon_list":[{"text":"List Item #1","selected_icon":{"value":"supplero-icon- supplero-icon-cycling","library":"supplero-icon"},"_id":"a9319ce"}],"icon_size":{"unit":"px","size":40,"sizes":[]},"__globals__":{"icon_color_hover":"globals\/colors?id=secondary_hover"}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false}],"many-doctors-use-wrong-test-to-diagnose-kids-food-allergies-2":[{"id":"53e3f14c","elType":"section","settings":{"gap":"no","html_tag":"div"},"elements":[{"id":"2c54d3fb","elType":"column","settings":{"_column_size":100,"space_between_widgets":0},"elements":[{"id":"9caa329","elType":"widget","settings":{"editor":"<p>Fusce ac pharetra urna. Duis non lacus sit amet lacus interdum facilisis sed non est. Ut mi metus, semper eu dictum nec, condimentum sed sapien. Nullam lobortis nunc semper ipsum luctus ut viverra ante eleifend. Nunc pretium velit sed augue luctus accumsan. Aliquam laoreet consequat malesuada. Integer vitae diam sed dolor euismod laoreet eget ac<\/p>"},"elements":[],"widgetType":"text-editor"},{"id":"b89a2da","elType":"section","settings":{"layout":"full_width","gap":"no","structure":"20","margin":{"unit":"px","top":"0","right":0,"bottom":"10","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"272e9e0","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"15","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"25","left":"0","isLinked":false}},"elements":[{"id":"4968a3d","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/single-blog-img2.jpg","id":6137},"image_size":"full","align":"left"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"86cfd83","elType":"column","settings":{"_column_size":50,"_inline_size":null,"space_between_widgets":0,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"1bf791a","elType":"widget","settings":{"image":{"url":"https:\/\/demo2wpopal.b-cdn.net\/supplero\/wp-content\/uploads\/2020\/12\/single-blog-img1.jpg","id":6136},"image_size":"full","align":"right"},"elements":[],"widgetType":"image"}],"isInner":true}],"isInner":true},{"id":"b8b1837","elType":"widget","settings":{"editor":"<p>Fusce ac pharetra urna. Duis non lacus sit amet lacus interdum facilisis sed non est. Ut mi metus, semper eu dictum nec, condimentum sed sapien. Nullam lobortis nunc semper ipsum luctus ut viverra ante eleifend. Nunc pretium velit sed augue luctus accumsan. Aliquam laoreet consequat malesuada. Integer vitae diam sed dolor euismod laoreet eget ac<\/p>"},"elements":[],"widgetType":"text-editor"},{"id":"a185cd1","elType":"section","settings":{"layout":"full_width","gap":"no","margin":{"unit":"px","top":"0","right":0,"bottom":"20","left":0,"isLinked":false},"html_tag":"div"},"elements":[{"id":"1102c7d","elType":"column","settings":{"_column_size":100,"_inline_size":null,"content_position":"center","space_between_widgets":0,"border_border":"solid","border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"4","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"35","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"25","isLinked":false},"__globals__":{"border_color":"globals\/colors?id=primary"}},"elements":[{"id":"0d6da13","elType":"widget","settings":{"editor":"<p>\u201cStrange as it seems, no amount of learning can cure stupidity, and higher education positively fortifies it.\u201d<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":20,"sizes":[]},"typography_font_size_mobile":{"unit":"px","size":18,"sizes":[]},"typography_line_height":{"unit":"px","size":30,"sizes":[]}},"elements":[],"widgetType":"text-editor"},{"id":"ab0c356","elType":"widget","settings":{"width":{"unit":"px","size":20,"sizes":[]},"text":"Divider","color":"#D9D9D9","weight":{"unit":"px","size":2,"sizes":[]},"gap":{"unit":"px","size":0,"sizes":[]},"_margin":{"unit":"px","top":"0","right":"10","bottom":"0","left":"0","isLinked":false},"_element_width":"auto"},"elements":[],"widgetType":"divider"},{"id":"a918afc","elType":"widget","settings":{"editor":"<div>john doe<\/div>","text_color":"#333333","typography_typography":"custom","typography_font_size":{"unit":"px","size":12,"sizes":[]},"typography_font_weight":"700","typography_text_transform":"uppercase","_element_width":"auto","__globals__":{"text_color":""}},"elements":[],"widgetType":"text-editor"}],"isInner":true}],"isInner":true},{"id":"c64e6fa","elType":"widget","settings":{"editor":"<p>Ready For Perfect Fitness<\/p>","typography_typography":"custom","typography_font_size":{"unit":"px","size":18,"sizes":[]},"typography_font_weight":"700","typography_line_height":{"unit":"px","size":20,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"text-editor"},{"id":"30b9cbf","elType":"widget","settings":{"editor":"<p>Leos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam<\/p>"},"elements":[],"widgetType":"text-editor"},{"id":"b14e442","elType":"widget","settings":{"icon_list":[{"text":"Train with the best experts in bodybuilding field.","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"bbce9fd"},{"text":"Our personal trainers will help you find a perfect workout.","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"e76dd7d"},{"text":"Trainers will build your perfect cardio workout.","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"c1727b3"},{"text":"Proin gravida nibh vel velit auctor aliquet.","selected_icon":{"value":"far fa-check-circle","library":"fa-regular"},"_id":"b523ecb"}],"space_between":{"unit":"px","size":10,"sizes":[]},"icon_color":"#8BA73B","icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14,"sizes":[]},"__globals__":{"text_color":"globals\/colors?id=accent"}},"elements":[],"widgetType":"icon-list"}],"isInner":false}],"isInner":false}],"default-kit":[]}', true);
    }

}

return new Supplero_Merlin_Config();
