<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

class OSF_Elementor_Nav_Menu extends Elementor\Widget_Base{

    protected $nav_menu_index = 1;

    public function get_name()
    {
        return 'supplero-nav-menu';
    }

    public function get_title()
    {
        return esc_html__('Supplero Nav Menu', 'supplero');
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }

    public function get_categories()
    {
        return ['supplero-addons'];
    }
    public function on_export( $element ) {
        unset( $element['settings']['menu'] );

        return $element;
    }

    protected function get_nav_menu_index() {
        return $this->nav_menu_index++;
    }

    private function get_available_menus() {
        $menus = wp_get_nav_menus();

        $options = [];

        foreach ( $menus as $menu ) {
            $options[ $menu->slug ] = $menu->name;
        }

        return $options;
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__( 'Layout', 'supplero' ),
            ]
        );
        $menus = $this->get_available_menus();
        if ( ! empty( $menus ) ) {
            $this->add_control(
                'menu',
                [
                    'label' => esc_html__( 'Menu', 'supplero' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => $menus,
                    'default' => array_keys( $menus )[0],
                    'save_default' => true,
                    'separator' => 'after',
                    'description' => sprintf(__( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'supplero' ), admin_url( 'nav-menus.php' ) ),
                ]
            );
        } else {
            $this->add_control(
                'menu',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => '<strong>' . __( 'There are no menus in your site.', 'supplero' ) . '</strong><br>' . sprintf(__( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'supplero' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
                    'separator' => 'after',
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                ]
            );
        }
        $this->add_control(
            'layout_style',
            [
                'label' => esc_html__( 'Layout Style', 'supplero' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'supplero'),
                    'layout-2' => esc_html__('Layout 2', 'supplero'),
                ],
                'default' => 'layout-1',
                'prefix_class' => 'supplero-nav-menu-',
            ]
        );
        $this->add_control(
            'show_full_menu',
            [
                'label' => esc_html__( 'Full Width', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [
                    'layout_style' => 'layout-2',
                ],
                'prefix_class' => 'supplero-nav-menu-show-full-menu-',
            ]
        );
        $this->end_controls_section();

        $this -> start_controls_section(
            'nav-menu_style',
            [
                'label' => esc_html__('Menu','supplero'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this -> add_responsive_control(
            'nav_menu_aligrment',
            [
                'label'       => esc_html__( 'Alignment', 'supplero' ),
                'type'        => Controls_Manager::CHOOSE,
                'default'     => 'center',
                'options'     => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'supplero' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'supplero' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'supplero' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'label_block' => false,
                'selectors'   => [
                    '{{WRAPPER}} .main-navigation' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography Menu', 'supplero'),
                'name'     => 'nav_menu_typography',
                'selector' => '{{WRAPPER}} .main-navigation ul.menu > li.menu-item > a',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography Sub Menu', 'supplero'),
                'name'     => 'nav_sub_menu_typography',
                'selector' => '{{WRAPPER}} .main-navigation ul.menu li.menu-item .sub-menu .menu-item a',
            ]
        );

        $this->start_controls_tabs( 'tabs_nav_menu_style' );

        $this->start_controls_tab(
            'tab_nav_menu_normal',
            [
                'label' =>  esc_html__( 'Normal', 'supplero' ),
            ]
        );
        $this->add_control(
            'menu_title_color',
            [
                'label'     => esc_html__( 'Color Menu', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu > li.menu-item > a:not(:hover)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_sub_title_color',
            [
                'label'     => esc_html__( 'Color Sub Menu', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu li.menu-item .sub-menu .menu-item a:not(:hover)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'sub_menu_color',
            [
                'label'     => esc_html__( 'Background Dropdown', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation .sub-menu' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'color_divider',
            [
                'label'     => esc_html__( 'Divider Border', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'condition' => [
                    'show_divider' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}}.divider-nav-menu-active-yes .main-navigation ul.menu > li > a' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}}.divider-nav-menu-active-yes .main-navigation ul.menu > li:last-child > a' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}}.divider-nav-menu-active-yes .main-navigation ul.nav-menu > li:last-child > a' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'color_divider_top',
            [
                'label'     => esc_html__( 'Divider Top', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'condition' => [
                    'show_divider_top' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}}.divider-top-nav-menu-active-yes .main-navigation ul.menu > li.menu-item > a:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_nav_menu_hover',
            [
                'label' =>  esc_html__( 'Hover', 'supplero' ),
            ]
        );
        $this->add_control(
            'menu_title_color_hover',
            [
                'label'     => esc_html__( 'Color Menu', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu >li.menu-item >a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_sub_title_color_hover',
            [
                'label'     => esc_html__( 'Color Sub Menu', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu li.menu-item .sub-menu .menu-item a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_item_color_hover',
            [
                'label'     => esc_html__( 'Background Item', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu li.menu-item .sub-menu .menu-item:hover > a' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_nav_menu_action',
            [
                'label' =>  esc_html__( 'Active', 'supplero' ),
            ]
        );
        $this->add_control(
            'menu_title_color_action',
            [
                'label'     => esc_html__( 'Color Menu', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu > li.menu-item.current-menu-item > a:not(:hover)' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .main-navigation ul.menu > li.menu-item.current-menu-parent > a:not(:hover)' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .main-navigation ul.menu > li.menu-item.current-menu-ancestor > a:not(:hover)' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'menu_sub_title_color_action',
            [
                'label'     => esc_html__( 'Color Sub Menu', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu li.menu-item .sub-menu .menu-item.current-menu-item > a:not(:hover)' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'menu_item_color_action',
            [
                'label'     => esc_html__( 'Background Item', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.menu li.menu-item .sub-menu .menu-item.current-menu-item > a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'show_divider',
            [
                'label' => esc_html__( 'Show Divider', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
                'prefix_class' => 'divider-nav-menu-active-',
            ]
        );
        $this->add_control(
            'show_divider_top',
            [
                'label' => esc_html__( 'Divider Top', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
                'prefix_class' => 'divider-top-nav-menu-active-',
            ]
        );
        $this->add_control(
            'show_background',
            [
                'label' => esc_html__( 'Background', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
                'prefix_class' => 'background-color-nav-menu-active-',
            ]
        );
        $this->add_control(
            'background_color',
            [
                'label'     => esc_html__( 'Background Color', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}}.background-color-nav-menu-active-yes .main-navigation ul.menu > li > a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'background_color_hover',
            [
                'label'     => esc_html__( 'Background Hover', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}}.background-color-nav-menu-active-yes .main-navigation ul.menu > li:hover > a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $function_to_call = 'r' . 'emov'. 'e_'. 'filter';
        $args = apply_filters('supplero_nav_menu_args', [
            'menu' => $settings['menu'],
            'menu_id' => 'menu-' . $this->get_nav_menu_index() . '-' . $this->get_id(),
            'fallback_cb'     => '__return_empty_string',
            'container_class' => 'primary-navigation',
        ]);

        $function_to_call( 'nav_menu_item_id', '__return_empty_string' );

        $this->add_render_attribute( 'wrapper', 'class', 'elementor-nav-menu-wrapper' );
        ?>
        <div <?php echo supplero_elementor_get_render_attribute_string('wrapper', $this);?>>
            <nav class="main-navigation" role="navigation" aria-label="<?php esc_attr_e('Primary Navigation', 'supplero'); ?>">
                <?php wp_nav_menu( $args ); ?>
            </nav>
        </div>
        <?php
    }

}
$widgets_manager->register(new OSF_Elementor_Nav_Menu());
