<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;

class OSF_Elementor_Header_Group extends Elementor\Widget_Base
{

    public function get_name() {
        return 'supplero-header-group';
    }

    public function get_title() {
        return esc_html__('Supplero Header Group', 'supplero');
    }

    public function get_icon() {
        return 'eicon-lock-user';
    }

    public function get_categories()
    {
        return array('supplero-addons');
    }

    public function get_script_depends() {
        return ['supplero-elementor-header-group', 'slick', 'supplero-cart-canvas'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'header_group_config',
            [
                'label' => esc_html__('Config', 'supplero'),
            ]
        );

        $this->add_control(
            'show_divider',
            [
                'label' => esc_html__( 'Show Divider', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'after',
                'prefix_class' => 'divider-header-group-action-',
            ]
        );

        $this->add_control(
            'show_account',
            [
                'label' => esc_html__( 'Show account', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'show_wishlist',
            [
                'label' => esc_html__( 'Show wishlist', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'show_cart',
            [
                'label' => esc_html__( 'Show cart', 'supplero' ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->end_controls_section();

        $this -> start_controls_section(
            'header-group-style',
            [
                'label' => esc_html__('Icon','supplero'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Color', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div a:not(:hover) i:before' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div a:not(:hover):before' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label'     => esc_html__( 'Color Hover', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div a:hover i:before' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div a:hover:before' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color_divider',
            [
                'label'     => esc_html__( 'Color Divider', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'show_divider' => 'yes',
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}}.divider-header-group-action-yes .elementor-header-group-wrapper .header-group-action > div' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'background_color',
            [
                'label'     => esc_html__( 'Background Color', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div > a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'background_color_hover',
            [
                'label'     => esc_html__( 'Background Hover', 'supplero' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div > a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'border_width',
            [
                'label'      => esc_html__( 'Divider width', 'supplero' ),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
                'condition' => [
                    'show_divider' => 'yes',
                ],
                'size_units' => [ 'px' ],
                'selectors'  => [
                    '{{WRAPPER}}.divider-header-group-action-yes .elementor-header-group-wrapper .header-group-action > div' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_size',
            [
                'label'     => esc_html__('Font Size', 'supplero'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div a i:before' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div a:before' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_padding',
            [
                'label'      => esc_html__( 'Padding', 'supplero' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-header-group-wrapper .header-group-action > div > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute( 'wrapper', 'class', 'elementor-header-group-wrapper' );
        ?>
        <div <?php echo supplero_elementor_get_render_attribute_string('wrapper', $this);?>>
            <div class="header-group-action">

                <?php if ( $settings['show_account'] === 'yes' ):{
                    supplero_header_account();
                }
                endif; ?>

                <?php if ( $settings['show_wishlist'] === 'yes' && supplero_is_woocommerce_activated() ):{
                    supplero_header_wishlist();
                }
                endif; ?>

                <?php if ( $settings['show_cart'] === 'yes' && supplero_is_woocommerce_activated() ):{
                    supplero_header_cart();
                }
                endif; ?>
            </div>
        </div>
        <?php
    }
}

$widgets_manager->register(new OSF_Elementor_Header_Group());
