<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Supplero_Call_To_Action extends Elementor\Widget_Base {

    public function get_name() {
        return 'supplero-banner';
    }

    public function get_title() {
        return esc_html__('Supplero Banner', 'supplero');
    }

    public function get_icon() {
        return 'eicon-image-rollover';
    }

    public function get_script_depends() {
        return ['supplero-elementor-banner'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_main_image',
            [
                'label' => esc_html__('Image', 'supplero'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label'      => esc_html__('Choose Image', 'supplero'),
                'default'    => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default'   => 'full',
                'separator' => 'none',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'supplero'),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label'       => esc_html__('Sub title', 'supplero'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('', 'supplero'),
                'label_block' => true,
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => esc_html__('Title & Description', 'supplero'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('', 'supplero'),
                'label_block' => true,
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'description',
            [
                'label'      => esc_html__('Description', 'supplero'),
                'type'       => Controls_Manager::TEXTAREA,
                'separator'  => 'none',
                'rows'       => 5,
                'show_label' => false,
            ]
        );

        $this->add_control(
            'button',
            [
                'label'     => esc_html__('Button Text', 'supplero'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Click Here', 'supplero'),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label'            => esc_html__('Icon', 'supplero'),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label'       => esc_html__('Link', 'supplero'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'supplero'),

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_main_box',
            [
                'label' => esc_html__('Box', 'supplero'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_background_color',
            [
                'label'     => esc_html__('Background Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content' => 'background-color: {{VALUE}}'
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__('Padding', 'supplero'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .banner-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__('Margin', 'supplero'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .banner-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image', 'supplero'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'          => esc_html__('Width', 'supplero'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .banner-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'min-height',
            [
                'label'      => esc_html__('Height', 'supplero'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 100,
                        'max' => 1000,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'vh'],
                'selectors'  => [
                    '{{WRAPPER}} .banner-image img' => 'height: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .banner-image'     => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content_style',
            [
                'label' => esc_html__('Content', 'supplero'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'heading_style_sub_title',
            [
                'type'  => Controls_Manager::HEADING,
                'label' => esc_html__('Sub Title', 'supplero'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .banner-content .content .sub-title',
            ]
        );

        $this->add_responsive_control(
            'sub_title_spacing',
            [
                'label'     => esc_html__('Spacing', 'supplero'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .content .sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'sub_title_color',
            [
                'label'     => esc_html__('Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .content .sub-title' => 'color: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'heading_style_title',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__('Title', 'supplero'),
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .banner-content .content .title',
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label'     => esc_html__('Spacing', 'supplero'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .content .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .content .title' => 'color: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'heading_style_description',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__('Description', 'supplero'),
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'description_typography',
                'selector' => '{{WRAPPER}} .banner-content .content .description',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__('Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .content .description' => 'color: {{VALUE}}'
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button', 'supplero'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .banner-content .button-banner span',
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__('Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner span' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__('Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner:hover span' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'style_icon',
            [
                'type'      => Controls_Manager::HEADING,
                'label'     => esc_html__('Icon', 'supplero'),
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label'     => esc_html__('Icon Size', 'supplero'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__('Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner .icon' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label'     => esc_html__('Color', 'supplero'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner-content .button-banner:hover .icon' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('wrapper', 'class', 'elementor-supplero-banner-wrapper js-banner-content-hover');
        $migrated = isset($settings['__fa4_migrated']['button_icon']);
        $is_new   = empty($settings['icon']) && Icons_Manager::is_migration_allowed();
        ?>
        <div <?php echo supplero_elementor_get_render_attribute_string('wrapper', $this); ?>>
            <div class="banner-image">
                <?php
                if (!empty($settings['image']['url'])) :
                    echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                endif;
                ?>
            </div>
            <div class="banner-content">

                <?php if (!empty($settings['button'])) { ?>
                    <a class="button-banner" href="<?php echo esc_url($settings['link']['url']); ?>">
                        <span><?php echo esc_html($settings['button']); ?></span>
                        <div class="icon">
                            <?php if ($is_new || $migrated) {
                                Icons_Manager::render_icon($settings['button_icon'], ['aria-hidden' => 'true']);
                            } ?>
                        </div>
                    </a>
                <?php } ?>
                <?php if (!empty($settings['subtitle']) || !empty($settings['title']) || !empty($settings['description'])) { ?>
                    <div class="content js-banner-content">
                        <?php if (!empty($settings['subtitle'])) { ?>
                            <div class="sub-title"><?php printf('%s', $settings['subtitle']); ?></div>
                        <?php } ?>
                        <?php if (!empty($settings['title'])) { ?>
                            <div class="title"><?php printf('%s', $settings['title']); ?></div>
                        <?php } ?>
                        <?php if (!empty($settings['description'])) { ?>
                            <div class="description"><?php printf('%s', $settings['description']); ?></div>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

$widgets_manager->register(new Supplero_Call_To_Action());
