<?php
// Icon List
use Elementor\Controls_Manager;

add_action( 'elementor/element/icon-list/section_text_style/after_section_end', function ($element, $args ) {
    /** @var \Elementor\Element_Base $element */
    // Remove Schema
    $element->update_control( 'icon_color', [
        'scheme' => [],
    ] );

    $element->update_control( 'text_color', [
        'scheme'    => [],
        'selectors' => [
            '{{WRAPPER}} .elementor-icon-list-items .elementor-icon-list-item .elementor-icon-list-text' => 'color: {{VALUE}};',
        ],
    ] );

    $element->update_control( 'text_color_hover', [
        'scheme'    => [],
        'selectors' => [
            '{{WRAPPER}} .elementor-icon-list-items .elementor-icon-list-item:hover .elementor-icon-list-text' => 'color: {{VALUE}};',
        ],
    ] );

    $element->update_control( 'icon_typography', [
        'scheme'    => [],
        'selectors' => '{{WRAPPER}} .elementor-icon-list-items .elementor-icon-list-item:hover .elementor-icon-list-text',
    ] );

    $element->update_control( 'divider_color', [
        'scheme'  => [],
        'default' => ''
    ] );

}, 10, 2 );

add_action( 'elementor/element/icon-list/section_icon_style/before_section_end', function ( $element, $args ) {
    $element->add_control(
        'icon_height',
        [
            'label' => esc_html__( 'Line Height', 'supplero' ),
            'type' => Controls_Manager::SLIDER,
            'selectors' => [
                '{{WRAPPER}} .elementor-icon-list-icon' => 'line-height: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
}, 10, 2 );

add_action( 'elementor/element/icon-list/section_icon_list/before_section_end', function ( $element, $args ) {
    $element->add_control(
        'style_icon_list',
        [
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label' => esc_html__( 'Style Theme', 'supplero' ),
            'prefix_class'	=> 'style-icon-list-supplero-'
        ]
    );
}, 10, 2 );