<?php
// Counter
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

add_action( 'elementor/element/counter/section_counter/before_section_end', function ( $element, $args ) {
    $element->add_responsive_control(
        'text_align',
        [
            'label' => esc_html__( 'Alignment', 'supplero' ),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'supplero' ),
                    'icon' => 'eicon-h-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'supplero' ),
                    'icon' => 'eicon-h-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'supplero' ),
                    'icon' => 'eicon-h-align-right',
                ],
            ],
            'prefix_class' => 'elementor%s-align-',
        ]
    );
}, 10, 2 );

add_action( 'elementor/element/counter/section_number/before_section_end', function ( $element, $args ) {

    $element->add_responsive_control(
        'number_space',
        [
            'label' => esc_html__( 'Spacing', 'supplero' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 15,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-counter-number-wrapper' => 'margin-bottom: {{SIZE}}{{UNIT}};',
            ],
        ]
    );

    $element->add_control(
        'number_suffix',
        [
            'label' => esc_html__( 'Suffix Color', 'supplero' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .elementor-counter-number-suffix' => 'color: {{VALUE}};',
            ],
        ]
    );

    $element->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Suffix Typography', 'supplero' ),
            'name' => 'suffix_typography',
            'type' => Controls_Manager::TEXT,
            'selector' => '{{WRAPPER}} .elementor-counter-number-suffix' ,
        ]
    );

    $element->add_control(
        'content_vertical_alignment',
        [
            'label' => esc_html__( 'Vertical Alignment', 'supplero' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'top' => esc_html__( 'Top', 'supplero' ),
                'middle' => esc_html__( 'Middle', 'supplero' ),
                'bottom' => esc_html__( 'Bottom', 'supplero' ),
            ],
            'default' => 'top',
            'prefix_class' => 'elementor-vertical-align-',
        ]
    );

}, 10, 2 );








