<?php

use Elementor\Controls_Manager;

add_action( 'elementor/element/countdown/section_content_style/before_section_end', function ($element, $args ) {

    $element->add_responsive_control(
        'label_padding',
        [
            'size_units' => [ 'px', 'em', '%' ],
            'label'     => esc_html__( 'Spacing', 'supplero' ),
            'type'      => Controls_Manager::SLIDER,
            'range'     => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                ],
            ],
            'selectors'  => [
                '{{WRAPPER}} .elementor-countdown-label' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
        ]
    );

},10,2);