<?php
// Button
use Elementor\Controls_Manager;

add_action( 'elementor/element/button/section_style/after_section_end', function ($element, $args ) {

    $element->update_control(
        'background_color',
        [
            'global' => [
                'default' => '',
            ],
        ]
    );
    $element->update_control(
        'hover_color',
        [
            'selectors' => [
                '{{WRAPPER}} .elementor-button:hover, {{WRAPPER}} .elementor-button:focus' => 'color: {{VALUE}};',
                '{{WRAPPER}}.supplero-style-button-hover-yes .elementor-button:hover .elementor-button-content-wrapper' => 'color: {{VALUE}};',
                '{{WRAPPER}} .elementor-button:hover svg, {{WRAPPER}} .elementor-button:focus svg' => 'fill: {{VALUE}};',
            ],
        ]
    );
}, 10, 2 );

add_action('elementor/element/button/section_style/before_section_end', function ($element, $args) {
    $element->add_control(
        'icon_button_size',
        [
            'label' => esc_html__('Icon Size', 'supplero'),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 6,
                    'max' => 300,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button .elementor-button-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'selected_icon[value]!' => '',
            ],
        ]
    );
    $element->add_control(
        'button_icon_color',
        [
            'label'     => esc_html__('Icon Color', 'supplero'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .elementor-button .elementor-button-icon' => 'fill: {{VALUE}}; color: {{VALUE}};',
            ],
            'condition' => [
                'selected_icon[value]!' => '',
            ],
        ]
    );
}, 10, 2);

add_action( 'elementor/element/button/section_style/before_section_end', function ( $element, $args ) {

    $element -> add_control(
        'style_button_hover',
        [
            'label' => esc_html__('Hover Themes','supplero'),
            'type' => Controls_Manager::SWITCHER,
            'prefix_class' => 'supplero-style-button-hover-',
            'default' => 'yes',
        ]
    );
    $element -> add_control(
        'style_button_hover_background',
        [
            'condition' => [
                'style_button_hover' => 'yes',
            ],
            'label' => esc_html__('Background Hover','supplero'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.supplero-style-button-hover-yes .elementor-button:after' => 'background-color: {{VALUE}};',
                '{{WRAPPER}}.supplero-style-button-hover-yes .elementor-button:before' => 'background-color: {{VALUE}};',
            ],
        ]
    );
}, 10, 2 );