<?php

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Supplero_Elementor' ) ) :

	/**
	 * The Supplero Elementor Integration class
	 */
	class Supplero_Elementor {
		private $suffix = '';

		public function __construct() {
			$this->suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

			add_action( 'wp', [ $this, 'register_auto_scripts_frontend' ] );
			add_action( 'elementor/init', array( $this, 'add_category' ) );
			add_action( 'wp_enqueue_scripts', [ $this, 'add_scripts' ], 15 );
            add_action('elementor/widgets/register', array($this, 'customs_widgets'));
			add_action( 'elementor/widgets/register', array( $this, 'include_widgets' ) );
			add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'add_js' ] );

			// Custom Animation Scroll
			add_filter( 'elementor/controls/animations/additional_animations', [ $this, 'add_animations_scroll' ] );

			// Elementor Fix Noitice WooCommerce
			add_action( 'elementor/editor/before_enqueue_scripts', array( $this, 'woocommerce_fix_notice' ) );

			// Backend
			add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'add_style_editor' ], 99 );
//
//			// Add Icon Custom
			add_action( 'elementor/icons_manager/native', [ $this, 'add_icons_native' ] );
			add_action( 'elementor/controls/register', [ $this, 'add_icons' ] );

			if ( ! supplero_is_elementor_pro_activated() ) {
				require trailingslashit( get_template_directory() ) . 'inc/elementor/custom-css.php';
			}

			add_filter( 'elementor/fonts/additional_fonts', [ $this, 'additional_fonts' ] );
            add_action('wp_enqueue_scripts', [$this, 'elementor_kit']);
		}

        public function elementor_kit() {
            $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
            Elementor\Plugin::$instance->kits_manager->frontend_before_enqueue_styles();
            $myvals        = get_post_meta($active_kit_id, '_elementor_page_settings', true);
            if ( ! empty( $myvals ) ) {
                $css = '';
                foreach ( $myvals['system_colors'] as $key => $value ) {
                    $css .= $value['color'] !== '' ? '--' . $value['_id'] . ':' . $value['color'] . ';' : '';
                }

                $var = "body{{$css}}";
                wp_add_inline_style( 'supplero-style', $var );
            }
        }

		public function additional_fonts( $fonts ) {
			$fonts["Poppins"] = 'system';

			return $fonts;
		}

		public function add_js() {
			global $supplero_version;
			wp_enqueue_script( 'supplero-elementor-frontend', get_theme_file_uri( '/assets/js/elementor-frontend.js' ), [], $supplero_version );
		}

		public function add_style_editor() {
			global $supplero_version;
			wp_enqueue_style( 'supplero-elementor-editor-icon', get_theme_file_uri( '/assets/css/admin/elementor/icons.css' ), [], $supplero_version );
		}

		public function add_scripts() {
			global $supplero_version;
			$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
			wp_enqueue_style( 'supplero-elementor', get_template_directory_uri() . '/assets/css/base/elementor.css', '', $supplero_version );
			wp_style_add_data( 'supplero-elementor', 'rtl', 'replace' );

			// Add Scripts
			wp_register_script( 'tweenmax', get_theme_file_uri( '/assets/js/vendor/TweenMax.min.js' ), array( 'jquery' ), '1.11.1' );
			wp_register_script( 'parallaxmouse', get_theme_file_uri( '/assets/js/vendor/jquery-parallax.js' ), array( 'jquery' ), $supplero_version );

			if ( supplero_elementor_check_type( 'animated-bg-parallax' ) ) {
				wp_enqueue_script( 'tweenmax' );
				wp_enqueue_script( 'jquery-panr', get_theme_file_uri( '/assets/js/vendor/jquery-panr' . $suffix . '.js' ), array( 'jquery' ), '0.0.1' );
			}
		}


		public function register_auto_scripts_frontend() {
            global $supplero_version;
            wp_register_script('supplero-elementor-banner', get_theme_file_uri('/assets/js/elementor/banner.js'), array('jquery','elementor-frontend'), $supplero_version, true);
            wp_register_script('supplero-elementor-brand', get_theme_file_uri('/assets/js/elementor/brand.js'), array('jquery','elementor-frontend'), $supplero_version, true);
            wp_register_script('supplero-elementor-posts-grid', get_theme_file_uri('/assets/js/elementor/posts-grid.js'), array('jquery','elementor-frontend'), $supplero_version, true);
            wp_register_script('supplero-elementor-product-categories', get_theme_file_uri('/assets/js/elementor/product-categories.js'), array('jquery','elementor-frontend'), $supplero_version, true);
            wp_register_script('supplero-elementor-product-tab', get_theme_file_uri('/assets/js/elementor/product-tab.js'), array('jquery','elementor-frontend'), $supplero_version, true);
            wp_register_script('supplero-elementor-products', get_theme_file_uri('/assets/js/elementor/products.js'), array('jquery','elementor-frontend'), $supplero_version, true);
            wp_register_script('supplero-elementor-testimonial', get_theme_file_uri('/assets/js/elementor/testimonial.js'), array('jquery','elementor-frontend'), $supplero_version, true);
            wp_register_script('supplero-elementor-video', get_theme_file_uri('/assets/js/elementor/video.js'), array('jquery','elementor-frontend'), $supplero_version, true);
           
        }

		public function add_category() {
			Elementor\Plugin::instance()->elements_manager->add_category(
				'supplero-addons',
				array(
					'title' => esc_html__( 'Supplero Addons', 'supplero' ),
					'icon'  => 'fa fa-plug',
				),
				1 );
		}

		public function add_animations_scroll( $animations ) {
			$animations['Supplero Animation'] = [
				'opal-move-up'    => 'Move Up',
				'opal-move-down'  => 'Move Down',
				'opal-move-left'  => 'Move Left',
				'opal-move-right' => 'Move Right',
				'opal-flip'       => 'Flip',
				'opal-helix'      => 'Helix',
				'opal-scale-up'   => 'Scale',
				'opal-am-popup'   => 'Popup',
			];

			return $animations;
		}

        public function customs_widgets() {
            $files = glob(get_theme_file_path('/inc/elementor/custom-widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

		/**
		 * @param $widgets_manager Elementor\Widgets_Manager
		 */
		public function include_widgets( $widgets_manager ) {
			$files = glob( get_theme_file_path( '/inc/elementor/widgets/*.php' ) );
			foreach ( $files as $file ) {
				if ( file_exists( $file ) ) {
					require_once $file;
				}
			}
		}

		public function woocommerce_fix_notice() {
			if ( supplero_is_woocommerce_activated() ) {
				remove_action( 'woocommerce_cart_is_empty', 'woocommerce_output_all_notices', 5 );
				remove_action( 'woocommerce_shortcode_before_product_cat_loop', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_single_product', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_cart', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_checkout_form', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_account_content', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_customer_login_form', 'woocommerce_output_all_notices', 10 );
			}
		}

		public function add_icons( $manager ) {
            $new_icons = json_decode( '{"supplero-icon-account":"account","supplero-icon-arrow-supplero":"arrow-supplero","supplero-icon-box-alt":"box-alt","supplero-icon-cart":"cart","supplero-icon-clock-1":"clock-1","supplero-icon-comment":"comment","supplero-icon-cycling":"cycling","supplero-icon-envelope-open":"envelope-open","supplero-icon-experts":"experts","supplero-icon-football":"football","supplero-icon-globe-asia":"globe-asia","supplero-icon-gym":"gym","supplero-icon-location-circle":"location-circle","supplero-icon-long-arrow-down":"long-arrow-down","supplero-icon-long-arrow-left":"long-arrow-left","supplero-icon-long-arrow-right":"long-arrow-right","supplero-icon-long-arrow-up":"long-arrow-up","supplero-icon-map-marker":"map-marker","supplero-icon-material":"material","supplero-icon-medal":"medal","supplero-icon-phone-rotary":"phone-rotary","supplero-icon-plus":"plus","supplero-icon-running":"running","supplero-icon-search":"search","supplero-icon-shipping-fast":"shipping-fast","supplero-icon-star_1":"star_1","supplero-icon-star_outline":"star_outline","supplero-icon-swimming":"swimming","supplero-icon-top-rated":"top-rated","supplero-icon-undo-alt":"undo-alt","supplero-icon-wishlist":"wishlist","supplero-icon-360":"360","supplero-icon-angle-down":"angle-down","supplero-icon-angle-left":"angle-left","supplero-icon-angle-right":"angle-right","supplero-icon-angle-up":"angle-up","supplero-icon-arrow-circle-down":"arrow-circle-down","supplero-icon-arrow-circle-left":"arrow-circle-left","supplero-icon-arrow-circle-right":"arrow-circle-right","supplero-icon-arrow-circle-up":"arrow-circle-up","supplero-icon-arrow-left":"arrow-left","supplero-icon-arrow-right":"arrow-right","supplero-icon-bars":"bars","supplero-icon-caret-down":"caret-down","supplero-icon-caret-left":"caret-left","supplero-icon-caret-right":"caret-right","supplero-icon-caret-up":"caret-up","supplero-icon-cart-empty":"cart-empty","supplero-icon-check-square":"check-square","supplero-icon-chevron-circle-left":"chevron-circle-left","supplero-icon-chevron-circle-right":"chevron-circle-right","supplero-icon-chevron-down":"chevron-down","supplero-icon-chevron-left":"chevron-left","supplero-icon-chevron-right":"chevron-right","supplero-icon-chevron-up":"chevron-up","supplero-icon-circle":"circle","supplero-icon-clock":"clock","supplero-icon-cloud-download-alt":"cloud-download-alt","supplero-icon-comments":"comments","supplero-icon-contact":"contact","supplero-icon-credit-card":"credit-card","supplero-icon-dot-circle":"dot-circle","supplero-icon-edit":"edit","supplero-icon-envelope":"envelope","supplero-icon-expand-alt":"expand-alt","supplero-icon-external-link-alt":"external-link-alt","supplero-icon-eye":"eye","supplero-icon-file-alt":"file-alt","supplero-icon-file-archive":"file-archive","supplero-icon-filter":"filter","supplero-icon-folder-open":"folder-open","supplero-icon-folder":"folder","supplero-icon-free_ship":"free_ship","supplero-icon-frown":"frown","supplero-icon-gift":"gift","supplero-icon-grid":"grid","supplero-icon-grip-horizontal":"grip-horizontal","supplero-icon-heart-fill":"heart-fill","supplero-icon-heart":"heart","supplero-icon-history":"history","supplero-icon-home":"home","supplero-icon-info-circle":"info-circle","supplero-icon-instagram":"instagram","supplero-icon-level-up-alt":"level-up-alt","supplero-icon-list":"list","supplero-icon-long-arrow-alt-down":"long-arrow-alt-down","supplero-icon-long-arrow-alt-left":"long-arrow-alt-left","supplero-icon-long-arrow-alt-right":"long-arrow-alt-right","supplero-icon-long-arrow-alt-up":"long-arrow-alt-up","supplero-icon-map-marker-check":"map-marker-check","supplero-icon-meh":"meh","supplero-icon-minus-circle":"minus-circle","supplero-icon-minus":"minus","supplero-icon-mobile-android-alt":"mobile-android-alt","supplero-icon-money-bill":"money-bill","supplero-icon-pencil-alt":"pencil-alt","supplero-icon-play-circle":"play-circle","supplero-icon-plus-circle":"plus-circle","supplero-icon-quote":"quote","supplero-icon-random":"random","supplero-icon-reply-all":"reply-all","supplero-icon-reply":"reply","supplero-icon-search-plus":"search-plus","supplero-icon-shield-check":"shield-check","supplero-icon-shopping-basket":"shopping-basket","supplero-icon-shopping-cart":"shopping-cart","supplero-icon-sign-out-alt":"sign-out-alt","supplero-icon-smile":"smile","supplero-icon-spinner":"spinner","supplero-icon-square":"square","supplero-icon-star":"star","supplero-icon-store":"store","supplero-icon-sync":"sync","supplero-icon-tachometer-alt":"tachometer-alt","supplero-icon-th-large":"th-large","supplero-icon-th-list":"th-list","supplero-icon-thumbtack":"thumbtack","supplero-icon-times-circle":"times-circle","supplero-icon-times":"times","supplero-icon-trophy-alt":"trophy-alt","supplero-icon-truck":"truck","supplero-icon-user-headset":"user-headset","supplero-icon-user-shield":"user-shield","supplero-icon-user":"user","supplero-icon-video":"video","supplero-icon-adobe":"adobe","supplero-icon-amazon":"amazon","supplero-icon-android":"android","supplero-icon-angular":"angular","supplero-icon-apper":"apper","supplero-icon-apple":"apple","supplero-icon-atlassian":"atlassian","supplero-icon-behance":"behance","supplero-icon-bitbucket":"bitbucket","supplero-icon-bitcoin":"bitcoin","supplero-icon-bity":"bity","supplero-icon-bluetooth":"bluetooth","supplero-icon-btc":"btc","supplero-icon-centos":"centos","supplero-icon-chrome":"chrome","supplero-icon-codepen":"codepen","supplero-icon-cpanel":"cpanel","supplero-icon-discord":"discord","supplero-icon-dochub":"dochub","supplero-icon-docker":"docker","supplero-icon-dribbble":"dribbble","supplero-icon-dropbox":"dropbox","supplero-icon-drupal":"drupal","supplero-icon-ebay":"ebay","supplero-icon-facebook":"facebook","supplero-icon-figma":"figma","supplero-icon-firefox":"firefox","supplero-icon-google-plus":"google-plus","supplero-icon-google":"google","supplero-icon-grunt":"grunt","supplero-icon-gulp":"gulp","supplero-icon-html5":"html5","supplero-icon-jenkins":"jenkins","supplero-icon-joomla":"joomla","supplero-icon-link-brand":"link-brand","supplero-icon-linkedin":"linkedin","supplero-icon-mailchimp":"mailchimp","supplero-icon-opencart":"opencart","supplero-icon-paypal":"paypal","supplero-icon-pinterest-p":"pinterest-p","supplero-icon-reddit":"reddit","supplero-icon-skype":"skype","supplero-icon-slack":"slack","supplero-icon-snapchat":"snapchat","supplero-icon-spotify":"spotify","supplero-icon-trello":"trello","supplero-icon-twitter":"twitter","supplero-icon-vimeo":"vimeo","supplero-icon-whatsapp":"whatsapp","supplero-icon-wordpress":"wordpress","supplero-icon-yoast":"yoast","supplero-icon-youtube":"youtube"}', true );
			$icons     = $manager->get_control( 'icon' )->get_settings( 'options' );
			$new_icons = array_merge(
				$new_icons,
				$icons
			);
			// Then we set a new list of icons as the options of the icon control
			$manager->get_control( 'icon' )->set_settings( 'options', $new_icons ); 
        }

		public function add_icons_native( $tabs ) {
			global $supplero_version;
			$tabs['opal-custom'] = [
				'name'          => 'supplero-icon',
				'label'         => esc_html__( 'Supplero Icon', 'supplero' ),
				'prefix'        => 'supplero-icon-',
				'displayPrefix' => 'supplero-icon-',
				'labelIcon'     => 'fab fa-font-awesome-alt',
				'ver'           => $supplero_version,
				'fetchJson'     => get_theme_file_uri( '/inc/elementor/icons.json' ),
				'native'        => true,
			];

			return $tabs;
		}
	}

endif;

return new Supplero_Elementor();
