<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Supplero_Customize')) {

    class Supplero_Customize {


        public function __construct() {
            add_action('customize_register', array($this, 'customize_register'));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         */
        public function customize_register($wp_customize) {

            /**
             * Theme options.
             */
            require_once get_theme_file_path('inc/customize-control/editor.php');
            $this->init_supplero_blog($wp_customize);

            $this->init_supplero_social($wp_customize);

            if (supplero_is_woocommerce_activated()) {
                $this->init_woocommerce($wp_customize);
            }

            do_action('supplero_customize_register', $wp_customize);
        }


        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_supplero_blog($wp_customize) {

            $wp_customize->add_section('supplero_blog_archive', array(
                'title' => esc_html__('Blog', 'supplero'),
            ));

            // =========================================
            // Select Style
            // =========================================

            $wp_customize->add_setting('supplero_options_blog_style', array(
                'type'              => 'option',
                'default'           => 'standard',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_blog_style', array(
                'section' => 'supplero_blog_archive',
                'label'   => esc_html__('Blog style', 'supplero'),
                'type'    => 'select',
                'choices' => array(
                    'standard' => esc_html__('Blog Standard', 'supplero'),
                    'grid'     => esc_html__('Blog Grid', 'supplero'),
                ),
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_supplero_social($wp_customize) {

            $wp_customize->add_section('supplero_social', array(
                'title' => esc_html__('Socials', 'supplero'),
            ));
            $wp_customize->add_setting('supplero_options_social_share', array(
                'type'       => 'option',
                'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_social_share', array(
                'type'    => 'checkbox',
                'section' => 'supplero_social',
                'label'   => esc_html__('Show Social Share', 'supplero'),
            ));
            $wp_customize->add_setting('supplero_options_social_share_facebook', array(
                'type'       => 'option',
                'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_social_share_facebook', array(
                'type'    => 'checkbox',
                'section' => 'supplero_social',
                'label'   => esc_html__('Share on Facebook', 'supplero'),
            ));
            $wp_customize->add_setting('supplero_options_social_share_twitter', array(
                'type'       => 'option',
                'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_social_share_twitter', array(
                'type'    => 'checkbox',
                'section' => 'supplero_social',
                'label'   => esc_html__('Share on Twitter', 'supplero'),
            ));
            $wp_customize->add_setting('supplero_options_social_share_linkedin', array(
                'type'       => 'option',
                'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_social_share_linkedin', array(
                'type'    => 'checkbox',
                'section' => 'supplero_social',
                'label'   => esc_html__('Share on Linkedin', 'supplero'),
            ));
            $wp_customize->add_setting('supplero_options_social_share_google-plus', array(
                'type'       => 'option',
                'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_social_share_google-plus', array(
                'type'    => 'checkbox',
                'section' => 'supplero_social',
                'label'   => esc_html__('Share on Google+', 'supplero'),
            ));

            $wp_customize->add_setting('supplero_options_social_share_pinterest', array(
                'type'       => 'option',
                'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_social_share_pinterest', array(
                'type'    => 'checkbox',
                'section' => 'supplero_social',
                'label'   => esc_html__('Share on Pinterest', 'supplero'),
            ));
            $wp_customize->add_setting('supplero_options_social_share_email', array(
                'type'       => 'option',
                'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_social_share_email', array(
                'type'    => 'checkbox',
                'section' => 'supplero_social',
                'label'   => esc_html__('Share on Email', 'supplero'),
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_woocommerce($wp_customize) {

            $wp_customize->add_panel('woocommerce', array(
                'title' => esc_html__('Woocommerce', 'supplero'),
            ));

            $wp_customize->add_section('supplero_woocommerce_archive', array(
                'title'      => esc_html__('Archive', 'supplero'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            $wp_customize->add_setting('supplero_options_woocommerce_archive_layout', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_woocommerce_archive_layout', array(
                'section' => 'supplero_woocommerce_archive',
                'label'   => esc_html__('Layout Style', 'supplero'),
                'type'    => 'select',
                'choices' => array(
                    'default'  => esc_html__('Sidebar', 'supplero'),
                    'canvas'   => esc_html__('Canvas Filter', 'supplero'),
                    'dropdown' => esc_html__('Dropdown Filter', 'supplero'),
                ),
            ));

            $wp_customize->add_setting('supplero_options_woocommerce_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('supplero_options_woocommerce_archive_sidebar', array(
                'section' => 'supplero_woocommerce_archive',
                'label'   => esc_html__('Sidebar Position', 'supplero'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'supplero'),
                    'right' => esc_html__('Right', 'supplero'),

                ),
            ));

            // =========================================
            // Single Product
            // =========================================

            $wp_customize->add_section('supplero_woocommerce_single', array(
                'title'      => esc_html__('Single Product', 'supplero'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
            ));

            $wp_customize->add_setting('supplero_options_single_product_gallery_layout', array(
                'type'              => 'option',
                'default'           => 'horizontal',
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('supplero_options_single_product_gallery_layout', array(
                'section' => 'supplero_woocommerce_single',
                'label'   => esc_html__('Style', 'supplero'),
                'type'    => 'select',
                'choices' => array(
                    'horizontal' => esc_html__('Horizontal', 'supplero'),
                    'vertical'   => esc_html__('Vertical', 'supplero'),
                    'gallery'    => esc_html__('Gallery', 'supplero'),
                    'sticky'     => esc_html__('Sticky', 'supplero'),
                ),
            ));

            $wp_customize->add_setting('supplero_options_single_product_content_meta', array(
                'type'              => 'option',
                'capability'        => 'edit_theme_options',
                'sanitize_callback' => 'supplero_sanitize_editor',
            ));

            $wp_customize->add_control(new Supplero_Customize_Control_Editor($wp_customize, 'supplero_options_single_product_content_meta', array(
                'section' => 'supplero_woocommerce_single',
                'label'   => esc_html__('Single extra description', 'supplero'),
            )));

            $wp_customize->add_setting('supplero_options_single_product_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('supplero_options_single_product_archive_sidebar', array(
                'section' => 'supplero_woocommerce_single',
                'label'   => esc_html__('Sidebar Position', 'supplero'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'supplero'),
                    'right' => esc_html__('Right', 'supplero'),

                ),
            ));

            // =========================================
            // Product
            // =========================================

            $wp_customize->add_section('supplero_woocommerce_product', array(
                'title'      => esc_html__('Product Block', 'supplero'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
            ));

            $wp_customize->add_setting('supplero_options_wocommerce_block_style', array(
                'type'              => 'option',
                'default'           => '1',
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('supplero_options_wocommerce_block_style', array(
                'section' => 'supplero_woocommerce_product',
                'label'   => esc_html__('Style', 'supplero'),
                'type'    => 'select',
                'choices' => array(
                    '1' => esc_html__('Style 1', 'supplero'),
                    '2' => esc_html__('Style 2', 'supplero'),
                    '3' => esc_html__('Style 3', 'supplero'),
                ),
            ));

            $wp_customize->add_setting('supplero_options_woocommerce_product_hover', array(
                'type'              => 'option',
                'default'           => 'none',
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('supplero_options_woocommerce_product_hover', array(
                'section' => 'supplero_woocommerce_product',
                'label'   => esc_html__('Animation Image Hover', 'supplero'),
                'type'    => 'select',
                'choices' => array(
                    'none'          => esc_html__( 'None', 'supplero' ),
                    'bottom-to-top' => esc_html__( 'Bottom to Top', 'supplero' ),
                    'top-to-bottom' => esc_html__( 'Top to Bottom', 'supplero' ),
                    'right-to-left' => esc_html__( 'Right to Left', 'supplero' ),
                    'left-to-right' => esc_html__( 'Left to Right', 'supplero' ),
                    'swap'          => esc_html__( 'Swap', 'supplero' ),
                    'fade'          => esc_html__( 'Fade', 'supplero' ),
                    'zoom-in'       => esc_html__( 'Zoom In', 'supplero' ),
                    'zoom-out'      => esc_html__( 'Zoom Out', 'supplero' ),
                ),
            ));
        }
    }
}
return new Supplero_Customize();
