<?php
/**
 * Plugin Name: Sumi Toolkit
 * Plugin URI: https://themeforest.net/user/fami_themes
 * Description: The Sumi Toolkit For WordPress Theme WooCommerce Shop.
 * Author: Sumi Team
 * Author URI: https://themeforest.net/user/fami_themes
 * Version: 1.0.2
 * Text Domain: sumi-toolkit
 */
// Exit if accessed directly.
if ( !defined( 'ABSPATH' ) ) exit;
if ( !class_exists( 'Sumi_Toolkit' ) ) {
	class Sumi_Toolkit
	{
		/**
		 * @var Sumi_Toolkit The one true Sumi_Toolkit
		 * @since 1.0
		 */
		private static $instance;

		public static function instance()
		{
			if ( !isset( self::$instance ) && !( self::$instance instanceof Sumi_Toolkit ) ) {
				self::$instance = new Sumi_Toolkit;
				self::$instance->setup_constants();
				add_action( 'plugins_loaded', array( self::$instance, 'load_textdomain' ) );
				self::$instance->includes();
				add_action( 'after_setup_theme', array( self::$instance, 'after_setup_theme' ) );
			}

			return self::$instance;
		}

		public function after_setup_theme()
		{
			require_once SUMI_TOOLKIT_PATH . 'includes/admin/import/import.php';
			/* MAILCHIMP */
			require_once SUMI_TOOLKIT_PATH . 'includes/admin/mailchimp/MCAPI.class.php';
			require_once SUMI_TOOLKIT_PATH . 'includes/admin/mailchimp/mailchimp-settings.php';
			require_once SUMI_TOOLKIT_PATH . 'includes/admin/mailchimp/MCAPI.class.v3.client.php';
			require_once SUMI_TOOLKIT_PATH . 'includes/admin/mailchimp/mailchimp.php';
			require_once SUMI_TOOLKIT_PATH . 'includes/admin/live-search/live-search.php';
			require_once SUMI_TOOLKIT_PATH . 'includes/mapper/includes/core.php';
		}

		public function setup_constants()
		{
			// Plugin version.
			if ( !defined( 'SUMI_TOOLKIT_VERSION' ) ) {
				define( 'SUMI_TOOLKIT_VERSION', '1.0.2' );
			}
			// Plugin Folder Path.
			if ( !defined( 'SUMI_TOOLKIT_PATH' ) ) {
				define( 'SUMI_TOOLKIT_PATH', plugin_dir_path( __FILE__ ) );
			}
			// Plugin Folder URL.
			if ( !defined( 'SUMI_TOOLKIT_URL' ) ) {
				define( 'SUMI_TOOLKIT_URL', plugin_dir_url( __FILE__ ) );
			}
		}

		public function includes()
		{
			require_once SUMI_TOOLKIT_PATH . 'includes/admin/welcome.php';
			require_once SUMI_TOOLKIT_PATH . 'includes/post-types.php';
			require_once SUMI_TOOLKIT_PATH . 'includes/frontend/framework.php';
		}

		public function load_textdomain()
		{
			load_plugin_textdomain( 'sumi-toolkit', false, SUMI_TOOLKIT_URL . 'languages' );
		}
	}
}
if ( !function_exists( 'sumi_toolkit' ) ) {
	function sumi_toolkit()
	{
		return Sumi_Toolkit::instance();
	}

    sumi_toolkit();
	add_action( 'plugins_loaded', 'sumi_toolkit', 10 );
}
