<?php
/**
 * @version    1.0
 * @package    Sumi_Toolkit
 * @author     Sumi
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 */
/**
 * Class Toolkit Post Type
 *
 * @since    1.0
 */
if ( !class_exists( 'Sumi_Post_Type' ) ) {
	class Sumi_Post_Type
	{
		public function __construct()
		{
			add_action( 'init', array( &$this, 'init' ), 9999 );
		}

		public static function init()
		{
			/* Mega menu */
			$args = array(
				'labels'              => array(
					'name'               => __( 'Mega Builder', 'sumi-toolkit' ),
					'singular_name'      => __( 'Mega menu item', 'sumi-toolkit' ),
					'add_new'            => __( 'Add new', 'sumi-toolkit' ),
					'add_new_item'       => __( 'Add new menu item', 'sumi-toolkit' ),
					'edit_item'          => __( 'Edit menu item', 'sumi-toolkit' ),
					'new_item'           => __( 'New menu item', 'sumi-toolkit' ),
					'view_item'          => __( 'View menu item', 'sumi-toolkit' ),
					'search_items'       => __( 'Search menu items', 'sumi-toolkit' ),
					'not_found'          => __( 'No menu items found', 'sumi-toolkit' ),
					'not_found_in_trash' => __( 'No menu items found in trash', 'sumi-toolkit' ),
					'parent_item_colon'  => __( 'Parent menu item:', 'sumi-toolkit' ),
					'menu_name'          => __( 'Menu Builder', 'sumi-toolkit' ),
				),
				'hierarchical'        => false,
				'description'         => __( 'Mega Menus.', 'sumi-toolkit' ),
				'supports'            => array( 'title', 'editor' ),
				'public'              => true,
				'show_ui'             => true,
				'show_in_menu'        => 'sumi_menu',
				'menu_position'       => 3,
				'show_in_nav_menus'   => true,
				'publicly_queryable'  => false,
				'exclude_from_search' => true,
				'has_archive'         => false,
				'query_var'           => true,
				'can_export'          => true,
				'rewrite'             => false,
				'capability_type'     => 'page',
				'menu_icon'           => 'dashicons-welcome-widgets-menus',
			);
			register_post_type( 'megamenu', $args );
			/* Footer */
			$args = array(
				'labels'              => array(
					'name'               => __( 'Footers', 'sumi-toolkit' ),
					'singular_name'      => __( 'Footers', 'sumi-toolkit' ),
					'add_new'            => __( 'Add New', 'sumi-toolkit' ),
					'add_new_item'       => __( 'Add new footer', 'sumi-toolkit' ),
					'edit_item'          => __( 'Edit footer', 'sumi-toolkit' ),
					'new_item'           => __( 'New footer', 'sumi-toolkit' ),
					'view_item'          => __( 'View footer', 'sumi-toolkit' ),
					'search_items'       => __( 'Search template footer', 'sumi-toolkit' ),
					'not_found'          => __( 'No template items found', 'sumi-toolkit' ),
					'not_found_in_trash' => __( 'No template items found in trash', 'sumi-toolkit' ),
					'parent_item_colon'  => __( 'Parent template item:', 'sumi-toolkit' ),
					'menu_name'          => __( 'Footer Builder', 'sumi-toolkit' ),
				),
				'hierarchical'        => false,
				'description'         => __( 'To Build Template Footer.', 'sumi-toolkit' ),
				'supports'            => array( 'title', 'editor' ),
				'public'              => true,
				'show_ui'             => true,
				'show_in_menu'        => 'sumi_menu',
				'menu_position'       => 4,
				'show_in_nav_menus'   => true,
				'publicly_queryable'  => false,
				'exclude_from_search' => true,
				'has_archive'         => false,
				'query_var'           => true,
				'can_export'          => true,
				'rewrite'             => false,
				'capability_type'     => 'page',
			);
			register_post_type( 'footer', $args );
		}
	}

	new Sumi_Post_Type();
}
