<?php
if ( !defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Sumi Mailchimp
 *
 * Displays Mailchimp widget.
 *
 * @author   Sumi
 * @category Widgets
 * @package  Sumi/Widgets
 * @version  1.0.0
 * @extends  SUMI_Widget
 */
if ( !class_exists( 'Sumi_Mailchimp_Widget' ) ) {
	class Sumi_Mailchimp_Widget extends SUMI_Widget
	{
		/**
		 * Constructor.
		 */
		public function __construct()
		{
			$array_settings           = apply_filters( 'sumi_filter_settings_widget_mailchimp',
				array(
					'title'       => array(
						'type'  => 'text',
						'title' => esc_html__( 'Title', 'sumi-toolkit' ),
					),
					'placeholder' => array(
						'type'    => 'text',
						'title'   => esc_html__( 'Placeholder Text:', 'sumi-toolkit' ),
						'default' => esc_html__( 'Enter your email address', 'sumi-toolkit' ),
					),
				)
			);
			$this->widget_cssclass    = 'widget-sumi-mailchimp';
			$this->widget_description = esc_html__( 'Display the customer Newsletter.', 'sumi-toolkit' );
			$this->widget_id          = 'widget_sumi_mailchimp';
			$this->widget_name        = esc_html__( 'Sumi: Newsletter', 'sumi-toolkit' );
			$this->settings           = $array_settings;
			parent::__construct();
		}

		/**
		 * Output widget.
		 *
		 * @see WP_Widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget( $args, $instance )
		{
			$this->widget_start( $args, $instance );
			ob_start();
			?>
            <div class="newsletter-form-wrap">
                <input class="email email-newsletter" type="email" name="email"
                       placeholder="<?php echo esc_attr( $instance['placeholder'] ); ?>">
                <a href="#" class="button btn-submit submit-newsletter">
                    <?php echo esc_html__( 'SIGN UP', 'sumi-toolkit' ); ?>
                </a>
            </div>
			<?php
			echo apply_filters( 'sumi_filter_widget_newsletter', ob_get_clean(), $instance );
			$this->widget_end( $args );
		}
	}
}
add_action( 'widgets_init', 'Sumi_Mailchimp_Widget' );
if ( !function_exists( 'Sumi_Mailchimp_Widget' ) ) {
	function Sumi_Mailchimp_Widget()
	{
		register_widget( 'Sumi_Mailchimp_Widget' );
	}
}