<?php
if ( !defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Sumi Content Page
 *
 * Displays Content Page widget.
 *
 * @author   Sumi
 * @category Widgets
 * @package  Sumi/Widgets
 * @version  1.0.0
 * @extends  SUMI_Widget
 */
if ( !class_exists( 'Sumi_Content_Page_Widget' ) ) {
	class Sumi_Content_Page_Widget extends SUMI_Widget
	{
		/**
		 * Constructor.
		 */
		public function __construct()
		{
			$array_settings           = apply_filters( 'sumi_filter_settings_widget_content_page',
				array(
					'title'         => array(
						'type'  => 'text',
						'title' => esc_html__( 'Title', 'sumi-toolkit' ),
					),
					'sumi_page_id' => array(
						'type'    => 'select',
						'title'   => esc_html__( 'Select Content', 'sumi-toolkit' ),
						'options' => 'pages',
					),
				)
			);
			$this->widget_cssclass    = 'widget-sumi-content_page sumi-content_page';
			$this->widget_description = esc_html__( 'Display the customer Content Page.', 'sumi-toolkit' );
			$this->widget_id          = 'widget_sumi_content_page';
			$this->widget_name        = esc_html__( 'Sumi: Content Page', 'sumi-toolkit' );
			$this->settings           = $array_settings;
			parent::__construct();
		}

		/**
		 * Output widget.
		 *
		 * @see WP_Widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget( $args, $instance )
		{
			$this->widget_start( $args, $instance );
			if ( $instance['sumi_page_id'] ) {
				$post_id = get_post( $instance['sumi_page_id'] );
				$content = $post_id->post_content;
				$content = apply_filters( 'the_content', $content );
				$content = str_replace( ']]>', ']]>', $content );
				/* GET CUSTOM CSS */
				$post_custom_css = get_post_meta( $instance['sumi_page_id'], '_Sumi_Shortcode_custom_css', true );
				echo '<style type="text/css">' . $post_custom_css . '</style>';
				echo $content;
			}
			$this->widget_end( $args );
		}
	}
}
/**
 * Register Widgets.
 *
 * @since 2.3.0
 */
function Sumi_Content_Page_Widget()
{
	register_widget( 'Sumi_Content_Page_Widget' );
}

add_action( 'widgets_init', 'Sumi_Content_Page_Widget' );