(function ($) {
    "use strict"; // Start of use strict
    var wf = document.createElement('script');
    wf.src = 'https://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
    wf.type = 'text/javascript';
    wf.async = 'true';
    var s = document.getElementsByTagName('script')[0];
    s.parentNode.insertBefore(wf, s);

    var FAMITHEMEDOCS_SCRIPTS = {
        init : function() {
            this.famithemedocs_register_function();
            this.famithemedocs_init_lazy_load();
            this.famithemedocs_prev_page();
            this.famithemedocs_clone_main_menu();
            this.scrollbar_vertical_menu();
            this.famithemedocs_add_to_cart_single();
            this.famithemedocs_auto_width_vertical_menu();
            this.famithemedocs_auto_width_main_vertical_menu();
            this.famithemedocs_show_other_item_vertical_menu();
            this.famithemedocs_scrolldown();
            this.famithemedocs_remove_product();
            this.famithemedocs_sidebar_offcanvas();
            this.famithemedocs_search_open();
            this.initAjaxLoad();
            this.initAjaxLoadPort();
            this.thumbnail_product();
            this.famithemedocs_countdown();
            this.famithemedocs_init_popup();
            this.famithemedocs_resizeMegamenu();
            this.famithemedocs_resizeMainmenu();
            this.famithemedocs_singleProduct_popup();
            this.famithemedocs_product_loadmore();
            this.sticky_scrollup();
            this.famithemedocs_custom_categories();
            this.sticky_detail_content();
            this.famithemedocs_vertical_menu();
            this.dropdown_menu('#menu-main-vertical-menu');
            this.famithemedocs_clickminicart_header_vertical();
            this.dropdown_menu('#menu-vertical-menu');
            this.famithemedocs_center_content();
            this.famithemedocs_dropdown();
            this.famithemedocs_google_maps();
            this.famithemedocs_woo_quantily();
            this.famithemedocs_tab_fade_effect();
            this.famithemedocs_gallery_photoswipe();
            this.update_wishlist_count();
            this.ajax_shop_page();
            this.backToTop();
            this.box_mobile_menu();
            this.famithemedocs_init_slick();
            this.better_equal_elems();
            this.famithemedocs_functions_runing_on_load();
            this.cp_masonry();
            this.famithemedocs_save_compared_options();
        },
        onReady: function(){
            if ($('.famithemedocs-google-maps').length > 0 && famithemedocs_global_script.gmap_api_key != '') {
                var wfm = document.createElement('script');
                wfm.src = 'https://maps.googleapis.com/maps/api/js?key=' + famithemedocs_global_script.gmap_api_key;
                wfm.type = 'text/javascript';
                var sm = document.getElementsByTagName('script')[0];
                sm.parentNode.insertBefore(wfm, sm);
            }
        },
        onResize: function(){
            this.famithemedocs_running_on_resize();
            this.sticky_scrollup();
            this.scrollbar_vertical_menu();
            this.thumbnail_product();
            this.better_equal_elems();
            this.famithemedocs_clone_main_menu();
            this.famithemedocs_resizeMegamenu();
            this.famithemedocs_resizeMainmenu();
            this.famithemedocs_auto_width_vertical_menu();
            this.famithemedocs_auto_width_main_vertical_menu();
            this.box_mobile_menu();
            this.cp_masonry();
        },
        onScroll: function(){

        },
        ajaxComplete: function(){
            this.slide_quick_view();
            this.famithemedocs_functions_runing_on_ajaxcomplete();
            this.famithemedocs_remove_product();
        },

        famithemedocs_save_compared_options: function(){
            // yith_woocompare_list
            var compare_cookie_name = famithemedocs_global_script.compare_cookie_name,
                woocompare_list = FAMITHEMEDOCS_SCRIPTS.getCookie(compare_cookie_name);
            if(woocompare_list !== null){
                var arr_data = JSON.parse(woocompare_list);
                if(arr_data !== '' && $.isArray(arr_data) ){
                    for (var i = 0; i < arr_data.length; i++) {
                        $('a.compare[data-product_id="'+arr_data[i]+'"]').addClass('added');
                    }
                }
            }
        },

        /* SLIDE QUICK VIEW */
        slide_quick_view : function () {
            if ($('#yith-quick-view-content .woocommerce-gallery-carousel').length > 0) {
                $('#yith-quick-view-content .woocommerce-gallery-carousel').each(function () {
                    var _this = $(this);
                    _this.slick({
                        prevArrow: '<i class="fa fa-angle-left" aria-hidden="true"></i>',
                        nextArrow: '<i class="fa fa-angle-right" aria-hidden="true"></i>',
                        infinite: false,
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    });
                    _this.find('.wp-post-image').on('load', function () {
                        _this.slick('slickGoTo', 0);
                    });
                });
            }
        },
        famithemedocs_center_content: function () {
            /*if ( $('.main-container.has-sidebar').length > 0 ) {
                if ( $('#widget-area').length > 0 ) {
                }
                else {
                    $('.main-content').css({'float':'none','margin-left':'auto','margin-right': 'auto'});
                }
            }*/
        },
        famithemedocs_dropdown: function () {
            $(document).on('click', '.language-toggle,.language-toggle-overlay', function () {
                $('.switcher-language').toggleClass('open');
            })
        },

        famithemedocs_vertical_menu: function () {
            $(document).on('click', '.vertical-menu-btn,.close-vertical-menu,.vertical-menu-overlay', function () {
                $('body').toggleClass('vertical-menu-open');
            })
        },

        dropdown_menu: function (contain) {
            $(contain).each(function () {
                var _main = $(this);
                _main.children('.menu-item.parent').each(function () {

                    var curent = $(this).find('.submenu');

                    $(this).children('.toggle-submenu').on('click', function () {
                        $(this).parent().children('.submenu').slideToggle(400);
                        _main.find('.submenu').not(curent).slideUp(400);

                        $(this).parent().toggleClass('show-submenu');
                        _main.find('.menu-item.parent').not($(this).parent()).removeClass('show-submenu');
                    });

                    var next_curent = $(this).find('.submenu');

                    next_curent.children('.menu-item.parent').each(function () {

                        var child_curent = $(this).find('.submenu');
                        $(this).children('.toggle-submenu').on('click', function () {
                            $(this).parent().parent().find('.submenu').not(child_curent).slideUp(400);
                            $(this).parent().children('.submenu').slideToggle(400);

                            $(this).parent().parent().find('.menu-item.parent').not($(this).parent()).removeClass('show-submenu');
                            $(this).parent().toggleClass('show-submenu');
                        })
                    });
                });
            });
        },

        // sticky_detail
        sticky_detail_content: function () {
            $('.sticky_detail .detail-content')
                .theiaStickySidebar({
                    additionalMarginTop: 30
                });
        },

        scrollbar_vertical_menu: function () {
            if ($(window).width() < 1200) {
                $('.menu-scroll .scrollbar-macosx').scrollbar();
            } else {
                $('.menu-scroll .scrollbar-macosx').scrollbar('destroy');
            }
        },

        sticky_scrollup: function () {
            if ($(window).width() > 1199) {
                if ($('.menu-sticky-smart .header-wrap-stick').length) {
                    var previousScroll = 0,
                        headerOrgOffset = $('.header-position').offset().top;

                    $('.menu-sticky-smart .header-wrap-stick').outerHeight($('.header-position').outerHeight());

                    $(window).scroll(function () {
                        var currentScroll = $(this).scrollTop();
                        if (currentScroll > headerOrgOffset) {
                            if (currentScroll > previousScroll) {
                                $('.header-position').addClass('hide-header');
                            } else {
                                $('.header-position').removeClass('hide-header');
                                $('.header-position').addClass('fixed');
                            }
                        } else {
                            $('.header-position').removeClass('fixed');
                        }
                        previousScroll = currentScroll;
                    });
                }
            } else {
                $('.menu-sticky-smart .header-wrap-stick').css("height", "auto");

            }
        },

        // sidebar canvas
        famithemedocs_sidebar_offcanvas: function () {
            $('.btn-canvas ,.sidebar-canvas-overlay,.close-sidebar-canvas').on('click', function () {
                $('body').toggleClass('sidebar-canvas-open')
            });
        },

        // search
        famithemedocs_search_open: function () {
            $('.header-search-icon').on('click', function () {
                $('body').toggleClass('header-seach-open')
            });
        },

        getCookie: function (c_name) {
            var c_value = document.cookie,
                c_start = c_value.indexOf(" " + c_name + "=");
            if (c_start == -1) {
                c_start = c_value.indexOf(c_name + "=");
            }
            if (c_start == -1) {
                c_value = null;
            } else {
                c_start = c_value.indexOf("=", c_start) + 1;
                var c_end = c_value.indexOf(";", c_start);
                if (c_end == -1) {
                    c_end = c_value.length;
                }
                c_value = unescape(c_value.substring(c_start, c_end));
            }
            return c_value;
        },

        setCookie: function (c_name, value, exdays) {
            var exdate = new Date();
            exdate.setDate(exdate.getDate() + exdays);
            var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
            document.cookie = c_name + "=" + c_value;
        },

        famithemedocs_singleProduct_popup: function () {
            $('.famithemedocs-bt-video a').magnificPopup({
                type: 'iframe',
                mainClass: 'mfp-fade',
                removalDelay: 160,
                preloader: false,
                disableOn: false,
                fixedContentPos: false
            });
            $('.product-360-button a').magnificPopup({
                type: 'inline',
                mainClass: 'mfp-fade',
                removalDelay: 160,
                disableOn: false,
                preloader: false,
                fixedContentPos: false,
                callbacks: {
                    open: function () {
                        $(window).resize()
                    },
                },
            });
            $('.open-popup-link').magnificPopup({
                mainClass: 'mfp-fade',
                removalDelay: 100,
                type: 'inline',
                callbacks: {
                    beforeOpen: function () {
                        this.st.mainClass = this.st.el.attr('data-effect');
                    }
                },
                midClick: true // allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source.
            });
            $('.open-popup-login').magnificPopup({
                mainClass: 'mfp-fade',
                removalDelay: 100,
                type: 'inline',
                callbacks: {
                    beforeOpen: function () {
                        this.st.mainClass = this.st.el.attr('data-effect');
                    }
                },
                midClick: true // allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source.
            });

            var expireDate = FAMITHEMEDOCS_SCRIPTS.getCookie("showpopup"),
                today = new Date().toUTCString();
            if (expireDate != null && expireDate > today) {
                //Do nothing!
            }
            else {
                setTimeout(function () {
                    if ($('#popup-discount').length) {
                        $.magnificPopup.open({
                            items: {
                                src: '#popup-discount'
                            },
                            type: 'inline',
                            mainClass: 'mfp-zoom-in'
                        });
                    }
                }, 3000);
                //Create cookie
                FAMITHEMEDOCS_SCRIPTS.setCookie("showpopup", "anything", 1);
            }
        },

        /* ---------------------------------------------
         Resize mega menu
         --------------------------------------------- */
        famithemedocs_resizeMegamenu: function () {
            var window_size = jQuery('body').innerWidth();
            window_size += FAMITHEMEDOCS_SCRIPTS.famithemedocs_get_scrollbar_width();
            if (window_size > 767) {
                if ($('#header .main-menu-wrapper').length > 0) {
                    var container = $('#header .main-menu-wrapper');
                    if (container != 'undefined') {
                        var container_width = 0,
                            container_offset = container.offset();
                        container_width = container.innerWidth();
                        setTimeout(function () {
                            $('.main-menu .item-megamenu').each(function (index, element) {
                                $(element).children('.megamenu').css({'max-width': container_width + 'px'});
                                var sub_menu_width = $(element).children('.megamenu').outerWidth(),
                                    item_width = $(element).outerWidth();
                                $(element).children('.megamenu').css({'left': '-' + (sub_menu_width / 2 - item_width / 2) + 'px'});
                                var container_left = container_offset.left,
                                    container_right = (container_left + container_width),
                                    item_left = $(element).offset().left,
                                    overflow_left = (sub_menu_width / 2 > (item_left - container_left)),
                                    overflow_right = ((sub_menu_width / 2 + item_left) > container_right);
                                if (overflow_left) {
                                    var left = (item_left - container_left);
                                    $(element).children('.megamenu').css({'left': -left + 'px'});
                                }
                                if (overflow_right && !overflow_left) {
                                    var left = (item_left - container_left);
                                    left = left - ( container_width - sub_menu_width );
                                    $(element).children('.megamenu').css({'left': -left + 'px'});
                                }
                            })
                        }, 100);
                    }
                }
            }
        },

        famithemedocs_resizeMainmenu: function () {
            var window_size = jQuery('body').innerWidth();
            window_size += FAMITHEMEDOCS_SCRIPTS.famithemedocs_get_scrollbar_width();
            if ((window_size > 767) & (window_size < 1199)) {
                if ($('#header .main-menu-wrapper').length > 0) {
                    var container = $('#header .main-menu-wrapper');
                    if (container != 'undefined') {
                        var container_width = 0,
                            container_offset = container.offset();
                        container_width = container.innerWidth();
                        setTimeout(function () {
                            $('.main-menu .menu-item-has-children:not(.item-megamenu)').each(function (index, element) {
                                $(element).children('.submenu:not(.megamenu)').css({'max-width': container_width + 'px'});
                                var sub_menu_width = $(element).children('.submenu:not(.megamenu)').outerWidth(),
                                    item_width = $(element).outerWidth();
                                $(element).children('.submenu:not(.megamenu)').css({'left': '-' + (sub_menu_width / 2 - item_width / 2) + 'px'});
                                var container_left = container_offset.left,
                                    container_right = (container_left + container_width),
                                    item_left = $(element).offset().left,
                                    overflow_left = (sub_menu_width / 2 > (item_left - container_left)),
                                    overflow_right = ((sub_menu_width / 2 + item_left) > container_right);
                                if (overflow_left) {
                                    var left = (item_left - container_left);
                                    $(element).children('.submenu:not(.megamenu)').css({'left': -left + 'px'});
                                }
                                if (overflow_right && !overflow_left) {
                                    var left = (item_left - container_left);
                                    left = left - ( container_width - sub_menu_width );
                                    $(element).children('.submenu:not(.megamenu)').css({'left': -left + 'px'});
                                }
                            })
                        }, 100);
                    }
                }
            }
        },

        famithemedocs_get_scrollbar_width: function () {
            var $inner = jQuery('<div style="width: 100%; height:200px;">test</div>'),
                $outer = jQuery('<div style="width:200px;height:150px; position: absolute; top: 0; left: 0; visibility: hidden; overflow:hidden;"></div>').append($inner),
                inner = $inner[0],
                outer = $outer[0];
            jQuery('body').append(outer);
            var width1 = inner.offsetWidth;
            $outer.css('overflow', 'scroll');
            var width2 = outer.clientWidth;
            $outer.remove();
            return (width1 - width2);
        },

        famithemedocs_auto_width_vertical_menu: function () {
            setTimeout(function () {
                var full_width = parseInt($('.container').innerWidth()) - 30,
                    menu_width = parseInt($('.verticalmenu-content').actual('width')),
                    w = (full_width - menu_width);
                $('.verticalmenu-content').find('.megamenu').each(function () {
                    $(this).css('max-width', w + 'px');
                });
            }, 100);
        },

        famithemedocs_auto_width_main_vertical_menu: function () {
            setTimeout(function () {
                var full_width = parseInt($(window).innerWidth()),
                    menu_width = parseInt($('.vertical-menu-wrap').actual('width')),
                    w = (full_width - menu_width);
                $('.vertical-menu-wrap').find('.megamenu').each(function () {
                    $(this).css('max-width', w + 'px');
                });
            }, 100);
        },

        famithemedocs_show_other_item_vertical_menu: function () {
            if ($('.block-nav-category').length > 0) {
                $('.block-nav-category').each(function () {
                    var all_item = 0,
                        limit_item = $(this).data('items') - 1;
                    all_item = $(this).find('.shortcode-vertical-menu>li').length;

                    if (all_item > (limit_item + 1)) {
                        $(this).addClass('show-button-all');
                    }
                    $(this).find('.shortcode-vertical-menu>li').each(function (i) {
                        all_item = all_item + 1;
                        if (i > limit_item) {
                            $(this).addClass('link-other');
                        }
                    });
                });
            }
        },

        famithemedocs_clone_main_menu: function () {
            var _clone_menu = $('#header .clone-main-menu'),
                _target = $('#box-mobile-menu .clone-main-menu'),
                _data_width = $('#header .main-navigation').data('width');
            if ($(window).innerWidth() <= _data_width) {
                if (_clone_menu.length > 0) {
                    _clone_menu.each(function () {
                        $(this).appendTo('#box-mobile-menu .box-inner');
                    });
                }
            } else {
                if (_target.length > 0) {
                    _target.each(function () {
                        $(this).appendTo('#header .main-navigation');
                    });
                }
            }

            function action_addClass() {
                $('body').addClass('box-mobile-menu-open');
                return false;
            }

            function action_removeClass() {
                $('body').removeClass('box-mobile-menu-open');
                return false;
            }

            $(".mobile-navigation").click(action_addClass);
            $("#box-mobile-menu .close-menu, .body-overlay").click(action_removeClass);
        },

        thumbnail_product: function () {
            $('.default .flex-control-thumbs').each(function () {
                if ($(this).not('.slick-initialized').children().length == 0) {
                    return;
                }
                var _data = $(this).parent().data('responsive'),
                    _data_1500 = $(this).parent().data('1500'),
                    _data_1199 = $(this).parent().data('1199'),
                    _data_991 = $(this).parent().data('991'),
                    _data_767 = $(this).parent().data('767'),
                    _data_480 = $(this).parent().data('480'),
                    _items = $(this).parent().data('items');
                $(this).slick({
                    infinite: false,
                    slidesToShow: _items,
                    slidesToScroll: 1,
                    dots: false,
                    prevArrow: '<i class="fa fa-angle-left" aria-hidden="true"></i>',
                    nextArrow: '<i class="fa fa-angle-right" aria-hidden="true"></i>',
                    responsive: _data,

                });
            });
            $('.vertical_thumnail .flex-control-thumbs').each(function () {
                if ($(this).not('.slick-initialized').children().length == 0) {
                    return;
                }
                var _data = $(this).parent().data('responsive'),
                    _items = $(this).parent().data('items');
                $(this).slick({
                    vertical: true,
                    verticalSwiping: true,
                    slidesToShow: _items,
                    slidesToScroll: 1,
                    dots: false,
                    infinite: false,
                    focusOnSelect: true,
                    prevArrow: '<i class="fa fa-angle-up" aria-hidden="true"></i>',
                    nextArrow: '<i class="fa fa-angle-down" aria-hidden="true"></i>',
                    responsive: _data,
                });
            });
            $('.sticky_detail .flex-control-thumbs').each(function () {
                if ($(this).not('.slick-initialized').children().length == 0) {
                    return;
                }
                if ($(window).width() < 1024) {
                    $(this).slick({
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        dots: false,
                        infinite: false,
                        focusOnSelect: true,
                        prevArrow: '<i class="fa fa-angle-left" aria-hidden="true"></i>',
                        nextArrow: '<i class="fa fa-angle-right" aria-hidden="true"></i>',
                        responsive: [
                            {
                                breakpoint: 767,
                                settings: {
                                    slidesToShow: 4,
                                    infinite: false
                                }
                            },
                            {
                                breakpoint: 480,
                                settings: {
                                    slidesToShow: 2,
                                    infinite: false
                                }
                            }
                        ]
                    });
                }
            });

            $(".owl-slick").not('.slick-initialized').each(function () {
                var _this = $(this),
                    _responsive = _this.data('responsive'),
                    config = Array();

                config.responsive = _responsive;
                config.mobileFirst = true;
                config.cssEase = 'linear';
                _this.slick(config);
                _this.on('beforeChange', function (event, slick, currentSlide) {
                    FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_lazy_load();
                });
            });
        },

        famithemedocs_prev_page: function () {
            if (history.length < 2) {
                $('.prev-page').addClass('prev-hide');
            } else {
                $(document).on('click', '.prev-page', function () {
                    history.go(-1);
                });
            }
        },

        /* ---------------------------------------------
         COUNTDOWN
         --------------------------------------------- */
        famithemedocs_countdown: function () {
            $('.famithemedocs-countdown').each(function () {
                var $el = $(this),
                    $timers = $el.find('.timers'),
                    $check = $timers.data('check'),
                    output = '';
                $timers.countdown($timers.data('date'), function (event) {
                    output = '';
                    var day = event.strftime('%D');
                    for (var i = 0; i < day.length; i++) {
                        output += '<span>' + day[i] + '</span>';
                    }
                    $timers.find('.day').html(output);

                    output = '';
                    if ($check == 'no-day') {
                        var hour = event.strftime('%I');
                    } else {
                        var hour = event.strftime('%H');
                    }
                    for (i = 0; i < hour.length; i++) {
                        output += '<span>' + hour[i] + '</span>';
                    }
                    $timers.find('.hour').html(output);

                    output = '';
                    var minu = event.strftime('%M');
                    for (i = 0; i < minu.length; i++) {
                        output += '<span>' + minu[i] + '</span>';
                    }
                    $(this).find('.min').html(output);

                    output = '';
                    var secs = event.strftime('%S');
                    for (i = 0; i < secs.length; i++) {
                        output += '<span>' + secs[i] + '</span>';
                    }
                    $timers.find('.secs').html(output);
                });
            });
        },

        /* ---------------------------------------------
         Woocommerce Quantily
         --------------------------------------------- */
        famithemedocs_woo_quantily: function () {
            $('body').on('click', '.quantity .quantity-plus', function () {
                var obj_qty = $(this).closest('.quantity').find('input.qty'),
                    val_qty = parseInt(obj_qty.val()),
                    min_qty = parseInt(obj_qty.attr('min')),
                    max_qty = parseInt(obj_qty.attr('max')),
                    step_qty = parseInt(obj_qty.attr('step'));
                val_qty = val_qty + step_qty;
                if (max_qty && val_qty > max_qty) {
                    val_qty = max_qty;
                }
                obj_qty.val(val_qty);
                obj_qty.trigger("change");
                return false;
            });

            $('body').on('click', '.quantity .quantity-minus', function () {
                var obj_qty  = $(this).closest('.quantity').find('input.qty'),
                    val_qty  = parseInt(obj_qty.val()),
                    min_qty  = parseInt(obj_qty.attr('min')),
                    max_qty  = parseInt(obj_qty.attr('max')),
                    step_qty = parseInt(obj_qty.attr('step'));
                val_qty = val_qty - step_qty;
                if (min_qty && val_qty < min_qty) {
                    val_qty = min_qty;
                }
                if (!min_qty && val_qty < 0) {
                    val_qty = 0;
                }
                obj_qty.val(val_qty);
                obj_qty.trigger("change");
                return false;
            });
        },

        //famithemedocs_ajax_lazy_load
        famithemedocs_init_lazy_load: function () {
            if ($('.lazy').length > 0) {
                $('.lazy').each(function () {
                    var _this = $(this),
                        _config = [];
                    _config.beforeLoad = function (element) {
                        element.parent().addClass('loading-lazy');
                    };
                    _config.afterLoad = function (element) {
                        element.parent().removeClass('loading-lazy');
                        _this.removeClass('lazy-bg-color');
                    };
                    _config.errorLoader = function (element) {
                        element.error();
                    };
                    _config.effect = "fadeIn";
                    _config.enableThrottle = true;
                    _config.throttle = 250;
                    _config.effectTime = 1000;
                    _config.threshold = 0;
                    _config.visibleOnly = true;

                    if (_this.closest('.center-mode').length == 0) {
                        _this.Lazy(_config);
                    } else {
                        this.attr('src', this.data("src"));
                        _this.removeAttr('data-src');
                    }
                })
            }
            $('.footer .lazy').lazy(
                {
                    bind: 'load',
                    beforeLoad: function (element) {
                        element.removeClass('lazy-bg-color');
                    },
                }
            );
        },

        /* ---------------------------------------------
         TAB EFFECT
         --------------------------------------------- */
        famithemedocs_tab_fade_effect: function () {
            // effect click
            $(document).on('click', '.famithemedocs-tabs .tab-link a', function () {
                var tab_id = $(this).attr('href'),
                    tab_animated = $(this).data('animate');

                tab_animated = ( tab_animated == undefined || tab_animated == "" ) ? '' : tab_animated;
                if (tab_animated == "") {
                    return false;
                }
                $(tab_id).find('.product-list-owl .owl-item.active, .product-list-grid .product-item').each(function (i) {
                    var t = $(this),
                        delay = i * 400,
                        style = $(this).attr("style"),
                        style = ( style == undefined ) ? '' : style;
                    t.attr("style", style +
                        ";-webkit-animation-delay:" + delay + "ms;"
                        + "-moz-animation-delay:" + delay + "ms;"
                        + "-o-animation-delay:" + delay + "ms;"
                        + "animation-delay:" + delay + "ms;"
                    ).addClass(tab_animated + ' animated').one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                        t.removeClass(tab_animated + ' animated');
                        t.attr("style", style);
                    });
                });
            });
        },

        famithemedocs_google_maps: function () {
            if ($('.famithemedocs-google-maps').length == 1 && famithemedocs_global_script.gmap_api_key != '') {
                $('.famithemedocs-google-maps').each(function () {
                    var $this = $(this),
                        $id = $this.attr('id'),
                        $zoom = parseInt($this.attr('data-zoom')),
                        $latitude = $this.attr('data-latitude'),
                        $longitude = $this.attr('data-longitude'),
                        $address = $this.attr('data-address'),
                        $map_type = $this.attr('data-map-type'),
                        $styles,
                        map,
                        bounds = new google.maps.LatLngBounds(),
                        mapOptions = {
                            zoom: $zoom,
                            panControl: true,
                            zoomControl: true,
                            mapTypeControl: true,
                            scaleControl: true,
                            draggable: true,
                            scrollwheel: false,
                            mapTypeId: google.maps.MapTypeId[$map_type],
                            styles: $styles
                        };

                    map = new google.maps.Map(document.getElementById($id), mapOptions);
                    map.setTilt(45);

                    // Multiple Markers
                    var markers = [],
                        infoWindowContent = [];

                    if ($latitude != '' && $longitude != '') {
                        markers[0] = [$address, $latitude, $longitude];
                        infoWindowContent[0] = [$address];
                    }

                    var infoWindow = new google.maps.InfoWindow(), marker, i;

                    for (i = 0; i < markers.length; i++) {
                        var position = new google.maps.LatLng(markers[i][1], markers[i][2]);
                        bounds.extend(position);
                        marker = new google.maps.Marker({
                            position: position,
                            map: map,
                            title: markers[i][0],
                        });
                        map.fitBounds(bounds);
                    }
                    var boundsListener = google.maps.event.addListener((map), 'bounds_changed', function (event) {
                        this.setZoom($zoom);
                        google.maps.event.removeListener(boundsListener);
                    });
                });
            }

        },
        //EQUAL ELEM
        better_equal_elems: function () {
            setTimeout(function () {
                $('.equal-container').each(function () {
                    var $this = $(this);
                    if ($this.find('.equal-elem').length) {
                        $this.find('.equal-elem').css({
                            'height': 'auto'
                        });
                        var elem_height = 0;
                        $this.find('.equal-elem').each(function () {
                            var this_elem_h = $(this).height();
                            if (elem_height < this_elem_h) {
                                elem_height = this_elem_h;
                            }
                        });
                        $this.find('.equal-elem').height(elem_height);
                    }
                });
            }, 1000);
        },

        /*mobile_menu*/
        box_mobile_menu: function () {
            var _content = $('#box-mobile-menu .clone-main-menu');
            if ($(window).innerWidth() <= 1024) {
                _content.each(function () {
                    var t = $(this);
                    t.addClass('active');
                    $(this).find('.toggle-submenu').on('click', function () {
                        t.removeClass('active');
                        var text_next = $(this).prev().text();
                        $('#box-mobile-menu .box-title').html(text_next);
                        t.find('li').removeClass('mobile-active');
                        $(this).parent().addClass('mobile-active');
                        $(this).parent().closest('.submenu').css({
                            'position': 'static',
                            'height': '0',
                        });
                        $('#box-mobile-menu #back-menu').css('display', 'block');
                    })
                });
                $('#box-mobile-menu #back-menu').on('click', function () {
                    _content.find('li.mobile-active').each(function () {
                        _content.find('li').removeClass('mobile-active');
                        if ($(this).parent().hasClass('main-menu')) {
                            _content.addClass('active');
                            $('#box-mobile-menu .box-title').html('MAIN MENU');
                            $('#box-mobile-menu #back-menu').css('display', 'none');
                        } else {
                            _content.removeClass('active');
                            $(this).parent().parent().addClass('mobile-active');
                            $(this).parent().css({
                                'position': 'absolute',
                                'height': 'auto',
                            });
                            var text_prev = $(this).parent().parent().children('a').text();
                            $('#box-mobile-menu .box-title').html(text_prev);
                        }
                    })
                });
            }
            $('.mobile-navigation').on('click', function () {
                $('body').addClass('box-mobile-menu-open');
            });
            $('#box-mobile-menu .close-menu, .body-overlay').on('click', function () {
                $('body').removeClass('box-mobile-menu-open');
            });
        },

        /* update wishlist count */
        update_wishlist_count: function () {
            var famithemedocs_update_wishlist_count = function () {
                $.ajax({
                    data: {
                        action: 'famithemedocs_update_wishlist_count'
                    },
                    url: yith_wcwl_l10n.ajax_url,
                    success: function (data) {
                        $('.header-wishlist .count, .block-wishlist .count').text('('+data+')');
                    },
                });
            };

            $('body').on('added_to_wishlist removed_from_wishlist', famithemedocs_update_wishlist_count);
        },

        famithemedocs_init_popup: function () {
            if ($(window).innerWidth() + FAMITHEMEDOCS_SCRIPTS.famithemedocs_get_scrollbar_width() < 768) {
                return false;
            }
            var disabled_popup_by_user = FAMITHEMEDOCS_SCRIPTS.getCookie('famithemedocs_disabled_popup_by_user');
            if (disabled_popup_by_user == 'true') {
                return false;
            } else {
                if ($('body').hasClass('home') && famithemedocs_global_script.famithemedocs_enable_popup == 1) {
                    setTimeout(function () {
                        $('#popup-newsletter').modal({
                            keyboard: false
                        })
                    }, famithemedocs_global_script.famithemedocs_popup_delay_time);

                }
            }
        },

        /* JAVASCRIPT SHOP PAGE */
        ajax_shop_page: function () {
            /*  VIEW GRID LIST */
            $(document).on('click', '.display-mode', function () {
                var _mode = $(this).data('mode'),
                    _url = window.location.href,
                    xhttp;
                $(this).closest('.main-content').find('.famithemedocs-ajax-load').attr("data-mode", _mode);
                _url += ( _url.indexOf("?") === -1 ? "?" : "&" ) + "shop_display_mode=" + _mode;

                $(this).addClass('active').siblings().removeClass('active');
                $('.main-content').addClass('loading');

                if (window.XMLHttpRequest)
                    xhttp = new XMLHttpRequest();
                else
                    xhttp = new ActiveXObject("Microsoft.XMLHTTP");
                xhttp.onreadystatechange = function () {
                    if (xhttp.readyState == 4 && xhttp.status == 200) {
                        $('.product-grid').html($(xhttp.responseText).find('.product-grid').html());
                        $('.main-content').removeClass('loading');
                        FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_lazy_load();
                    }
                };
                xhttp.open("POST", _url, true);
                xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                xhttp.send("shop_display_mode=" + _mode);
                return false;
            });
        },

        initAjaxLoad: function () {
            var button = $('.famithemedocs-ajax-load'),
                _option = $(this).data('load-more'),
                _mode = $(this).data('mode');

            button.each(function (i, val) {

                if (_option !== undefined) {
                    var page = _option.page,
                        container = _option.container,
                        layout = _option.layout,
                        isLoading = false,
                        anchor = $(val).find('a'),
                        next = $(anchor).attr('href'),
                        i = 2;

                    if (layout == 'loadmore') {
                        $(val).on('click', 'a', function (e) {
                            e.preventDefault();
                            anchor = $(val).find('a');
                            next = $(anchor).attr('href');
                            $(anchor).html('<i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>');
                            $(anchor).addClass('loading');
                            getData();
                        });
                    } else {
                        var animationFrame = function () {
                            anchor = $(val).find('a');
                            next = $(anchor).attr('href');
                            var bottomOffset = $('.' + container).offset().top + $('.' + container).height() - $(window).scrollTop();
                            if (bottomOffset < window.innerHeight && bottomOffset > 0 && !isLoading) {
                                if (!next)
                                    return;
                                isLoading = true;
                                $(anchor).html('<i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>');

                                getData();
                            }
                        }

                        var scrollHandler = function () {
                            requestAnimationFrame(animationFrame);
                        };

                        $(window).scroll(scrollHandler);
                    }

                    var getData = function () {
                        $.get(next + '', function (data) {
                            var content = $('.' + container, data).wrapInner('').html(),
                                newElement = $('.' + container, data).find('.product-item');
                            $(content).imagesLoaded(function () {
                                next = $(anchor, data).attr('href');
                                $('.' + container).append(newElement);
                                FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_lazy_load();
                            });

                            $(anchor).text('Load More');
                            $(anchor).removeClass('loading');
                            if (page > i) {
                                if (ZIGG_Data_Js != undefined && ZIGG_Data_Js['permalink'] == 'plain') {
                                    var link = next.replace(/paged=+[0-9]+/gi, 'paged=' + ( i + 1 ));
                                } else {
                                    var link = next.replace(/page\/+[0-9]+\//gi, 'page/' + ( i + 1 ) + '/');
                                }

                                $(anchor).attr('href', link);
                            } else {
                                $(anchor).removeAttr('href').addClass('disabled');
                                $(anchor).text('No More Products');
                            }
                            isLoading = false;
                            i++;
                        });
                    }
                }
            });
        },

        /* ---------------------------------------------
         AJAX LOADMORE
         -----------------------------------------------*/

        initAjaxLoadPort: function () {
            /* SHORTCODE PRODUCT LOADMORE*/
            $(document).on('click', '.loadmore-button-portfolio', function () {
                var atts = $(this).data('atts'),
                    key = $(this).data('key'),
                    port_w = parseInt($(this).data('width')),
                    port_h = parseInt($(this).data('height')),
                    page = parseInt($(this).attr('data-page'));

                $(this).addClass('loading');
                var data = {
                    action: 'famithemedocs_portfolio_load_more',
                    security: famithemedocs_ajax_frontend.security,
                    atts: atts,
                    page: page,
                    key: key,
                    port_w: port_w,
                    port_h: port_h
                }
                var t = $(this);
                $.post(famithemedocs_ajax_frontend.ajaxurl, data, function (response) {
                    t.removeClass('loading');
                    if (response.type == 'done') {
                        var items = $('' + response.data + '');
                        items.imagesLoaded(function () {
                            $('.portfolio-grid').append(items).isotope('appended', items, true);
                            FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_lazy_load();
                            FAMITHEMEDOCS_SCRIPTS.cp_masonry();
                        });
                        if (response.show_button == 0) {
                            t.remove();
                        } else {
                            t.attr('data-page', page + 1);
                        }
                    } else {
                        t.remove();
                    }

                })
                return false;
            });
        },

        famithemedocs_get_url_var: function (key, url) {
            var result = new RegExp(key + "=([^&]*)", "i").exec(url);
            return result && result[1] || "";
        },

        famithemedocs_remove_product: function () {
            $(document).on('click', '.minicart-items .product-cart .product-remove a.remove', function (e) {
                var $this = $(this),
                    thisItem = $this.closest('.product-cart'),
                    remove_url = $this.attr('href'),
                    product_id = $this.attr('data-product_id');

                if (thisItem.is('.loading')) {
                    return false;
                }
                if ($.trim(remove_url) !== '' && $.trim(remove_url) !== '#') {
                    thisItem.addClass('loading');
                    var nonce = FAMITHEMEDOCS_SCRIPTS.famithemedocs_get_url_var('_wpnonce', remove_url),
                        cart_item_key = FAMITHEMEDOCS_SCRIPTS.famithemedocs_get_url_var('remove_item', remove_url),
                        data = {
                            action: 'famithemedocs_remove_cart_item_via_ajax',
                            product_id: product_id,
                            cart_item_key: cart_item_key,
                            nonce: nonce
                        };

                    $.post(famithemedocs_ajax_frontend['ajaxurl'], data, function (response) {

                        if (response['err'] != 'yes') {
                            $('.header-minicart').html(response['mini_cart_html']);
                        }
                        thisItem.removeClass('loading');
                    });
                    e.preventDefault();
                }
                return false;
            });
        },

        famithemedocs_add_to_cart_single: function () {
            /* SINGLE ADD TO CART */
            $(document).on('click', '.single_add_to_cart_button', function (e) {
                e.preventDefault();
                var _this = $(this),
                    _product_id = _this.val(),
                    _form = _this.closest('form'),
                    _form_data = _form.serialize();

                if (_product_id != '') {
                    var _data = 'add-to-cart=' + _product_id + '&' + _form_data;
                } else {
                    var _data = _form_data;
                }
                $('.header-minicart').addClass('is-adding-to-cart');
                _this.addClass('loading');
                var atcUrl = wc_add_to_cart_params.wc_ajax_url.toString().replace('wc-ajax=%%endpoint%%', 'add-to-cart=' + _product_id + '&famithemedocs-ajax-add-to-cart=1');
                $.ajax({
                    type: 'POST',
                    url: atcUrl,
                    data: _data,
                    dataType: 'html',
                    cache: false,
                    headers: {'cache-control': 'no-cache'},
                    success: function () {
                        $(document.body).trigger('wc_fragment_refresh');
                        _this.removeClass('loading');
                        $(document).on('added_to_cart', function () {
                            $('.header-minicart').removeClass('is-adding-to-cart');
                        });
                    }
                });
            });
        },

        /*-----------------------------------------------
         Load More Product
         -----------------------------------------------*/
        famithemedocs_product_loadmore: function () {
            $('.woo-product-loadmore').on('click', function (e) {
                var $this = $(this);
                $this.addClass('loading');
                // get post ID in array
                var except_post_ids = new Array(),
                    _product_wrap = $(this).closest('.famithemedocs-products');
                _product_wrap.find('.product-item').each(function () {
                    var post_id = $(this).attr('data-id').replace('post-', '');
                    except_post_ids.push(post_id);
                });
                // get post ID in array
                var attr = $(this).attr('data-attribute'),
                    cats = $(this).attr('data-cats'),
                    id = $(this).data('id'),
                    page = parseInt($(this).attr('data-page')),
                    data = {
                        action: 'famithemedocs_loadmore_product',
                        except_post_ids: except_post_ids,
                        security: famithemedocs_ajax_frontend.security,
                        attr: attr,
                        cats: cats,
                        page: page,
                    };
                $.post(famithemedocs_ajax_frontend.ajaxurl, data, function (response) {
                    var items = $('' + response['html'] + '');
                    if ($.trim(response['success']) == 'yes') {
                        var tab_id = '.' + id;
                        $('#' + id).append(items);
                        FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_lazy_load();
                        if ($.trim(response['show_bt']) == '0') {
                            $this.addClass('disable');
                            $(tab_id + ' .woo-product-loadmore').html('No More Product');
                        } else {
                            $(tab_id + ' .woo-product-loadmore').attr('data-page', page + 1);
                        }
                    } else {
                        $('#' + id).append('<p class="return-message bg-success">Not ok</p>');
                    }
                    $this.removeClass('loading');
                });
                return false;
            });
        },

        /*----------------------------------------------
         //Slick Slider
         ------------------------------------------------*/
        famithemedocs_init_slick: function () {
            $(".owl-slick").not('.slick-initialized').each(function () {
                var _this = $(this),
                    _responsive = _this.data('responsive'),
                    config = Array();
                if (_this.hasClass('nav-themify')) {
                    config.prevArrow = '<span class="ti-angle-left"></span>';
                    config.nextArrow = '<span class="ti-angle-right"></span>';

                } else {
                    config.prevArrow = '<span aria-hidden="true" class="arrow_carrot-left"></span>';
                    config.nextArrow = '<span aria-hidden="true" class="arrow_carrot-right"></span>';
                }
                if (_this.hasClass('slick-modecenter')) {
                    config.centerPadding = '23.9583333%';
                    config.centerMode = true;
                    config.variableWidth = false;
                    config.dots = true;
                }
                config.responsive = _responsive;
                config.mobileFirst = true;
                config.focusOnSelect = true,
                    config.cssEase = 'linear';
                _this.slick(config);
                _this.on('beforeChange', function (event, slick, currentSlide) {
                    FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_lazy_load();
                });
            });
            $('.slick-active').each(function () {
                $(document).on('click touchstart', '.slick-active', function () {
                    $(this).addClass('slick-current').siblings().removeClass('slick-current');
                });
            });
        },

        /* ---------------------------------------------
         //Scripts scroll back to top button
         -------------------------------------------- */
        backToTop: function () {
            var el = $('.backtotop');
            $(window).scroll(function () {
                if ($(this).scrollTop() > $(window).height()) {
                    el.show();
                } else {
                    el.hide();
                }
            });
            el.click(function () {
                $('body,html').animate({
                    scrollTop: 0
                }, 500);
                return false;
            });
        },

        /* ---------------------------------------------
         // Woof Ajax done
         --------------------------------------------- */
        woof_ajax_done_handler: function (e) {
            if ($('img.lazy').length > 0) {
                $('img.lazy').each(function () {
                    if ($(this).data('original')) {
                        $(this).attr('src', $(this).data('original'));
                    }
                });
            }
        },

        famithemedocs_scrolldown: function () {
            $('.rev_slider_wrapper').on('mousewheel', function (event) {
                var $this = $(this);
                if ($this.find('.arrow-down').length) {
                    if (!$this.find('.arrow-down').is('.has-scrolled')) {
                        $this.find('.arrow-down').trigger('click').addClass('has-scrolled');
                    }
                }
            });
        },

        // portfolio Masonry
        kt_masonry: function ($masonry) {
            var t = $masonry.attr("data-cols");
            if (t == "1") {
                var n = $masonry.width(),
                    r = 1;
                return r
            }
            if (t == "2") {
                var n = $masonry.width()
                r = 2;
                if (n < 600) r = 1;
                return r
            } else if (t == "3") {
                var n = $masonry.width(),
                    r = 3;
                if (n < 600) r = 1;
                else if (n >= 600 && n < 768) r = 2;
                else if (n >= 768 && n < 992) r = 3;
                else if (n >= 992) r = 3;
                return r
            } else if (t == "4") {
                var n = $masonry.width(),
                    r = 4;
                if (n < 600) r = 1;
                else if (n >= 600 && n < 768) r = 2;
                else if (n >= 768 && n < 992) r = 3;
                else if (n >= 992) r = 4;
                return r
            } else if (t == "5") {
                var n = $masonry.width(),
                    r = 5;
                if (n < 600) r = 1;
                else if (n >= 600 && n < 768) r = 2;
                else if (n >= 768 && n < 992) r = 3;
                else if (n >= 992 && n < 1140) r = 4;
                else if (n >= 1140) r = 5;
                return r
            } else if (t == "6") {
                var n = $masonry.width(),
                    r = 5;
                if (n < 600) r = 1;
                else if (n >= 600 && n < 768) r = 2;
                else if (n >= 768 && n < 992) r = 3;
                else if (n >= 992 && n < 1160) r = 4;
                else if (n >= 1160) r = 6;
                return r
            } else if (t == "8") {
                var n = $masonry.width(),
                    r = 5;
                if (n < 600) r = 1;
                else if (n >= 600 && n < 768) r = 2;
                else if (n >= 768 && n < 992) r = 3;
                else if (n >= 992 && n < 1160) r = 4;
                else if (n >= 1160) r = 8;
                return r
            }
        },

        cp_s: function ($masonry) {
            var t = FAMITHEMEDOCS_SCRIPTS.kt_masonry($masonry),
                n = $masonry.width(),
                r = n / t;
            r = Math.floor(r);
            $masonry.find(".portfolio-item").each(function (t) {
                $(this).css({
                    width: r + "px"
                });
            });
        },

        cp_masonry: function () {
            $('.famithemedocs-portfolio').each(function () {
                var $masonry = $(this).find('.portfolio-grid'),
                    $layoutMode = $masonry.attr('data-layoutMode');
                FAMITHEMEDOCS_SCRIPTS.cp_s($masonry);
                // init Isotope
                var $grid = $masonry.isotope({
                    itemSelector: '.portfolio-item',
                    layoutMode: $layoutMode,
                    itemPositionDataEnabled: true
                });

                $grid.imagesLoaded().progress(function () {
                    $grid.isotope({
                        itemSelector: '.portfolio-item',
                        layoutMode: $layoutMode,
                        itemPositionDataEnabled: true
                    });
                });

                $(this).find('.portfolio_fillter .item-fillter').on('click', function () {
                    var $filterValue = $(this).attr('data-filter');
                    $grid.isotope({
                        filter: $filterValue
                    });
                    $(this).closest('.famithemedocs-portfolio').find('.portfolio_fillter .item-fillter').removeClass('fillter-active');
                    $(this).addClass('fillter-active');
                });

            });
        },

        // Categories product custom
        famithemedocs_custom_categories: function () {
            $(".ms-accordion").each(function () {
                var _main = $(this);
                _main.find('.cat-parent').each(function () {
                    $(this).append('<span class="carets"></span>');
                });
                _main.children('.cat-parent').each(function () {
                    var curent = $(this).find('.children');
                    $(this).children('.carets').on('click', function () {
                        $(this).parent().children('.children').slideToggle(400);
                        _main.find('.children').not(curent).slideUp(400);
                        $(this).parent().toggleClass('show-sub');
                        _main.find('.cat-parent').not($(this).parent()).removeClass('show-sub');
                    });
                    var next_curent = $(this).find('.children');
                    next_curent.children('.cat-parent').each(function () {
                        var child_curent = $(this).find('.children');
                        $(this).children('.carets').on('click', function () {
                            $(this).parent().parent().find('.children').not(child_curent).slideUp(400);
                            $(this).parent().children('.children').slideToggle(400);
                            $(this).parent().parent().find('.cat-parent').not($(this).parent()).removeClass('show-sub');
                            $(this).parent().toggleClass('show-sub');
                        })
                    });
                });
            });
        },

        // Portfolio Images popup
        famithemedocs_gallery_photoswipe: function () {
            var getGalleryItems = function () {
                var _slides = $('.portfolio-grid'),
                    _items = [];
                if (_slides.length > 0) {
                    _slides.find('a.portfolio-view').each(function () {
                        var $href = $(this).attr('href'),
                            $size = $(this).data('size').split('x'),
                            $width = $size[0],
                            $height = $size[1],
                            _item = {
                                src: $href,
                                w: $width,
                                h: $height
                            };
                        _items.push(_item);
                    });
                }
                return _items;
            };
            $(document).on('click', '.portfolio-item a.portfolio-view', function () {
                var _items = getGalleryItems(),
                    _index = $(this).data('index'),
                    _pswpElement = document.querySelectorAll('.pswp')[0],
                    _options = {
                        index: _index
                    },
                    gallery = new PhotoSwipe(_pswpElement, PhotoSwipeUI_Default, _items, _options);
                gallery.init();
                return false;
            });

            var getGalleryItemsInstagram = function () {
                var _slides = $('.famithemedocs-instagram'),
                    _items = [];
                _slides.each(function () {
                    if (_slides.length > 0) {
                        _slides.find('a').each(function () {
                            var $href = $(this).attr('href'),
                                $size = $(this).data('size').split('x'),
                                $width = $size[0],
                                $height = $size[1],
                                _item = {
                                    src: $href,
                                    w: $width,
                                    h: $height
                                };
                            _items.push(_item);
                        });
                    }
                })
                return _items;
            };
            $(document).on('click', '.item-instagram > a', function () {
                var _items = getGalleryItemsInstagram(),
                    _index = $(this).data('index'),
                    _pswpElement = document.querySelectorAll('.pswp')[0],
                    _options = {
                        index: _index
                    },
                    gallery = new PhotoSwipe(_pswpElement, PhotoSwipeUI_Default, _items, _options);
                gallery.init();
                return false;
            });
        },

        /* Click minicar header vertical */
        famithemedocs_clickminicart_header_vertical: function () {
            if ($(window).width() > 1199) {
                $(document).on('click', '.vertical-menu .header-minicart > .header-minicart-icon, .minicart-overlay', function () {
                    $('body').toggleClass('minicart-open');
                    return false
                });
            }
        },

        famithemedocs_register_function: function(){

            /* ---------------------------------------------
             Ajax Tab
             --------------------------------------------- */
            $(document).on('click', '[data-ajax="1"]', function () {
                FAMITHEMEDOCS_SCRIPTS.better_equal_elems();
                if (!$(this).hasClass('loaded')) {
                    var id = $(this).data('id'),
                        tab_id = $(this).attr('href'),
                        section_id = tab_id.replace('#', ''),
                        t = $(this);

                    $(tab_id).closest('.tab-container').append('<div class="cssload-wapper" style="min-height: 300px;position: static"><div class="cssload-square"><div class="cssload-square-part cssload-square-green"></div><div class="cssload-square-part cssload-square-pink"></div><div class="cssload-square-blend"></div></div></div>');
                    $(tab_id).closest('.panel-collapse').append('<div class="cssload-wapper" style="min-height: 300px;position: static"><div class="cssload-square"><div class="cssload-square-part cssload-square-green"></div><div class="cssload-square-part cssload-square-pink"></div><div class="cssload-square-blend"></div></div></div>');
                    $.ajax({
                        type: 'POST',
                        data: {
                            action: 'famithemedocs_ajax_tabs',
                            security: famithemedocs_ajax_frontend.security,
                            id: id,
                            section_id: section_id,
                        },
                        url: famithemedocs_ajax_frontend.ajaxurl,
                        success: function (response) {
                            $(tab_id).closest('.tab-container').find('.cssload-wapper').remove();
                            $(tab_id).closest('.panel-collapse').find('.cssload-wapper').remove();
                            $(tab_id).html($(response['html']).find('.vc_tta-panel-body').html());
                            t.addClass('loaded');
                        },
                        complete: function () {
                            FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_lazy_load();
                            FAMITHEMEDOCS_SCRIPTS.famithemedocs_product_loadmore();
                            FAMITHEMEDOCS_SCRIPTS.better_equal_elems();
                            FAMITHEMEDOCS_SCRIPTS.famithemedocs_init_slick();
                            FAMITHEMEDOCS_SCRIPTS.famithemedocs_tab_fade_effect();
                        }
                    });
                }
            });
            $(document).on('change', '.famithemedocs_disabled_popup_by_user', function () {
                if ($(this).is(":checked")) {
                    FAMITHEMEDOCS_SCRIPTS.setCookie("famithemedocs_disabled_popup_by_user", 'true', 7);
                } else {
                    FAMITHEMEDOCS_SCRIPTS.setCookie("famithemedocs_disabled_popup_by_user", '', 0);
                }
            });
            //BACK TO TOP
            $('a.backtotop').on('click', function () {
                $('html, body').animate({scrollTop: 0}, 800);
                return false;
            });

            $(document).on("woof_ajax_done", FAMITHEMEDOCS_SCRIPTS.woof_ajax_done_handler);
            $(document).on('adding_to_cart', function () {
                if ($('.header-minicart').length) {
                    $('.header-minicart').addClass('is-adding-to-cart');
                }
            });
            $(document).on('added_to_cart', function () {
                if ($('.header-minicart').length) {
                    $('.header-minicart').removeClass('is-adding-to-cart');
                }
            });




            $(document).on('click', '.open-cate', function () {
                $(this).closest('.block-nav-category').find('li.link-other').each(function () {
                    $(this).slideDown();
                });
                var closetext = $(this).data('closetext');
                $(this).addClass('close-cate').removeClass('open-cate').html(closetext);
                return false;
            });

            /* Close Categorie */
            $(document).on('click', '.close-cate', function () {
                $(this).closest('.block-nav-category').find('li.link-other').each(function () {
                    $(this).slideUp();
                });
                var alltext = $(this).data('alltext');
                $(this).addClass('open-cate').removeClass('close-cate').html(alltext);
                return false;
            });

            $(".block-nav-category .block-title").on('click', function () {
                $(this).toggleClass('active');
                $(this).parent().toggleClass('has-open');
                $("body").toggleClass("category-open");
            });

            $('#yith-quick-view-content .scrollbar-macosx,.sidebar-canvas .scrollbar-macosx, .minicart-content .scrollbar-macosx').scrollbar();
            $('.orderby, .category-search-option').chosen();
        },
        famithemedocs_running_on_resize: function(){
            $('#yith-quick-view-content .scrollbar-macosx,.sidebar-canvas .scrollbar-macosx, .minicart-content .scrollbar-macosx').scrollbar();
        },

        famithemedocs_functions_runing_on_load: function(){
            $('#yith-quick-view-content .scrollbar-macosx,.sidebar-canvas .scrollbar-macosx, .minicart-content .scrollbar-macosx').scrollbar();
        },
        famithemedocs_functions_runing_on_ajaxcomplete: function(){
            $('#yith-quick-view-content .scrollbar-macosx').scrollbar();
            $('.minicart-content .scrollbar-macosx').scrollbar();
        },

    }

    $(window).load(function () {
        WebFont.load({
            google: {
                families: famithemedocs_global_script.google_font
            }
        });
    });

    $(window).on("resize", function () {
        FAMITHEMEDOCS_SCRIPTS.onResize();
    });

    $(document).ajaxComplete(function (event, xhr, settings) {
        FAMITHEMEDOCS_SCRIPTS.ajaxComplete();
    });

    $(document).ready(function () {
        FAMITHEMEDOCS_SCRIPTS.onReady();
    });

    window.addEventListener('load', function () {
        FAMITHEMEDOCS_SCRIPTS.init();
    }, false);

})(jQuery); // End of use strict