<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Sumi_Newsletter"
 */
if ( !class_exists( 'Sumi_Shortcode_Newsletter' ) ) {
	class Sumi_Shortcode_Newsletter extends Sumi_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'newsletter';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'sumi_newsletter', $atts ) : $atts;
			extract( $atts );
			$css_class    = array( 'sumi-newsletter' );
			$css_class[]  = $atts['el_class'];
			$css_class[]  = $atts['style'];
			$class_editor = isset( $atts['css'] ) ? vc_shortcode_custom_css_class( $atts['css'], ' ' ) : '';
			$css_class[]  = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_newsletter', $atts );
			$shortcode    = '';
			$default      = array(
				'title'       => $atts['title'],
				'subtitle'    => $atts['subtitle'],
				'show_list'   => $atts['show_list'],
				'field_name'  => $atts['field_name'],
				'fname_text'  => $atts['fname_text'],
				'lname_text'  => $atts['lname_text'],
				'placeholder' => $atts['placeholder'],
				'button_text' => $atts['button_text'],
			);
			foreach ( $default as $key => $value ) {
				$shortcode .= ' ' . $key . '="' . $value . '" ';
			}
			ob_start(); ?>
			<?php if ( $atts['style'] == 'style1' ) : ?>
	            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
	            	<?php if ( $atts['images'] ) : ?>
						<?php $image_thumb = apply_filters( 'sumi_resize_image', $atts['images'], false, false, true, true ); ?>
	                    <div class="img-newsletter">
							<?php echo wp_specialchars_decode( $image_thumb['img'] ); ?>
	                    </div>
					<?php endif; ?>
                    <div class="box-info">
                        <?php if ( $atts['title'] ) : ?>
                            <h3 class="widgettitle">
                                <span class="title"><?php echo esc_html( $atts['title'] ); ?></span>
                            </h3>
                        <?php endif; ?>
                        <?php if ( $atts['subtitle'] ) : ?>
                            <p class="desc"><?php echo wp_specialchars_decode( $atts['subtitle'] ); ?></p>
                        <?php endif; ?>
                    </div>
                    <?php echo do_shortcode( '[sumi_mailchimp' . $shortcode . ']' ); ?>
	            </div>
            <?php elseif ( $atts['style'] == 'style2' ) : ?>
			<div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
            		<div class="newsletter-content">
            			<div class="newsletter-text">
							<?php if ( $atts['title'] ) : ?>
			                    <h3 class="widgettitle">
			                        <span class="title"><?php echo esc_html( $atts['title'] ); ?></span>
			                    </h3>
							<?php endif; ?>
							<?php if ( $atts['subtitle'] ) : ?>
			                    <p class="desc"><?php echo wp_specialchars_decode( $atts['subtitle'] ); ?></p>
							<?php endif; ?>
						</div>
						<?php echo do_shortcode( '[sumi_mailchimp' . $shortcode . ']' ); ?>
	                </div>
	            </div>
            <?php endif; ?>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Sumi_Shortcode_Newsletter', $html, $atts, $content );
		}
	}

	new Sumi_Shortcode_Newsletter();
}