<?php
if ( ! class_exists( 'Sumi_Shortcode_Iconbox' ) ) {
	class Sumi_Shortcode_Iconbox extends Sumi_Shortcode {
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'iconbox';
		/**
		 * Default $atts .
		 *
		 * @var  array
		 */
		public $default_atts = array();
		
		public function output_html( $atts, $content = null ) {
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'sumi_iconbox', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class    = array( 'sumi-iconbox' );
			$css_class[]  = $atts['style'];
			$css_class[]  = $atts['el_class'];
			$class_editor = isset( $atts['css'] ) ? vc_shortcode_custom_css_class( $atts['css'], ' ' ) : '';
			$css_class[]  = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_iconbox', $atts );
			$icon_avatar  = apply_filters( 'sumi_resize_image', $atts['avatar_testi'], 320, 348, true, true );
			$icon         = $atts[ 'icon_' . $atts['type'] ];
			// Enqueue needed icon font.
			vc_icon_element_fonts_enqueue( $atts['type'] );
			ob_start();
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
                <div class="iconbox-inner">
					<?php if ( $atts['title'] && $atts['style'] == 'style4' && $atts['style'] != 'style1' ) : ?>
						<?php $link_icon = vc_build_link( $atts['link'] );
						if ( $link_icon['url'] ) : ?>
                            <h4 class="title">
                                <a href="<?php echo esc_url( $link_icon['url'] ); ?>"
                                   target="<?php echo esc_attr( $link_icon['target'] ); ?>">
									<?php echo esc_html( $atts['title'] ); ?>
                                </a>
                            </h4>
						<?php else: ?>
                            <h4 class="title"><?php echo esc_html( $atts['title'] ); ?></h4>
						<?php endif; ?>
					<?php endif; ?>
					<?php if ( $atts['style'] != 'style1' ) : ?>
                        <div class="box-icon">
							<?php if ( $icon ): ?>
                                <div class="icon"><span class="<?php echo esc_attr( $icon ) ?>"></span></div>
							<?php endif; ?>
							<?php if ( $atts['style'] == 'style2' ) : ?>
								<?php if ( $atts['text_1'] ): ?>
                                    <p class="text-1"><?php echo esc_html( $atts['text_1'] ); ?></p>
								<?php endif; ?>
							<?php endif; ?>
                        </div>
                        <div class="content">
							<?php if ( $atts['title'] && $atts['style'] != 'style4' ): ?>
								<?php $link_icon = vc_build_link( $atts['link'] );
								if ( $link_icon['url'] ) : ?>
                                    <h4 class="title">
                                        <a href="<?php echo esc_url( $link_icon['url'] ); ?>"
                                           target="<?php echo esc_attr( $link_icon['target'] ); ?>">
											<?php echo esc_html( $atts['title'] ); ?>
                                        </a>
                                    </h4>
								<?php else: ?>
                                    <h4 class="title"><?php echo esc_html( $atts['title'] ); ?></h4>
								<?php endif; ?>
							<?php endif; ?>
							<?php if ( $atts['style'] == 'style2' ) : ?>
								<?php
								$text_2_link = isset( $atts['text_2_link'] ) ? trim( $atts['text_2_link'] ) : '';
								if ( $atts['text_2'] != '' ) {
									if ( $text_2_link != '' ) {
										?>
                                        <p class="text-2"><a
                                                    href="<?php echo esc_url( $text_2_link ); ?>"><?php echo esc_html( $atts['text_2'] ); ?></a>
                                        </p>
										<?php
									} else {
										?>
                                        <p class="text-2"><?php echo esc_html( $atts['text_2'] ); ?></p>
										<?php
									}
								}
								?>
							<?php endif; ?>
							<?php if ( $atts['text_content'] && $atts['style'] != 'style1' ): ?>
                                <p class="text"><?php echo wp_specialchars_decode( $atts['text_content'] ); ?></p>
							<?php endif; ?>
                        </div>
					<?php endif; ?>
					<?php if ( $atts['style'] == 'style1' ) : ?>
                        <div class="testimonial-info">
							<?php if ( $atts['text_content'] ): ?>
                                <p class="text"><?php echo wp_specialchars_decode( $atts['text_content'] ); ?></p>
							<?php endif; ?>
							<?php if ( $atts['select_rating'] ): ?>
                                <span class="<?php echo esc_attr( $atts['select_rating'] ); ?>"></span>
							<?php endif; ?>
                        </div>
                        <div class="testimonial-author">
							<?php if ( $atts['avatar_testi'] ): ?>
                                <div class="avatar">
									<?php echo wp_specialchars_decode( $icon_avatar['img'] ); ?>
                                </div>
							<?php endif; ?>
                            <div class="author-info">
								<?php if ( $atts['text_name'] ): ?>
                                    <p class="text-name"><?php echo esc_html( $atts['text_name'] ); ?></p>
								<?php endif; ?>
								<?php if ( $atts['text_position'] ): ?>
                                    <p class="text-position"><?php echo esc_html( $atts['text_position'] ); ?></p>
								<?php endif; ?>
                            </div>
                        </div>
					<?php endif; ?>
                </div>
            </div>
			<?php
			$html = ob_get_clean();
			
			return apply_filters( 'Sumi_Shortcode_Iconbox', $html, $atts, $content );
		}
	}
	
	new Sumi_Shortcode_Iconbox();
}