<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Sumi_Heading"
 */
if ( !class_exists( 'Sumi_Shortcode_Heading' ) ) {
	class Sumi_Shortcode_Heading extends Sumi_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'heading';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'sumi_heading', $atts ) : $atts;
			extract( $atts );
			$css_class    = array( 'sumi-heading' );
			$css_class[]  = $atts['style'];
			$css_class[]  = $atts['el_class'];
			$class_editor = isset( $atts['css'] ) ? vc_shortcode_custom_css_class( $atts['css'], ' ' ) : '';
			$css_class[]  = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_heading', $atts );
			// Enqueue needed icon font.
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php if ( $atts['title'] ) : ?>
                    <h4 class="sumi-title">
                        <span><?php echo esc_html( $atts['title'] ); ?></span>
                    </h4>
				<?php endif; ?>
				<?php if ( $atts['desc'] ) : ?>
                    <p class="desc"><?php echo wp_specialchars_decode( $atts['desc'] ); ?></p>
				<?php endif; ?>
				<?php if ( $atts['link'] ) : ?>
					<?php
					$link           = vc_build_link( $atts['link'] );
					$link['target'] = $link['target'] == '' ? '_self' : $link['target'];
					$link['url']    = $link['url'] == '' ? '#' : $link['url'];
					?>
                    <a class="view-all button" href="<?php echo esc_url( $link['url'] ) ?>"
                       target="<?php echo esc_attr( $link['target'] ) ?>">
						<?php echo esc_html( $link['title'] ) ?>
                    </a>
				<?php endif; ?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Sumi_Shortcode_Heading', $html, $atts, $content );
		}
	}

	new Sumi_Shortcode_Heading();
}