<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Sumi_Countdown"
 */
if ( !class_exists( 'Sumi_Shortcode_Countdown' ) ) {
	class Sumi_Shortcode_Countdown extends Sumi_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'countdown';

		static public function add_css_generate( $atts )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'sumi_countdown', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css = '';
			return apply_filters( 'Sumi_Shortcode_Countdown_css', $css, $atts );
		}

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'sumi_countdown', $atts ) : $atts;
			extract( $atts );
			$css_class    = array( 'sumi-countdown-sc' );
			$css_class[]  = $atts['el_class'];
			$class_editor = isset( $atts['css'] ) ? vc_shortcode_custom_css_class( $atts['css'], ' ' ) : '';
			$css_class[]  = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_countdown', $atts );
			
			ob_start(); ?>
			<div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<div class="head">
					<?php if ( $atts['title'] ) : ?>
						<h4 class="title">
							<?php echo esc_html( $atts['title'] ); ?>
						</h4>
					<?php endif; ?>
					<?php if ( $atts['subtitle'] ) : ?>
						<p class="subtitle">
							<?php echo esc_html( $atts['subtitle'] ); ?>
						</p>
					<?php endif; ?>
					<?php if ( $atts['text_date'] ) : ?>
						<p class="text-date">
							<?php echo esc_html( $atts['text_date'] ); ?>
						</p>
					<?php endif; ?>
				</div>
				<div class="sumi-countdown"
					 data-datetime="<?php echo esc_attr( $atts['date'] ); ?>">
				</div>
			</div>
			<?php
			$html = ob_get_clean();
			return apply_filters( 'Sumi_Shortcode_Countdown', $html, $atts, $content );
		}
	}

	new Sumi_Shortcode_Countdown();
}