<?php
if (!defined('ABSPATH')) {
    die('-1');
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Sumi_Category"
 */
if (!class_exists('Sumi_Shortcode_Category')) {
    class Sumi_Shortcode_Category extends Sumi_Shortcode
    {
        /**
         * Shortcode name.
         *
         * @var  string
         */
        public $shortcode = 'category';



        public function output_html($atts, $content = null)
        {
            $atts = function_exists('vc_map_get_attributes') ? vc_map_get_attributes('sumi_category', $atts) : $atts;
            extract($atts);
            $css_class = array('sumi-category');
            $css_class[] = $atts['el_class'];
            $class_editor = isset($atts['css']) ? vc_shortcode_custom_css_class($atts['css'], ' ') : '';
            $css_class[] = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_category', $atts);
            $style = '';
            /* START */
            $html = '<div class="' . esc_attr( implode( ' ', $css_class ) ) . '">';
            $html .= '<div class="category-inner">';
            if ( $atts['taxonomy'] ) {
                $term = get_term_by( 'slug', $atts['taxonomy'], 'product_cat' );
                if ( !is_wp_error( $term ) ) {
                    $url  = get_term_link( $term->term_id, 'product_cat' );
                    if ( $atts['background'] ){
                        $style = 'background-image: url('. wp_get_attachment_url( $atts['background'], 'full' ) .');';
                    }
                    $html .= '<a href="' . esc_url( $url ) . '" class="category-thumb" style="'. $style .'">';
                    if ( $atts['background'] ) {
                        $html .= '<figure>' . wp_get_attachment_image( $atts['background'], 'full' ) . '</figure>';
                    }
                    $html .= '<div class="category-content"><div class="content-inner">';
                    $html .= '<span class="color-category" style="background-color:'.$atts['background_color'].';"  ></span>';
                    $html .= '<h3 class="title">' . esc_html( $term->name ) . '</h3>';
                    $html .= '<p class="desc">' . esc_html( $term->count ) . ' ' . esc_html__( 'products', 'sumi' ) . '</p>';
                    $html .= '</div></div>';
                    $html .= '</a>';
                }
            }
            $html .= '</div></div>';

            return apply_filters( 'Sumi_Shortcode_Category', $html, $atts, $content );
        }
    }

    new Sumi_Shortcode_Category();
}