<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Sumi_Blog"
 */
if ( !class_exists( 'Sumi_Shortcode_Blog' ) ) {
	class Sumi_Shortcode_Blog extends Sumi_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'blog';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'sumi_blog', $atts ) : $atts;
			extract( $atts );
			$css_class    = array( 'sumi-blog' );
			$css_class[]  = $atts['blog_style'];
			$css_class[]  = $atts['el_class'];
			$class_editor = isset( $atts['css'] ) ? vc_shortcode_custom_css_class( $atts['css'], ' ' ) : '';
			$css_class[]  = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_blog', $atts );
			/* START */
			$data_loop     = vc_build_loop_query( $atts['loop'] )[1];
			$owl_settings  = apply_filters( 'sumi_carousel_data_attributes', 'owl_', $atts );
			$template_blog = apply_filters( 'sumi_template_blog_style', 'templates/blog/blog-styles/content-blog' );
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php if ( $atts['blog_title'] ) : ?>
                    <h4 class="sumi-title">
                        <span><?php echo esc_html( $atts['blog_title'] ); ?></span>
                    </h4>
				<?php endif; ?>
				<?php if ( $data_loop->have_posts() ) : ?>
                    <div class="blog-list-owl owl-slick" <?php echo esc_attr( $owl_settings ); ?>>
						<?php while ( $data_loop->have_posts() ) : $data_loop->the_post(); ?>
                            <article <?php post_class( 'post-item' ); ?>>
                                <div class="post-item-inner">
                                    <div class="post-thumb">
                                    	<div class="thumb-img">
	                                        <a href="<?php the_permalink(); ?>">
												<?php
												$image_thumb = apply_filters( 'sumi_resize_image', get_post_thumbnail_id(), 443, 347, true, true );
												echo wp_specialchars_decode( $image_thumb['img'] );
												?>
	                                        </a>
                                        </div>
                                        <span class="post-date"> <?php echo get_the_date(); ?> </span>
                                    </div>
                                    <div class="post-info">
                                    	<h2 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                        <div class="post-content">
											<?php echo wp_trim_words( apply_filters( 'the_excerpt', get_the_excerpt() ), 15, esc_html__( '...', 'sumi' ) ); ?>
							            </div>
                                    </div>
                                </div>
                            </article>
						<?php endwhile; ?>
                    </div>
				<?php else :
					get_template_part( 'content', 'none' );
				endif; ?>
            </div>
			<?php
			$array_filter = array(
				'template' => $template_blog,
				'carousel' => $owl_settings,
				'query'    => $data_loop,
			);
			wp_reset_postdata();
			$html = ob_get_clean();

			return apply_filters( 'Sumi_Shortcode_Blog', $html, $atts, $content, $array_filter );
		}
	}

	new Sumi_Shortcode_Blog();
}