<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Sumi_Banner"
 */
if ( !class_exists( 'Sumi_Shortcode_Banner' ) ) {
	class Sumi_Shortcode_Banner extends Sumi_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'banner';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'sumi_banner', $atts ) : $atts;
			extract( $atts );
			$css_class    = array( 'sumi-banner' );
			$css_class[]  = $atts['style'];
			$css_class[]  = $atts['el_class'];
			$class_editor = isset( $atts['css'] ) ? vc_shortcode_custom_css_class( $atts['css'], ' ' ) : '';
			$css_class[]  = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_banner', $atts );
			$banner_link_arg  = vc_build_link( $atts['banner_link'] );
			// Enqueue needed icon font.
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
            	<?php if ( $atts['image_background'] ) : ?>
					<?php $image_thumb = apply_filters( 'sumi_resize_image', $atts['image_background'], false, false, true, true ); ?>
                    <div class="thumb-banner">
						<?php echo  wp_specialchars_decode( $image_thumb['img'] ); ?>
                    </div>
				<?php endif; ?>
				<div class="banner-content">
					<?php if ( $atts['text_1'] ) : ?>
	                    <span class="sumi-first">
	                        <span><?php echo esc_html( $atts['text_1'] ); ?></span>
	                    </span>
					<?php endif; ?>
					<?php if ( $atts['text_2'] ) : ?>
	                    <h4 class="sumi-second">
	                        <span><?php echo esc_html( $atts['text_2'] ); ?></span>
	                    </h4>
					<?php endif; ?>
					<?php if ( $atts['text_3'] ) : ?>
	                    <span class="sumi-third">
	                        <span><?php echo esc_html( $atts['text_3'] ); ?></span>
	                    </span>
					<?php endif; ?>
					<?php if ( $atts['banner_link'] ): ?>
	                    <a class="banner-link"
	                       href="<?php echo esc_url( $banner_link_arg['url'] ) ?>"><?php echo esc_html($banner_link_arg['title']) ?>
	                    </a>
					<?php endif; ?>
				</div>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Sumi_Shortcode_Banner', $html, $atts, $content );
		}
	}

	new Sumi_Shortcode_Banner();
}