<?php
if (!defined('ABSPATH')) {
    die('-1');
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Sumi_Accordions"
 */
if (!class_exists('Sumi_Shortcode_Accordion')) {
    class Sumi_Shortcode_Accordion extends Sumi_Shortcode
    {
        /**
         * Shortcode name.
         *
         * @var  string
         */
        public $shortcode = 'accordions';

        public function output_html($atts, $content = null)
        {
            $atts = function_exists('vc_map_get_attributes') ? vc_map_get_attributes('sumi_accordions', $atts) : $atts;
            extract($atts);
            $css_class = array('sumi-accordion');
            $css_class[] = $atts['el_class'];
            $class_editor = isset($atts['css']) ? vc_shortcode_custom_css_class($atts['css'], ' ') : '';
            $css_class[] = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_editor, 'sumi_accordions', $atts);
            // Enqueue needed icon font.
            ob_start(); ?>
            <div class="<?php echo esc_attr(implode(' ', $css_class)); ?>">
                <?php if ($atts['title']) : ?>
                    <h4 class="title">
                        <?php echo esc_html($atts['title']); ?>
                    </h4>
                    <span class="arrow"></span>
                <?php endif; ?>
                <?php if ($atts['desc']) : ?>
                    <p class="desc"><?php echo wp_specialchars_decode($atts['desc']); ?></p>
                <?php endif; ?>
            </div>
            <?php
            $html = ob_get_clean();

            return apply_filters('Sumi_Shortcode_Accordion', $html, $atts, $content);
        }
    }

    new Sumi_Shortcode_Accordion();
}