<?php
/**
 * Name:  Header style 02
 **/
?>
<?php
$sumi_icon    = Sumi_Functions::sumi_get_option( 'header_icon' );
$sumi_phone   = Sumi_Functions::sumi_get_option( 'header_phone' );
$sumi_text    = Sumi_Functions::sumi_get_option( 'header_text' );
$enable_sticky = Sumi_Functions::sumi_get_option( 'sumi_enable_sticky_menu' );
$hidden_top_left = Sumi_Functions::sumi_get_option( 'sumi_hidden_top_left' );
$hidden_top_right = Sumi_Functions::sumi_get_option( 'sumi_hidden_top_right' );
$class         = array( 'header', 'style2' );
if ( $hidden_top_left == 1 )
	$class[] = 'hidden-top-left';
if ( $hidden_top_right == 1 )
	$class[] = 'hidden-top-right';
?>
<?php
if( class_exists( 'WooCommerce' ) ): ?>
	<div class="canvas-content">
		<h3 class="text-canvas"><?php esc_html_e( 'YOUR CART', 'sumi' ); ?></h3>
		<a href="#" class="canvas-button canvas-close"><i class="flaticon-cancel"></i></a>
		<?php
		the_widget( 'WC_Widget_Cart', 'title=' );
		?>
	</div>
<?php endif;
?>
<header id="header" class="<?php echo esc_attr( implode( ' ', $class ) ); ?>">
	<?php if ( has_nav_menu( 'top_left_menu' ) || has_nav_menu( 'top_right_menu' ) ): ?>
        <div class="header-top">
            <div class="container">
                <div class="header-top-inner">
					<?php
					if ( has_nav_menu( 'top_left_menu' ) ) {
						wp_nav_menu( array(
								'menu'            => 'top_left_menu',
								'theme_location'  => 'top_left_menu',
								'depth'           => 1,
								'container'       => '',
								'container_class' => '',
								'container_id'    => '',
								'menu_class'      => 'sumi-nav top-bar-menu',
								'fallback_cb'     => 'Sumi_navwalker::fallback',
								'walker'          => new Sumi_navwalker(),
							)
						);
					}
					if ( has_nav_menu( 'top_right_menu' ) ) {
						wp_nav_menu( array(
								'menu'            => 'top_right_menu',
								'theme_location'  => 'top_right_menu',
								'depth'           => 1,
								'container'       => '',
								'container_class' => '',
								'container_id'    => '',
								'menu_class'      => 'sumi-nav top-bar-menu right',
								'fallback_cb'     => 'Sumi_navwalker::fallback',
								'walker'          => new Sumi_navwalker(),
							)
						);
					}
					?>
                </div>
            </div>
        </div>
	<?php endif; ?>
    <div class="header-middle">
        <div class="container">
            <div class="header-middle-inner">
                <div class="logo">
					<?php sumi_get_logo(); ?>
                </div>
				<?php sumi_search_form(); ?>
                <div class="header-control">
                    <div class="header-control-inner">
                        <div class="meta-woo">
                        	<a class="search-mobile" href="#">
                                <span class="flaticon-search-interface-symbol"></span>
                                <span class="text-control"><?php esc_html_e( 'SEARCH', 'sumi' ); ?></span>
                            </a>
							<?php
							sumi_user_link();
							do_action( 'sumi_header_wishlist' );
							do_action( 'sumi_header_mini_cart' );
							?>
							<div class="block-menu-bar">
                                <a class="menu-bar menu-toggle" href="#">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header-nav">
        <div class="container">
            <div class="header-nav-inner">
				<?php sumi_header_vertical(); ?>
                <div class="box-header-nav sumi-menu-wapper">
					<?php
					wp_nav_menu( array(
							'menu'            => 'primary',
							'theme_location'  => 'primary',
							'depth'           => 3,
							'container'       => '',
							'container_class' => '',
							'container_id'    => '',
							'menu_class'      => 'clone-main-menu sumi-clone-mobile-menu sumi-nav main-menu',
							'fallback_cb'     => 'Sumi_navwalker::fallback',
							'walker'          => new Sumi_navwalker(),
						)
					);
					?>
                </div>
                <?php if ( $sumi_phone ) : ?>
                    <div class="phone-header">
						<?php if ( $sumi_icon ) : ?>
                            <span class="<?php echo esc_attr( $sumi_icon ); ?>"></span>
						<?php endif; ?>
                        <div class="phone-number">
                            <p class="text-1"><?php echo esc_html( $sumi_text ); ?></p>
	                        <?php if ( $sumi_phone != '' ) { ?>
                                <p class="text-2"><a
                                            href="tel:<?php echo esc_attr( $sumi_phone ); ?>"><?php echo esc_html( $sumi_phone ); ?></a>
                                </p>
	                        <?php } ?>
                        </div>
                    </div>
				<?php endif; ?>
            </div>
        </div>
    </div>
</header>