<?php
// Custom columns
$classes[] = 'post-item';
$classes[] = 'col-bg-' . Sumi_Functions::sumi_get_option('sumi_blog_bg_items', 4);
$classes[] = 'col-lg-' . Sumi_Functions::sumi_get_option('sumi_blog_lg_items', 4);
$classes[] = 'col-md-' . Sumi_Functions::sumi_get_option('sumi_blog_md_items', 4);
$classes[] = 'col-sm-' . Sumi_Functions::sumi_get_option('sumi_blog_sm_items', 6);
$classes[] = 'col-xs-' . Sumi_Functions::sumi_get_option('sumi_blog_xs_items', 6);
$classes[] = 'col-ts-' . Sumi_Functions::sumi_get_option('sumi_blog_ts_items', 12);
$classes[] = apply_filters('sumi_blog_content_class', '');
if (have_posts()) : ?>
    <?php do_action('sumi_before_blog_content'); ?>
    <div class="row blog-grid content-post auto-clear">
        <?php while (have_posts()) : the_post();
            add_action('sumi_post_info_content', 'sumi_post_category_grid', 5);
            ?>
            <article <?php post_class($classes); ?>>
                <div class="post-item-inner">
                    <?php
                    /**
                     * Functions hooked into sumi_post_content action
                     *
                     * @hooked sumi_post_thumbnail          - 10
                     * @hooked sumi_post_info               - 20
                     */
                    do_action('sumi_post_content'); ?>
                </div>
            </article>
            <?php
            remove_action('sumi_post_info_content', 'sumi_post_category_grid', 5);
        endwhile;
        wp_reset_postdata(); ?>
    </div>
    <?php
    /**
     * Functions hooked into sumi_after_blog_content action
     *
     * @hooked sumi_paging_nav               - 10
     */
    do_action('sumi_after_blog_content'); ?>
<?php else :
    get_template_part('content', 'none');
endif;