<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Sumi
 */
?>
<?php
get_header();
$term_id       = get_queried_object_id();
$sidebar_isset = wp_get_sidebars_widgets();
/* Blog Layout */
$video                   = '';
$sumi_blog_layout       = Sumi_Functions::sumi_get_option( 'sumi_sidebar_blog_layout', 'left' );
$sumi_blog_list_style   = Sumi_Functions::sumi_get_option( 'sumi_blog_list_style', 'standard' );
$sumi_blog_used_sidebar = Sumi_Functions::sumi_get_option( 'sumi_blog_used_sidebar', 'widget-area' );
$sumi_container_class   = array( 'main-container' );
if ( is_single() ) {
	/*Single post layout*/
	$sumi_blog_layout       = Sumi_Functions::sumi_get_option( 'sumi_sidebar_single_layout', 'left' );
	$sumi_blog_used_sidebar = Sumi_Functions::sumi_get_option( 'sumi_single_used_sidebar', 'widget-area' );
}
if ( isset( $sidebar_isset[$sumi_blog_used_sidebar] ) && empty( $sidebar_isset[$sumi_blog_used_sidebar] ) ) {
	$sumi_blog_layout = 'full';
}
if ( $sumi_blog_layout == 'full' ) {
	$sumi_container_class[] = 'no-sidebar';
} else {
	$sumi_container_class[] = $sumi_blog_layout . '-sidebar';
}
$sumi_content_class   = array();
$sumi_content_class[] = 'main-content sumi_blog';
if ( $sumi_blog_layout == 'full' ) {
	$sumi_content_class[] = 'col-sm-12';
} else {
	$sumi_content_class[] = 'col-lg-9 col-md-8';
}
$sumi_slidebar_class   = array();
$sumi_slidebar_class[] = 'sidebar sumi_sidebar';
if ( $sumi_blog_layout != 'full' ) {
	$sumi_slidebar_class[] = 'col-lg-3 col-md-4';
}
?>
<div class="<?php echo esc_attr( implode( ' ', $sumi_container_class ) ); ?>">
    <!-- POST LAYOUT -->
    <div class="container">
		<?php
		if ( !is_front_page() ) {
			$args = array(
				'container'     => 'div',
				'before'        => '',
				'after'         => '',
				'show_on_front' => true,
				'network'       => false,
				'show_title'    => true,
				'show_browse'   => false,
				'post_taxonomy' => array(),
				'labels'        => array(),
				'echo'          => true,
			);
			do_action( 'sumi_breadcrumb', $args );
		}
		?>
        <div class="blog-banner">
            <?php sumi_blog_banner(); ?>
        </div>
		<?php if ( !is_single() ) : ?>
			<?php if ( is_home() ) : ?>
				<?php if ( is_front_page() ): ?>
                    <h1 class="page-title blog-title"><?php esc_html_e( 'Latest Posts', 'sumi' ); ?></h1>
				<?php else: ?>
                    <h1 class="page-title blog-title"><?php single_post_title(); ?></h1>
				<?php endif; ?>
			<?php elseif ( is_page() ): ?>
                <h1 class="page-title blog-title"><?php single_post_title(); ?></h1>
			<?php elseif ( is_search() ): ?>
                <h1 class="page-title blog-title"><?php printf( esc_html__( 'Search Results for: %s', 'sumi' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
			<?php else: ?>
                <h1 class="page-title blog-title"><?php the_archive_title( '', '' );; ?></h1>
				<?php
				the_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
			<?php endif; ?>
		<?php endif; ?>
        <div class="row">
            <div class="<?php echo esc_attr( implode( ' ', $sumi_content_class ) ); ?>">
				<?php
				if ( is_single() ) {
					while ( have_posts() ): the_post();
						sumi_set_post_views( get_the_ID() );
						get_template_part( 'templates/blog/blog', 'single' );
						/*If comments are open or we have at least one comment, load up the comment template.*/
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;
					endwhile;
					wp_reset_postdata();
				} else {
					get_template_part( 'templates/blog/blog', $sumi_blog_list_style );
				} ?>
            </div>
			<?php if ( $sumi_blog_layout != 'full' ): ?>
                <div class="<?php echo esc_attr( implode( ' ', $sumi_slidebar_class ) ); ?>">
					<?php get_sidebar(); ?>
                </div>
			<?php endif; ?>
        </div>
    </div>

</div>
<?php get_footer(); ?>
