<?php
if ( ! isset( $content_width ) ) {
	$content_width = 1040;
}
if ( ! class_exists( 'Sumi_Functions' ) ) {
	class Sumi_Functions {
		/**
		 * @var Sumi_Functions The one true Sumi_Functions
		 * @since 1.0
		 */
		private static $instance;
		
		public static function instance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sumi_Functions ) ) {
				self::$instance = new Sumi_Functions;
			}
			add_action( 'after_setup_theme', array( self::$instance, 'sumi_setup' ) );
			add_action( 'widgets_init', array( self::$instance, 'widgets_init' ) );
			add_action( 'wp_enqueue_scripts', array( self::$instance, 'enqueue_scripts' ) );
			add_action( 'admin_enqueue_scripts', array( self::$instance, 'enqueue_admin_scripts' ) );
			add_filter( 'get_default_comment_status', array(
				self::$instance,
				'open_default_comments_for_page'
			), 10, 3 );
			add_filter( 'comment_form_fields', array( self::$instance, 'sumi_move_comment_field_to_bottom' ), 10, 3 );
			add_filter( 'body_class', array( self::$instance, 'body_class' ) );
			self::includes();
			
			return self::$instance;
		}
		
		public function sumi_setup() {
			load_theme_textdomain( 'sumi', get_template_directory() . '/languages' );
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'title-tag' );
			add_theme_support( 'post-thumbnails' );
			add_theme_support( 'custom-background' );
			add_theme_support( 'customize-selective-refresh-widgets' );
			/*This theme uses wp_nav_menu() in two locations.*/
			
			$menu_args = array(
				'primary' => esc_html__( 'Primary Menu', 'sumi' )
			);
			
			if ( class_exists( 'Sumi_Toolkit' ) ) {
				$menu_args['vertical_menu']  = esc_html__( 'Vertical Menu', 'sumi' );
				$menu_args['top_left_menu']  = esc_html__( 'Top Left Menu', 'sumi' );
				$menu_args['top_right_menu'] = esc_html__( 'Top Right Menu', 'sumi' );
			}
			
			register_nav_menus( $menu_args );
			add_theme_support( 'html5', array(
				                          'search-form',
				                          'comment-form',
				                          'comment-list',
				                          'gallery',
				                          'caption',
			                          )
			);
			add_theme_support( 'post-formats',
			                   array(
				                   'image',
				                   'video',
				                   'quote',
				                   'link',
				                   'gallery',
				                   'audio',
			                   )
			);
			/*Support woocommerce*/
			add_theme_support( 'woocommerce' );
			add_theme_support( 'wc-product-gallery-lightbox' );
			add_theme_support( 'wc-product-gallery-slider' );
			add_theme_support( 'wc-product-gallery-zoom' );
			
			self::support_gutenberg();
		}
		
		public function support_gutenberg() {
			// Add support for Block Styles.
			add_theme_support( 'wp-block-styles' );
			
			// Add support for full and wide align images.
			add_theme_support( 'align-wide' );
			
			// Add support for editor styles.
			add_theme_support( 'editor-styles' );
			
			// Enqueue editor styles.
			add_editor_style( 'style-editor.css' );
			
			// Add custom editor font sizes.
			add_theme_support(
				'editor-font-sizes',
				array(
					array(
						'name'      => __( 'Small', 'funiter' ),
						'shortName' => __( 'S', 'funiter' ),
						'size'      => 13,
						'slug'      => 'small',
					),
					array(
						'name'      => __( 'Normal', 'funiter' ),
						'shortName' => __( 'M', 'funiter' ),
						'size'      => 14,
						'slug'      => 'normal',
					),
					array(
						'name'      => __( 'Large', 'funiter' ),
						'shortName' => __( 'L', 'funiter' ),
						'size'      => 36,
						'slug'      => 'large',
					),
					array(
						'name'      => __( 'Huge', 'funiter' ),
						'shortName' => __( 'XL', 'funiter' ),
						'size'      => 48,
						'slug'      => 'huge',
					),
				)
			);
			
			// Add support for responsive embedded content.
			add_theme_support( 'responsive-embeds' );
		}
		
		function body_class( $classes ) {
			$my_theme  = wp_get_theme();
			$classes[] = $my_theme->get( 'Name' ) . "-" . $my_theme->get( 'Version' );
			if ( ! class_exists( 'Sumi_Toolkit' ) ) {
				$classes[] = 'no-toolkit';
			}
			
			$sumi_enable_vertical = Sumi_Functions::sumi_get_option( 'sumi_enable_vertical_menu' );
			if ( $sumi_enable_vertical == 1 ) {
				$classes[] = 'enable-vertical-menu';
			} else {
				$classes[] = 'disable-vertical-menu';
			}
			
			return $classes;
		}
		
		public function sumi_move_comment_field_to_bottom( $fields ) {
			$comment_field = $fields['comment'];
			unset( $fields['comment'] );
			$fields['comment'] = $comment_field;
			
			return $fields;
		}
		
		/**
		 * Register widget area.
		 *
		 * @since sumi 1.0
		 *
		 * @link  https://codex.wordpress.org/Function_Reference/register_sidebar
		 */
		function widgets_init() {
			register_sidebar( array(
				                  'name'          => esc_html__( 'Widget Area', 'sumi' ),
				                  'id'            => 'widget-area',
				                  'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'sumi' ),
				                  'before_widget' => '<div id="%1$s" class="widget %2$s">',
				                  'after_widget'  => '</div>',
				                  'before_title'  => '<h2 class="widgettitle">',
				                  'after_title'   => '<span class="arrow"></span></h2>',
			                  )
			);
			register_sidebar( array(
				                  'name'          => esc_html__( 'Widget Shop', 'sumi' ),
				                  'id'            => 'widget-shop',
				                  'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'sumi' ),
				                  'before_widget' => '<div id="%1$s" class="widget %2$s">',
				                  'after_widget'  => '</div>',
				                  'before_title'  => '<h2 class="widgettitle">',
				                  'after_title'   => '<span class="arrow"></span></h2>',
			                  )
			);
			register_sidebar( array(
				                  'name'          => esc_html__( 'Widget Product', 'sumi' ),
				                  'id'            => 'widget-product',
				                  'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'sumi' ),
				                  'before_widget' => '<div id="%1$s" class="widget %2$s">',
				                  'after_widget'  => '</div>',
				                  'before_title'  => '<h2 class="widgettitle">',
				                  'after_title'   => '<span class="arrow"></span></h2>',
			                  )
			);
			register_sidebar( array(
				                  'name'          => esc_html__( 'Widget Summary Product', 'sumi' ),
				                  'id'            => 'widget-summary-product',
				                  'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'sumi' ),
				                  'before_widget' => '<div id="%1$s" class="widget %2$s">',
				                  'after_widget'  => '</div>',
				                  'before_title'  => '<h2 class="widgettitle">',
				                  'after_title'   => '<span class="arrow"></span></h2>',
			                  )
			);
		}
		
		/**
		 * Register custom fonts.
		 */
		function sumi_fonts_url() {
			/**
			 * Translators: If there are characters in your language that are not
			 * supported by Montserrat, translate this to 'off'. Do not translate
			 * into your own language.
			 */
			$sumi_enable_typography = $this->sumi_get_option( 'sumi_enable_typography' );
			$sumi_typography_group  = $this->sumi_get_option( 'typography_group' );
			$settings               = get_option( 'wpb_js_google_fonts_subsets' );
			$font_families          = array();
			if ( $sumi_enable_typography == 1 && ! empty( $sumi_typography_group ) ) {
				foreach ( $sumi_typography_group as $item ) {
					$font_families[] = str_replace( ' ', '+', $item['sumi_typography_font_family']['family'] );
				}
			}
			$font_families[] = 'Rubik:300,300i,400,400i,500,500i,700,700i,900,900i';
			$font_families[] = 'Lato:300,300i,400,400i,700,700i,900,900i';
			$font_families[] = 'Roboto:300,300i,400,400i,500,500i,700,700i';
			$query_args      = array(
				'family' => urlencode( implode( '|', $font_families ) ),
			);
			if ( ! empty( $settings ) ) {
				$query_args['subset'] = implode( ',', $settings );
			}
			$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
			
			return esc_url_raw( $fonts_url );
		}
		
		public function enqueue_admin_scripts() {
			wp_enqueue_style( 'sumi-admin-fonts', get_theme_file_uri( '/assets/css/admin-style.css' ), array(), null );
			wp_enqueue_script( 'sumi-backend-script', get_theme_file_uri( '/assets/js/backend.js' ), array(), false, true );
		}
		
		/**
		 * Enqueue scripts and styles.
		 *
		 * @since sumi 1.0
		 */
		function enqueue_scripts() {
			global $wp_query;
			$posts = $wp_query->posts;
			wp_dequeue_style( 'woocommerce_prettyPhoto_css' );
			wp_dequeue_style( 'yith-wcwl-font-awesome' );
			foreach ( $posts as $post ) {
				if ( is_a( $post, 'WP_Post' ) && ! has_shortcode( $post->post_content, 'contact-form-7' ) ) {
					wp_dequeue_script( 'contact-form-7' );
				}
			}
			// Add custom fonts, used in the main stylesheet.
			wp_enqueue_style( 'sumi-fonts', self::sumi_fonts_url(), array(), null );
			/* Theme stylesheet. */
			wp_enqueue_style( 'animate-css' );
			wp_enqueue_style( 'flaticon', get_theme_file_uri( '/assets/fonts/flaticon/flaticon.css' ), array(), '1.0' );
			wp_enqueue_style( 'pe-icon-7-stroke', get_theme_file_uri( '/assets/css/pe-icon-7-stroke.css' ), array(), '1.0' );
			wp_enqueue_style( 'font-awesome', get_theme_file_uri( '/assets/css/font-awesome.min.css' ), array(), '1.0' );
			wp_enqueue_style( 'bootstrap', get_theme_file_uri( '/assets/css/bootstrap.min.css' ), array(), '1.0' );
			wp_enqueue_style( 'growl', get_theme_file_uri( '/assets/css/jquery.growl.min.css' ), array(), '1.0' );
			wp_enqueue_style( 'magnific-popup', get_theme_file_uri( '/assets/css/magnific-popup.css' ), array(), '1.0' );
			wp_enqueue_style( 'slick', get_theme_file_uri( '/assets/css/slick.min.css' ), array(), '1.0' );
			wp_enqueue_style( 'scrollbar', get_theme_file_uri( '/assets/css/jquery.scrollbar.css' ), array(), '1.0' );
			wp_enqueue_style( 'chosen', get_theme_file_uri( '/assets/css/chosen.min.css' ), array(), '1.0' );
			wp_enqueue_style( 'sumi-style', get_theme_file_uri( '/assets/css/style.css' ), array(), '1.0', 'all' );
			wp_enqueue_style( 'sumi-main-style', get_stylesheet_uri() );
			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}
			wp_enqueue_script( 'wc-single-product' );
			/* SCRIPTS */
			
			$gmap_api_key = $this->sumi_get_option( 'gmap_api_key', '' );
			$gmap_api_key = trim( $gmap_api_key );
			if ( $gmap_api_key != '' ) {
				$load_gmap_js        = false;
				$load_gmap_js_target = $this->sumi_get_option( 'load_gmap_js_target', 'all_pages' );
				if ( $load_gmap_js_target == 'selected_pages' ) {
					$load_gmap_js_on = $this->sumi_get_option( 'load_gmap_js_on', array() );
					if ( ! is_array( $load_gmap_js_on ) ) {
						$load_gmap_js_on = array();
					}
					if ( is_singular( 'page' ) ) {
						if ( in_array( get_the_ID(), $load_gmap_js_on ) ) {
							$load_gmap_js = true;
						}
					}
				}
				if ( $load_gmap_js_target == 'all_pages' ) {
					$load_gmap_js = true;
				}
				if ( $load_gmap_js ) {
					wp_enqueue_script( 'maps', esc_url( 'https://maps.googleapis.com/maps/api/js?key=' . $gmap_api_key ), array( 'jquery' ), false, true );
				}
			}
			
			if ( ! is_admin() ) {
				wp_dequeue_style( 'woocommerce_admin_styles' );
			}
			
			wp_enqueue_script( 'chosen', get_theme_file_uri( '/assets/js/libs/chosen.min.js' ), array(), '1.0', true );
			wp_enqueue_script( 'bootstrap', get_theme_file_uri( '/assets/js/libs/bootstrap.min.js' ), array(), '3.3.7', true );
			wp_enqueue_script( 'threesixty', get_theme_file_uri( '/assets/js/libs/threesixty.min.js' ), array(), '1.0.7', true );
			wp_enqueue_script( 'growl', get_theme_file_uri( '/assets/js/libs/jquery.growl.min.js' ), array(), '1.0.0', true );
			wp_enqueue_script( 'magnific-popup', get_theme_file_uri( '/assets/js/libs/magnific-popup.min.js' ), array(), '1.1.0', true );
			wp_enqueue_script( 'slick', get_theme_file_uri( '/assets/js/libs/slick.min.js' ), array(), '3.3.7', true );
			wp_enqueue_script( 'scrollbar', get_theme_file_uri( '/assets/js/libs/jquery.scrollbar.min.js' ), array(), '1.0.0', true );
			/* http://hilios.github.io/jQuery.countdown/documentation.html */
			wp_enqueue_script( 'countdown', get_theme_file_uri( '/assets/js/libs/countdown.min.js' ), array(), '1.0.0', true );
			/* http://jquery.eisbehr.de/lazy */
			wp_enqueue_script( 'lazy-load', get_theme_file_uri( '/assets/js/libs/lazyload.min.js' ), array(), '1.7.9', true );
			wp_enqueue_script( 'sumi-script', get_theme_file_uri( '/assets/js/functions.js' ), array(), '1.0', true );
			wp_localize_script( 'sumi-script', 'sumi_ajax_frontend', array(
				                                 'ajaxurl'                         => admin_url( 'admin-ajax.php' ),
				                                 'security'                        => wp_create_nonce( 'sumi_ajax_frontend' ),
				                                 'added_to_cart_notification_text' => apply_filters( 'sumi_added_to_cart_notification_text', esc_html__( 'has been added to cart!', 'sumi' ) ),
				                                 'view_cart_notification_text'     => apply_filters( 'sumi_view_cart_notification_text', esc_html__( 'View Cart', 'sumi' ) ),
				                                 'added_to_cart_text'              => apply_filters( 'sumi_adding_to_cart_text', esc_html__( 'Product has been added to cart!', 'sumi' ) ),
				                                 'wc_cart_url'                     => ( function_exists( 'wc_get_cart_url' ) ? esc_url( wc_get_cart_url() ) : '' ),
				                                 'added_to_wishlist_text'          => get_option( 'yith_wcwl_product_added_text', esc_html__( 'Product has been added to wishlist!', 'sumi' ) ),
				                                 'wishlist_url'                    => ( function_exists( 'YITH_WCWL' ) ? esc_url( YITH_WCWL()->get_wishlist_url() ) : '' ),
				                                 'browse_wishlist_text'            => get_option( 'yith_wcwl_browse_wishlist_text', esc_html__( 'Browse Wishlist', 'sumi' ) ),
				                                 'growl_notice_text'               => esc_html__( 'Notice!', 'sumi' ),
				                                 'removed_cart_text'               => esc_html__( 'Product Removed', 'sumi' ),
				                                 'wp_nonce_url'                    => ( function_exists( 'wc_get_cart_url' ) ? wp_nonce_url( wc_get_cart_url() ) : '' ),
			                                 )
			);
			$sumi_enable_popup        = $this->sumi_get_option( 'sumi_enable_popup' );
			$sumi_enable_popup_mobile = $this->sumi_get_option( 'sumi_enable_popup_mobile' );
			$sumi_popup_delay_time    = $this->sumi_get_option( 'sumi_popup_delay_time' );
			$atts                     = array(
				'owl_vertical'            => true,
				'owl_responsive_vertical' => 1199,
				'owl_loop'                => false,
				'owl_slide_margin'        => 10,
				'owl_focus_select'        => true,
				'owl_ts_items'            => $this->sumi_get_option( 'sumi_product_thumbnail_ts_items', 2 ),
				'owl_xs_items'            => $this->sumi_get_option( 'sumi_product_thumbnail_xs_items', 3 ),
				'owl_sm_items'            => $this->sumi_get_option( 'sumi_product_thumbnail_sm_items', 3 ),
				'owl_md_items'            => $this->sumi_get_option( 'sumi_product_thumbnail_md_items', 3 ),
				'owl_lg_items'            => $this->sumi_get_option( 'sumi_product_thumbnail_lg_items', 4 ),
				'owl_ls_items'            => $this->sumi_get_option( 'sumi_product_thumbnail_ls_items', 4 ),
			);
			$atts                     = apply_filters( 'sumi_thumb_product_single_slide', $atts );
			$owl_settings             = explode( ' ', apply_filters( 'sumi_carousel_data_attributes', 'owl_', $atts ) );
			wp_localize_script( 'sumi-script', 'sumi_global_frontend',
			                    array(
				                    'sumi_enable_popup'        => $sumi_enable_popup,
				                    'sumi_popup_delay_time'    => $sumi_popup_delay_time,
				                    'sumi_enable_popup_mobile' => $sumi_enable_popup_mobile,
				                    'data_slick'               => urldecode( $owl_settings[3] ),
				                    'data_responsive'          => urldecode( $owl_settings[6] ),
				                    'countdown_day'            => esc_html__( 'Days', 'sumi' ),
				                    'countdown_hrs'            => esc_html__( 'Hours', 'sumi' ),
				                    'countdown_mins'           => esc_html__( 'Mins', 'sumi' ),
				                    'countdown_secs'           => esc_html__( 'Secs', 'sumi' ),
			                    )
			);
		}
		
		public static function sumi_get_option( $option_name, $default = '' ) {
			$get_value = isset( $_GET[ $option_name ] ) ? $_GET[ $option_name ] : '';
			$cs_option = null;
			if ( defined( 'CS_VERSION' ) ) {
				$cs_option = get_option( CS_OPTION );
			}
			if ( isset( $_GET[ $option_name ] ) ) {
				$cs_option = $get_value;
				$default   = $get_value;
			}
			$options = apply_filters( 'cs_get_option', $cs_option, $option_name, $default );
			if ( ! empty( $option_name ) && ! empty( $options[ $option_name ] ) ) {
				$option = $options[ $option_name ];
				if ( is_array( $option ) && isset( $option['multilang'] ) && $option['multilang'] == true ) {
					if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
						if ( isset( $option[ ICL_LANGUAGE_CODE ] ) ) {
							return $option[ ICL_LANGUAGE_CODE ];
						}
					}
				}
				
				return $option;
			} else {
				return ( ! empty( $default ) ) ? $default : null;
			}
		}
		
		public static function theme_get_meta( $meta_key, $meta_value ) {
			$main_data            = '';
			$enable_theme_options = self::sumi_get_option( 'enable_theme_options' );
			$meta_data            = get_post_meta( get_the_ID(), $meta_key, true );
			if ( is_page() && isset( $meta_data[ $meta_value ] ) && $enable_theme_options == 1 ) {
				$main_data = $meta_data[ $meta_value ];
			}
			
			return $main_data;
		}
		
		/**
		 * Filter whether comments are open for a given post type.
		 *
		 * @param string $status       Default status for the given post type,
		 *                             either 'open' or 'closed'.
		 * @param string $post_type    Post type. Default is `post`.
		 * @param string $comment_type Type of comment. Default is `comment`.
		 *
		 * @return string (Maybe) filtered default status for the given post type.
		 */
		function open_default_comments_for_page( $status, $post_type, $comment_type ) {
			if ( 'page' == $post_type ) {
				return 'open';
			}
			
			return $status;
		}
		
		public static function includes() {
			include_once get_parent_theme_file_path( '/framework/framework.php' );
			define( 'CS_ACTIVE_FRAMEWORK', true );
			define( 'CS_ACTIVE_METABOX', true );
			define( 'CS_ACTIVE_TAXONOMY', false );
			define( 'CS_ACTIVE_SHORTCODE', false );
			define( 'CS_ACTIVE_CUSTOMIZE', false );
		}
	}
}
if ( ! function_exists( 'Sumi_Functions' ) ) {
	function Sumi_Functions() {
		return Sumi_Functions::instance();
	}
	
	Sumi_Functions();
}