<?php
global $product;
// Ensure visibility
if ( ! empty( $product ) || $product->is_visible() ) {
	// Custom columns
	$sumi_woo_bg_items = Sumi_Functions::sumi_get_option( 'sumi_woo_bg_items', 3 ); // 4 products per row
	$sumi_woo_lg_items = Sumi_Functions::sumi_get_option( 'sumi_woo_lg_items', 3 ); // 4 products per row
	$sumi_woo_md_items = Sumi_Functions::sumi_get_option( 'sumi_woo_md_items', 4 ); // 3 products per row
	$sumi_woo_sm_items = Sumi_Functions::sumi_get_option( 'sumi_woo_sm_items', 4 ); // 3 products per row
	$sumi_woo_xs_items = Sumi_Functions::sumi_get_option( 'sumi_woo_xs_items', 6 ); // 2 products per row
	$sumi_woo_ts_items = Sumi_Functions::sumi_get_option( 'sumi_woo_ts_items', 12 );
	$shop_display_mode = Sumi_Functions::sumi_get_option( 'sumi_shop_list_style', 'grid' );
	$classes[]         = 'product-item';
	if ( $shop_display_mode == 'list' ) {
		$classes[] = 'list col-sm-12';
	} else {
		$classes[] = 'col-bg-' . $sumi_woo_bg_items;
		$classes[] = 'col-lg-' . $sumi_woo_lg_items;
		$classes[] = 'col-md-' . $sumi_woo_md_items;
		$classes[] = 'col-sm-' . $sumi_woo_sm_items;
		$classes[] = 'col-xs-' . $sumi_woo_xs_items;
		$classes[] = 'col-ts-' . $sumi_woo_ts_items;
	}
	if ( $shop_display_mode == 'grid' ) {
		$classes[] = 'style-1';
	} elseif ( $shop_display_mode == 'grid-v2' ) {
		$classes[] = 'style-3';
	}
	?>
    <li <?php post_class( $classes ); ?>>
		<?php if ( $shop_display_mode == 'list' ):
			get_template_part( 'woocommerce/product-styles/content-product', 'list' );
        elseif ( $shop_display_mode == 'grid-v2' ):
			get_template_part( 'woocommerce/product-styles/content-product', 'style-3' );
		else:
			get_template_part( 'woocommerce/product-styles/content-product', 'style-1' );
		endif; ?>
    </li>
	<?php
}