<?php
if ( !function_exists( 'sumi_custom_inline_css' ) ) {
	function sumi_custom_inline_css()
	{
		$css     = sumi_theme_color();
		$css     .= sumi_vc_custom_css_footer();
		$content = preg_replace( '/\s+/', ' ', $css );
		wp_add_inline_style( 'sumi-style', $content );
	}
}
add_action( 'wp_enqueue_scripts', 'sumi_custom_inline_css', 999 );
if ( !function_exists( 'sumi_theme_color' ) ) {
	function sumi_theme_color()
	{
		$main_color              = Sumi_Functions::sumi_get_option( 'sumi_main_color', '#e52e06' );
		$sumi_page_404          = Sumi_Functions::sumi_get_option( 'sumi_page_404' );
		$page_faqs_product       = Sumi_Functions::sumi_get_option( 'sumi_add_page_product' );
		$sumi_enable_typography = Sumi_Functions::sumi_get_option( 'sumi_enable_typography' );
		$sumi_typography_group  = Sumi_Functions::sumi_get_option( 'typography_group' );
		$css                     = '';
		if ( $sumi_enable_typography == 1 && !empty( $sumi_typography_group ) ) {
			foreach ( $sumi_typography_group as $item ) {
				$css .= '
					' . $item['sumi_element_tag'] . '{
						font-family: ' . $item['sumi_typography_font_family']['family'] . ';
						font-weight: ' . $item['sumi_typography_font_family']['variant'] . ';
						font-size: ' . $item['sumi_typography_font_size'] . 'px;
						line-height: ' . $item['sumi_typography_line_height'] . 'px;
						color: ' . $item['sumi_body_text_color'] . ';
					}
				';
			}
		}
		$css .= '
			a:hover,
			.product-grid .block-title a:hover,
			.woocommerce-product-gallery .flex-control-nav.flex-control-thumbs .slick-arrow:hover,
			.product-type-grouped .entry-summary .cart .group_table .amount,
			.product-360-button a,
			.product-video-button a,
			.woocommerce-error .button, .woocommerce-info .button, .woocommerce-message .button,
			.wishlist_table .yith-wcwl-share li a:hover:after,
			.sumi-heading.style6 .view-all:hover,
			.sumi-products.style-4 .owl-slick .slick-arrow:hover,
			.tab-link > .slick-arrow:hover,
			.owl-slick .slick-arrow:hover,
			.sumi-countdown-sc .text-date,
			.yith-wcwl-add-to-wishlist:hover a::before,
            .entry-summary .compare.button:hover:after,
            .product-item.style-4 .group-button .button.loading::before
			{
				 color: ' . $main_color . ';
			}

			.custom-heading-menu:hover,
			.entry-summary .yith-wcwl-add-to-wishlist:hover a::before
			{
				 color: ' . $main_color . '!important;
			}
			
			.post-title::after,
            .post-item .post-thumb .post-date,
            .page-title.blog-title::before,
            .widget_price_filter .button,
            .widget_price_filter .ui-slider-range,
            .owl-slick .slick-dots li button,
            .woocommerce-error .button:hover, .woocommerce-info .button:hover, .woocommerce-message .button:hover,
            .sumi-socials .content-socials .socials-list li a:hover,
            .sumi-iconbox.style2,
            .entry-summary .cart, .entry-summary .woocommerce-variation-add-to-cart,
            .onsale,
            .newsletter-form-wrap .submit-newsletter:hover,
            .woocommerce table.wishlist_table td.product-add-to-cart a,
            .wishlist_table tr td a.yith-wcqv-button,
            .woocommerce-mini-cart__buttons .button.checkout,
            .page-title:after,
            .sumi-heading.style1 .sumi-title:after,
            .sumi-heading.style1 .view-all:hover,
            .sumi-tabs.style3 .tab-link li.active,
            .sumi-tabs.style5 .tab-link li.active,
			.sumi-tabs.style3 .tab-link li:hover,
			.sumi-tabs.style5 .tab-link li:hover,
			.sumi-banner.style1 .banner-link,
			.block-search .form-search .btn-submit,
			.block-minicart .link-dropdown .count,
			.block-nav-category .block-title,
			.sumi-countdown-sc .text-date:before,
			.block-nav-category .sumi-custommenu .widgettitle::before,
			.widget-sumi-mailchimp .newsletter-form-wrap .submit-newsletter,
			.backtotop,
			.product-item.style-4 .add-to-cart a:hover,
			.sumi-heading.style2 .sumi-title:after,
			.sumi-heading.style5 .sumi-title:after,
			.sumi-accordion .title:after,
			.error-404 .search-form .search-submit,
			.error-404 .button:hover,
			.error-404 .vc_btn3-container .vc_btn3:hover,
			.box-header-nav .main-menu > .menu-item>a:after,
			.box-header-nav .main-menu > .current_page_parent>a:after,
			.box-header-nav .sumi-custommenu .widgettitle:before,
			.sumi-heading.style7 .sumi-title:before,
			.wc-tabs li:after,
			form.woocommerce-form-login .button,
			.track_order .form-row .button,
			.close-block-search,
			.sticky_info_single_product button.sumi-single-add-to-cart-btn.btn.button
            {
				background-color: ' . $main_color . ';
			}
			@media (max-width: 767px){
                .header.style1 .header-nav,
                .header.style2 .header-nav,
                .header.style3 .header-nav
                {
                    background-color: ' . $main_color . ';
                }
            }
			
			
			.sumi-tabs.style1 .tab-link li.active::before ,
			.woocommerce-product-gallery .flex-control-nav.flex-control-thumbs li img.flex-active,
			.wc-tabs li:hover,
			.wc-tabs li.active,
			.woocommerce-error .button, .woocommerce-info .button, .woocommerce-message .button,
			.woocommerce-product-gallery .flex-control-nav.flex-control-thumbs .slick-arrow:hover,
			.product-360-button a:hover,
			.product-video-button a:hover,
			.wishlist_table .yith-wcwl-share li a:hover,
			.sumi-tabs.style3 .tab-link li.active,
			.sumi-tabs.style5 .tab-link li.active,
			.sumi-tabs.style3 .tab-link li:hover,
			.sumi-tabs.style5 .tab-link li:hover,
			.tab-link > .slick-arrow:hover,
			.owl-slick .slick-arrow:hover,
			.canvas-close:hover,
			.sumi-banner.style1 .banner-link,
			.entry-summary .yith-wcwl-add-to-wishlist:hover, 
			.entry-summary .compare.button:hover,
			.onsale::after,
			.main-contain-summary .onsale:after
			{
				border-color:  ' . $main_color . ';
			}
			.total-price-html {
			    color: ' . $main_color . ';
			}

			div.famibt-wrap .famibt-item .famibt-price {
			    color: ' . $main_color . ';
			}

			.famibt-wrap ins {
			    color: ' . $main_color . ';
			}
			.famibt-messages-wrap a.button.wc-forward:hover {
			    background: ' . $main_color . ';
			}
		';
		/* GET CUSTOM 404 */
		if ( $sumi_page_404 )
			$css .= get_post_meta( $sumi_page_404, '_Sumi_Shortcode_custom_css', true );
		/* GET CUSTOM FAQS */
		if ( class_exists( 'WooCommerce' ) && $page_faqs_product && is_product() )
			$css .= get_post_meta( $page_faqs_product, '_Sumi_Shortcode_custom_css', true );
		/* Main color */
		$css .= '';

		return apply_filters( 'sumi_main_custom_css', $css );
	}
}
if ( !function_exists( 'sumi_vc_custom_css_footer' ) ) {
	function sumi_vc_custom_css_footer()
	{
		$data_meta           = get_post_meta( get_the_ID(), '_custom_metabox_theme_options', true );
		$footer_options      = Sumi_Functions::sumi_get_option( 'sumi_footer_options' );
		$enable_theme_option = Sumi_Functions::sumi_get_option( 'enable_theme_options' );
		$footer_options      = $enable_theme_option == 1 && isset( $data_meta['metabox_sumi_footer_options'] ) && $data_meta['metabox_sumi_footer_options'] != '' ? $data_meta['metabox_sumi_footer_options'] : $footer_options;
		if ( !$footer_options ) {
			$query = new WP_Query( array( 'p' => $footer_options, 'post_type' => 'footer', 'posts_per_page' => 1 ) );
			while ( $query->have_posts() ): $query->the_post();
				$footer_options = get_the_ID();
			endwhile;
		}
		$shortcodes_custom_css = get_post_meta( $footer_options, '_Sumi_Shortcode_custom_css', true );

		return $shortcodes_custom_css;
	}
}
if ( !function_exists( 'sumi_write_custom_js ' ) ) {
	function sumi_write_custom_js()
	{
		$sumi_custom_js = Sumi_Functions::sumi_get_option( 'sumi_custom_js', '' );
		$content         = preg_replace( '/\s+/', ' ', $sumi_custom_js );
		wp_add_inline_script( 'sumi-script', $content );
	}
}
add_action( 'wp_enqueue_scripts', 'sumi_write_custom_js' );