<?php
/**
 * Sumi Visual composer setup
 *
 * @author   Sumi
 * @category API
 * @package  Sumi_Visual_composer
 * @since    1.0.0
 */
if ( ! function_exists( 'sumi_custom_param_vc' ) ) {
	add_filter( 'sumi_add_param_visual_composer', 'sumi_custom_param_vc' );
	function sumi_custom_param_vc( $param ) {
		$attributes_tax = array();
		if ( function_exists( 'wc_get_attribute_taxonomies' ) ) {
			$attributes_tax = wc_get_attribute_taxonomies();
		}
		$attributes = array();
		if ( is_array( $attributes_tax ) && count( $attributes_tax ) > 0 ) {
			foreach ( $attributes_tax as $attribute ) {
				$attributes[ $attribute->attribute_label ] = $attribute->attribute_name;
			}
		}
		// CUSTOM PRODUCT OPTIONS
		$layoutDir       = get_template_directory() . '/woocommerce/product-styles/';
		$product_options = array();
		if ( is_dir( $layoutDir ) ) {
			$files = scandir( $layoutDir );
			if ( $files && is_array( $files ) ) {
				foreach ( $files as $file ) {
					if ( $file != '.' && $file != '..' ) {
						$fileInfo = pathinfo( $file );
						if ( $fileInfo['extension'] == 'php' && $fileInfo['basename'] != 'index.php' && $fileInfo['filename'] != 'content-product-list' ) {
							$file_data                     = get_file_data( $layoutDir . $file, array( 'Name' => 'Name' ) );
							$file_name                     = str_replace( 'content-product-style-', '', $fileInfo['filename'] );
							$product_options[ $file_name ] = array(
								'title'   => $file_data['Name'],
								'preview' => get_theme_file_uri( 'woocommerce/product-styles/content-product-style-' . $file_name . '.jpg' ),
							);
						}
					}
				}
			}
		}
		// CUSTOM PRODUCT SIZE
		$product_size_width_list = array();
		$width                   = 300;
		$height                  = 300;
		$crop                    = 1;
		if ( function_exists( 'wc_get_image_size' ) ) {
			$size   = wc_get_image_size( 'shop_catalog' );
			$width  = isset( $size['width'] ) ? $size['width'] : $width;
			$height = isset( $size['height'] ) ? $size['height'] : $height;
			$crop   = isset( $size['crop'] ) ? $size['crop'] : $crop;
		}
		for ( $i = 100; $i < $width; $i = $i + 10 ) {
			array_push( $product_size_width_list, $i );
		}
		$product_size_list                           = array();
		$product_size_list[ $width . 'x' . $height ] = $width . 'x' . $height;
		foreach ( $product_size_width_list as $k => $w ) {
			$w = intval( $w );
			if ( isset( $width ) && $width > 0 ) {
				$h = round( $height * $w / $width );
			} else {
				$h = $w;
			}
			$product_size_list[ $w . 'x' . $h ] = $w . 'x' . $h;
		}
		$product_size_list['Custom'] = 'custom';
		/* Map New Custom menu */
		$all_menu = array();
		$menus    = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
		if ( $menus && count( $menus ) > 0 ) {
			foreach ( $menus as $m ) {
				$all_menu[ $m->name ] = $m->slug;
			}
		}
		$param['sumi_banner']     = array(
			'base'        => 'sumi_banner',
			'name'        => esc_html__( 'Sumi: Banner', 'sumi' ),
			'icon'        => '',
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Your can build banner here', 'sumi' ),
			'params'      => array(
				array(
					'heading'    => esc_html__( 'Select layout banner', 'sumi' ),
					'param_name' => 'style',
					'type'       => 'select_preview',
					'value'      => array(
						'style1' => array(
							'title'   => esc_html__( 'Style 01', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/banner/style01.jpg' ),
						),
						'style2' => array(
							'title'   => esc_html__( 'Style 02', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/banner/style02.jpg' ),
						),
						'style3' => array(
							'title'   => esc_html__( 'Style 03', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/banner/style03.jpg' ),
						),
						'style4' => array(
							'title'   => esc_html__( 'Style 04', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/banner/style04.jpg' ),
						),
						'style5' => array(
							'title'   => esc_html__( 'Style 05', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/banner/style05.jpg' ),
						),
					),
				),
				array(
					"type"        => "attach_image",
					"heading"     => esc_html__( "Image Background", 'sumi' ),
					'description' => esc_html__( 'Set Background For Banner', 'sumi' ),
					"param_name"  => "image_background",
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Effect Banner', 'sumi' ),
					'description' => esc_html__( 'Select an effect for this banner', 'sumi' ),
					'admin_label' => true,
					'param_name'  => 'banner-effect',
					'std'         => 'banner-effect-1',
					'value'       => array(
						esc_html__( 'None', 'sumi' )        => 'default',
						esc_html__( 'Effect Zoom', 'sumi' ) => 'banner-effect-1',
					),
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Text First', 'sumi' ),
					'description' => esc_html__( 'Enter the Text First on banner', 'sumi' ),
					'admin_label' => true,
					'param_name'  => 'text_1',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Text Second', 'sumi' ),
					'description' => esc_html__( 'Enter the Text Second on banner', 'sumi' ),
					'admin_label' => true,
					'param_name'  => 'text_2',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Text Third', 'sumi' ),
					'description' => esc_html__( 'Enter the Text Third on banner', 'sumi' ),
					'admin_label' => true,
					'param_name'  => 'text_3',
					'dependency'  => array(
						'element'            => 'style',
						'value_not_equal_to' => array(
							'style5',
						),
					),
				),
				array(
					'type'        => 'vc_link',
					'heading'     => esc_html__( 'Custom link', 'sumi' ),
					'description' => esc_html__( 'Link for button banner', 'sumi' ),
					'admin_label' => true,
					'param_name'  => 'banner_link',
				),
			),
		);
		$param['sumi_countdown']  = array(
			'base'        => 'sumi_countdown',
			'name'        => esc_html__( 'Sumi: Countdown', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Countdown', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'The title of shortcode', 'sumi' ),
					'admin_label' => true,
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Subittle text', 'sumi' ),
					'param_name'  => 'subtitle',
					'description' => esc_html__( 'The subtitle of shortcode', 'sumi' ),
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Text before date', 'sumi' ),
					'param_name'  => 'text_date',
					'description' => esc_html__( 'The before date of shortcode', 'sumi' ),
				),
				array(
					'type'       => 'datepicker',
					'heading'    => esc_html__( 'Date', 'sumi' ),
					'param_name' => 'date',
				),
			),
		);
		$param['sumi_category']   = array(
			'base'        => 'sumi_category',
			'name'        => esc_html__( 'Sumi: Category', 'sumi' ),
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/diagram.svg',
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Custom Category Product', 'sumi' ),
			'params'      => array(
				array(
					"type"       => 'colorpicker',
					'rgba'       => true,
					"heading"    => esc_html__( "Color Category", 'sumi' ),
					"param_name" => "background_color",
				),
				array(
					'type'       => 'attach_image',
					'heading'    => esc_html__( 'Background', 'sumi' ),
					'param_name' => 'background',
				),
				array(
					'type'        => 'taxonomy',
					'heading'     => esc_html__( 'Product Category', 'sumi' ),
					'param_name'  => 'taxonomy',
					'options'     => array(
						'multiple'   => false,
						'hide_empty' => true,
						'taxonomy'   => 'product_cat',
					),
					'placeholder' => esc_html__( 'Choose category', 'sumi' ),
					'description' => esc_html__( 'Note: If you want to narrow output, select category(s) above. Only selected categories will be displayed.', 'sumi' ),
				),
			),
		);
		$param['sumi_accordions'] = array(
			'base'        => 'sumi_accordions',
			'name'        => esc_html__( 'Sumi: Accordion', 'sumi' ),
			'icon'        => '',
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Custom Accordion', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Title shortcode.', 'sumi' ),
					'admin_label' => true,
				),
				array(
					'type'        => 'textarea',
					'heading'     => esc_html__( 'Content', 'sumi' ),
					'param_name'  => 'desc',
					'description' => esc_html__( 'Content shortcode.', 'sumi' ),
					'admin_label' => true,
				),
			),
		);
		$param['sumi_heading']    = array(
			'base'        => 'sumi_heading',
			'name'        => esc_html__( 'Sumi: Custom Heading', 'sumi' ),
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/text.svg',
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Custom Heading', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Select style', 'sumi' ),
					'value'       => array(
						'style1' => array(
							'title'   => esc_html__( 'Style 01', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/heading/style01.jpg' ),
						),
						'style2' => array(
							'title'   => esc_html__( 'Style 02', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/heading/style02.jpg' ),
						),
						'style3' => array(
							'title'   => esc_html__( 'Style 03', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/heading/style03.jpg' ),
						),
						'style4' => array(
							'title'   => esc_html__( 'Style 04', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/heading/style04.jpg' ),
						),
						'style5' => array(
							'title'   => esc_html__( 'Style 05', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/heading/style05.jpg' ),
						),
						'style6' => array(
							'title'   => esc_html__( 'Style 06', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/heading/style06.jpg' ),
						),
						'style7' => array(
							'title'   => esc_html__( 'Style 07', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/heading/style07.jpg' ),
						),
					),
					'default'     => 'default',
					'admin_label' => true,
					'param_name'  => 'style',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Title shortcode.', 'sumi' ),
					'admin_label' => true,
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style1', 'style2', 'style5', 'style6', 'style7' ),
					),
				),
				array(
					'type'        => 'textarea',
					'heading'     => esc_html__( 'Descriptions', 'sumi' ),
					'param_name'  => 'desc',
					'description' => esc_html__( 'Descriptions of title.', 'sumi' ),
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style1', 'style3', 'style4' ),
					),
				),
				array(
					'type'        => 'vc_link',
					'heading'     => esc_html__( 'Link', 'sumi' ),
					'param_name'  => 'link',
					'description' => esc_html__( 'The Link to Icon', 'sumi' ),
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style1', 'style6' ),
					),
				),
			),
		);
		$param['sumi_custommenu'] = array(
			'base'        => 'sumi_custommenu',
			'name'        => esc_html__( 'Sumi: Custom Menu', 'sumi' ),
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/menu.svg',
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Custom Menu', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'What text use as a widget title. Leave blank to use default widget title.', 'sumi' ),
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Menu', 'sumi' ),
					'value'       => $all_menu,
					'admin_label' => true,
					'param_name'  => 'nav_menu',
					'description' => esc_html__( 'Select menu to display.', 'sumi' ),
				),
			),
		);
		$param['sumi_iconbox']    = array(
			'base'        => 'sumi_iconbox',
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/happiness.svg',
			'name'        => esc_html__( 'Sumi: Icon Box', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Icon Box', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Select style', 'sumi' ),
					'value'       => array(
						'default' => array(
							'title'   => esc_html__( 'Default', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/iconbox/default.jpg' ),
						),
						'style1'  => array(
							'title'   => esc_html__( 'Style 01', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/iconbox/style1.jpg' ),
						),
						'style2'  => array(
							'title'   => esc_html__( 'Style 02', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/iconbox/style2.jpg' ),
						),
						'style3'  => array(
							'title'   => esc_html__( 'Style 03', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/iconbox/style3.jpg' ),
						),
						'style4'  => array(
							'title'   => esc_html__( 'Style 04', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/iconbox/style4.jpg' ),
						),
						'style5'  => array(
							'title'   => esc_html__( 'Style 05', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/iconbox/style5.jpg' ),
						),
						'style6'  => array(
							'title'   => esc_html__( 'Style 06', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/iconbox/style6.jpg' ),
						),
					),
					'default'     => 'default',
					'admin_label' => true,
					'param_name'  => 'style',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'admin_label' => true,
					'dependency'  => array(
						'element'            => 'style',
						'value_not_equal_to' => array( 'style1', 'style6' ),
					),
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Text 1', 'sumi' ),
					'param_name'  => 'text_1',
					'admin_label' => true,
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style2' ),
					),
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Text 2', 'sumi' ),
					'param_name'  => 'text_2',
					'admin_label' => true,
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style2' ),
					),
					'description' => esc_html__( 'Ex: tel:(+123) 456 789', 'sumi' )
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Text 2 Link', 'sumi' ),
					'param_name'  => 'text_2_link',
					'admin_label' => true,
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style2' ),
					),
				),
				array(
					'param_name' => 'text_content',
					'heading'    => esc_html__( 'Content', 'sumi' ),
					'type'       => 'textarea',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Choose rating stars', 'sumi' ),
					'param_name' => 'select_rating',
					'value'      => array(
						esc_html__( '0 number of star', 'sumi' )  => 'star star-0',
						esc_html__( '01 number of star', 'sumi' ) => 'star star-1',
						esc_html__( '02 number of star', 'sumi' ) => 'star star-2',
						esc_html__( '03 number of star', 'sumi' ) => 'star star-3',
						esc_html__( '04 number of star', 'sumi' ) => 'star star-4',
						esc_html__( '05 number of star', 'sumi' ) => 'star star-5',
					),
					'dependency' => array(
						'element' => 'style',
						"value"   => array( 'style1' ),
					),
				),
				array(
					'param_name'  => 'avatar_testi',
					'heading'     => esc_html__( 'Avatar', 'sumi' ),
					'type'        => 'attach_image',
					'admin_label' => true,
					'dependency'  => array(
						'element' => 'style',
						"value"   => array( 'style1' ),
					),
				),
				array(
					'param_name' => 'text_name',
					'heading'    => esc_html__( 'Name', 'sumi' ),
					'type'       => 'textfield',
					'dependency' => array(
						'element' => 'style',
						"value"   => array( 'style1' ),
					),
				),
				array(
					'param_name' => 'text_position',
					'heading'    => esc_html__( 'Position', 'sumi' ),
					'type'       => 'textfield',
					'dependency' => array(
						'element' => 'style',
						"value"   => array( 'style1' ),
					),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Icon library', 'sumi' ),
					'value'       => array(
						esc_html__( 'Font Awesome', 'sumi' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'sumi' )  => 'openiconic',
						esc_html__( 'Typicons', 'sumi' )     => 'typicons',
						esc_html__( 'Entypo', 'sumi' )       => 'entypo',
						esc_html__( 'Linecons', 'sumi' )     => 'linecons',
						esc_html__( 'Mono Social', 'sumi' )  => 'monosocial',
						esc_html__( 'Material', 'sumi' )     => 'material',
						esc_html__( 'Sumi Fonts', 'sumi' )   => 'sumicustomfonts',
					),
					'admin_label' => true,
					'param_name'  => 'type',
					'description' => esc_html__( 'Select icon library.', 'sumi' ),
					'dependency'  => array(
						'element'            => 'style',
						'value_not_equal_to' => array(
							'style1',
						),
					),
				),
				array(
					'param_name'  => 'icon_sumicustomfonts',
					'heading'     => esc_html__( 'Icon', 'sumi' ),
					'description' => esc_html__( 'Select icon from library.', 'sumi' ),
					'type'        => 'iconpicker',
					'settings'    => array(
						'emptyIcon' => false,
						'type'      => 'sumicustomfonts',
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'sumicustomfonts',
					),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'sumi' ),
					'param_name'  => 'icon_fontawesome',
					'value'       => 'fa fa-adjust',
					'settings'    => array(
						'emptyIcon'    => false,
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'sumi' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'sumi' ),
					'param_name'  => 'icon_openiconic',
					'value'       => 'vc-oi vc-oi-dial',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'openiconic',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'sumi' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'sumi' ),
					'param_name'  => 'icon_typicons',
					'value'       => 'typcn typcn-adjust-brightness',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'typicons',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'sumi' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'sumi' ),
					'param_name' => 'icon_entypo',
					'value'      => 'entypo-icon entypo-icon-note',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'entypo',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'type',
						'value'   => 'entypo',
					),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'sumi' ),
					'param_name'  => 'icon_linecons',
					'value'       => 'vc_li vc_li-heart',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'linecons',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'sumi' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'sumi' ),
					'param_name'  => 'icon_monosocial',
					'value'       => 'vc-mono vc-mono-fivehundredpx',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'monosocial',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'monosocial',
					),
					'description' => esc_html__( 'Select icon from library.', 'sumi' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'sumi' ),
					'param_name'  => 'icon_material',
					'value'       => 'vc-material vc-material-cake',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'material',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'material',
					),
					'description' => esc_html__( 'Select icon from library.', 'sumi' ),
				),
				array(
					'type'        => 'vc_link',
					'heading'     => esc_html__( 'Link', 'sumi' ),
					'param_name'  => 'link',
					'description' => esc_html__( 'The Link to Icon', 'sumi' ),
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'default' ),
					),
				),
			),
		);
		/*Section Team*/
		$param['sumi_member']   = array(
			'base'        => 'sumi_member',
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/happiness.svg',
			'name'        => esc_html__( 'Sumi: Member', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display member info', 'sumi' ),
			'params'      => array(
				array(
					'param_name'  => 'avatar_member',
					'heading'     => esc_html__( 'Avatar Member', 'sumi' ),
					'type'        => 'attach_image',
					'admin_label' => true,
				),
				array(
					"type"        => "textfield",
					"heading"     => esc_html__( "Member Name", "sumi" ),
					"param_name"  => "name",
					"description" => esc_html__( "Add name member.", "sumi" ),
				),
				array(
					"type"       => "textfield",
					"heading"    => esc_html__( "Member Postion", "sumi" ),
					"param_name" => "position",
				),
				array(
					"type"       => "textarea",
					"heading"    => esc_html__( "Member Descriptions", "sumi" ),
					"param_name" => "desc",
				),
			),
		);
		$param['sumi_map']      = array(
			'base'        => 'sumi_map',
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/google.svg',
			'name'        => esc_html__( 'Sumi: Google Map', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Google Map', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'admin_label' => true,
					'description' => esc_html__( 'title.', 'sumi' ),
					'std'         => 'Sumi',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Phone', 'sumi' ),
					'param_name'  => 'phone',
					'description' => esc_html__( 'phone.', 'sumi' ),
					'std'         => '088-465 9965 02',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Email', 'sumi' ),
					'param_name'  => 'email',
					'description' => esc_html__( 'email.', 'sumi' ),
					'std'         => 'zankover@gmail.com',
				),
				array(
					'type'       => 'number',
					'heading'    => esc_html__( 'Map Height', 'sumi' ),
					'param_name' => 'map_height',
					'std'        => '400',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Maps type', 'sumi' ),
					'param_name' => 'map_type',
					'value'      => array(
						esc_html__( 'ROADMAP', 'sumi' )   => 'ROADMAP',
						esc_html__( 'SATELLITE', 'sumi' ) => 'SATELLITE',
						esc_html__( 'HYBRID', 'sumi' )    => 'HYBRID',
						esc_html__( 'TERRAIN', 'sumi' )   => 'TERRAIN',
					),
					'std'        => 'ROADMAP',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Address', 'sumi' ),
					'param_name'  => 'address',
					'admin_label' => true,
					'description' => esc_html__( 'address.', 'sumi' ),
					'std'         => 'Z115 TP. Thai Nguyen',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Longitude', 'sumi' ),
					'param_name'  => 'longitude',
					'admin_label' => true,
					'description' => esc_html__( 'longitude.', 'sumi' ),
					'std'         => '105.800286',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Latitude', 'sumi' ),
					'param_name'  => 'latitude',
					'admin_label' => true,
					'description' => esc_html__( 'latitude.', 'sumi' ),
					'std'         => '21.587001',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Zoom', 'sumi' ),
					'param_name'  => 'zoom',
					'admin_label' => true,
					'description' => esc_html__( 'zoom.', 'sumi' ),
					'std'         => '14',
				),
			),
		);
		$param['sumi_tabs']     = array(
			'base'                    => 'sumi_tabs',
			'icon'                    => SUMI_FRAMEWORK_URI . 'assets/images/tab.svg',
			'name'                    => esc_html__( 'Sumi: Tabs', 'sumi' ),
			'category'                => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description'             => esc_html__( 'Display Tabs', 'sumi' ),
			'is_container'            => true,
			'show_settings_on_create' => false,
			'as_parent'               => array(
				'only' => 'vc_tta_section',
			),
			'params'                  => array(
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Select style', 'sumi' ),
					'value'       => array(
						'style1' => array(
							'title'   => esc_html__( 'Tabs Style1', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/tabs/style1.jpg' ),
						),
						'style2' => array(
							'title'   => esc_html__( 'Tabs Style2', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/tabs/style2.jpg' ),
						),
						'style3' => array(
							'title'   => esc_html__( 'Tabs Style3', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/tabs/style3.jpg' ),
						),
						'style5' => array(
							'title'   => esc_html__( 'Tabs Style4', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/tabs/style4.jpg' ),
						),
					),
					'default'     => 'default',
					'admin_label' => true,
					'param_name'  => 'style',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'tab_title',
					'description' => esc_html__( 'The title of shortcode', 'sumi' ),
					'admin_label' => true,
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style3', 'style5' ),
					),
				),
				array(
					'type'        => 'vc_link',
					'heading'     => esc_html__( 'Link', 'sumi' ),
					'param_name'  => 'link',
					'description' => esc_html__( 'The Link to Icon', 'sumi' ),
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style3' ),
					),
				),
				vc_map_add_css_animation(),
				array(
					'param_name' => 'ajax_check',
					'heading'    => esc_html__( 'Using Ajax Tabs', 'sumi' ),
					'type'       => 'dropdown',
					'value'      => array(
						esc_html__( 'Yes', 'sumi' ) => '1',
						esc_html__( 'No', 'sumi' )  => '0',
					),
					'std'        => '0',
				),
				array(
					'type'       => 'number',
					'heading'    => esc_html__( 'Active Section', 'sumi' ),
					'param_name' => 'active_section',
					'std'        => 0,
				),
			),
			'js_view'                 => 'VcBackendTtaTabsView',
			'custom_markup'           => '
                    <div class="vc_tta-container" data-vc-action="collapse">
                        <div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
                            <div class="vc_tta-tabs-container">'
			                             . '<ul class="vc_tta-tabs-list">'
			                             . '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
			                             . '</ul>
                            </div>
                            <div class="vc_tta-panels vc_clearfix {{container-class}}">
                              {{ content }}
                            </div>
                        </div>
                    </div>',
			'default_content'         => '
                        [vc_tta_section title="' . sprintf( '%s %d', esc_html__( 'Tab', 'sumi' ), 1 ) . '"][/vc_tta_section]
                        [vc_tta_section title="' . sprintf( '%s %d', esc_html__( 'Tab', 'sumi' ), 2 ) . '"][/vc_tta_section]
                    ',
			'admin_enqueue_js'        => array(
				vc_asset_url( 'lib/vc_tabs/vc-tabs.min.js' ),
			),
		);
		$param['sumi_products'] = array(
			'base'        => 'sumi_products',
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/shopping-bag.svg',
			'name'        => esc_html__( 'Sumi: Products', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Products', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'admin_label' => true,
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Product Attribute', 'sumi' ),
					'param_name'  => 'product_attribute',
					'value'       => $attributes,
					'description' => esc_html__( 'Select a Attribute for product', 'sumi' ),
					'dependency'  => array( 'element' => 'product_style', 'value' => array( '2' ) ),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Product List style', 'sumi' ),
					'param_name'  => 'productsliststyle',
					'value'       => array(
						esc_html__( 'Grid Bootstrap', 'sumi' ) => 'grid',
						esc_html__( 'Owl Carousel', 'sumi' )   => 'owl',
					),
					'description' => esc_html__( 'Select a style for list', 'sumi' ),
					'std'         => 'grid',
				),
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Product style', 'sumi' ),
					'value'       => $product_options,
					'default'     => '1',
					'admin_label' => true,
					'param_name'  => 'product_style',
					'description' => esc_html__( 'Select a style for product item', 'sumi' ),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Image size', 'sumi' ),
					'param_name'  => 'product_image_size',
					'value'       => $product_size_list,
					'description' => esc_html__( 'Select a size for product', 'sumi' ),
				),
				array(
					'type'       => 'number',
					'heading'    => esc_html__( 'Width', 'sumi' ),
					'param_name' => 'product_custom_thumb_width',
					'value'      => $width,
					'suffix'     => esc_html__( 'px', 'sumi' ),
					'dependency' => array( 'element' => 'product_image_size', 'value' => array( 'custom' ) ),
				),
				array(
					'type'       => 'number',
					'heading'    => esc_html__( 'Height', 'sumi' ),
					'param_name' => 'product_custom_thumb_height',
					'value'      => $height,
					'suffix'     => esc_html__( 'px', 'sumi' ),
					'dependency' => array( 'element' => 'product_image_size', 'value' => array( 'custom' ) ),
				),
				array(
					'type'        => 'vc_link',
					'heading'     => esc_html__( 'Link', 'sumi' ),
					'param_name'  => 'link',
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( '4' ),
					),
				),
				/* Products */
				array(
					'type'        => 'taxonomy',
					'heading'     => esc_html__( 'Product Category', 'sumi' ),
					'param_name'  => 'taxonomy',
					'options'     => array(
						'multiple'   => true,
						'hide_empty' => true,
						'taxonomy'   => 'product_cat',
					),
					'placeholder' => esc_html__( 'Choose category', 'sumi' ),
					'description' => esc_html__( 'Note: If you want to narrow output, select category(s) above. Only selected categories will be displayed.', 'sumi' ),
					'group'       => esc_html__( 'Products options', 'sumi' ),
					'dependency'  => array(
						'element' => 'target',
						'value'   => array(
							'top-rated',
							'recent-product',
							'product-category',
							'featured_products',
							'on_sale',
							'on_new'
						)
					),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Target', 'sumi' ),
					'param_name'  => 'target',
					'value'       => array(
						esc_html__( 'Best Selling Products', 'sumi' ) => 'best-selling',
						esc_html__( 'Top Rated Products', 'sumi' )    => 'top-rated',
						esc_html__( 'Recent Products', 'sumi' )       => 'recent-product',
						esc_html__( 'Product Category', 'sumi' )      => 'product-category',
						esc_html__( 'Products', 'sumi' )              => 'products',
						esc_html__( 'Featured Products', 'sumi' )     => 'featured_products',
						esc_html__( 'On Sale', 'sumi' )               => 'on_sale',
						esc_html__( 'On New', 'sumi' )                => 'on_new',
					),
					'description' => esc_html__( 'Choose the target to filter products', 'sumi' ),
					'std'         => 'recent-product',
					'group'       => esc_html__( 'Products options', 'sumi' ),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Order by', 'sumi' ),
					'param_name'  => 'orderby',
					'value'       => array(
						esc_html__( 'Date', 'sumi' )          => 'date',
						esc_html__( 'ID', 'sumi' )            => 'ID',
						esc_html__( 'Author', 'sumi' )        => 'author',
						esc_html__( 'Title', 'sumi' )         => 'title',
						esc_html__( 'Modified', 'sumi' )      => 'modified',
						esc_html__( 'Random', 'sumi' )        => 'rand',
						esc_html__( 'Comment count', 'sumi' ) => 'comment_count',
						esc_html__( 'Menu order', 'sumi' )    => 'menu_order',
						esc_html__( 'Sale price', 'sumi' )    => '_sale_price',
					),
					'std'         => 'date',
					'description' => esc_html__( 'Select how to sort.', 'sumi' ),
					'dependency'  => array(
						'element' => 'target',
						'value'   => array(
							'top-rated',
							'recent-product',
							'product-category',
							'featured_products',
							'on_sale',
							'on_new',
							'product_attribute'
						)
					),
					'group'       => esc_html__( 'Products options', 'sumi' ),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Order', 'sumi' ),
					'param_name'  => 'order',
					'value'       => array(
						esc_html__( 'ASC', 'sumi' )  => 'ASC',
						esc_html__( 'DESC', 'sumi' ) => 'DESC',
					),
					'std'         => 'DESC',
					'description' => esc_html__( 'Designates the ascending or descending order.', 'sumi' ),
					'dependency'  => array(
						'element' => 'target',
						'value'   => array(
							'top-rated',
							'recent-product',
							'product-category',
							'featured_products',
							'on_sale',
							'on_new',
							'product_attribute'
						)
					),
					'group'       => esc_html__( 'Products options', 'sumi' ),
				),
				array(
					'type'       => 'number',
					'heading'    => esc_html__( 'Product per page', 'sumi' ),
					'param_name' => 'per_page',
					'value'      => 6,
					'dependency' => array(
						'element' => 'target',
						'value'   => array(
							'best-selling',
							'top-rated',
							'recent-product',
							'product-category',
							'featured_products',
							'product_attribute',
							'on_sale',
							'on_new'
						)
					),
					'group'      => esc_html__( 'Products options', 'sumi' ),
				),
				array(
					'type'        => 'autocomplete',
					'heading'     => esc_html__( 'Products', 'sumi' ),
					'param_name'  => 'ids',
					'settings'    => array(
						'multiple'      => true,
						'sortable'      => true,
						'unique_values' => true,
					),
					'save_always' => true,
					'description' => esc_html__( 'Enter List of Products', 'sumi' ),
					'dependency'  => array( 'element' => 'target', 'value' => array( 'products' ) ),
					'group'       => esc_html__( 'Products options', 'sumi' ),
				),
			),
		);
		$param['sumi_slide']    = array(
			'base'                    => 'sumi_slide',
			'icon'                    => SUMI_FRAMEWORK_URI . 'assets/images/slider.svg',
			'name'                    => esc_html__( 'Sumi: Slide', 'sumi' ),
			'category'                => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description'             => esc_html__( 'Display Slide', 'sumi' ),
			'as_parent'               => array(
				'only' => 'vc_single_image, sumi_banner, vc_custom_heading, sumi_person, vc_column_text, sumi_iconbox, sumi_category, sumi_socials, vc_row',
			),
			'content_element'         => true,
			'show_settings_on_create' => true,
			'js_view'                 => 'VcColumnView',
			'params'                  => array(
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Select style', 'sumi' ),
					'value'       => array(
						'default' => array(
							'title' => esc_html__( 'Default', 'sumi' ),
						),
						'style1'  => array(
							'title' => esc_html__( 'Slide Brand', 'sumi' ),
						),
					),
					'default'     => 'default',
					'admin_label' => true,
					'param_name'  => 'style',
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'slider_title',
					'admin_label' => true,
				),
			),
		);
		/* Map New blog */
		$categories_array = array(
			esc_html__( 'All', 'sumi' ) => '',
		);
		$args             = array();
		$categories       = get_categories( $args );
		foreach ( $categories as $category ) {
			$categories_array[ $category->name ] = $category->slug;
		}
		$param['sumi_blog'] = array(
			'base'        => 'sumi_blog',
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/blogger.svg',
			'name'        => esc_html__( 'Sumi: Blog', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Blog', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'loop',
					'heading'     => esc_html__( 'Option Query', 'sumi' ),
					'param_name'  => 'loop',
					'save_always' => true,
					'value'       => 'size:10|order_by:date',
					'settings'    => array(
						'size'     => array(
							'hidden' => false,
							'value'  => 10,
						),
						'order_by' => array( 'value' => 'date' ),
					),
					'description' => esc_html__( 'Create WordPress loop, to populate content from your site.', 'sumi' ),
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'blog_title',
					'description' => esc_html__( 'The title of shortcode', 'sumi' ),
					'admin_label' => true,
				),
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Blog style', 'sumi' ),
					'value'       => array(
						'style-1' => array(
							'title'   => esc_html__( 'Style 01', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/blog/default.jpg' ),
						),
					),
					'default'     => 'style-1',
					'admin_label' => true,
					'param_name'  => 'blog_style',
					'description' => esc_html__( 'Select a style for blog item', 'sumi' ),
				),
			),
		);
		$socials            = array();
		$all_socials        = Sumi_Functions::sumi_get_option( 'user_all_social' );
		if ( ! empty( $all_socials ) ) {
			foreach ( $all_socials as $key => $social ) {
				$socials[ $social['title_social'] ] = $key;
			}
		}
		$param['sumi_socials']    = array(
			'base'        => 'sumi_socials',
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/share.svg',
			'name'        => esc_html__( 'Sumi: Socials', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Socials', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title', 'sumi' ),
					'param_name'  => 'title',
					'admin_label' => true,
				),
				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'List Social', 'sumi' ),
					'param_name' => 'socials',
					'value'      => $socials,
				),
			),
		);
		$param['sumi_newsletter'] = array(
			'base'        => 'sumi_newsletter',
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/newsletter.svg',
			'name'        => esc_html__( 'Sumi: Newsletter', 'sumi' ),
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Newsletter', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Select style', 'sumi' ),
					'value'       => array(
						'style1' => array(
							'title'   => esc_html__( 'Style 01', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/newsletter/style01.jpg' ),
						),
						'style2' => array(
							'title'   => esc_html__( 'Style 02', 'sumi' ),
							'preview' => get_theme_file_uri( 'assets/images/shortcode-preview/newsletter/style02.jpg' ),
						),
					),
					'default'     => 'style-1',
					'admin_label' => true,
					'param_name'  => 'style',
				),
				array(
					"type"        => "attach_image",
					"heading"     => esc_html__( "Image Newsletter", 'sumi' ),
					'param_name'  => 'images',
					'admin_label' => true,
					'dependency'  => array(
						'element' => 'style',
						"value"   => array( 'style1' ),
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Title', 'sumi' ),
					'param_name' => 'title',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Subtitle', 'sumi' ),
					'param_name' => 'subtitle',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Show Mailchimp List', 'sumi' ),
					'param_name' => 'show_list',
					'value'      => array(
						esc_html__( 'Yes', 'sumi' ) => 'yes',
						esc_html__( 'No', 'sumi' )  => 'no',
					),
					'std'        => 'no',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Show Field Name', 'sumi' ),
					'param_name' => 'field_name',
					'value'      => array(
						esc_html__( 'Yes', 'sumi' ) => 'yes',
						esc_html__( 'No', 'sumi' )  => 'no',
					),
					'std'        => 'no',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'First Name Text', 'sumi' ),
					'param_name' => 'fname_text',
					'std'        => esc_html__( 'First Name', 'sumi' ),
					'dependency' => array(
						'element' => 'field_name',
						'value'   => 'yes',
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Last Name Text', 'sumi' ),
					'param_name' => 'lname_text',
					'std'        => esc_html__( 'Last Name', 'sumi' ),
					'dependency' => array(
						'element' => 'field_name',
						'value'   => 'yes',
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Placeholder Text', 'sumi' ),
					'param_name' => 'placeholder',
					'std'        => esc_html__( 'Your email letter', 'sumi' ),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Button Text', 'sumi' ),
					'param_name' => 'button_text',
					'std'        => esc_html__( 'Subscribe', 'sumi' ),
				),
			),
		);
		/* GET PINMAP */
		$args_pm        = array(
			'post_type'      => 'sumi_mapper',
			'posts_per_page' => - 1,
			'post_status'    => 'publish',
		);
		$pinmap_loop    = new wp_query( $args_pm );
		$pinmap_options = array();
		while ( $pinmap_loop->have_posts() ) {
			$pinmap_loop->the_post();
			$attachment_id                  = get_post_meta( get_the_ID(), 'sumi_mapper_image', true );
			$pinmap_options[ get_the_ID() ] = array(
				'title'   => get_the_title(),
				'preview' => wp_get_attachment_image_url( $attachment_id, 'medium' ),
			);
		}
		$param['sumi_pinmapper'] = array(
			'base'        => 'sumi_pinmapper',
			'name'        => esc_html__( 'Sumi: Pin Map', 'sumi' ),
			'icon'        => SUMI_FRAMEWORK_URI . 'assets/images/push-pin.svg',
			'category'    => esc_html__( 'Sumi Shortcode', 'sumi' ),
			'description' => esc_html__( 'Display Pin Map', 'sumi' ),
			'params'      => array(
				array(
					'type'        => 'select_preview',
					'heading'     => esc_html__( 'Pinmaper style', 'sumi' ),
					'value'       => $pinmap_options,
					'admin_label' => true,
					'param_name'  => 'pinmaper_style',
					'description' => esc_html__( 'Select a style for pinmaper item', 'sumi' ),
				),
			),
		);
		
		return $param;
	}
}

