<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 *
 * HOOK FOOTER
 */
add_action( 'sumi_footer', 'sumi_footer_content', 10 );
// add_action( 'sumi_footer', 'sumi_footer_mobile', 15 );
/**
 *
 * HOOK HEADER
 */
add_action( 'sumi_header', 'sumi_header_content', 10 );
add_action( 'sumi_header_sticky', 'sumi_header_sticky' );
/**
 *
 * HOOK BLOG META
 */
/* POST INFO */
add_action( 'sumi_post_info_content', 'sumi_post_title', 10 );
add_action( 'sumi_post_info_content', 'sumi_post_content', 20 );
add_action( 'sumi_post_info_content', 'sumi_post_author', 30 );
/**
 *
 * HOOK BLOG GRID
 */
add_action( 'sumi_after_blog_content', 'sumi_paging_nav', 10 );
add_action( 'sumi_post_content', 'sumi_post_thumbnail', 10 );
add_action( 'sumi_post_content', 'sumi_post_info', 20 );
/**
 *
 * HOOK BLOG SINGLE
 */
add_action( 'sumi_single_post_content', 'sumi_post_thumbnail', 10 );
add_action( 'sumi_single_post_content', 'sumi_post_info', 20 );
add_action( 'sumi_single_post_bottom_content', 'sumi_pagination_single_post', 30 );
/**
 *
 * HOOK TEMPLATE
 */
add_filter( 'wp_nav_menu_items', 'sumi_menu_detailing', 10, 2 );
add_filter( 'wp_nav_menu_items', 'sumi_top_right_menu', 10, 2 );
/**
 *
 * HOOK AJAX
 */
add_filter( 'wcml_multi_currency_ajax_actions', 'sumi_add_action_to_multi_currency_ajax', 10, 1 );
add_action( 'wp_ajax_sumi_ajax_tabs', 'sumi_ajax_tabs' );
add_action( 'wp_ajax_nopriv_sumi_ajax_tabs', 'sumi_ajax_tabs' );
/**
 *
 * HOOK AJAX
 */
add_action( 'wp_ajax_sumi_ajax_loadmore', 'sumi_ajax_loadmore' );
add_action( 'wp_ajax_nopriv_sumi_ajax_loadmore', 'sumi_ajax_loadmore' );
add_action( 'wp_ajax_sumi_ajax_faqs_loadmore', 'sumi_ajax_faqs_loadmore' );
add_action( 'wp_ajax_nopriv_sumi_ajax_faqs_loadmore', 'sumi_ajax_faqs_loadmore' );

/**
 *
 * HOOK TEMPLATE FUNCTIONS
 */
if ( ! function_exists( 'sumi_top_right_menu' ) ) {
	function sumi_top_right_menu( $items, $args ) {
		if ( $args->theme_location == 'top_right_menu' ) {
			$content = '';
			$content .= $items;
			ob_start();
			sumi_header_language();
			$content .= ob_get_clean();
			$items   = $content;
		}
		
		return $items;
	}
}
if ( ! function_exists( 'sumi_header_language' ) ) {
	function sumi_header_language() {
		$current_language = '';
		$list_language    = '';
		$menu_language    = '';
		$languages        = apply_filters( 'wpml_active_languages', null, 'skip_missing=0' );
		if ( ! empty( $languages ) ) {
			foreach ( $languages as $l ) {
				if ( ! $l['active'] ) {
					$list_language .= '
						<li class="menu-item">
                            <a href="' . esc_url( $l['url'] ) . '"><img src="' . esc_url( $l['country_flag_url'] ) . '" height="12" alt="' . esc_attr( $l['language_code'] ) . '" width="18"/>' . esc_html( $l['native_name'] ) . '</a>
                        </li>';
				} else {
					$current_language = '
						<a href="' . esc_url( $l['url'] ) . '" data-sumi="sumi-dropdown"> <img src="' . esc_url( $l['country_flag_url'] ) . '" height="12" alt="' . esc_attr( $l['language_code'] ) . '" width="18"/>' . esc_html( $l['native_name'] ) . '</a>
                        <span class="toggle-submenu"></span>';
				}
			}
			$menu_language .= '
                 <li class="menu-item sumi-dropdown block-language">
                    ' . $current_language . '
                    <ul class="sub-menu">
                        ' . $list_language . '
                    </ul>
                </li>';
			$menu_language .= '<li class="menu-item block-currency">' . do_shortcode( '[currency_switcher format="%code%" switcher_style="wcml-dropdown"]' ) . '</li>';
		}
		echo wp_specialchars_decode( $menu_language );
	}
}
if ( ! function_exists( 'sumi_get_logo' ) ) {
	function sumi_get_logo() {
		$logo_url = get_theme_file_uri( '/assets/images/logo.png' );
		$logo     = Sumi_Functions::sumi_get_option( 'sumi_logo' );
		if ( $logo != '' ) {
			$logo_url = wp_get_attachment_image_url( $logo, 'full' );
		}
		$html = '<a href="' . esc_url( home_url( '/' ) ) . '"><img alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" src="' . esc_url( $logo_url ) . '" class="_rw" /></a>';
		echo apply_filters( 'sumi_site_logo', $html );
	}
}
if ( ! function_exists( 'sumi_search_form' ) ) {
	function sumi_search_form() {
		$key_words = Sumi_Functions::sumi_get_option( 'key_word' );
		$selected  = '';
		if ( isset( $_GET['product_cat'] ) && $_GET['product_cat'] ) {
			$selected = $_GET['product_cat'];
		}
		$args = array(
			'show_option_none'  => esc_html__( 'All Categories', 'sumi' ),
			'taxonomy'          => 'product_cat',
			'class'             => 'category-search-option',
			'hide_empty'        => 1,
			'orderby'           => 'name',
			'order'             => 'ASC',
			'tab_index'         => true,
			'hierarchical'      => true,
			'id'                => rand(),
			'name'              => 'product_cat',
			'value_field'       => 'slug',
			'selected'          => $selected,
			'option_none_value' => '0',
		);
		?>
        <div class="block-search">
            <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ) ?>"
                  class="form-search block-search sumi-live-search-form">
                <a href="#" class="close-block-search"><span class="flaticon-cancel"></span></a>
                <div class="form-content search-box results-search">
                    <div class="inner">
                        <input autocomplete="off" type="text" class="searchfield txt-livesearch input" name="s"
                               value="<?php echo esc_attr( get_search_query() ); ?>"
                               placeholder="<?php echo esc_attr__( 'I’m searching for...', 'sumi' ); ?>">
                    </div>
                </div>
				<?php if ( class_exists( 'WooCommerce' ) ): ?>
                    <input type="hidden" name="post_type" value="product"/>
                    <input type="hidden" name="taxonomy" value="product_cat">
                    <div class="category">
						<?php wp_dropdown_categories( $args ); ?>
                    </div>
				<?php else: ?>
                    <input type="hidden" name="post_type" value="post"/>
				<?php endif; ?>
                <button type="submit" class="btn-submit">
                    <span class="flaticon-search-interface-symbol"></span>
                </button>
            </form><!-- block search -->
			<?php if ( ! empty( $key_words ) ): ?>
                <div class="key-word-search">
                    <span class="title-key"><?php echo esc_html__( 'Trending now :', 'sumi' ); ?></span>
                    <div class="listkey-word">
						<?php foreach ( $key_words as $key_word ): ?>
                            <a class="key-item" href="<?php echo esc_url( $key_word['key_word_link'] ); ?>">
								<?php echo esc_html( $key_word['key_word_item'] ); ?>
                            </a>
						<?php endforeach; ?>
                    </div>
                </div>
			<?php endif; ?>
        </div>
		<?php
	}
}
if ( ! function_exists( 'sumi_header_vertical' ) ) {
	function sumi_header_vertical() {
		
		if ( ! class_exists( 'Sumi_Toolkit' ) ) {
			return;
		}
		
		global $post;
		/* MAIN THEME OPTIONS */
		$sumi_enable_vertical = Sumi_Functions::sumi_get_option( 'sumi_enable_vertical_menu' );
		$sumi_block_vertical  = Sumi_Functions::sumi_get_option( 'sumi_block_vertical_menu' );
		$sumi_item_visible    = Sumi_Functions::sumi_get_option( 'sumi_vertical_item_visible', 10 );
		if ( $sumi_enable_vertical == 1 ) :
			$locations = get_nav_menu_locations();
			$menu_id          = $locations['vertical_menu'];
			$menu_items       = wp_get_nav_menu_items( $menu_id );
			$count            = 0;
			foreach ( $menu_items as $menu_item ) {
				if ( $menu_item->menu_item_parent == 0 ) {
					$count ++;
				}
			}
			/* MAIN THEME OPTIONS */
			$vertical_title        = Sumi_Functions::sumi_get_option( 'sumi_vertical_menu_title', esc_html__( 'CATEGORIES', 'sumi' ) );
			$vertical_button_all   = Sumi_Functions::sumi_get_option( 'sumi_vertical_menu_button_all_text', esc_html__( 'All Categories', 'sumi' ) );
			$vertical_button_close = Sumi_Functions::sumi_get_option( 'sumi_vertical_menu_button_close_text', esc_html__( 'Close', 'sumi' ) );
			$sumi_block_class      = array( 'vertical-wrapper block-nav-category' );
			$id                    = '';
			$post_type             = '';
			if ( $sumi_enable_vertical == 1 ) {
				$sumi_block_class[] = 'has-vertical-menu';
			}
			if ( isset( $post->ID ) ) {
				$id = $post->ID;
			}
			if ( isset( $post->post_type ) ) {
				$post_type = $post->post_type;
			}
			if ( is_array( $sumi_block_vertical ) && in_array( $id, $sumi_block_vertical ) && $post_type == 'page' ) {
				$sumi_block_class[] = 'always-open';
			}
			?>
            <!-- block category -->
            <div data-items="<?php echo esc_attr( $sumi_item_visible ); ?>"
                 class="<?php echo implode( ' ', $sumi_block_class ); ?>">
                <div class="block-title">
                    <span class="before">
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                    <span class="text-title"><?php echo esc_html( $vertical_title ); ?></span>
                </div>
                <div class="block-content verticalmenu-content">
					<?php
					wp_nav_menu( array(
						             'menu'            => 'vertical_menu',
						             'theme_location'  => 'vertical_menu',
						             'depth'           => 3,
						             'container'       => '',
						             'container_class' => '',
						             'container_id'    => '',
						             'menu_class'      => 'sumi-nav vertical-menu',
						             'fallback_cb'     => 'Sumi_navwalker::fallback',
						             'walker'          => new Sumi_navwalker(),
					             )
					);
					if ( $count > $sumi_item_visible ) : ?>
                        <div class="view-all-category">
                            <a href="#" data-closetext="<?php echo esc_attr( $vertical_button_close ); ?>"
                               data-alltext="<?php echo esc_attr( $vertical_button_all ) ?>"
                               class="btn-view-all open-cate"><?php echo esc_html( $vertical_button_all ) ?></a>
                        </div>
					<?php endif; ?>
                </div>
            </div><!-- block category -->
		<?php endif;
	}
}
if ( ! function_exists( 'sumi_set_post_views' ) ) {
	function sumi_set_post_views( $postID ) {
		if ( get_post_type( $postID ) == 'post' ) {
			$count_key = 'sumi_post_views_count';
			$count     = get_post_meta( $postID, $count_key, true );
			if ( $count == '' ) {
				$count = 0;
				delete_post_meta( $postID, $count_key );
				add_post_meta( $postID, $count_key, '0' );
			} else {
				$count ++;
				update_post_meta( $postID, $count_key, $count );
			}
		}
	}
}
if ( ! function_exists( 'sumi_get_post_views' ) ) {
	function sumi_get_post_views( $postID ) {
		$count_key = 'sumi_post_views_count';
		$count     = get_post_meta( $postID, $count_key, true );
		if ( $count == '' ) {
			delete_post_meta( $postID, $count_key );
			add_post_meta( $postID, $count_key, '0' );
			echo 0;
		}
		echo esc_html( $count );
	}
}
if ( ! function_exists( 'sumi_detected_shortcode' ) ) {
	function sumi_detected_shortcode( $id, $tab_id = null, $product_id = null ) {
		$post              = get_post( $id );
		$content           = preg_replace( '/\s+/', ' ', $post->post_content );
		$shortcode_section = '';
		if ( $tab_id == null ) {
			$out = array();
			preg_match_all( '/\[sumi_products(.*?)\]/', $content, $matches );
			if ( $matches[0] && is_array( $matches[0] ) && count( $matches[0] ) > 0 ) {
				foreach ( $matches[0] as $key => $value ) {
					if ( shortcode_parse_atts( $matches[1][ $key ] )['products_custom_id'] == $product_id ) {
						$out['atts']    = shortcode_parse_atts( $matches[1][ $key ] );
						$out['content'] = $value;
					}
				}
			}
			$shortcode_section = $out;
		}
		if ( $product_id == null ) {
			preg_match_all( '/\[vc_tta_section(.*?)vc_tta_section\]/', $content, $matches );
			if ( $matches[0] && is_array( $matches[0] ) && count( $matches[0] ) > 0 ) {
				foreach ( $matches[0] as $key => $value ) {
					preg_match_all( '/tab_id="([^"]+)"/', $matches[0][ $key ], $matches_ids );
					foreach ( $matches_ids[1] as $matches_id ) {
						if ( $tab_id == $matches_id ) {
							$shortcode_section = $value;
						}
					}
				}
			}
		}
		
		return $shortcode_section;
	}
}
if ( ! function_exists( 'sumi_add_action_to_multi_currency_ajax' ) ) {
	function sumi_add_action_to_multi_currency_ajax( $ajax_actions ) {
		$ajax_actions[] = 'sumi_ajax_tabs'; // Add a AJAX action to the array
		
		return $ajax_actions;
	}
}
if ( ! function_exists( 'sumi_ajax_tabs' ) ) {
	function sumi_ajax_tabs() {
		$response   = array(
			'html'    => '',
			'message' => '',
			'success' => 'no',
		);
		$section_id = isset( $_POST['section_id'] ) ? $_POST['section_id'] : '';
		$id         = isset( $_POST['id'] ) ? $_POST['id'] : '';
		$shortcode  = sumi_detected_shortcode( $id, $section_id, null );
		WPBMap::addAllMappedShortcodes();
		$response['html']    = wpb_js_remove_wpautop( $shortcode );
		$response['success'] = 'ok';
		wp_send_json( $response );
		die();
	}
}
if ( ! function_exists( 'sumi_menu_detailing' ) ) {
	function sumi_menu_detailing( $items, $args ) {
		if ( $args->theme_location == 'primary' ) {
			$sumi_block_detailing = Sumi_Functions::sumi_get_option( 'sumi_block_detailing', '' );
			$content              = '';
			ob_start();
			$content .= $items;
			ob_start();
			if ( $sumi_block_detailing != '' ) : ?>
                <li class="menu-item block-detailing">
                    <p><?php echo wp_specialchars_decode( $sumi_block_detailing ); ?></p>
                </li>
			<?php endif;
			$content .= ob_get_clean();
			$items   = $content;
		}
		
		return $items;
	}
}
/**
 *
 * TEMPLATE BLOG
 */
if ( ! function_exists( 'sumi_blog_banner' ) ) {
	function sumi_blog_banner() {
		$sumi_blog_banner     = Sumi_Functions::sumi_get_option( 'sumi_blog_banner' );
		$sumi_blog_banner_url = Sumi_Functions::sumi_get_option( 'sumi_blog_banner_url', '#' );
		if ( $sumi_blog_banner ):
			?>
            <a href="<?php echo esc_url( $sumi_blog_banner_url ); ?>">
				<?php
				$image_gallery = apply_filters( 'sumi_resize_image', $sumi_blog_banner, false, false, true, true );
				echo wp_specialchars_decode( $image_gallery['img'] );
				?>
            </a>
			<?php
		endif;
	}
}
if ( ! function_exists( 'sumi_paging_nav' ) ) {
	function sumi_paging_nav() {
		global $wp_query;
		$max = $wp_query->max_num_pages;
		// Don't print empty markup if there's only one page.
		if ( $max >= 2 ) {
			echo get_the_posts_pagination( array(
				                               'screen_reader_text' => '&nbsp;',
				                               'before_page_number' => '',
				                               'prev_text'          => esc_html__( 'Prev', 'sumi' ),
				                               'next_text'          => esc_html__( 'Next', 'sumi' ),
			                               )
			);
		}
	}
}
if ( ! function_exists( 'sumi_pagination_single_post' ) ) {
	function sumi_pagination_single_post() {
		$enable_nav_post = Sumi_Functions::sumi_get_option( 'enable_nav_post' );
		if ( $enable_nav_post == 1 ):
			?>
            <!-- Post Pagination -->
            <div class="post-pagination-single">
				<?php
				$prev_post = get_previous_post();
				if ( ! empty( $prev_post ) ): ?>
                    <div class="other-post prev">
						<?php
						$prevthumbnail = get_the_post_thumbnail( $prev_post->ID, array( 120, 120 ) ); ?>
                        <div class="image"><?php previous_post_link( '%link', $prevthumbnail ); ?></div>
                        <div class="content">
                            <h2><?php previous_post_link( '%link', 'PREVIEW POST' ); ?></h2>
                            <h5>
                                <a href="<?php the_permalink( $prev_post->ID ); ?>"><?php echo esc_html( $prev_post->post_title ); ?></a>
                            </h5>
                            <span class="post-date"><?php echo get_the_date( 'M j, Y', $prev_post->ID ); ?></span>
                        </div>
                    </div>
				<?php endif ?>
				<?php
				$next_post = get_next_post();
				if ( ! empty( $next_post ) ): ?>
                    <div class="other-post next">
						<?php
						$nextthumbnail = get_the_post_thumbnail( $next_post->ID, array( 120, 120 ) ); ?>
                        <div class="image"><?php next_post_link( '%link', $nextthumbnail ); ?></div>
                        <div class="content">
                            <h2><?php next_post_link( '%link', 'NEXT POST' ); ?></h2>
                            <h5>
                                <a href="<?php the_permalink( $next_post->ID ); ?>"><?php echo esc_html( $next_post->post_title ); ?></a>
                            </h5>
                            <span class="post-date"><?php echo get_the_date( 'M j, Y', $next_post->ID ); ?></span>
                        </div>
                    </div>
				<?php endif ?>
            </div>
			<?php
		endif;
	}
}
if ( ! function_exists( 'sumi_post_thumbnail' ) ) {
	function sumi_post_thumbnail() {
		$sumi_blog_style = Sumi_Functions::sumi_get_option( 'sumi_blog_list_style', 'standard' );
		$sumi_post_meta  = get_post_meta( get_the_ID(), '_custom_metabox_post_options', true );
		$gallery_post    = isset( $sumi_post_meta['gallery_post'] ) ? $sumi_post_meta['gallery_post'] : '';
		$video_post      = isset( $sumi_post_meta['video_post'] ) ? $sumi_post_meta['video_post'] : '';
		$quote_post      = isset( $sumi_post_meta['quote_post'] ) ? $sumi_post_meta['quote_post'] : '';
		$post_format     = get_post_format();
		$class           = 'post-thumb';
		$check           = false;
		if ( $gallery_post != '' && $post_format == 'gallery' ) {
			$check = true;
		}
		if ( $video_post != '' && $post_format == 'video' ) {
			$check = true;
		}
		if ( $quote_post != '' && $post_format == 'quote' ) {
			$check = true;
		}
		if ( $sumi_blog_style != 'grid' ) {
			$width  = false;
			$height = false;
		} else {
			$width  = 442;
			$height = 328;
		}
		if ( has_post_thumbnail() ) :
			?>
            <div class="<?php echo esc_attr( $class ); ?>">
                <div class="thumb-img">
					<?php
					if ( $check == true && $sumi_blog_style != 'grid' ) {
						if ( $post_format == 'gallery' ) :
							$gallery_post = explode( ',', $gallery_post );
							?>
                            <div class="owl-slick"
                                 data-slick='{"arrows": false, "dots": true, "infinite": false, "slidesToShow": 1}'>
                                <figure>
									<?php
									$image_thumb = apply_filters( 'sumi_resize_image', get_post_thumbnail_id(), $width, $height, true, true );
									echo wp_specialchars_decode( $image_thumb['img'] );
									?>
                                </figure>
								<?php foreach ( $gallery_post as $item ) : ?>
                                    <figure>
										<?php
										$image_gallery = apply_filters( 'sumi_resize_image', $item, $width, $height, true, true );
										echo wp_specialchars_decode( $image_gallery['img'] );
										?>
                                    </figure>
								<?php endforeach; ?>
                            </div>
						<?php endif;
						if ( $post_format == 'quote' ) {
							echo '<p class="quote">' . wp_specialchars_decode( $quote_post ) . '</p>';
						}
						if ( $post_format == 'video' ) {
							the_widget( 'WP_Widget_Media_Video', 'url=' . $video_post . '' );
						}
					} else {
						if ( is_single() ) {
							the_post_thumbnail( 'full' );
						} else {
							$image_thumb = apply_filters( 'sumi_resize_image', get_post_thumbnail_id(), $width, $height, true, true );
							echo '<a href="' . get_permalink() . '">';
							echo wp_specialchars_decode( $image_thumb['img'] );
							echo '</a>';
						}
					}
					?>
                </div>
                <span class="post-date"> <?php echo get_the_date(); ?> </span>
            </div>
			<?php
		endif;
	}
}
if ( ! function_exists( 'sumi_callback_comment' ) ) {
	/**
	 * Sumi comment template
	 *
	 * @param array $comment the comment array.
	 * @param array $args    the comment args.
	 * @param int   $depth   the comment depth.
	 *
	 * @since 1.0.0
	 */
	function sumi_callback_comment( $comment, $args, $depth ) {
		if ( 'div' == $args['style'] ) {
			$tag       = 'div ';
			$add_below = 'comment';
		} else {
			$tag       = 'li ';
			$add_below = 'div-comment';
		}
		?>
        <<?php echo esc_attr( $tag ); ?><?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php echo get_comment_ID(); ?>">
        <div class="comment_container">
            <div class="comment-avatar">
				<?php echo get_avatar( $comment, 60 ); ?>
            </div>
            <div class="comment-text commentmetadata">
                <div class="comment-author vcard">
					<?php printf( wp_kses_post( '%s', 'sumi' ), get_comment_author_link() ); ?>
                </div>
				<?php if ( '0' == $comment->comment_approved ) : ?>
                    <em class="comment-awaiting-moderation"><?php esc_attr_e( 'Your comment is awaiting moderation.', 'sumi' ); ?></em>
                    <br/>
				<?php endif; ?>
                <a href="<?php echo esc_url( htmlspecialchars( get_comment_link( get_comment_ID() ) ) ); ?>"
                   class="comment-date">
					<?php echo '<time datetime="' . get_comment_date( 'c' ) . '">' . get_comment_date() . '</time>'; ?>
                </a>
				<?php edit_comment_link( __( 'Edit', 'sumi' ), '  ', '' ); ?>
				<?php comment_reply_link( array_merge( $args, array(
					'add_below' => $add_below,
					'depth'     => $depth,
					'max_depth' => $args['max_depth']
				) ) ); ?>
				<?php echo ( 'div' != $args['style'] ) ? '<div id="div-comment-' . get_comment_ID() . '" class="comment-content">' : '' ?>
				<?php comment_text(); ?>
				<?php echo 'div' != $args['style'] ? '</div>' : ''; ?>
            </div>
        </div>
		<?php
	}
}
if ( ! function_exists( 'sumi_post_title' ) ) {
	function sumi_post_title() {
		$title = get_the_title();
		if ( $title ): ?>
            <h2 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		<?php else: ?>
            <h2 class="post-title no-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		<?php endif;
	}
}
if ( ! function_exists( 'sumi_post_content' ) ) {
	function sumi_post_content() {
		$sumi_blog_style = Sumi_Functions::sumi_get_option( 'sumi_blog_list_style', 'standard' );
		if ( $sumi_blog_style == 'grid' && !is_single() ):
			?>
            <div class="post-content">
				<?php echo wp_trim_words( apply_filters( 'the_excerpt', get_the_excerpt() ), 15, esc_html__( '...', 'sumi' ) ); ?>
            </div>
		<?php else: ?>
            <div class="post-content">
				<?php
				/* translators: %s: Name of current post */
				the_content( sprintf(
					             esc_html__( 'Continue reading %s', 'sumi' ),
					             the_title( '<span class="screen-reader-text">', '</span>', false )
				             )
				);
				wp_link_pages( array(
					               'before'      => '<div class="post-pagination"><span class="title">' . esc_html__( 'Pages:', 'sumi' ) . '</span>',
					               'after'       => '</div>',
					               'link_before' => '<span>',
					               'link_after'  => '</span>',
				               )
				);
				?>
				<?php
				$title = get_the_title();
				if ( ! $title ): ?>
                    <a href="<?php the_permalink(); ?>" class="read-more screen-reader-text">
                        <span class="text"><?php esc_html_e( 'Read More', 'sumi' ); ?></span>
                    </a>
				<?php endif;
				?>
            </div>
			<?php
		endif;
	}
}
if ( ! function_exists( 'sumi_post_single_content' ) ) {
	function sumi_post_single_content() {
		?>
        <div class="post-content">
			<?php
			/* translators: %s: Name of current post */
			the_content( sprintf(
				             esc_html__( 'Continue reading %s', 'sumi' ),
				             the_title( '<span class="screen-reader-text">', '</span>', false )
			             )
			);
			wp_link_pages( array(
				               'before'      => '<div class="post-pagination"><span class="title">' . esc_html__( 'Pages:', 'sumi' ) . '</span>',
				               'after'       => '</div>',
				               'link_before' => '<span>',
				               'link_after'  => '</span>',
			               )
			);
			?>
        </div>
		<?php
	}
}
if ( ! function_exists( 'sumi_post_sticky' ) ) {
	function sumi_post_sticky() {
		if ( is_sticky() ) : ?>
            <li class="sticky-post"><i class="fa fa-flag"></i>
				<?php echo esc_html__( ' Sticky', 'sumi' ); ?>
            </li>
		<?php endif;
	}
}
if ( ! function_exists( 'sumi_post_calendar' ) ) {
	function sumi_post_calendar() {
		?>
        <div class="post-meta">
            <ul class="info-meta-left">
				<?php $get_term_cat = get_the_terms( get_the_ID(), 'category' );
				if ( ! is_wp_error( $get_term_cat ) && ! empty( $get_term_cat ) ) : ?>
                    <li class="category">
						<?php
						the_category( ', ' );
						?>
                    </li>
				<?php endif; ?>
            </ul>
            <ul class="info-meta-right">
                <li class="author">
                    <span><?php echo esc_html__( 'By : ', 'sumi' ) ?></span>
                    <a href="<?php the_permalink(); ?>"><?php echo get_the_author(); ?></a>
                </li>
                <li class="comment">
					<?php
					comments_number(
						esc_html__( '0', 'sumi' ),
						esc_html__( '1', 'sumi' ),
						esc_html__( '%', 'sumi' )
					);
					?>
                    <span class="fa fa-comments"></span>
                </li>
            </ul>
        </div>
		<?php
		sumi_post_tags();
	}
}
if ( ! function_exists( 'sumi_post_category_grid' ) ) {
	function sumi_post_category_grid() {
		?>
        <div class="post-meta">
            <ul class="info-meta-left">
				<?php $get_term_cat = get_the_terms( get_the_ID(), 'category' );
				if ( ! is_wp_error( $get_term_cat ) && ! empty( $get_term_cat ) ) : ?>
                    <li class="category">
						<?php
						the_category( ', ' );
						?>
                    </li>
				<?php endif; ?>
            </ul>
        </div>
		<?php
		sumi_post_tags();
	}
}
if ( ! function_exists( 'sumi_post_author' ) ) {
	function sumi_post_author() {
		?>
        <div class="post-meta clearfix">
            <div class="author">
                <span><?php echo esc_html__( 'By : ', 'sumi' ) ?></span>
                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) ?>">
					<?php the_author() ?>
                </a>
            </div>
            <div class="comment">
				<?php
				comments_number(
					esc_html__( '0', 'sumi' ),
					esc_html__( '1', 'sumi' ),
					esc_html__( '%', 'sumi' )
				);
				?>
                <span class="fa fa-comments"></span>
            </div>
        </div>
		<?php
	}
}
if ( ! function_exists( 'sumi_share_button' ) ) {
	function sumi_share_button( $post_id ) {
		$share_image_url       = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
		$share_link_url        = get_permalink( $post_id );
		$share_link_title      = get_the_title();
		$share_twitter_summary = get_the_excerpt();
		$twitter               = 'https://twitter.com/share?url=' . $share_link_url . '&text=' . $share_twitter_summary;
		$facebook              = 'https://www.facebook.com/sharer.php?s=100&title=' . $share_link_title . '&url=' . $share_link_url;
		$google                = 'https://plus.google.com/share?url=' . $share_link_url . '&title=' . $share_link_title;
		$pinterest             = 'http://pinterest.com/pin/create/button/?url=' . $share_link_url . '&description=' . $share_twitter_summary . '&media=' . $share_image_url[0];
		?>
        <div class="sumi-share-socials">
            <a target="_blank" class="twitter"
               href="<?php echo esc_url( $twitter ); ?>"
               title="<?php echo esc_attr__( 'Twitter', 'sumi' ) ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <span class="fa fa-twitter"></span>
            </a>
            <a target="_blank" class="facebook"
               href="<?php echo esc_url( $facebook ); ?>"
               title="<?php echo esc_attr__( 'Facebook', 'sumi' ) ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <span class="fa fa-facebook-f"></span>
            </a>
            <a target="_blank" class="googleplus"
               href="<?php echo esc_url( $google ); ?>"
               title="<?php echo esc_attr__( 'Google+', 'sumi' ) ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <span class="fa fa-google-plus"></span>
            </a>
            <a target="_blank" class="pinterest"
               href="<?php echo esc_url( $pinterest ); ?>"
               title="<?php echo esc_attr__( 'Pinterest', 'sumi' ) ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <span class="fa fa-pinterest"></span>
            </a>
        </div>
		<?php
	}
}
if ( ! function_exists( 'sumi_post_tags' ) ) {
	function sumi_post_tags() {
		$get_term_tag = get_the_terms( get_the_ID(), 'post_tag' );
		if ( ! is_wp_error( $get_term_tag ) && ! empty( $get_term_tag ) ) : ?>
            <div class="tags">
				<?php the_tags( '', '' ); ?>
            </div>
		<?php endif;
	}
}
if ( ! function_exists( 'sumi_post_category' ) ) {
	function sumi_post_category() {
		$get_term_cat = get_the_terms( get_the_ID(), 'category' );
		if ( ! is_wp_error( $get_term_cat ) && ! empty( $get_term_cat ) ) : ?>
			<?php
			the_category( ', ' );
			?>
		<?php endif;
	}
}
if ( ! function_exists( 'sumi_post_single_meta' ) ) {
	function sumi_post_single_meta() {
		$enable_share_post = Sumi_Functions::sumi_get_option( 'enable_share_post' );
		?>
        <div class="single-meta-post">
            <div class="category">
				<?php
				sumi_post_category(); ?>
            </div>
			<?php if ( $enable_share_post == 1 ) {
				sumi_share_button( get_the_ID() );
			} ?>
        </div>
		<?php
		sumi_post_tags();
	}
}
if ( ! function_exists( 'sumi_post_info' ) ) {
	function sumi_post_info() { ?>
        <div class="post-info">
			<?php
			/**
			 * Functions hooked into sumi_post_info_content action
			 *
			 * @hooked sumi_post_title               - 10
			 * @hooked sumi_post_content             - 20
			 * @hooked sumi_post_author              - 30
			 */
			do_action( 'sumi_post_info_content' );
			?>
        </div>
		<?php
	}
}

/**
 *
 * TEMPLATE FOOTER
 */
if ( ! function_exists( 'sumi_footer_content' ) ) {
	function sumi_footer_content() {
		$data_meta             = get_post_meta( get_the_ID(), '_custom_metabox_theme_options', true );
		$footer_options        = Sumi_Functions::sumi_get_option( 'sumi_footer_options' );
		$enable_theme_option   = Sumi_Functions::sumi_get_option( 'enable_theme_options' );
		$footer_options        = $enable_theme_option == 1 && isset( $data_meta['metabox_sumi_footer_options'] ) && $data_meta['metabox_sumi_footer_options'] != '' ? $data_meta['metabox_sumi_footer_options'] : $footer_options;
		$meta_template_style   = get_post_meta( $footer_options, '_custom_footer_options', true );
		$footer_template_style = isset( $meta_template_style['sumi_footer_style'] ) ? $meta_template_style['sumi_footer_style'] : 'style-01';
		ob_start();
		$query = new WP_Query( array( 'p' => $footer_options, 'post_type' => 'footer', 'posts_per_page' => 1 ) );
		if ( $query->have_posts() ):
			while ( $query->have_posts() ): $query->the_post();
				get_template_part( 'templates/footer/footer', $footer_template_style );
			endwhile;
		endif;
		wp_reset_postdata();
		echo ob_get_clean();
	}
}
/**
 *
 * TEMPLATE HEADER
 */
if ( ! function_exists( 'sumi_header_content' ) ) {
	function sumi_header_content() {
		$enable_theme_option = Sumi_Functions::sumi_get_option( 'enable_theme_options' );
		$data_meta           = get_post_meta( get_the_ID(), '_custom_metabox_theme_options', true );
		$header_options      = Sumi_Functions::sumi_get_option( 'sumi_used_header', 'style-01' );
		$header_options      = $enable_theme_option == 1 && isset( $data_meta['metabox_sumi_used_header'] ) && $data_meta['metabox_sumi_used_header'] != '' ? $data_meta['metabox_sumi_used_header'] : $header_options;
		get_template_part( 'templates/header/header', $header_options );
	}
}
if ( ! function_exists( 'sumi_header_sticky' ) ) {
	function sumi_header_sticky() {
		$sumi_icon     = Sumi_Functions::sumi_get_option( 'header_icon' );
		$sumi_phone    = Sumi_Functions::sumi_get_option( 'header_phone' );
		$sumi_text     = Sumi_Functions::sumi_get_option( 'header_text' );
		$enable_sticky = Sumi_Functions::sumi_get_option( 'sumi_enable_sticky_menu' );
		if ( $enable_sticky == 1 ): ?>
            <div class="header-sticky">
                <div class="container">
                    <div class="header-nav ">
                        <div class="header-nav-inner header-position">
							<?php sumi_header_vertical(); ?>
                            <div class="box-header-nav sumi-menu-wapper">
								<?php
								wp_nav_menu( array(
									             'menu'            => 'primary',
									             'theme_location'  => 'primary',
									             'depth'           => 3,
									             'container'       => '',
									             'container_class' => '',
									             'container_id'    => '',
									             'menu_class'      => 'sumi-nav main-menu',
									             'fallback_cb'     => 'Sumi_navwalker::fallback',
									             'walker'          => new Sumi_navwalker(),
								             )
								);
								?>
                            </div>
							<?php if ( $sumi_phone ) : ?>
                                <div class="phone-header">
									<?php if ( $sumi_icon ) : ?>
                                        <span class="<?php echo esc_attr( $sumi_icon ); ?>"></span>
									<?php endif; ?>
                                    <div class="phone-number">
                                        <p class="text-1"><?php echo esc_html( $sumi_text ); ?></p>
                                        <p class="text-2"><?php echo esc_html( $sumi_phone ); ?></p>
                                    </div>
                                </div>
							<?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
		<?php endif;
	}
}
if ( ! function_exists( 'sumi_header_language' ) ) {
	function sumi_header_language() {
		$list_language = '';
		$menu_language = '';
		$languages     = apply_filters( 'wpml_active_languages', null, 'skip_missing=0' );
		if ( ! empty( $languages ) ) {
			foreach ( $languages as $l ) {
				if ( ! $l['active'] ) {
					$list_language .= '
						<li>
                            <a href="' . esc_url( $l['url'] ) . '">
                                <img src="' . esc_url( $l['country_flag_url'] ) . '" height="12"
                                     alt="' . esc_attr( $l['language_code'] ) . '" width="18"/>
								' . esc_html( $l['native_name'] ) . '
                            </a>
                        </li>';
				}
			}
			$menu_language = '<ul>' . $list_language . '</ul>';
		}
		echo wp_specialchars_decode( $menu_language );
	}
}
if ( ! function_exists( 'sumi_user_link' ) ) {
	function sumi_user_link() {
		$currentUser    = wp_get_current_user();
		$myaccount_link = wp_login_url();
		if ( class_exists( 'WooCommerce' ) ) {
			$myaccount_link = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) );
		}
		?>
        <div class="menu-item block-user sumi-dropdown">
			<?php if ( is_user_logged_in() ): ?>
                <a data-sumi="sumi-dropdown" class="woo-wishlist-link"
                   href="<?php echo esc_url( $myaccount_link ); ?>">
                    <span class="flaticon-user"></span>
                    <span class="text-control"><?php echo esc_html( $currentUser->display_name ); ?></span>
                </a>
				<?php if ( function_exists( 'wc_get_account_menu_items' ) ): ?>
                    <ul class="sub-menu">
						<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
                            <li class="menu-item <?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                                <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
                            </li>
						<?php endforeach; ?>
                    </ul>
				<?php else: ?>
                    <ul class="sub-menu">
                        <li class="menu-item">
                            <a href="<?php echo wp_logout_url( get_permalink() ); ?>"><?php esc_html_e( 'Logout', 'sumi' ); ?></a>
                        </li>
                    </ul>
				<?php endif;
			else: ?>
                <a class="woo-wishlist-link" href="<?php echo esc_url( $myaccount_link ); ?>">
                    <span class="flaticon-user"></span>
                    <span class="text-control"><?php esc_html_e( 'Login', 'sumi' ); ?></span>
                </a>
			<?php endif; ?>
        </div>
		<?php
	}
}
/**
 *
 * TEMPLATE LOAD MORE
 */
if ( ! function_exists( 'sumi_ajax_loadmore' ) ) {
	function sumi_ajax_loadmore() {
		$response             = array(
			'html'     => '',
			'loop_id'  => array(),
			'out_post' => 'no',
			'message'  => '',
			'success'  => 'no',
		);
		$out_post             = 'no';
		$args                 = isset( $_POST['loop_query'] ) ? $_POST['loop_query'] : array();
		$class                = isset( $_POST['loop_class'] ) ? $_POST['loop_class'] : array();
		$loop_id              = isset( $_POST['loop_id'] ) ? $_POST['loop_id'] : array();
		$loop_style           = isset( $_POST['loop_style'] ) ? $_POST['loop_style'] : '';
		$loop_thumb           = isset( $_POST['loop_thumb'] ) ? explode( 'x', $_POST['loop_thumb'] ) : '';
		$args['post__not_in'] = $loop_id;
//		add_filter( 'sumi_shop_pruduct_thumb_width', create_function( '', 'return ' . $loop_thumb[0] . ';' ) );
//		add_filter( 'sumi_shop_pruduct_thumb_height', create_function( '', 'return ' . $loop_thumb[1] . ';' ) );
		
		$product_size_args = array(
			'width'  => $loop_thumb[0],
			'height' => $loop_thumb[1]
		);
  
		$loop_posts = new WP_Query( $args );
		ob_start();
		if ( $loop_posts->have_posts() ) {
			while ( $loop_posts->have_posts() ) : $loop_posts->the_post(); ?>
				<?php $loop_id[] = get_the_ID(); ?>
                <div <?php post_class( $class ); ?>>
					<?php wc_get_template( 'product-styles/content-product-style-' . $loop_style.'.php', $product_size_args ); ?>
                </div>
				<?php
			endwhile;
		} else {
			$out_post = 'yes';
		}
		$response['html']     = ob_get_clean();
		$response['loop_id']  = $loop_id;
		$response['out_post'] = $out_post;
		$response['success']  = 'yes';
		wp_send_json( $response );
		die();
	}
}
if ( ! function_exists( 'sumi_ajax_faqs_loadmore' ) ) {
	function sumi_ajax_faqs_loadmore() {
		$response             = array(
			'html'     => '',
			'loop_id'  => array(),
			'out_post' => 'no',
			'message'  => '',
			'success'  => 'no',
		);
		$out_post             = 'no';
		$args                 = isset( $_POST['loop_query'] ) ? $_POST['loop_query'] : array();
		$class                = isset( $_POST['loop_class'] ) ? $_POST['loop_class'] : array();
		$loop_id              = isset( $_POST['loop_id'] ) ? $_POST['loop_id'] : array();
		$args['post__not_in'] = $loop_id;
		$loop_posts           = new WP_Query( $args );
		ob_start();
		if ( $loop_posts->have_posts() ) {
			while ( $loop_posts->have_posts() ) : $loop_posts->the_post(); ?>
				<?php $loop_id[] = get_the_ID(); ?>
                <article <?php post_class( $class ); ?>>
                    <div class="question">
                        <span class="icon"><?php echo esc_html__( 'Q', 'sumi' ); ?></span>
                        <p class="text"><?php the_title(); ?></p>
                    </div>
                    <div class="answer">
                        <span class="icon"><?php echo esc_html__( 'A', 'sumi' ); ?></span>
                        <p class="text"><?php the_content(); ?></p>
                    </div>
                </article>
				<?php
			endwhile;
		} else {
			$out_post = 'yes';
		}
		$response['html']     = ob_get_clean();
		$response['loop_id']  = $loop_id;
		$response['out_post'] = $out_post;
		$response['success']  = 'yes';
		wp_send_json( $response );
		die();
	}
}

if ( ! function_exists( 'sumi_calculate_image_srcset' ) ) {
	/**
	 * A helper function to calculate the image sources to include in a 'srcset' attribute.
	 *
	 * @since 4.4.0
	 *
	 * @param array  $size_array    Array of width and height values in pixels (in that order).
	 * @param string $image_src     The 'src' of the image.
	 * @param array  $image_meta    The image meta data as returned by 'wp_get_attachment_metadata()'.
	 * @param int    $attachment_id Optional. The image attachment ID to pass to the filter. Default 0.
	 *
	 * @return string|bool          The 'srcset' attribute value. False on error or when only one source exists.
	 */
	function sumi_calculate_image_srcset( $size_array, $image_src, $image_meta, $attachment_id = 0 ) {
		/**
		 * Let plugins pre-filter the image meta to be able to fix inconsistencies in the stored data.
		 *
		 * @since 4.5.0
		 *
		 * @param array  $image_meta    The image meta data as returned by 'wp_get_attachment_metadata()'.
		 * @param array  $size_array    Array of width and height values in pixels (in that order).
		 * @param string $image_src     The 'src' of the image.
		 * @param int    $attachment_id The image attachment ID or 0 if not supplied.
		 */
		$image_meta = apply_filters( 'sumi_calculate_image_srcset_meta', $image_meta, $size_array, $image_src, $attachment_id );
		
		if ( empty( $image_meta['sizes'] ) || ! isset( $image_meta['file'] ) || strlen( $image_meta['file'] ) < 4 ) {
			return false;
		}
		
		$image_sizes = $image_meta['sizes'];
		
		// Get the width and height of the image.
		$image_width  = (int) $size_array[0];
		$image_height = (int) $size_array[1];
		
		// Bail early if error/no width.
		if ( $image_width < 1 ) {
			return false;
		}
		
		$image_basename = wp_basename( $image_meta['file'] );
		
		/*
		 * WordPress flattens animated GIFs into one frame when generating intermediate sizes.
		 * To avoid hiding animation in user content, if src is a full size GIF, a srcset attribute is not generated.
		 * If src is an intermediate size GIF, the full size is excluded from srcset to keep a flattened GIF from becoming animated.
		 */
		if ( ! isset( $image_sizes['thumbnail']['mime-type'] ) || 'image/gif' !== $image_sizes['thumbnail']['mime-type'] ) {
			$image_sizes[] = array(
				'width'  => $image_meta['width'],
				'height' => $image_meta['height'],
				'file'   => $image_basename,
			);
		} elseif ( strpos( $image_src, $image_meta['file'] ) ) {
			return false;
		}
		
		// Retrieve the uploads sub-directory from the full size image.
		$dirname = _wp_get_attachment_relative_path( $image_meta['file'] );
		
		if ( $dirname ) {
			$dirname = trailingslashit( $dirname );
		}
		
		$upload_dir    = wp_get_upload_dir();
		$image_baseurl = trailingslashit( $upload_dir['baseurl'] ) . $dirname;
		
		/*
		 * If currently on HTTPS, prefer HTTPS URLs when we know they're supported by the domain
		 * (which is to say, when they share the domain name of the current request).
		 */
		if ( is_ssl() && 'https' !== substr( $image_baseurl, 0, 5 ) ) {
			$image_baseurl = set_url_scheme( $image_baseurl, 'https' );
		}
		
		/*
		 * Images that have been edited in WordPress after being uploaded will
		 * contain a unique hash. Look for that hash and use it later to filter
		 * out images that are leftovers from previous versions.
		 */
		$image_edited = preg_match( '/-e[0-9]{13}/', wp_basename( $image_src ), $image_edit_hash );
		
		/**
		 * Filters the maximum image width to be included in a 'srcset' attribute.
		 *
		 * @since 4.4.0
		 *
		 * @param int   $max_width  The maximum image width to be included in the 'srcset'. Default '1600'.
		 * @param array $size_array Array of width and height values in pixels (in that order).
		 */
		$max_srcset_image_width = apply_filters( 'max_srcset_image_width', 1600, $size_array );
		
		// Array to hold URL candidates.
		$sources = array();
		
		/**
		 * To make sure the ID matches our image src, we will check to see if any sizes in our attachment
		 * meta match our $image_src. If no matches are found we don't return a srcset to avoid serving
		 * an incorrect image. See #35045.
		 */
		$src_matched = false;
		
		/*
		 * Loop through available images. Only use images that are resized
		 * versions of the same edit.
		 */
		foreach ( $image_sizes as $image ) {
			$is_src = false;
			
			// Check if image meta isn't corrupted.
			if ( ! is_array( $image ) ) {
				continue;
			}
			
			// If the file name is part of the `src`, we've confirmed a match.
			if ( ! $src_matched && false !== strpos( $image_src, $dirname . $image['file'] ) ) {
				$src_matched = $is_src = true;
			}
			
			// Filter out images that are from previous edits.
			if ( $image_edited && ! strpos( $image['file'], $image_edit_hash[0] ) ) {
				continue;
			}
			
			/*
			 * Filters out images that are wider than '$max_srcset_image_width' unless
			 * that file is in the 'src' attribute.
			 */
			if ( $max_srcset_image_width && $image['width'] > $max_srcset_image_width && ! $is_src ) {
				continue;
			}
			
			// If the image dimensions are within 1px of the expected size, use it.
			if ( wp_image_matches_ratio( $image_width, $image_height, $image['width'], $image['height'] ) ) {
				// Add the URL, descriptor, and value to the sources array to be returned.
				$source = array(
					'url'        => $image_baseurl . $image['file'],
					'descriptor' => 'w',
					'value'      => $image['width'],
				);
				
				// The 'src' image has to be the first in the 'srcset', because of a bug in iOS8. See #35030.
				if ( $is_src ) {
					$sources = array( $image['width'] => $source ) + $sources;
				} else {
					$sources[ $image['width'] ] = $source;
				}
			}
		}
		
		/**
		 * Filters an image's 'srcset' sources.
		 *
		 * @since 4.4.0
		 *
		 * @param array  $sources       {
		 *                              One or more arrays of source data to include in the 'srcset'.
		 *
		 * @type array   $width         {
		 * @type string  $url           The URL of an image source.
		 * @type string  $descriptor    The descriptor type used in the image candidate string,
		 *                                  either 'w' or 'x'.
		 * @type int     $value         The source width if paired with a 'w' descriptor, or a
		 *                                  pixel density value if paired with an 'x' descriptor.
		 *     }
		 * }
		 *
		 * @param array  $size_array    Array of width and height values in pixels (in that order).
		 * @param string $image_src     The 'src' of the image.
		 * @param array  $image_meta    The image meta data as returned by 'wp_get_attachment_metadata()'.
		 * @param int    $attachment_id Image attachment ID or 0.
		 */
		$sources = apply_filters( 'sumi_calculate_image_srcset', $sources, $size_array, $image_src, $image_meta, $attachment_id );
		
		// Only return a 'srcset' value if there is more than one source.
		if ( ! $src_matched || ! is_array( $sources ) || count( $sources ) < 2 ) {
			return false;
		}
		
		$srcset = '';
		
		foreach ( $sources as $source ) {
			$srcset .= str_replace( ' ', '%20', $source['url'] ) . ' ' . $source['value'] . $source['descriptor'] . ', ';
		}
		
		return rtrim( $srcset, ', ' );
	}
}
if ( ! function_exists( 'sumi_change_buy_together_thumb_width' ) ) {
	function sumi_change_buy_together_thumb_width( $thumb_w ) {
		$thumb_w = 220;
		
		return $thumb_w;
	}
	
	add_filter( 'famibt_thumb_w', 'sumi_change_buy_together_thumb_width', 10, 1 );
}

if ( ! function_exists( 'sumi_change_buy_together_thumb_height' ) ) {
	function sumi_change_buy_together_thumb_height( $thumb_h ) {
		$thumb_h = 220;
		
		return $thumb_h;
	}
	
	add_filter( 'famibt_thumb_h', 'sumi_change_buy_together_thumb_height', 10, 1 );
}