<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package WordPress
 * @subpackage Sumi
 * @since 1.0
 * @version 1.0
 */
get_header();
$sumi_page_404 = Sumi_Functions::sumi_get_option( 'sumi_page_404' );
?>
<?php if ( $sumi_page_404 ) : ?>
	<?php
	$post_id = get_post( $sumi_page_404 );
	$content = $post_id->post_content;
	$content = apply_filters( 'the_content', $content );
	$content = str_replace( ']]>', ']]>', $content );
	echo wp_specialchars_decode( $content );
	?>
<?php else: ?>
    <div class="main-container">
        <div class="container">
            <div id="primary" class="content-area">
                <main id="main" class="site-main" role="main">
                    <section class="error-404 not-found">
                        <h1 class="title"><?php echo esc_html__( 'We are sorry, the page you’ve requested is not available', 'sumi' ); ?></h1>
						<?php get_search_form(); ?>
                        <!-- .page-content -->
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>"
                           class="button"><?php echo esc_html__( 'Back to hompage', 'sumi' ); ?></a>
                    </section><!-- .error-404 -->
                </main><!-- #main -->
            </div><!-- #primary -->
        </div>
    </div>
<?php endif;
get_footer();
