<?php
/**
 * Single variation cart button
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

global $product;

$ajax_cart = StockieSettings::get( 'woocommerce_add_to_cart_ajax', 'global' );
?>

<div class="woocommerce-variation-add-to-cart variations_button">
	
	<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

	<?php /* Hide quantity switcher
	do_action( 'woocommerce_before_add_to_cart_quantity' );

	woocommerce_quantity_input(
		array(
			'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
			'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
			'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
		)
	);

	do_action( 'woocommerce_after_add_to_cart_quantity' );
	*/?>

	<?php if ( $ajax_cart ): ?>

		<a class="single_add_to_cart_button btn alt btn-loading-disabled">
			<i class="icon ion ion-left">
				<svg version="1.1"  width="14px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 12 16" xml:space="preserve"><path class="st0" d="M9,4V3c0-1.7-1.3-3-3-3S3,1.3,3,3v1H0v10c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V4H9z M4,3c0-1.1,0.9-2,2-2
			s2,0.9,2,2v1H4V3z"></path></svg>
			</i>
			<?php echo esc_html( $product->single_add_to_cart_text() ); ?>
		</a>

	<?php else: ?>

		<button type="submit" class="single_add_to_cart_button button alt">
			<i class="icon ion ion-left">
				<svg version="1.1"  xmlns="http://www.w3.org/2000/svg" width="12px" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 12 16" xml:space="preserve"><path class="st0" d="M9,4V3c0-1.7-1.3-3-3-3S3,1.3,3,3v1H0v10c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V4H9z M4,3c0-1.1,0.9-2,2-2
			s2,0.9,2,2v1H4V3z"/></svg>
			</i>
			<?php echo esc_html( $product->single_add_to_cart_text() ); ?>
		</button>

	<?php endif; ?>

	<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>

	<input type="hidden" name="add-to-cart" value="<?php echo absint( $product->get_id() ); ?>" />
	<input type="hidden" name="product_id" value="<?php echo absint( $product->get_id() ); ?>" />
	<input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>
