<?php
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 6.1.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$attribute_keys  = array_keys( $attributes );
$variations_json = wp_json_encode( $available_variations );
$variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );

do_action( 'woocommerce_before_add_to_cart_form' );

// Custom functions

function is_color_attr($options, $attribute_name) {
	$custom = false;

	foreach ($options as $option):
		$term = get_term_by( 'slug', $option, $attribute_name);
		if ($term) {
			if (get_field('attribute_mod', $term) == 'color') {
				if (get_field('color', $term)) {
					$custom = true;
					break;
				}
			}
		}
	endforeach;

	return $custom;
}

function is_radio_attr($options, $attribute_name) {
	$custom = false;
	foreach ($options as $option):
		$term = get_term_by( 'slug', $option, $attribute_name);
		if ($term) {
			if (get_field('attribute_mod', $term) == 'Radio') {
				$custom = true;
				break;
			}
		}
	endforeach;

	return $custom;
}

?>

<form id="variation_form_anchor" class="woo_c-product-details-variations variations_form cart <?php if ( $product->is_sold_individually() ) { echo esc_attr('sold-individually'); } ?>" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo htmlspecialchars( json_encode( $available_variations ) ) ?>">

	<?php do_action( 'woocommerce_before_variations_form' ); ?>

	<?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>

		<button type="submit" class="single_add_to_cart_button btn btn-small alt" disabled="true">
			<?php esc_html_e( 'This product is currently out of stock and unavailable.', 'stockie' ); ?>
		</button>

	<?php else : ?>

		<div class="variations">
			<div class="variation">
                <div class="label">
					<label for="php"><?php esc_html_e( 'QTY', 'stockie' ); ?>:</label>
				</div>

				<?php /* Show quantity switcher*/
                do_action( 'woocommerce_before_add_to_cart_quantity' );

                woocommerce_quantity_input(
                    array(
                        'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
                        'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
                        'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
                    )
                );

                do_action( 'woocommerce_after_add_to_cart_quantity' );
                ?>

			</div>

			<?php foreach ( $attributes as $attribute_name => $options ) : ?>
				<div id="variation_<?php echo esc_attr($attribute_name) ?>" class="variation">
					<div class="label"><label for="pa_color"><?php echo wc_attribute_label( $attribute_name ) ?>:</label></div>

					<?php
					if ( is_color_attr( $options, $attribute_name ) ):

						echo '<div class="custom_select" style="display: none">';
						$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ) : $product->get_variation_default_attribute( $attribute_name );
						wc_dropdown_variation_attribute_options( array( 'options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected, 'class'=> 'test', 'show_option_none' => wc_attribute_label( $attribute_name ) ) );
						echo "</div>";
						echo '<div class="color_attr">';
							$defalt_option = $product->get_variation_default_attribute( $attribute_name );
							foreach ($options as $option):
								$active = '';
								if ($defalt_option == $option) {
									$active = 'active';
								}
								$term = get_term_by( 'slug', $option, $attribute_name);
								if (get_field('color', $term)) {
									echo '<span class="color-item '.$active.'"  data-option='.$option.' style="background-color: '. get_field('color', $term) .';display:none"></span>';
								} else {
									echo '<span'.$active.'  data-option='.$option.' style="margin-right: 12px;display:none">' .$term->name .'</span>';
								}

							endforeach;
						echo '</div>';

					elseif ( is_radio_attr( $options, $attribute_name ) ):

						echo '<span class="select-holder -small">';
						$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ) : $product->get_variation_default_attribute( $attribute_name );
						wc_dropdown_variation_attribute_options(
							array(
								'options' => $options,
								'attribute' => $attribute_name,
								'product' => $product,
								'class'=> '-small -flat',
								'show_option_none' => wc_attribute_label( $attribute_name )
							)
						);
						echo '</span>';

						echo '<div class="size_attr">';
						$defalt_option = $product->get_variation_default_attribute( $attribute_name );
						foreach ($options as $option):
							$active = '';
							if ($defalt_option == $option) {
								$active = 'active';
							}
							$term = get_term_by( 'slug', $option, $attribute_name);
							if (get_field('color', $term)) {
								echo '<span class="color-item '.$active.'"  data-option='.$option.' style="background-color: '. get_field('color', $term) .'"></span>';
							} else {
								echo '<span class="size-item'.$active.'""  data-option='.$option.'>' .$term->name .'</span>';
							}

						endforeach;
						echo '</div>';

						else :
						
						echo '<span class="select-holder -small">';
						$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ) : $product->get_variation_default_attribute( $attribute_name );
						wc_dropdown_variation_attribute_options(
							array(
								'options' => $options,
								'attribute' => $attribute_name,
								'product' => $product,
								'class'=> '-small -flat',
								'show_option_none' => wc_attribute_label( $attribute_name )
							)
						);
						echo '</span>';

					endif; ?>

				</div>
				<?php
					echo end( $attribute_keys ) === $attribute_name ? apply_filters( 'woocommerce_reset_variations_link', '<div class="reset variation"><a class="btn btn-link reset_variations" href="#"><span>' . esc_html__( 'Reset', 'stockie' ) . '</span><i class="ion ion-right ion-android-close-circle-outline"></i></a></div>' ) : '';
				?>
			<?php endforeach;?>

		</div>

		<?php do_action( 'woocommerce_after_variations_table' ); ?>

		<div class="single_variation_wrap">
			<?php
				/**
				 * Hook: woocommerce_before_single_variation.
				 */
				do_action( 'woocommerce_before_single_variation' );

				/**
				 * Hook: woocommerce_single_variation. Used to output the cart button and placeholder for variation data.
				 *
				 * @since 2.4.0
				 * @hooked woocommerce_single_variation - 10 Empty div for variation data.
				 * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
				 */
				do_action( 'woocommerce_single_variation' );

				/**
				 * Hook: woocommerce_after_single_variation.
				 */
				do_action( 'woocommerce_after_single_variation' );
			?>
		</div>

	<?php endif; ?>

	<?php do_action( 'woocommerce_after_variations_form' ); ?>
</form>

<?php
do_action( 'woocommerce_after_add_to_cart_form' );
