<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

global $product;

if ( ! $product->is_purchasable() ) {
    return;
}

echo wc_get_stock_html( $product ); // WPCS: XSS ok.

if ( $product->is_in_stock() ) : ?>

    <?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>

    <form class="woo_c-product-details-variations cart woocommerce-add-to-cart <?php if ( $product->is_sold_individually() ) { echo esc_attr('sold-individually'); } ?>" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data'>

        <?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

        <?php if ( $product->is_in_stock() ) : ?>

            <div class="simple-qty">
                <div class="label">
                    <label for="quantity"><?php esc_html_e( 'QTY', 'stockie' ); ?>:</label>
                </div>

                <?php /* Show quantity switcher*/
                do_action( 'woocommerce_before_add_to_cart_quantity' );

                woocommerce_quantity_input(
                    array(
                        'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
                        'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
                        'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
                    )
                );

                do_action( 'woocommerce_after_add_to_cart_quantity' );
                ?>

            </div>
            <input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" />
            <input type="hidden" name="product_id" value="<?php echo absint( $product->get_id() ); ?>" />
            <input type="hidden" name="variation_id" class="variation_id" value="0" />
            <div class="variations_button">

                <?php if ( StockieSettings::get('woocommerce_add_to_cart_ajax', 'global') ) { ?>
                    <a class="single_add_to_cart_button btn alt btn-loading-disabled">
                        <i class="icon ion ion-left">
                            <svg version="1.1"  xmlns="http://www.w3.org/2000/svg" width="12px" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 12 16" xml:space="preserve">
                            <path class="st0" d="M9,4V3c0-1.7-1.3-3-3-3S3,1.3,3,3v1H0v10c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V4H9z M4,3c0-1.1,0.9-2,2-2
                                s2,0.9,2,2v1H4V3z"/>
                            </svg>
                        </i>
                        <?php echo esc_html( $product->single_add_to_cart_text() ); ?>
                    </a>
                <?php } else { ?>
                    <button type="submit" class="single_add_to_cart_button btn alt btn-loading-disabled">

                        <i class="icon ion ion-left">
                            <svg version="1.1"  xmlns="http://www.w3.org/2000/svg" width="12px" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 12 16" xml:space="preserve">
                            <path class="st0" d="M9,4V3c0-1.7-1.3-3-3-3S3,1.3,3,3v1H0v10c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V4H9z M4,3c0-1.1,0.9-2,2-2
                                s2,0.9,2,2v1H4V3z"/>
                            </svg>
                        </i>
                        <?php echo esc_html( $product->single_add_to_cart_text() ); ?>
                    </button>
                <?php } ?>
                
                <?php
                if ( function_exists( 'YITH_WCWL' ) ) {
                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                }
                ?>

                <?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
            </div>

        <?php else: ?>

            <div class="single_add_to_cart_button out_of_stock">
                <div class="stockie-message-module-sc message-box error"><?php esc_html_e( 'This product is currently out of stock and unavailable.', 'stockie' ); ?></div>
            </div>

        <?php endif; ?>
        
    </form>

<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>

<?php endif; ?>
