<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}
// Coupon
$coupon = true;
	if (! wc_coupons_enabled() ) {
		$coupon = false;
	}
$one_page_checkout = StockieSettings::get( 'woocommerce_one_page_checkout', 'global' );
?>

<div class="woo-c_checkout vc_row<?php if ( !$coupon ) echo ' without-coupon' ?>">
	<div class="vc_col-md-12">
		<?php do_action( 'woocommerce_before_checkout_form', $checkout ); ?>
	</div>
	<div class="vc_col-lg-8 vc_col-lg-push-2 vc_col-md-10 vc_col-md-push-1 vc_col-xs-12">
		<form id="coupon_form" class="checkout_coupon woocommerce-form-coupon" method="post">
		    <input name="coupon_code" type="hidden">
		</form>
		<form name="checkout" method="post" class="woo-c_checkout_form checkout woocommerce-checkout<?php if ( $one_page_checkout ) { echo ' -onepage-checkout'; } ?>" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

		<?php if ( $checkout->get_checkout_fields() ): ?>

			<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

			<div class="customer_details">

				<div class="tab" data-stockie-tab-box="true">

				<?php if ( !$one_page_checkout ): ?>

					<div class="tabNav_wrapper">

						<ul class="tabNav" role="tablist">

							<li class="tabNav_line brand-bg-color"></li>

							<!-- Billing -->
							<li class="tabNav_link active">
								<div class="desctop-btn">
									<span class="tabNav_link_stage">1</span>
									<span class="font-titles"><?php esc_html_e( 'Billing details', 'stockie' ); ?></span>
								</div>
								<div class="mobile-btn font-titles"><span><?php esc_html_e( 'Billing', 'stockie' ); ?></span></div>
							</li>

							<!-- Shipping -->
							<li class="tabNav_link">
								<div class="desctop-btn">
									<span class="tabNav_link_stage">2</span>
									<span class="font-titles"><?php esc_html_e( 'Shipping address', 'stockie' ); ?></span>
								</div>
								<div class="mobile-btn font-titles"><span><?php esc_html_e( 'Shipping', 'stockie' ); ?></span></div>
							</li>

							<!-- Coupon -->
							<?php if ( $coupon ): ?>

								<li class="tabNav_link">
									<div class="desctop-btn">
										<span class="tabNav_link_stage">3</span>
										<span class="font-titles"><?php esc_attr_e( 'Apply Coupon', 'stockie' ); ?></span>
									</div>
									<div class="mobile-btn font-titles"><span><?php esc_html_e( 'Coupon', 'stockie' ); ?></span></div>
								</li>

							<?php endif; ?>

							<!-- Review and Payment -->
							<li class="tabNav_link">
								<div class="desctop-btn">
									<span class="tabNav_link_stage"><?php echo esc_html( $coupon ? 4 : 3);?></span>
									<span class="font-titles"><?php esc_html_e( 'Review order', 'stockie' ); ?></span>
								</div>
								<div class="mobile-btn font-titles"><span><?php esc_html_e( 'Order', 'stockie' ); ?></span></div>
							</li>
						</ul>
					</div>

				<?php endif; ?>

					<div class="tabItems<?php if ( $one_page_checkout ) { echo ' vc_row'; } ?>" role="tabpanel">

					<?php if ( $one_page_checkout ): ?>
						<div class="vc_col-lg-7">
					<?php endif; ?>

							<!-- Billing -->
							<div class="form-group<?php if ( !$one_page_checkout ) { echo ' tabItems_item active'; } ?>" data-title="<?php esc_html_e( 'Billing details', 'stockie' ); ?>">
								<div class="wpb_text_column wpb_content_element ">
									<div class="wpb_wrapper" id="customer_details">
										<div class="wpb_notices"><?php wc_print_notices(); ?></div>

										<?php do_action( 'woocommerce_checkout_billing' ); ?>

										<?php if ( !$one_page_checkout ): ?>
										<a href="#" class="btn next-btn">
											<span class="text"><?php esc_html_e( 'Continue', 'stockie' ); ?></span>
											<i class="ion-right ion ion-ios-arrow-forward"></i>
										</a>
										<?php endif; ?>
									</div>
								</div>
							</div>

							<!-- Shipping -->
							<div class="form-group<?php if ( !$one_page_checkout ) { echo ' tabItems_item'; } ?>" data-title="<?php esc_html_e( 'Shipping address', 'stockie' ); ?>">
								<div class="wpb_text_column wpb_content_element ">
									<div class="wpb_wrapper">

										<?php do_action( 'woocommerce_checkout_shipping' ); ?>

										<?php if ( !$one_page_checkout ): ?>
										<a href="#" class="btn next-btn">
											<span class="text"><?php esc_html_e( 'Continue', 'stockie' ); ?></span>
											<i class="ion-right ion ion-ios-arrow-forward"></i>
										</a>
										<?php endif; ?>
									</div>
								</div>
							</div>

							<!-- Coupon -->
							<?php if ( $coupon ): ?>

							<div class="form-group<?php if ( !$one_page_checkout ) { echo ' tabItems_item'; } ?>" data-title="<?php esc_attr_e( 'Apply Coupon', 'stockie' ); ?>">
								<div class="wpb_text_column wpb_content_element ">
									<div class="wpb_wrapper">

									<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
										
									</div>
								</div>
							</div>

							<?php endif; ?>

					<?php if ( $one_page_checkout ): ?>
						</div>
					<?php endif; ?>

						<!-- Review and Payment -->
						<div class="<?php if ( !$one_page_checkout ) { echo 'tabItems_item'; } else { echo 'vc_col-lg-5 page-sidebar -sticky-block'; } ?>" data-title="<?php esc_html_e( 'Review order', 'stockie' ); ?>">

							<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

							<div id="order_review" class="woo-check-order">
								<?php do_action( 'woocommerce_checkout_order_review' ); ?>
							</div>

							<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

						</div>
					</div>
				</div>
			</div>

			<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

		<?php endif; ?>

		</form>
	</div>
</div>