<?php

	$project_layout_type = StockieSettings::get( 'project_layout_type' );

	if ( in_array( $project_layout_type, array( 'inherit', NULL ) ) ) {
		$project_layout_type = StockieSettings::get( 'project_layout_type', 'global' );
	}

	get_header();
?>

<?php 
	if ( ! in_array( $project_layout_type, array( 'type_5', NULL ) ) ) {
		get_template_part( 'parts/elements/header-title' );
	}
?>

<?php
	if ( ! post_password_required() ) {
		switch ( $project_layout_type ) {
			case 'type_1':
				get_template_part( 'parts/portfolio/layout-type1' );
				break;
			case 'type_2':
				get_template_part( 'parts/portfolio/layout-type2' );
				break;
			case 'type_3':
				get_template_part( 'parts/portfolio/layout-type3' );
				break;
			case 'type_4':
				get_template_part( 'parts/portfolio/layout-type4' );
				break;
			case 'type_5':
				get_template_part( 'parts/portfolio/layout-type5' );
				break;
		}
	} else {
?>
	<div class="page-container bottom-offset">
		<div class="content">
			<?php echo get_the_password_form(); ?>
		</div>
	</div>
<?php 
	}

	get_footer();