<?php
global $post;
$project = StockieObjectParser::parse_to_project_object($post);
if (is_array($project['images_full']) && count($project['images_full']) > 0) {
    $project['images'] = $project['images_full'];
}

if (!$project['hide_breadcrumbs']) {
    get_template_part('parts/elements/breadcrumbs');
}
?>

    <!-- Content -->
    <div class="portfolio-page layout-type5" id="scroll-portfolio"
        <?php if ($project['images']) {
            echo ' data-stockie-bg-image="' . esc_url($project['images'][0]) . '"';
        } ?>>
        <div class="page-container">
            <div class="center-aligned">
                <div class="wrap">

                    <div class="portfolio-content">
                        <?php if ($project['categories_plain']) : ?>
                            <?php $categories = explode(', ', $project['categories_plain']) ?>
                            <?php foreach ($categories as $category) : ?>
                                <span class="tag brand-bg-color"><?php echo esc_html($category); ?></span>
                            <?php endforeach; ?>
                        <?php endif; ?>

                        <?php the_title('<h1 class="title">', '</h1>'); ?>
                        <div class="info">
                            <ul class="info-list">
                                <?php if ($project['date']) : ?>
                                    <li>
                                        <p class="">
                                            <span class="title"><?php esc_html_e('Date', 'stockie'); ?>:</span>
                                            <?php echo esc_html($project['date']); ?>
                                        </p>
                                    </li>
                                <?php endif; ?>

                                <?php if ($project['skills']) : ?>
                                    <li>
                                        <p class="">
                                            <span class="title"><?php esc_html_e('Skills', 'stockie'); ?>:</span>
                                            <?php echo wp_kses($project['skills'], 'default'); ?>
                                        </p>
                                    </li>
                                <?php endif; ?>

                                <?php if ($project['client']) : ?>
                                    <li>
                                        <p class="">
                                            <span class="title"><?php esc_html_e('Client', 'stockie'); ?>:</span>
                                            <?php echo wp_kses($project['client'], 'default'); ?>
                                        </p>
                                    </li>
                                <?php endif; ?>

                                <?php if ($project['link']) : ?>
                                    <li>
                                        <p class="">
                                            <span class="title"><?php esc_html_e('Project link', 'stockie'); ?>:</span>
                                            <a href="<?php echo esc_url($project['link']); ?>"
                                               target="_blank"><?php echo esc_html($project['link']); ?></a>
                                        </p>
                                    </li>
                                <?php endif; ?>

                                <?php
                                $tags = wp_get_post_terms($post->ID, 'stockie_portfolio_tags', array('fields' => 'names'));
                                if (!empty($tags)) {
                                    ?>
                                    <li>
                                        <div class="title"><?php esc_html_e( 'Tags', 'stockie' ); ?></div>
                                        <p>
                                            <?php
                                            echo esc_html(implode(', ', $tags));?>
                                        </p>
                                    </li>
                                    <?php
                                }
                                ?>

                                <?php if ($project['custom_fields']) : ?>
                                    <?php foreach ($project['custom_fields'] as $custom_field) : ?>
                                        <li>
                                            <p class="">
                                                <span class="title"><?php echo esc_html($custom_field['title']); ?>
                                                    :</span>
                                                <?php echo esc_html($custom_field['value']); ?>
                                            </p>
                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </ul>

                        </div>

                    </div><!--.content-->

                </div>
            </div>
        </div><!--.center-aligned-->

    </div>

<?php
if ($project['show_navigation'] == 'prev_n_next' && ($project['prev'] || $project['next'])
    && $project['navigation_position'] == 'top') {
    get_template_part('parts/elements/next-n-prev-projects');
}
?>

    <div class="page-container">
        <div class="page-content">
            <?php global $post;
            echo do_shortcode(get_post_field('post_content', $post->ID)); ?>
        </div>
    </div>

<?php
if ($project['show_navigation'] == 'prev_n_next' && ($project['prev'] || $project['next'])
    && $project['navigation_position'] == 'bottom') {
    get_template_part('parts/elements/next-n-prev-projects');
}
?>

<?php if (comments_open() || get_comments_number()) : ?>
    <div class="portfolio-comments">
        <?php comments_template(); ?>
    </div>
<?php endif; ?>